/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleAttributesProvider {
    private Attributes _saxAttrs;
    private String[] _attrNames;
    private int _attrCount;
    private int _attrCountRemaining;
    private boolean _parserIsInterningStrings = false;

    protected SimpleAttributesProvider(int initialCapacity) {
        this._attrNames = new String[initialCapacity];
    }

    void reinitializeForConsumptionOfAttributes(Attributes saxAttrs) throws SAXException {
        this._saxAttrs = saxAttrs;
        this._attrCountRemaining = this._attrCount = this._saxAttrs.getLength();
        if (this._attrNames.length < this._attrCount) {
            this._attrNames = new String[this._attrCount];
        }
        for (int i = 0; i < this._attrCount; ++i) {
            String attrName;
            this._attrNames[i] = attrName = this._saxAttrs.getQName(i);
        }
    }

    void setParserIsInterningStrings(boolean parserIsInterningStrings) {
        this._parserIsInterningStrings = parserIsInterningStrings;
    }

    @SuppressWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="string is interned here")
    protected String consumeAttr(String attrName, String defaultValue) {
        String outValue = defaultValue;
        if (this._attrCountRemaining > 0) {
            for (int i = 0; i < this._attrCount; ++i) {
                String slotName = this._attrNames[i];
                if (slotName != attrName && (slotName == null || this._parserIsInterningStrings || !slotName.equals(attrName))) continue;
                outValue = this._saxAttrs.getValue(i);
                this._attrNames[i] = null;
                --this._attrCountRemaining;
                break;
            }
        }
        return outValue;
    }

    public void replenishAttr(String attrName) {
        for (int i = 0; i < this._attrCount; ++i) {
            if (this._attrNames[i] != null) continue;
            this._attrNames[i] = attrName;
            ++this._attrCountRemaining;
            break;
        }
    }

    public String getFirstUnconsumedAttrName() {
        String out = null;
        if (this._attrCountRemaining > 0) {
            for (int i = 0; i < this._attrCount; ++i) {
                if (this._attrNames[i] == null) continue;
                out = this._attrNames[i];
                break;
            }
        }
        return out;
    }

    public boolean hasAttrsRemainingToBeConsumed() {
        return this._attrCountRemaining > 0;
    }

    public String[] trustedGetAttrNames() {
        return this._attrNames;
    }

    public TreeMap<Integer, String> getOrderedPrefixNAttrNames(String prefix) {
        TreeMap<Integer, String> sortedMap = new TreeMap<Integer, String>();
        for (int i = 0; i < this._attrCount; ++i) {
            String attrName = this._attrNames[i];
            if (attrName == null || !SimpleAttributesProvider.attrNameHasPrefixWithNumericSuffix(attrName, prefix)) continue;
            int key = Integer.parseInt(attrName.substring(prefix.length()));
            sortedMap.put(key, attrName);
        }
        return sortedMap;
    }

    public String[] consumeUnorderedPrefixNAttrs(String prefix) {
        String[] out = new String[this._attrCountRemaining];
        int outIndex = 0;
        for (int i = 0; i < this._attrCount; ++i) {
            String attrName = this._attrNames[i];
            if (attrName == null || !SimpleAttributesProvider.attrNameHasPrefixWithNumericSuffix(attrName, prefix)) continue;
            out[outIndex++] = this._saxAttrs.getValue(i);
            this._attrNames[i] = null;
            --this._attrCountRemaining;
        }
        return out;
    }

    public String[] consumeOrderedPrefixNAttrs(String prefix) {
        String[] out = null;
        TreeMap<Integer, String> orderedMap = this.getOrderedPrefixNAttrNames(prefix);
        int size = orderedMap.size();
        if (size > 0) {
            out = new String[size];
            int outIndex = 0;
            for (String attrName : orderedMap.values()) {
                String attrValue = this.consumeAttr(attrName, null);
                out[outIndex++] = attrValue;
            }
        }
        return out;
    }

    public ArrayList consumeOrderedPrefixNAttrsAsList(String prefix) {
        ArrayList<Object> out = null;
        String[] attrValues = this.consumeOrderedPrefixNAttrs(prefix);
        out = attrValues == null ? new ArrayList(0) : new ArrayList<String>(Arrays.asList(attrValues));
        return out;
    }

    public static boolean attrNameHasPrefixWithNumericSuffix(String attrName, String prefix) {
        return attrName.startsWith(prefix) && SimpleAttributesProvider.hasBase10OnlyChars(attrName, prefix.length());
    }

    private static boolean hasBase10OnlyChars(String str, int startingIndex) {
        boolean out = true;
        int endIndex = str.length() - 1;
        for (int i = startingIndex; i <= endIndex; ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            out = false;
            break;
        }
        return out;
    }

    public int getMaxAttrIndex() {
        return this._attrCount - 1;
    }
}

