/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.util.Preconditions;
import javax.xml.parsers.SAXParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXParserProperties {
    private SAXParser _parser;
    private boolean _stringInterningSupported = false;
    private static final Logger _logger = LogManager.getLogger(SAXParserProperties.class);

    SAXParserProperties(SAXParser parser) {
        Preconditions.ensureNonNull(parser);
        this._parser = parser;
        this.initRequired();
    }

    void initRequired() {
        XMLReader reader = null;
        try {
            reader = this._parser.getXMLReader();
            this._stringInterningSupported = this.getRequiredFeatureSetting(reader, "http://xml.org/sax/features/string-interning", false);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private boolean getRequiredFeatureSetting(XMLReader xmlReader, String featureName, boolean defaultValue) {
        boolean out;
        try {
            out = xmlReader.getFeature(featureName);
        }
        catch (SAXException e) {
            out = defaultValue;
        }
        return out;
    }

    boolean isParserInterningStrings() {
        return this._stringInterningSupported;
    }

    void logDebug() {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Parser is: " + this._parser.getClass().getName());
            XMLReader reader = null;
            try {
                reader = this._parser.getXMLReader();
                _logger.debug("Reader is: " + reader.getClass().getName());
                this.logOneFeature(reader, "external-general-entities");
                this.logOneFeature(reader, "external-parameter-entities");
                this.logOneFeature(reader, "is-standalone");
                this.logOneFeature(reader, "lexical-handler/parameter-entities");
                this.logOneFeature(reader, "namespaces");
                this.logOneFeature(reader, "namespace-prefixes");
                this.logOneFeature(reader, "resolve-dtd-uris");
                this.logOneFeature(reader, "string-interning");
                this.logOneFeature(reader, "unicode-normalization-checking");
                this.logOneFeature(reader, "use-attributes2");
                this.logOneFeature(reader, "use-locator2");
                this.logOneFeature(reader, "use-entity-resolver2");
                this.logOneFeature(reader, "validation");
                this.logOneFeature(reader, "xmlns-uris");
                this.logOneFeature(reader, "xml-1.1");
            }
            catch (SAXException e) {
                _logger.debug("Could not get XMLReader from SAXParser.", (Throwable)e);
            }
        }
    }

    private void logOneFeature(XMLReader reader, String feature) {
        String fullFeature = "http://xml.org/sax/features/" + feature;
        try {
            _logger.debug(feature + ": " + reader.getFeature(fullFeature));
        }
        catch (SAXException e) {
            _logger.debug("Exception when retrieving feature \"" + feature + "\": " + e.toString());
        }
    }
}

