/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.ObjectProvider;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.RelatedObjectList;
import com.sas.iquery.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.xml.sax.SAXException;

public final class RelatedObjectListsHolder {
    private ReadingContextV2 _readingContext;
    private AbstractBase _object;
    private static final int INITIAL_RELATIONSHIP_COUNT = 5;
    private static final int ROL_COUNT_INCREMENT = 2;
    private String[] _relationshipNames = new String[5];
    private RelatedObjectList[] _relatedObjectLists = new RelatedObjectList[5];
    private int _relationshipsCount;
    private int _relationshipsCountRemainingToBeConsumed;
    private boolean _parserIsInterningStrings;

    RelatedObjectListsHolder(AbstractBase object, ReadingContextV2 readingContext, boolean parserIsInterningStrings, RelatedObjectList[] rolsToStartWith) throws SAXException {
        this._readingContext = readingContext;
        this._parserIsInterningStrings = parserIsInterningStrings;
        this.reinitialize(object, rolsToStartWith);
    }

    public void reinitialize(AbstractBase object, RelatedObjectList[] rolsToStartWith) throws SAXException {
        this._object = object;
        this._relationshipsCount = 0;
        this._relationshipsCountRemainingToBeConsumed = 0;
        if (rolsToStartWith != null) {
            for (int i = 0; i < rolsToStartWith.length; ++i) {
                this.add(rolsToStartWith[i]);
            }
        }
    }

    public ReadingContextV2 getReadingContext() {
        return this._readingContext;
    }

    public AbstractModel getModel() {
        return this._readingContext.getModelBeingRead();
    }

    public void add(RelatedObjectList rol) throws SAXException {
        String relationshipName;
        if (this._relatedObjectLists.length == this._relationshipsCount) {
            int oldSize = this._relatedObjectLists.length;
            int newSize = oldSize + 2;
            RelatedObjectList[] newRol = new RelatedObjectList[newSize];
            System.arraycopy(this._relatedObjectLists, 0, newRol, 0, oldSize);
            this._relatedObjectLists = newRol;
            String[] newRelationshipNames = new String[newSize];
            System.arraycopy(this._relationshipNames, 0, newRelationshipNames, 0, oldSize);
            this._relationshipNames = newRelationshipNames;
        }
        this._relatedObjectLists[this._relationshipsCount] = rol;
        this._relationshipNames[this._relationshipsCount] = relationshipName = rol.getRelationshipName();
        ++this._relationshipsCount;
        ++this._relationshipsCountRemainingToBeConsumed;
    }

    public boolean hasRelatedObjectsToBeConsumed() {
        return this._relationshipsCountRemainingToBeConsumed > 0;
    }

    public boolean isForModelBeingRead() {
        return this._object == this.getModel();
    }

    public AbstractBase getObject() {
        return this._object;
    }

    public int getRelationshipsCount() {
        return this._relationshipsCount;
    }

    public RelatedObjectList[] trustedGetROLsStorage() {
        return this._relatedObjectLists;
    }

    public <T> List<T> consumeObjects(@Nonnull String relationshipName, @Nonnull Class<T> type) {
        Preconditions.ensureNonNull(type, "type");
        ArrayList<T> out = null;
        int index = this.getIndexOfRelatedObjectList(relationshipName);
        if (index == -1) {
            out = new ArrayList<T>();
        } else {
            List<Object> related = this._relatedObjectLists[index].getObjects();
            this._relationshipNames[index] = null;
            --this._relationshipsCountRemainingToBeConsumed;
            out = new ArrayList(related.size());
            for (Object o : related) {
                if (o == null) {
                    throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("RelatedObjectList.NullElement.fmt.txt", type.getName()));
                }
                out.add(type.cast(o));
            }
        }
        return out;
    }

    @Nonnull
    public <T> List<T> consumeForeignObjects(String relationshipName, @Nonnull Class<T> type) throws SAXException {
        ArrayList<T> out = null;
        int index = this.getIndexOfRelatedObjectList(relationshipName);
        if (index == -1) {
            out = new ArrayList<T>();
        } else {
            List<Object> related = this._relatedObjectLists[index].getObjects();
            this._relationshipNames[index] = null;
            --this._relationshipsCountRemainingToBeConsumed;
            out = new ArrayList(related.size());
            for (Object o : related) {
                if (o == null) {
                    throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("RelatedObjectList.NullElement.fmt.txt", relationshipName));
                }
                ObjectProvider wrapper = (ObjectProvider)o;
                Object foreignObject = wrapper.getObject();
                out.add(type.cast(foreignObject));
            }
        }
        return out;
    }

    public AbstractBase consumeObject(String relationshipName) throws SAXException {
        return this.consumeObject(relationshipName, null);
    }

    public AbstractBase consumeObject(String relationshipName, AbstractBase defaultObject) throws SAXException {
        AbstractBase out = defaultObject;
        int index = this.getIndexOfRelatedObjectList(relationshipName);
        if (index != -1) {
            out = this._relatedObjectLists[index].getObject();
            this._relationshipNames[index] = null;
            --this._relationshipsCountRemainingToBeConsumed;
        }
        return out;
    }

    public Object consumeForeignObject(String relationshipName) throws SAXException {
        Object out = null;
        int index = this.getIndexOfRelatedObjectList(relationshipName);
        if (index != -1) {
            out = this._relatedObjectLists[index].getForeignObject();
            this._relationshipNames[index] = null;
            --this._relationshipsCountRemainingToBeConsumed;
        }
        return out;
    }

    private int getIndexOfRelatedObjectList(String relationshipName) {
        int index = -1;
        if (this._relationshipsCountRemainingToBeConsumed > 0) {
            for (int i = 0; i < this._relationshipsCount; ++i) {
                String slotName = this._relationshipNames[i];
                if (slotName != relationshipName && (slotName == null || this._parserIsInterningStrings || !slotName.equals(relationshipName))) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public String getFirstUnconsumedRelationshipName() {
        String out = null;
        if (this._relationshipsCountRemainingToBeConsumed > 0) {
            for (int i = 0; i < this._relationshipsCount; ++i) {
                if (this._relationshipNames[i] == null) continue;
                out = this._relationshipNames[i];
                break;
            }
        }
        return out;
    }
}

