/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.Entity;
import com.sas.entities.EntityInterface;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.persist.EntityConverter;
import com.sas.entities.persist.EntityPersistenceUtility;
import com.sas.iquery.execution.util.StoredProcessUtils;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.FilterSetMember;
import com.sas.iquery.metadata.business.LookThroughDataSelection;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.RunStoredProcess;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.DataSelectionImpl;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCache;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.StoredProcess;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptDefinitionReference;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.StoredProcess2Interface;
import com.sas.services.storedprocess.StoredProcessInterface;
import com.sas.util.MutableUserInfoInterface;
import com.sas.util.log.LoggerFactoryInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class QueryPrompts
implements PropertyChangeListener {
    private DataSelectionImpl _query = null;
    private EntityInterface _entity;
    private PromptValuesInterface _promptValues;
    private boolean _isEntityStillValid = false;
    private boolean _isParameterizedValuesValid = false;
    private boolean _promptValuesResolved = false;
    private static final Logger _logger = LogManager.getLogger(QueryPrompts.class);

    QueryPrompts(DataSelectionImpl query) {
        this._query = query;
        this._query.addListener(this);
    }

    protected PromptValuesInterface getParameterizedValues(EffectiveObjectsCache effectiveObjectCache, Locale locale) {
        PromptValuesInterface results = null;
        if (this._isParameterizedValuesValid && this._promptValues != null) {
            results = this._promptValues;
        } else {
            PromptGroupInterface mdPrompts = this.getPrompts(effectiveObjectCache, locale);
            if (this._promptValues == null) {
                this._promptValues = new PromptValues(mdPrompts);
            } else if (this._promptValuesResolved) {
                PromptUtil.applyPromptGroupToPromptValues((PromptValuesInterface)this._promptValues, (PromptGroupInterface)mdPrompts);
            } else {
                this.resolvedPromptValues(this._promptValues, mdPrompts);
            }
            this.addParameterizedStoredProcesses(this._promptValues);
            this._isParameterizedValuesValid = true;
            this._promptValuesResolved = true;
            this.setServer(this._promptValues);
            results = this._promptValues;
        }
        return results;
    }

    private PromptGroupInterface getPrompts(EffectiveObjectsCache effectiveObjectCache, Locale labelLocale) {
        TransparentGroup prompts = new TransparentGroup();
        prompts.setPromptGroupLabel(this._query.getLabel(), labelLocale);
        List<Prompt> promptsUsed = this.getBusinessPrompts(effectiveObjectCache);
        for (Prompt prompt : promptsUsed) {
            PromptDefinitionInterface pd = prompt.getPromptDefinition();
            if (pd == null) continue;
            prompts.addPromptDefinition(pd);
        }
        return prompts;
    }

    private List<Prompt> getBusinessPrompts(EffectiveObjectsCache effectiveObjectCache) {
        LinkedHashSet<Prompt> promptsUsed = new LinkedHashSet<Prompt>();
        Map<FilterSetMember, List<Prompt>> promptsUsedByDataSources = this._query.getPromptsInDataSourcePrefilters(effectiveObjectCache);
        for (FilterSetMember filterSetMember : promptsUsedByDataSources.keySet()) {
            List<Prompt> valueList = promptsUsedByDataSources.get(filterSetMember);
            promptsUsed.addAll(valueList);
        }
        List<BusinessModelObject> objs = this._query.getAllExplicitlyReferencedBusinessModelObjects();
        for (BusinessModelObject bmo : objs) {
            List<Prompt> bmoPrompts = bmo.getResources(Prompt.class, 65535);
            promptsUsed.addAll(bmoPrompts);
        }
        return new ArrayList<Prompt>(promptsUsed);
    }

    protected void addParameterizedStoredProcesses(PromptValuesInterface dsPromptValues) {
        List<RunStoredProcess> storedProcessesUsed = this._query.getParameterizedStoredProcesses();
        List<PromptValuesInterface> allSPPromptValues = StoredProcessUtils.retrieveStoredProcessPromptValues(dsPromptValues);
        Iterator<RunStoredProcess> it = storedProcessesUsed.iterator();
        while (it.hasNext()) {
            RunStoredProcess runStoredProcess;
            boolean error;
            block14: {
                error = false;
                runStoredProcess = it.next();
                if (!runStoredProcess.isUsableInQuery()) continue;
                StoredProcess iqStoredProcess = runStoredProcess.getStoredProcess();
                if (iqStoredProcess != null) {
                    com.sas.services.storedprocess.metadata.StoredProcessInterface smartObjStoredProcess = iqStoredProcess.getStoredProcessInterface();
                    try {
                        MutableUserInfoInterface userInfo;
                        String modDate;
                        PromptValuesInterface spPromptValues = StoredProcessUtils.retrieveStoredProcessPromptValues(runStoredProcess, dsPromptValues);
                        boolean updatePromptValues = true;
                        if (spPromptValues != null && (modDate = (userInfo = spPromptValues.getMutableUserInfo()).get("spTimestampRef")) != null && !StoredProcessUtils.hasStoredProcessBeenUpdated(smartObjStoredProcess, Long.parseLong(modDate))) {
                            updatePromptValues = false;
                            allSPPromptValues.remove(spPromptValues);
                        }
                        if (!updatePromptValues && this._promptValuesResolved) break block14;
                        StoredProcess2Interface serviceStoredProcess = StoredProcessUtils.createStoredProcessFromMetadata(smartObjStoredProcess, this._query);
                        if (serviceStoredProcess != null) {
                            List spPromptDefinitions;
                            if (spPromptValues == null) {
                                spPromptValues = serviceStoredProcess.getPromptValues();
                            } else {
                                List pDefsNotUsed = serviceStoredProcess.setParameterValues(spPromptValues);
                                dsPromptValues.removePromptValuesDelegate(spPromptValues);
                                spPromptValues = serviceStoredProcess.getPromptValues();
                            }
                            if (spPromptValues != null && !(spPromptDefinitions = spPromptValues.getPromptGroup().getPromptDefinitions(true)).isEmpty()) {
                                dsPromptValues.addPromptValuesDelegate(spPromptValues);
                                MutableUserInfoInterface userInfo2 = spPromptValues.getMutableUserInfo();
                                userInfo2.put("spValueRef", runStoredProcess.getID());
                                Date modDate2 = smartObjStoredProcess.getModifyDate();
                                userInfo2.put("spTimestampRef", Long.toString(modDate2.getTime()));
                            }
                            break block14;
                        }
                        error = true;
                    }
                    catch (ServiceException e) {
                        _logger.debug("Exception trying to get a stored process object from a smart object", (Throwable)e);
                        error = true;
                    }
                    catch (RemoteException e) {
                        _logger.debug("Exception trying to get a stored process object from a smart object", (Throwable)e);
                        error = true;
                    }
                    catch (InvalidIDException e) {
                        _logger.debug("The IQ run stored process object has an invalid id", (Throwable)e);
                        error = true;
                    }
                } else {
                    error = true;
                }
            }
            if (!error) continue;
            this.logStoredProcessErrorMsg(runStoredProcess);
        }
        if (allSPPromptValues != null && !allSPPromptValues.isEmpty()) {
            for (PromptValuesInterface promptValuesInterface : allSPPromptValues) {
                dsPromptValues.removePromptValuesDelegate(promptValuesInterface);
            }
        }
    }

    private void resolvedPromptValues(PromptValuesInterface promptValues, PromptGroupInterface mdPrompts) {
        List prmptDefs = mdPrompts.getPromptDefinitions(true);
        for (PromptDefinitionInterface promptDef : prmptDefs) {
            try {
                PromptDefinitionReference.replaceDefinitionByPromptID((PromptValuesInterface)promptValues, (PromptDefinitionInterface)promptDef);
            }
            catch (PromptValueNotFoundException e) {
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug("The prompt definition " + promptDef.getPromptName() + " is new");
            }
            catch (InvalidPromptValueException e) {
                if (!_logger.isEnabled(Level.WARN)) continue;
                String msg = IQModelImplUtilities.getMessage("QueryPrompts.InvalidPromptValue.fmt.txt", new Object[]{e});
                _logger.warn(msg);
            }
        }
        PromptUtil.applyPromptGroupToPromptValues((PromptValuesInterface)this._promptValues, (PromptGroupInterface)mdPrompts);
    }

    public Collection<PromptDefinitionInterface> getDependentStoredProcessPrompts() {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            Collection<PromptDefinitionInterface> collection = this.getDependentStoredProcessPrompts(effectiveObjectCache);
            return collection;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    public Collection<PromptDefinitionInterface> getDependentStoredProcessPrompts(EffectiveObjectsCache effectiveObjectCache) {
        Locale labelLocale = LocaleUtilities.getDefaultViewerLocale(this._query);
        List<PromptDefinitionInterface> result = null;
        List<RunStoredProcess> storedProcessesUsed = this._query.getEffectiveRules(RunStoredProcess.class);
        if (!storedProcessesUsed.isEmpty()) {
            PromptValuesInterface promptValues = this.getParameterizedValues(effectiveObjectCache, labelLocale);
            for (RunStoredProcess runStoredProcess : storedProcessesUsed) {
                if (runStoredProcess.isUsableInQuery()) {
                    PromptValuesInterface spPromptValues = StoredProcessUtils.retrieveStoredProcessPromptValues(runStoredProcess, promptValues);
                    if (spPromptValues == null) continue;
                    PromptGroupInterface spPromptGroup = spPromptValues.getPromptGroup();
                    List spPromptDefinitions = spPromptGroup.getPromptDefinitions(true);
                    if (result == null) {
                        result = new ArrayList<PromptDefinitionInterface>();
                    }
                    result.addAll(spPromptDefinitions);
                    continue;
                }
                this.logStoredProcessErrorMsg(runStoredProcess);
            }
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    private void setServer(PromptValuesInterface promptValues) {
        block2: {
            try {
                this._promptValues.setInitParameter("SERVER", (Object)this._query.getAuthServer());
            }
            catch (MetadataException e) {
                if (!_logger.isEnabled(Level.ERROR)) break block2;
                _logger.error(e.getLocalizedMessage());
            }
        }
    }

    private void logStoredProcessErrorMsg(RunStoredProcess sp) {
        String errorMsg = IQModelImplUtilities.getMessage("DataSelectionImpl.UnusableStoredProcess.fmt.txt", sp);
        if (_logger.isEnabled(Level.WARN)) {
            _logger.warn(errorMsg);
        }
    }

    protected EntityInterface getEntityBasedPrompts() {
        if (this._entity == null) {
            this._entity = new Entity();
        } else if (this._isEntityStillValid) {
            return this._entity;
        }
        try {
            HashMap userSelectedValues = new HashMap((HashMap)((Entity)this._entity).getDelegate());
            this._entity.removeAllAttributes();
            List<BusinessModelObject> objs = this._query.getAllExplicitlyReferencedBusinessModelObjects();
            ArrayList promptsUsed = new ArrayList();
            for (BusinessModelObject bmo : objs) {
                List<Prompt> bmoPrompts = bmo.getResources(Prompt.class, 65535);
                Utils.addButNoDuplicates(promptsUsed, bmoPrompts);
            }
            ArrayList storedProcessesUsed = new ArrayList();
            objs = this._query.getEffectiveRules(RunStoredProcess.class);
            Utils.addButNoDuplicates(storedProcessesUsed, objs);
            ArrayList<AttributeDescriptorInterface> attributeDescriptors = new ArrayList<AttributeDescriptorInterface>();
            for (Prompt prompt : promptsUsed) {
                AttributeDescriptorInterface ad = prompt.getAttributeDescriptor();
                if (ad == null) continue;
                attributeDescriptors.add(ad);
            }
            Iterator it = storedProcessesUsed.iterator();
            while (it.hasNext()) {
                try {
                    RunStoredProcess runStoredProcess = (RunStoredProcess)it.next();
                    if (runStoredProcess.getBusinessModel() != this._query.getBusinessModel() && this._query.getBusinessModel() instanceof LookThroughDataSelection) continue;
                    if (runStoredProcess.isUsableInQuery()) {
                        com.sas.services.storedprocess.metadata.StoredProcessInterface smartObjStoredProcess;
                        StoredProcessInterface serviceStoredProcess;
                        AttributeDescriptorInterface[] spAttribDesc;
                        StoredProcess iqStoredProcess = runStoredProcess.getStoredProcess();
                        if (iqStoredProcess == null || (spAttribDesc = (serviceStoredProcess = (smartObjStoredProcess = iqStoredProcess.getStoredProcessInterface()).newServiceObject(this._query.getSession())).getParameters()) == null || spAttribDesc.length <= 0) continue;
                        for (AttributeDescriptorInterface element : spAttribDesc) {
                            Utils.addButNoDuplicates(attributeDescriptors, element);
                        }
                        continue;
                    }
                    if (!_logger.isEnabled(Level.WARN)) continue;
                    String errorMsg = IQModelImplUtilities.getMessage("DataSelectionImpl.UnusableStoredProcess.fmt.txt", runStoredProcess);
                    _logger.warn(errorMsg);
                }
                catch (RemoteException re) {
                    _logger.debug("Exception trying to get a stored process object from a smart object", (Throwable)re);
                }
                catch (ServiceException se) {
                    _logger.debug("Exception trying to get a stored process object from a smart object", (Throwable)se);
                }
            }
            AttributeGroupInterface attrGroup = this._entity.getAttributeGroup();
            if (attrGroup != null) {
                for (AttributeDescriptorInterface attrDesc : attributeDescriptors) {
                    Object value;
                    if (this.isIdentityDrivenPrompt(attrDesc)) continue;
                    String attrDescName = attrDesc.getName();
                    if (!attrGroup.containsAttributeDescriptorNamed(attrDescName, false)) {
                        attrGroup.addAttributeDescriptor(attrDesc, -1);
                    }
                    if ((value = userSelectedValues.get(attrDescName)) == null) continue;
                    try {
                        this._entity.setAttribute(attrDescName, value);
                    }
                    catch (AttributeSetException ase) {
                        if (!_logger.isDebugEnabled()) continue;
                        _logger.debug("The value " + value + " for the attribute descriptor " + attrDescName + " is no long valid.", (Throwable)ase);
                    }
                }
            }
        }
        catch (RemoteException re) {
            _logger.debug("Exception trying to create an query _entity", (Throwable)re);
        }
        this._isEntityStillValid = true;
        return this._entity;
    }

    protected boolean isIdentityDrivenPrompt(AttributeDescriptorInterface attr) {
        boolean identityDriven = false;
        if (attr != null) {
            String promptType = null;
            try {
                promptType = (String)attr.getSupplementalProperty("IQ_Prompt_Type");
                if (promptType != null && "IDENTITYDRIVEN".equalsIgnoreCase(promptType)) {
                    identityDriven = true;
                }
            }
            catch (IllegalArgumentException e) {
                identityDriven = false;
            }
        }
        return identityDriven;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            Locale xmlLocale = LocaleUtilities.getDefaultPersistenceLocale();
            PromptValuesInterface promptValues = this.getParameterizedValues(effectiveObjectCache, xmlLocale);
            List delegates = promptValues.getPromptValuesDelegates();
            PromptGroupInterface promptGroup = promptValues.getPromptGroup();
            if (!promptGroup.getPromptDefinitions(true).isEmpty() || delegates != null && !delegates.isEmpty()) {
                AbstractBase.writeForeignObjectUnderNewSubelement(promptGroup, thisElement, writingContext, "PromptOrdering");
                AbstractBase.writeForeignObjectUnderNewSubelement(promptValues, thisElement, writingContext, "QueryPrompts");
            }
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        this._entity = (EntityInterface)riHolder.consumeForeignObject("QueryEntity");
        if (this._entity != null) {
            try {
                pvLogger = PersistenceFactoryWithServices.newLoggerFactory((SessionContextInterface)this._query.getSession());
                this._promptValues = EntityConverter.DEFAULT_INSTANCE.newPromptValues((RemoteEntityInterface)this._entity, pvLogger, "");
                if (!this._promptValues.getPromptGroup().isPromptGroupHidden()) ** GOTO lbl17
                this._promptValues.getPromptGroup().setPromptGroupHidden(false);
            }
            catch (BackingStoreException e) {
                se = new SAXException(e);
                se.initCause(e);
                throw se;
            }
        } else {
            this._promptValues = (PromptValuesInterface)riHolder.consumeForeignObject("QueryPrompts");
            riHolder.consumeForeignObject("PromptOrdering");
        }
lbl17:
        // 3 sources

        this._promptValuesResolved = false;
    }

    protected void readQueryPrompts(Element queryEntityElement) throws MetadataException {
        if (queryEntityElement != null) {
            String xmlEntity = IQModelImplUtilities.getAttr(queryEntityElement, "value");
            this._entity = EntityPersistenceUtility.createEntityFromXML((String)xmlEntity);
            try {
                LoggerFactoryInterface pvLogger = PersistenceFactoryWithServices.newLoggerFactory((SessionContextInterface)this._query.getSession());
                this._promptValues = EntityConverter.DEFAULT_INSTANCE.newPromptValues((RemoteEntityInterface)this._entity, pvLogger, "");
                if (this._promptValues.getPromptGroup().isPromptGroupHidden()) {
                    this._promptValues.getPromptGroup().setPromptGroupHidden(false);
                }
                this._promptValuesResolved = false;
            }
            catch (BackingStoreException e) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("QueryPrompts.ErrorConvertingEntity.txt", xmlEntity), (Throwable)e);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this._isEntityStillValid = false;
        this._isParameterizedValuesValid = false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._query != null) {
            this._query.removeListener(this);
        }
    }

    void dispose() {
        if (this._query != null) {
            this._query.removeListener(this);
        }
        this._query = null;
        this._entity = null;
        this._promptValues = null;
    }
}

