/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ObjectProvider;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

abstract class PersistenceProvider
extends AbstractModelItem
implements ObjectProvider {
    PersistenceProvider() {
    }

    @Override
    protected final void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    protected final void replaceDirectReferences(Object oldObject, Object newObject) {
    }

    static PersistenceProvider newProviderForReadingLinkedHashMap() {
        return new PersistenceProviderForLinkedHashMap();
    }

    static PersistenceProvider newProviderForWritingLinkedHashMap(LinkedHashMap map) {
        return new PersistenceProviderForLinkedHashMap(map);
    }

    static PersistenceProvider newProviderForReadingOneOlapQuerySortCriteria() {
        return new PersistenceProviderForOneOlapQuerySortCriteria();
    }

    static PersistenceProvider newProviderForWritingOneOlapQuerySortCriteria(Object obj) {
        return new PersistenceProviderForOneOlapQuerySortCriteria(obj);
    }

    static PersistenceProvider newProviderForReadingMapEntry() {
        return new PersistenceProviderForMapEntry();
    }

    static PersistenceProvider newProviderForWritingMapEntry(Map.Entry mapEntry) {
        return new PersistenceProviderForMapEntry(mapEntry);
    }

    static PersistenceProvider newProviderForReadingLocale() {
        return new PersistenceProviderForLocale();
    }

    static PersistenceProvider newProviderForWritingLocale(Locale locale) {
        return new PersistenceProviderForLocale(locale);
    }

    static PersistenceProvider newProviderForReadingAssociatedPrompt() {
        return new PersistenceProviderForAssociatedPrompt();
    }

    public static class PersistenceProviderForAssociatedPrompt
    extends PersistenceProvider {
        private PromptDefinitionInterface _prompt;

        PersistenceProviderForAssociatedPrompt() {
        }

        void setPrompt(PromptDefinitionInterface prompt) {
            this._prompt = prompt;
        }

        @Override
        public Object getObject() {
            return this._prompt;
        }

        @Override
        protected String getDefinitionElementName() {
            return "AssociatedPrompt";
        }
    }

    private static class PersistenceProviderForLocale
    extends PersistenceProvider {
        private Locale _locale;

        PersistenceProviderForLocale() {
        }

        PersistenceProviderForLocale(Locale locale) {
            this._locale = locale;
        }

        @Override
        public Object getObject() {
            return this._locale;
        }

        @Override
        protected String getDefinitionElementName() {
            return "Locale";
        }

        @Override
        protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
            super.writeDefinition(thisElement, writingContext);
            IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "language", this._locale.getLanguage());
            IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "country", this._locale.getCountry());
            IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "variant", this._locale.getVariant());
        }

        @Override
        public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
            super.consumeAttributes(attrsProvider);
            String lang = attrsProvider.consumeAttrEmptyDefault("language");
            String country = attrsProvider.consumeAttrEmptyDefault("country");
            String variant = attrsProvider.consumeAttrEmptyDefault("variant");
            this._locale = new Locale(lang, country, variant);
        }
    }

    private static class PersistenceProviderForMapEntry
    extends PersistenceProvider {
        private AbstractModelItem _key;
        private AbstractModelItem _value;

        PersistenceProviderForMapEntry() {
        }

        PersistenceProviderForMapEntry(Map.Entry mapEntry) {
            this._key = (AbstractModelItem)mapEntry.getKey();
            this._value = (AbstractModelItem)mapEntry.getValue();
        }

        @Override
        public Object getObject() {
            return new Object[]{this._key, this._value};
        }

        @Override
        protected String getDefinitionElementName() {
            return "MapEntry";
        }

        @Override
        protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
            super.writeDefinition(thisElement, writingContext);
            PersistenceProviderForMapEntry.writeRelatedObject(this._key, thisElement, writingContext, "Key");
            PersistenceProviderForMapEntry.writeRelatedObject(this._value, thisElement, writingContext, "Value");
        }

        @Override
        public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
            super.consumeRelatedObjects(riHolder);
            this._key = (AbstractModelItem)riHolder.consumeObject("Key");
            this._value = (AbstractModelItem)riHolder.consumeObject("Value");
        }
    }

    private static class PersistenceProviderForOneOlapQuerySortCriteria
    extends PersistenceProvider {
        private Object _object;

        PersistenceProviderForOneOlapQuerySortCriteria() {
        }

        PersistenceProviderForOneOlapQuerySortCriteria(Object object) {
            this._object = object;
        }

        @Override
        public Object getObject() {
            return this._object;
        }

        @Override
        protected String getDefinitionElementName() {
            return "SortCriteria";
        }

        @Override
        protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
            super.writeDefinition(thisElement, writingContext);
            if (this._object != null) {
                if (this._object instanceof String) {
                    IQModelImplUtilities.setAttr(thisElement, "text", (String)this._object);
                } else if (this._object instanceof String[]) {
                    IQModelImplUtilities.setCommaSeparatedStringAttr(thisElement, "values", (String[])this._object);
                } else if (this._object instanceof List) {
                    PersistenceProviderForOneOlapQuerySortCriteria.writeRelatedObjects((List)this._object, thisElement, writingContext, "Exprs");
                } else if (this._object instanceof ExpressionInterface) {
                    PersistenceProviderForOneOlapQuerySortCriteria.writeRelatedObject((ExpressionInterface)this._object, thisElement, writingContext, "Expr");
                }
            }
        }

        @Override
        public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
            super.consumeAttributes(attrsProvider);
            this._object = attrsProvider.consumeAttr("text");
            if (this._object == null) {
                this._object = attrsProvider.consumeCommaSeparatedString("values");
            }
        }

        @Override
        public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
            super.consumeRelatedObjects(riHolder);
            if (this._object == null) {
                this._object = (ExpressionInterface)((Object)riHolder.consumeObject("Expr"));
                if (this._object == null) {
                    this._object = riHolder.consumeObjects("Exprs", ExpressionInterface.class);
                }
            }
        }
    }

    private static class PersistenceProviderForLinkedHashMap
    extends PersistenceProvider {
        private LinkedHashMap _orderedMap;

        PersistenceProviderForLinkedHashMap() {
            this._orderedMap = new LinkedHashMap();
        }

        PersistenceProviderForLinkedHashMap(LinkedHashMap map) {
            this._orderedMap = map;
        }

        @Override
        public Object getObject() {
            return this._orderedMap;
        }

        @Override
        protected String getDefinitionElementName() {
            return "LinkedHashMap";
        }

        @Override
        protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
            super.writeDefinition(thisElement, writingContext);
            if (this._orderedMap != null && this._orderedMap.size() > 0) {
                ArrayList<PersistenceProviderForMapEntry> entries = new ArrayList<PersistenceProviderForMapEntry>();
                for (Map.Entry mapEntry : this._orderedMap.entrySet()) {
                    PersistenceProviderForMapEntry pme = new PersistenceProviderForMapEntry(mapEntry);
                    entries.add(pme);
                }
                PersistenceProviderForLinkedHashMap.writeRelatedObjects(entries, thisElement, writingContext, "Entries");
            }
        }

        @Override
        public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
            super.consumeRelatedObjects(riHolder);
            List<Object[]> entries = riHolder.consumeForeignObjects("Entries", Object[].class);
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                Object[] entry = entries.get(i);
                this._orderedMap.put(entry[0], entry[1]);
            }
        }
    }
}

