/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.util.impl.MessageFormatter;

public final class MonotonicIntegerToStringMapping {
    private String[] _preferredStringValues;

    public MonotonicIntegerToStringMapping(String[] preferredStringValues, int[] values) {
        this._preferredStringValues = preferredStringValues;
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            if (i == values[i]) continue;
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("MonotonicIntegerToStringMapping.PersistenceArrayInvalid.txt", new Object[0]);
            throw new IQueryServicesRuntimeException(errorMsg);
        }
    }

    public String stringValue(int index) {
        String outString = null;
        outString = index >= 0 && index < this._preferredStringValues.length ? this._preferredStringValues[index] : Integer.toString(index);
        return outString;
    }

    public int intValue(String string, int defaultIndex) throws MetadataException {
        try {
            return this.intValueNoCheckedException(string, defaultIndex);
        }
        catch (NumberFormatException e) {
            MessageFormatter errorMsg = IQMetadataResourceBundle.getMessageFormatter("MonotonicIntegerToStringMapping.InvalidPersistedValue.fmt.txt", string);
            throw new MetadataException(errorMsg);
        }
    }

    public int intValueNoCheckedException(String string, int defaultIndex) {
        int outIndex = defaultIndex;
        if (string != null) {
            outIndex = -1;
            for (int i = 0; i < this._preferredStringValues.length && outIndex == -1; ++i) {
                if (!string.equals(this._preferredStringValues[i])) continue;
                outIndex = i;
            }
            if (outIndex == -1) {
                outIndex = Integer.parseInt(string, 10);
            }
        }
        return outIndex;
    }
}

