/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataNotDeletableException;
import com.sas.iquery.metadata.NamedObjectInterface;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.FolderItem;
import com.sas.iquery.metadata.business.LocalizableModelObject;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.util.LocalizableString;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MapFolderImpl
extends AbstractModelItem
implements MapFolder,
FolderItem,
Cloneable {
    private static final String LOCALIZATION_ID_PREFIX = "MF_LID_";
    public static final String INVALID_LABEL_CHARS = "\\ /";
    private AbstractBusinessModel _model;
    private MapFolder _parent = null;
    private List<MapFolder> _subfolders = new ArrayList<MapFolder>();
    private String _label = "";
    private String _description = "";
    private LocalizableString _descriptions = null;
    private LocalizableString _labels = null;
    private EntityInterface _extendedAttributes = null;
    private String _localizationId = "";
    private static final Logger _logger = LogManager.getLogger(MapFolderImpl.class);
    private static final Class<?>[] VALID_BUSINESS_ITEM_TYPES = new Class[]{BusinessItem.class};
    private static final Class<?>[] VALID_MAPFOLDER_TYPES_TYPES = new Class[]{MapFolder.class};
    private static final String FOLDER_PATH_ROOT = "Root";
    private static final String FOLDER_PATH_SEP = ".";

    MapFolderImpl(AbstractBusinessModel map) {
        this._model = map;
        this._descriptions = new LocalizablePersistableString();
        this._labels = new LocalizablePersistableString();
        this._localizationId = FOLDER_PATH_ROOT;
    }

    MapFolderImpl(AbstractBusinessModel map, MapFolder parent) {
        this._parent = parent;
        this._model = map;
        this._descriptions = new LocalizablePersistableString();
        this._labels = new LocalizablePersistableString();
        this._localizationId = this.getDefaultLocalizationID();
    }

    public MapFolderImpl() {
    }

    @Override
    public MapFolder newSubfolder() {
        MapFolderImpl folder = new MapFolderImpl(this._model, this);
        this._subfolders.add(folder);
        this._model.addMapFolder(folder);
        return folder;
    }

    @Override
    public void addBusinessItem(BusinessItem item) throws MetadataException {
        Preconditions.ensureNonNull(item);
        List<BusinessItem> items = this._model.getObjects(true, BusinessItem.class);
        if (!items.contains(item)) {
            this._model.addBusinessItem(item);
        }
        this._model.addBusinessItemToMapFolder(item, this);
    }

    @Override
    public List<BusinessItem> deleteBusinessItem(BusinessItem item) throws MetadataException {
        if (item == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("MapFolderCanDeleteNullSubfolder.txt", new Object[0]));
        }
        List<BusinessItem> removedItems = this._model.removeBusinessItem(item);
        this.removeBusinessItem(item);
        if (!removedItems.isEmpty()) {
            int count = removedItems.size();
            for (int index = 0; index < count; ++index) {
                this.removeBusinessItem(removedItems.get(index));
            }
        }
        return removedItems;
    }

    @Override
    public void removeBusinessItem(BusinessItem item) {
        if (item == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("MapFolderNoBusinessItem.txt", new Object[0]));
        }
        this._model.removeBusinessItem(item, this);
    }

    @Override
    public void deleteSubfolder(String subfolderLabel) throws MetadataNotDeletableException {
        MapFolder mapToDelete = this.getSubfolder(subfolderLabel);
        this.deleteSubfolder(mapToDelete);
    }

    @Override
    public void deleteSubfolder(MapFolder subfolder) throws MetadataNotDeletableException {
        if (subfolder == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("MapFolderCanDeleteNullSubfolder.txt", new Object[0]));
        }
        if (subfolder == this || !subfolder.getItems().isEmpty() || !subfolder.getSubfolders().isEmpty()) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("MapFolderImpl.UnableToDeleteSubfolder.fmt.txt", subfolder);
            Reason reason = new Reason((Object)this, 7, 81, "MapFolderImpl.UnableToDeleteSubfolder.fmt.txt", subfolder);
            MetadataNotDeletableException e = new MetadataNotDeletableException(msg, 1, Arrays.asList(reason));
            throw e;
        }
        this._subfolders.remove(subfolder);
        this._model.removeMapFolder(subfolder);
    }

    @Override
    public String getDisplayPath() {
        StringBuffer path = null;
        if (this._model != null) {
            MapFolder rootFolder = null;
            try {
                rootFolder = this._model.getRootMapFolder();
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
            if (this.equals(rootFolder)) {
                return "/";
            }
            path = new StringBuffer("/" + this._label);
            for (MapFolder folder = this._parent; folder != null; folder = folder.getParent()) {
                if (!folder.equals(rootFolder)) {
                    path.insert(0, folder.getLabel());
                }
                if (path.charAt(0) == '/') continue;
                path.insert(0, "/");
            }
        }
        return path != null ? path.toString() : null;
    }

    @Override
    public void moveTo(MapFolder newParent) throws MetadataException {
        this.moveChecks(newParent);
        ((MapFolderImpl)newParent).addSubfolder(this);
        ((MapFolderImpl)this._parent).removeSubfolder(this);
        this._parent = newParent;
    }

    private void moveChecks(MapFolder newParent) throws MetadataException {
        if (newParent == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("MapFolderCantMoveNullParentFolder.txt", new Object[0]));
        }
        if (this == newParent) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("MapFolderCantbeParentToSelf.txt", new Object[0]));
        }
        MapFolder rootFolder = this.getRootFolder();
        if (this == rootFolder) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("MapFolderCantMoveRoot.txt", new Object[0]));
        }
        if (this.isFolderBelowThis(newParent)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("MapFolder.CannotMoveToSubfolder.fmt.txt", this.getDisplayPath(), newParent.getDisplayPath()));
        }
    }

    private synchronized boolean isFolderBelowThis(MapFolder folder) {
        boolean rc = false;
        Iterator<MapFolder> it = this._subfolders.iterator();
        while (it.hasNext() && !rc) {
            MapFolderImpl mf = (MapFolderImpl)it.next();
            if (mf == folder) {
                rc = true;
                continue;
            }
            rc = mf.isFolderBelowThis(folder);
        }
        return rc;
    }

    @Override
    public void moveTo(int index, MapFolder newParent) throws MetadataException {
        this.moveChecks(newParent);
        ((MapFolderImpl)newParent).addSubfolder(index, this);
        ((MapFolderImpl)this._parent).removeSubfolder(this);
        this._parent = newParent;
    }

    @Override
    public void moveTo(int index) throws MetadataException {
        MapFolder folder = ((MapFolderImpl)this._parent)._subfolders.get(index);
        if (this == folder) {
            return;
        }
        ((MapFolderImpl)this._parent).removeSubfolder(this);
        ((MapFolderImpl)this._parent).addSubfolder(index, this);
    }

    @Override
    public BusinessItem getItem(String name, Class itemClass) throws MetadataException {
        if (name == null || itemClass == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("MapFolderNullBusinessItem.txt", new Object[0]));
        }
        BusinessItem result = null;
        List<BusinessItem> items = this._model.getMapFolderItems(this);
        int count = items.size();
        for (int index = 0; index < count; ++index) {
            BusinessItem item = items.get(index);
            if (!itemClass.isInstance(item) || !name.equals(item.getLabel())) continue;
            if (result == null) {
                result = item;
                continue;
            }
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("MapFolderDuplicateNames.fmt.txt", name));
        }
        return result;
    }

    @Override
    public void setItems(List<BusinessItem> items) throws MetadataException {
        List<BusinessItem> curItemsInFolder = null;
        boolean setSucceeded = false;
        items = ListUtils.newList(items);
        try {
            curItemsInFolder = this._model.removeAllBusinessItems(this);
            for (BusinessItem item : items) {
                this.addBusinessItem(item);
            }
            setSucceeded = true;
        }
        catch (MetadataException e) {
            _logger.debug("Exception occurred in setItems()", (Throwable)e);
            throw e;
        }
        finally {
            if (!setSucceeded) {
                this.setItems(curItemsInFolder);
            }
        }
    }

    @Override
    public List<BusinessItem> getItems() {
        return new ArrayList<BusinessItem>(this._model.getMapFolderItems(this));
    }

    @Override
    public <T extends BusinessItem> List<T> getItems(Class<T> itemClass) {
        ArrayList<BusinessItem> out = new ArrayList<BusinessItem>();
        List<BusinessItem> items = this._model.getMapFolderItems(this);
        if (itemClass == null) {
            out.addAll(items);
        } else {
            int count = items.size();
            for (int index = 0; index < count; ++index) {
                BusinessItem obj = items.get(index);
                if (!itemClass.isInstance(obj)) continue;
                out.add(obj);
            }
        }
        return out;
    }

    @Override
    public MapFolder getParent() {
        return this._parent;
    }

    @Override
    public MapFolder getSubfolder(String name) {
        MapFolder folder = null;
        boolean found = false;
        int count = this._subfolders.size();
        for (int index = 0; index < count && !found; ++index) {
            MapFolder mf = this._subfolders.get(index);
            if (!name.equals(mf.getLabel())) continue;
            folder = mf;
            found = true;
        }
        return folder;
    }

    @Override
    public List<MapFolder> getSubfolders() {
        return new CopyOnWriteArrayList<MapFolder>(this._subfolders);
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public void setLabel(String label) throws MetadataException {
        if (!this.isValidLabel(label)) {
            Object[] params = new Object[]{label, INVALID_LABEL_CHARS};
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("MapFolder.InvalidLabel.fmt.txt", params));
        }
        this._label = label.trim();
    }

    @Override
    public boolean isValidLabel(String label) {
        boolean valid = true;
        if (label == null) {
            valid = false;
        } else {
            char[] chars;
            for (char c : chars = label.toCharArray()) {
                if (c != '/' && c != '\\') continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(String description) {
        this._description = description;
    }

    private MapFolder getRootFolder() {
        MapFolder result = this;
        MapFolder parent = result.getParent();
        while (parent != null) {
            result = parent;
            parent = result.getParent();
        }
        return result;
    }

    private void addSubfolder(MapFolder subfolder) {
        this._subfolders.add(subfolder);
    }

    private void addSubfolder(int index, MapFolder subfolder) {
        this._subfolders.add(index, subfolder);
    }

    private void removeSubfolder(MapFolder subfolder) {
        this._subfolders.remove(subfolder);
    }

    @Override
    public void setExtendedAttributes(EntityInterface attrEntity) throws MetadataException {
        this._extendedAttributes = attrEntity;
    }

    @Override
    public EntityInterface getExtendedAttributes() {
        return this._extendedAttributes;
    }

    @Override
    protected String getDefinitionElementName() {
        return "MapFolder";
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        String key;
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "label", this._label);
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "desc", this._description);
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "lid", this._localizationId);
        MapFolderImpl.writeForeignObjectUnderNewSubelement(this._extendedAttributes, thisElement, writingContext, "ExtendedAttributes");
        List<BusinessItem> items = this._model.getMapFolderItems(this);
        MapFolderImpl.writeRelatedObjects(items, thisElement, writingContext, "FolderItems");
        MapFolderImpl.writeRelatedObjects(this._subfolders, thisElement, writingContext, "Subfolders");
        String keyValue = this.getLocalizationPrependKey() + FOLDER_PATH_SEP + this.getLocalizationID();
        if (this._labels != null && (this._labels.getLocales().size() > 0 || this._labels.getDefaultLocale() != null)) {
            if (writingContext.isWriteOperationToOMR()) {
                key = keyValue + FOLDER_PATH_SEP + "Label";
                writingContext.addLocalizableString(key, this._labels);
            } else {
                MapFolderImpl.writeForeignObjectUnderNewSubelement(this._labels, thisElement, writingContext, "Labels");
            }
        }
        if (this._descriptions != null && (this._descriptions.getLocales().size() > 0 || this._descriptions.getDefaultLocale() != null)) {
            if (writingContext.isWriteOperationToOMR()) {
                key = keyValue + FOLDER_PATH_SEP + "Description";
                writingContext.addLocalizableString(key, this._descriptions);
            } else {
                MapFolderImpl.writeForeignObjectUnderNewSubelement(this._descriptions, thisElement, writingContext, "Descs");
            }
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._label = attrsProvider.consumeAttrEmptyDefault("label");
        this._description = attrsProvider.consumeAttrEmptyDefault("desc");
        this._localizationId = attrsProvider.consumeAttrEmptyDefault("lid");
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._extendedAttributes = (EntityInterface)riHolder.consumeForeignObject("ExtendedAttributes");
        this._subfolders = riHolder.consumeObjects("Subfolders", MapFolder.class);
        int size = this._subfolders.size();
        for (int i = 0; i < size; ++i) {
            MapFolderImpl mfi = (MapFolderImpl)this._subfolders.get(i);
            mfi._parent = this;
        }
        this._model.addMapFolder(this);
        List<BusinessItem> items = riHolder.consumeObjects("FolderItems", BusinessItem.class);
        for (BusinessItem item : items) {
            this._model.addBusinessItemToMapFolder(item, this);
        }
        this._labels = (LocalizableString)riHolder.consumeForeignObject("Labels");
        if (this._labels == null) {
            this._labels = new LocalizablePersistableString();
        }
        this._descriptions = (LocalizableString)riHolder.consumeForeignObject("Descs");
        if (this._descriptions == null) {
            this._descriptions = new LocalizablePersistableString();
        }
    }

    @Override
    protected boolean mustCallConsumeRelatedObjects() {
        return true;
    }

    void setMap(InformationMapImpl2 map) {
        this._model = map;
    }

    @Override
    void setModel(AbstractModel model) {
        this._model = (AbstractBusinessModel)model;
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._label = IQModelImplUtilities.getAttr(thisElement, "label");
        this._description = IQModelImplUtilities.getAttr(thisElement, "desc");
        this._model = (InformationMapImpl2)readingContext.getModelBeingRead();
        this._model.addMapFolder(this);
        List items = MapFolderImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "BusinessItemList", VALID_BUSINESS_ITEM_TYPES);
        for (int i = 0; i < items.size(); ++i) {
            this._model.addBusinessItemToMapFolder((BusinessItem)items.get(i), this);
        }
        this._subfolders = MapFolderImpl.v1_readItemListDirectlyUnderElement(thisElement, readingContext, "MapFolder", VALID_MAPFOLDER_TYPES_TYPES);
        int size = this._subfolders.size();
        for (int i = 0; i < size; ++i) {
            MapFolderImpl mfi = (MapFolderImpl)this._subfolders.get(i);
            mfi._parent = this;
        }
        this._extendedAttributes = this.v1_readExtendedAttributes(thisElement);
    }

    public String toDebugString() {
        return "Label : " + this.getLabel() + " Description : " + this.getDescription() + " Path : " + this.getDisplayPath();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MapFolderImpl clone = (MapFolderImpl)super.clone();
        clone._subfolders = new ArrayList<MapFolder>();
        EntityInterface entity = this.getExtendedAttributes();
        if (entity != null) {
            try {
                clone._extendedAttributes = Utils.copy(entity);
            }
            catch (MetadataException e) {
                CloneNotSupportedException e2 = new CloneNotSupportedException(IQMetadataResourceBundle.getMessageString("MapFolderImpl.CannotCloneAttributes.fmt.txt", this.getLabel()));
                e2.initCause(e);
                throw e2;
            }
        }
        ((MapFolderImpl)this.getParent())._subfolders.add(clone);
        this._model.addMapFolder(clone);
        return clone;
    }

    public Map copyTo(MapFolder newParent, boolean recursive) throws MetadataException {
        if (recursive && this.isFolderBelowThis(newParent)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("MapFolder.CannotRecursivelyCopyToSubfolder.fmt.txt", this.getDisplayPath(), newParent.getDisplayPath()));
        }
        HashMap rules = new HashMap();
        MapFolderImpl clone = null;
        try {
            clone = (MapFolderImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(e);
        }
        clone.moveTo(newParent);
        try {
            this._model.ruleBasedResourceReplacement(this, clone, rules, false);
            if (recursive) {
                List<MapFolder> subfolders = this.getSubfolders();
                for (MapFolder mapFolder : subfolders) {
                    FolderItem fi;
                    if (!(mapFolder instanceof FolderItem) || !(fi = (FolderItem)((Object)mapFolder)).canCopy()) continue;
                    Map<FolderItem, FolderItem> retMap = fi.copyTo(clone, recursive);
                    for (Map.Entry<FolderItem, FolderItem> entry : retMap.entrySet()) {
                        FolderItem folderItem = entry.getKey();
                        FolderItem value = entry.getValue();
                        this._model.ruleBasedResourceReplacement((NamedObjectInterface)((Object)folderItem), (NamedObjectInterface)((Object)value), rules, false);
                    }
                }
                List<BusinessItem> subItems = this.getItems();
                for (BusinessItem bi : subItems) {
                    FolderItem fi;
                    if (!(bi instanceof FolderItem) || !(fi = (FolderItem)((Object)bi)).canCopy()) continue;
                    Map<FolderItem, FolderItem> retMap = fi.copyTo(clone, recursive);
                    for (Map.Entry<FolderItem, FolderItem> entry : retMap.entrySet()) {
                        FolderItem key = entry.getKey();
                        FolderItem value = entry.getValue();
                        this._model.ruleBasedResourceReplacement((NamedObjectInterface)((Object)key), (NamedObjectInterface)((Object)value), rules, false);
                    }
                }
            }
        }
        catch (MetadataException e) {
            if (recursive) {
                ArrayList<MapFolder> folders = new ArrayList<MapFolder>();
                for (Object obj : rules.keySet()) {
                    Object clonedObj = rules.get(obj);
                    if (clonedObj == null) continue;
                    if (clonedObj instanceof BusinessItem) {
                        BusinessItem item = (BusinessItem)clonedObj;
                        BusinessModel businessModel = item.getBusinessModel();
                        if (businessModel != null) {
                            businessModel.removeBusinessItem(item);
                        }
                        rules.remove(obj);
                        continue;
                    }
                    if (!(clonedObj instanceof MapFolder)) continue;
                    folders.add(0, (MapFolder)clonedObj);
                    rules.remove(obj);
                }
                for (MapFolder folder : folders) {
                    MapFolder parent = folder.getParent();
                    if (parent == null) continue;
                    parent.deleteSubfolder(folder);
                }
            }
            ((MapFolderImpl)newParent).removeSubfolder(clone);
            throw e;
        }
        return rules;
    }

    @Override
    public boolean canCopy() {
        MapFolder rootFolder = this.getRootFolder();
        return this != rootFolder;
    }

    @Override
    public boolean canMove() {
        MapFolder rootFolder = this.getRootFolder();
        return this != rootFolder;
    }

    public Map copyFolderItems(List listOfFolderItemsToCopy) throws MetadataException {
        HashMap mapOfAllObjectsCopied = new HashMap();
        for (int i = 0; i < listOfFolderItemsToCopy.size(); ++i) {
            FolderItem value;
            Object obj = listOfFolderItemsToCopy.get(i);
            if (!(obj instanceof FolderItem)) continue;
            FolderItem folderItem = (FolderItem)obj;
            Map<FolderItem, FolderItem> mapOfCurrentlyCopiedItems = null;
            try {
                mapOfCurrentlyCopiedItems = folderItem.copyTo(this, true);
                for (Map.Entry<FolderItem, FolderItem> entry : mapOfCurrentlyCopiedItems.entrySet()) {
                    FolderItem key = entry.getKey();
                    value = entry.getValue();
                    this._model.ruleBasedResourceReplacement((NamedObjectInterface)((Object)key), (NamedObjectInterface)((Object)value), mapOfAllObjectsCopied, false);
                }
                continue;
            }
            catch (MetadataException me) {
                _logger.error("copyFolderItems", (Throwable)me);
                if (mapOfCurrentlyCopiedItems != null) {
                    for (FolderItem key : mapOfCurrentlyCopiedItems.keySet()) {
                        value = mapOfCurrentlyCopiedItems.get(key);
                        if (value instanceof BusinessItem) {
                            this.removeBusinessItem((BusinessItem)((Object)value));
                        }
                        mapOfAllObjectsCopied.remove(key);
                    }
                }
                for (FolderItem key : mapOfAllObjectsCopied.keySet()) {
                    value = mapOfAllObjectsCopied.get(key);
                    if (!(value instanceof BusinessItem)) continue;
                    this.removeBusinessItem((BusinessItem)((Object)value));
                }
                throw me;
            }
        }
        return mapOfAllObjectsCopied;
    }

    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        if (this._subfolders != null) {
            intoList.addAll(this._subfolders);
        }
    }

    protected void accumulateDirectlyReferencedItemsInNonDownwardDefinition(List intoList) {
        intoList.add(this._parent);
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._parent = (MapFolder)MapFolderImpl.replace(this._parent, oldObject, newObject);
        MapFolderImpl.replaceInList(this._subfolders, oldObject, newObject);
    }

    @Override
    public String getDescription(Locale locale) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale(this._model);
        }
        LocalizableString descriptions = this._getDescriptions();
        String result = null;
        if (descriptions != null) {
            result = descriptions.getText(locale);
        }
        if (result == null) {
            result = this.getDescription();
        }
        return result;
    }

    @Override
    public LocalizableString getDescriptions() {
        LocalizableString dup = null;
        LocalizableString descriptions = this._getDescriptions();
        if (descriptions != null) {
            try {
                dup = (LocalizableString)descriptions.clone();
            }
            catch (CloneNotSupportedException e) {
                dup = IQModelImplUtilities.copyToLocalizablePersistableString(descriptions);
            }
        }
        return dup;
    }

    @Override
    public String getLabel(Locale locale) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale(this._model);
        }
        LocalizableString labels = this._getLabels();
        String result = null;
        if (labels != null) {
            result = labels.getText(locale);
        }
        if (result == null) {
            result = this.getLabel();
        }
        return result;
    }

    @Override
    public LocalizableString getLabels() {
        LocalizableString dup = null;
        LocalizableString labels = this._getLabels();
        if (labels != null) {
            try {
                dup = (LocalizableString)labels.clone();
            }
            catch (CloneNotSupportedException e) {
                dup = IQModelImplUtilities.copyToLocalizablePersistableString(labels);
            }
        }
        return dup;
    }

    @Override
    public void setDescription(String description, Locale locale) throws MetadataException {
        LocalizableString descriptions = this._getDescriptions();
        this._updateLocalizableString(descriptions, locale, description, "localizable descriptions changed");
    }

    @Override
    public void setDescriptions(LocalizableString descriptions) throws MetadataException {
        LocalizableString oldDescs = this._getDescriptions();
        this._updateLocalizableString(oldDescs, descriptions, "localizable descriptions changed");
    }

    @Override
    public void setLabel(String label, Locale locale) throws MetadataException {
        LocalizableString labels = this._getLabels();
        this._updateLocalizableString(labels, locale, label, "localizable labels changed");
    }

    @Override
    public void setLabels(LocalizableString labels) throws MetadataException {
        LocalizableString oldLabels = this._getLabels();
        this._updateLocalizableString(oldLabels, labels, "localizable labels changed");
    }

    private void _updateLocalizableString(LocalizableString localizableString, Locale locale, String text, String propertyChangeEventId) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale(this._model);
        }
        if (localizableString != null) {
            List knownLocales = localizableString.getLocales();
            if (text == null) {
                if (knownLocales.contains(locale)) {
                    this.changeableCheck();
                    localizableString.clearText(locale);
                    this.fireChangeEvent(propertyChangeEventId, locale, null);
                }
            } else if (!knownLocales.contains(locale)) {
                this.changeableCheck();
                localizableString.setText(text, locale);
                this.fireChangeEvent(propertyChangeEventId, null, locale);
            } else {
                String oldText = localizableString.getText(locale);
                if (!IQModelImplUtilities.same(oldText, text)) {
                    this.changeableCheck();
                    localizableString.setText(text, locale);
                    this.fireChangeEvent(propertyChangeEventId, locale, locale);
                }
            }
        }
    }

    private void _updateLocalizableString(LocalizableString copyTo, LocalizableString copyFrom, String propertyChangeEventId) {
        if (copyTo != null && !IQModelImplUtilities.same(copyTo, copyFrom)) {
            boolean changed = false;
            if (copyFrom == null) {
                if (copyTo.getDefaultLocale() != null) {
                    this.changeableCheck();
                    copyTo.setDefaultLocale(null);
                    changed = true;
                }
                if (copyTo.getLocales().size() > 0) {
                    this.changeableCheck();
                    copyTo.clearAll();
                    changed = true;
                }
            } else {
                Locale fromDefaultLocale = copyFrom.getDefaultLocale();
                Locale toDefaultLocale = copyTo.getDefaultLocale();
                if (fromDefaultLocale == null && toDefaultLocale != null || fromDefaultLocale != null && (toDefaultLocale == null || !fromDefaultLocale.equals(toDefaultLocale))) {
                    this.changeableCheck();
                    copyTo.setDefaultLocale(fromDefaultLocale);
                    changed = true;
                }
                List fromLocales = copyFrom.getLocales();
                List toLocales = copyTo.getLocales();
                for (Locale toLocale : toLocales) {
                    if (fromLocales.contains(toLocale)) continue;
                    this.changeableCheck();
                    copyTo.clearText(toLocale);
                    changed = true;
                }
                for (Locale fromLocale : fromLocales) {
                    String fromText = copyFrom.getText(fromLocale);
                    if (toLocales.contains(fromLocale)) {
                        String toText = copyTo.getText(fromLocale);
                        if ((fromText != null || toText == null) && (fromText == null || toText != null && fromText.equals(toText))) continue;
                        this.changeableCheck();
                        copyTo.setText(fromText, fromLocale);
                        changed = true;
                        continue;
                    }
                    this.changeableCheck();
                    copyTo.setText(fromText, fromLocale);
                    changed = true;
                }
            }
            if (changed) {
                this.fireChangeEvent(propertyChangeEventId, null, copyTo);
            }
        }
    }

    protected LocalizableString _getDescriptions() {
        this.loadAllLocalizableProperties();
        return this._descriptions;
    }

    protected LocalizableString _getLabels() {
        this.loadAllLocalizableProperties();
        return this._labels;
    }

    @Override
    public String getLocalizationID() throws MetadataException {
        String id = null;
        if (this._localizationId == null || this._localizationId.length() == 0) {
            MapFolder root = this._model.getRootMapFolder();
            StringBuffer buffer = new StringBuffer();
            this.getFolderUniquePath(buffer, this, root);
            id = buffer.toString();
        } else {
            id = this._localizationId;
        }
        return id;
    }

    private void getFolderUniquePath(StringBuffer buffer, MapFolder mapFolder, MapFolder rootFolder) throws MetadataException {
        MapFolder parentFolder = mapFolder.getParent();
        if (parentFolder == null) {
            if (mapFolder == this._model.getRootMapFolder()) {
                buffer.append(FOLDER_PATH_ROOT);
            }
        } else {
            this.getFolderUniquePath(buffer, parentFolder, rootFolder);
            List<MapFolder> subfolders = parentFolder.getSubfolders();
            int size = subfolders.size();
            for (int i = 0; i < size; ++i) {
                MapFolder subFolder = subfolders.get(i);
                if (subFolder != mapFolder) continue;
                buffer.append(FOLDER_PATH_SEP).append(i);
            }
        }
    }

    public final String toString() {
        return this.getLabel();
    }

    public String toString(Locale locale) {
        String result = null;
        if (locale == null) {
            result = this.toString();
        } else {
            result = this.getLabel(locale);
            if (result == null) {
                result = this.toString();
            }
        }
        return result;
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws MetadataException {
        PropertyList foldersList = new PropertyList();
        if (locale == null) {
            foldersList.addComment("Folder '" + this.getLabel() + "':");
        } else {
            foldersList.addComment("Folder '" + this.getLabel(locale) + "':");
        }
        PropertyList folderProperties = this.newLocalizableProperties(locale, this);
        return folderProperties;
    }

    protected PropertyList newLocalizableProperties(Locale locale, LocalizableModelObject bi) throws MetadataException {
        PropertyList list = new PropertyList();
        if (locale == null) {
            list.addProperty("Label", bi.getLabel());
            list.addProperty("Description", bi.getDescription());
        } else {
            list.addProperty("Label", bi.getLabel(locale));
            list.addProperty("Description", bi.getDescription(locale));
        }
        return list;
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap nestedMap) throws MetadataException {
        String localizeKey = this.getLocalizationID();
        if (nestedMap.containsNestedProperty(localizeKey)) {
            PropertyMap objectMap = nestedMap.getNestedProperties(localizeKey);
            try {
                if (objectMap.containsProperty("Label")) {
                    this.setLabel(objectMap.getProperty("Label"), locale);
                }
                if (objectMap.containsProperty("Description")) {
                    this.setDescription(objectMap.getProperty("Description"), locale);
                }
            }
            catch (MetadataException e) {
                throw new UnexpectedLocalizationException((Throwable)e);
            }
        }
    }

    private synchronized String getDefaultLocalizationID() {
        List<String> idsInUse = this._model.getAllContainedIntraModelIDs();
        Set<MapFolder> inUseFolders = this._model.getAllFolders();
        for (MapFolder folder : inUseFolders) {
            try {
                String id = folder.getLocalizationID();
                if (id == null || id.length() <= 0) continue;
                idsInUse.add(id);
            }
            catch (MetadataException e) {
                _logger.debug("failed getting loc id ", (Throwable)e);
            }
        }
        String defaultID = null;
        boolean inUse = true;
        while (inUse) {
            defaultID = LOCALIZATION_ID_PREFIX + this._model.newDefaultIDNumber();
            inUse = idsInUse.contains(defaultID);
        }
        return defaultID;
    }

    @Override
    AbstractModel getModel() {
        return this._model;
    }

    @Override
    public boolean isEmpty() {
        List<BusinessItem> items = this._model.getMapFolderItems(this);
        if (items != null && !items.isEmpty()) {
            return false;
        }
        if (this._subfolders != null && !this._subfolders.isEmpty()) {
            return false;
        }
        return this._extendedAttributes == null;
    }

    @Override
    public String getLocalizationPrependKey() {
        return "Folders";
    }

    public void loadAllLocalizableProperties() {
        for (AbstractModel model = this.getModel(); model != null; model = model.getParent()) {
            if (!(model instanceof InformationMapImpl2)) continue;
            try {
                ((InformationMapImpl2)model).loadAllLocalizableProperties();
                continue;
            }
            catch (MetadataException e) {
                _logger.warn(this.getClass().getName(), (Throwable)e);
            }
        }
    }
}

