/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.AggregateEntity;
import com.sas.entities.EntityInterface;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.BusinessQueryTotalModeType;
import com.sas.iquery.metadata.business.CascadeRule;
import com.sas.iquery.metadata.business.CascadeRuleSet;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.FilterSetMember;
import com.sas.iquery.metadata.business.LookThroughDataSelection;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RunStoredProcess;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.CascadeRuleImpl;
import com.sas.iquery.metadata.business.impl.CascadeRuleItemImpl;
import com.sas.iquery.metadata.business.impl.CascadeRuleSetImpl;
import com.sas.iquery.metadata.business.impl.DataSelectionImpl;
import com.sas.iquery.metadata.business.impl.DataSelectionReadingContext;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCache;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCacheSupport;
import com.sas.iquery.metadata.business.impl.OverriddenQueryProperties;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.Preconditions;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.session.SessionContextInterface;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class LookThroughDataSelectionImpl
extends DataSelectionImpl
implements LookThroughDataSelection {
    public static final String ELEMENT_LOOK_THROUGH_DATA_SELECTION = "LookThroughDataSelection";
    private boolean emptyDataFormatModified = false;
    private boolean sortOrderPrecedenceModified = false;
    private boolean totalModeModified = false;
    private OverriddenQueryProperties overriddenQueryProperties = new OverriddenQueryProperties();
    private AggregateEntity aggregateEntity;
    private static final Logger _logger = LogManager.getLogger(LookThroughDataSelectionImpl.class);

    public LookThroughDataSelectionImpl() {
    }

    public LookThroughDataSelectionImpl(DataSelectionImpl parent) {
        super(parent);
    }

    public LookThroughDataSelectionImpl(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service) {
        super(session, service);
    }

    @Nullable
    private DataSelection getParentDS() {
        return this.getParentDataSelection();
    }

    @Override
    public List<FilterItem> getEffectiveFilters(EffectiveObjectsCache effectiveObjectsCache) {
        List<FilterItem> effectiveFilters;
        DataSelection parentDS = this.getParentDS();
        ArrayList<FilterItem> out = parentDS != null ? ((effectiveFilters = parentDS.getEffectiveFilters()) != null ? new ArrayList<FilterItem>(effectiveFilters) : new ArrayList()) : new ArrayList();
        List<FilterItem> filters = super.getFilters();
        Utils.addButNoDuplicates(out, filters);
        return out;
    }

    @Override
    public void resetFilters() throws MetadataException {
        super.setFilters((List)new ArrayList());
    }

    @Override
    public boolean areFiltersModified() {
        return super.getFilters().size() > 0;
    }

    public List<BusinessGroup> getEffectiveGroups(EffectiveObjectsCache effectiveObjectsCache) {
        List<BusinessGroup> effectiveGroups;
        DataSelection parentDS = this.getParentDS();
        ArrayList<BusinessGroup> out = parentDS != null ? ((effectiveGroups = parentDS.getEffectiveGroups()) != null ? new ArrayList<BusinessGroup>(effectiveGroups) : new ArrayList()) : new ArrayList();
        List<BusinessGroup> Groups = super.getGroups();
        Utils.addButNoDuplicates(out, Groups);
        return out;
    }

    @Override
    public void resetGroups() throws MetadataException {
        super.setGroups(new ArrayList<BusinessGroup>());
    }

    @Override
    public boolean areGroupsModified() {
        return super.getGroups().size() > 0;
    }

    @Override
    public String getEmptyDataFormat() {
        DataSelection parentDS;
        String out = null;
        out = this.emptyDataFormatModified ? super.getEmptyDataFormat() : ((parentDS = this.getParentDS()) != null ? parentDS.getEmptyDataFormat() : "");
        return out;
    }

    @Override
    public void setEmptyDataFormat(String format) throws MetadataException {
        boolean savedFlag = this.emptyDataFormatModified;
        try {
            this.emptyDataFormatModified = true;
            super.setEmptyDataFormat(format);
        }
        catch (MetadataException e) {
            this.emptyDataFormatModified = savedFlag;
            throw e;
        }
    }

    @Override
    public void resetEmptyDataFormat() throws MetadataException {
        this.emptyDataFormatModified = false;
        this.fireChangeEvent("The empty data format has changed");
    }

    @Override
    public boolean isEmptyDataFormatModified() {
        return this.emptyDataFormatModified;
    }

    @Override
    public void resetTotalMode() throws MetadataException {
        this.totalModeModified = false;
        this.fireChangeEvent("The totaling mode for query has changed");
    }

    @Override
    public boolean isTotalModeModified() {
        return this.totalModeModified;
    }

    @Override
    public BusinessQueryTotalModeType getTotalMode() {
        DataSelection parentDS;
        BusinessQueryTotalModeType out = null;
        out = this.totalModeModified ? super.getTotalMode() : ((parentDS = this.getParentDS()) != null ? parentDS.getTotalMode() : BusinessQueryTotalModeType.VISUAL_VALUES);
        return out;
    }

    @Override
    public void setTotalMode(BusinessQueryTotalModeType totalMode) throws IllegalArgumentException {
        boolean savedFlag = this.totalModeModified;
        try {
            this.totalModeModified = true;
            super.setTotalMode(totalMode);
        }
        catch (IllegalArgumentException e) {
            this.totalModeModified = savedFlag;
            throw e;
        }
    }

    @Override
    public boolean getQueryProperty(BusinessQueryProperty property) {
        DataSelection parentDS;
        Preconditions.ensureNonNull(property, "business query property");
        Boolean bool = this.overriddenQueryProperties.get(property);
        boolean out = bool != null ? bool : ((parentDS = this.getParentDS()) != null ? parentDS.getQueryProperty(property) : false);
        return out;
    }

    @Override
    public void setQueryProperty(BusinessQueryProperty property, boolean value) throws MetadataException {
        this.setQueryPropertyCheck(property, value);
        if (this.overriddenQueryProperties.set(property, value)) {
            this.fireChangeEvent("A query property has changed");
        }
    }

    @Override
    public void resetQueryProperty(BusinessQueryProperty property) throws MetadataException {
        Preconditions.ensureNonNull(property, "business query property");
        this.overriddenQueryProperties.remove(property);
        this.fireChangeEvent("A query property has changed");
    }

    @Override
    public boolean isQueryPropertyModified(BusinessQueryProperty property) {
        Preconditions.ensureNonNull(property, "business query property");
        return this.overriddenQueryProperties.contains(property);
    }

    public Map<BusinessQueryProperty, Boolean> getOverriddenQueryProperties() {
        return this.overriddenQueryProperties.getProperties();
    }

    @Override
    public void addResultItem(DataItem dataItem, Role role) throws MetadataException {
        Preconditions.ensureNonNull(dataItem, "dataItem");
        super.addResultItem(dataItem, role);
    }

    private List<DataItem> getRecursiveDataItemsUsedByParentResultItems() {
        ArrayList<DataItem> out = new ArrayList<DataItem>();
        DataSelection parentDS = this.getParentDS();
        if (parentDS != null) {
            List<DataItem> ris = parentDS.getResultItems();
            for (DataItem parentResultItem : ris) {
                List<DataItem> resources = parentResultItem.getResources(DataItem.class, 65535);
                IQModelImplUtilities.addButNoDuplicates(out, resources);
            }
        }
        return out;
    }

    private List<Reason> reasonsNotValidToUseAsResultItems(List<DataItem> dataItems) {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        if (_logger.isDebugEnabled()) {
            _logger.debug("State of the LookThroughDataSelection in isValidToUseAsResultItems");
            _logger.debug("\n\n" + this.getFamilyStateDebugString() + "\n\n");
            _logger.debug("List of data items to validate as result items for the look through data selection " + this.getLabel() + " (id=" + this.getID() + ")\n" + dataItems.toString());
        }
        for (DataItem dataItem : dataItems) {
            DataSelection parentDS = this.getParentDS();
            List<DataItem> parentResultItems = parentDS != null ? parentDS.getResultItems() : new ArrayList<DataItem>();
            if (dataItem.getBusinessModel() != this) {
                List<DataItem> recursiveParentResources;
                if (parentResultItems.contains(dataItem) || (recursiveParentResources = this.getRecursiveDataItemsUsedByParentResultItems()).contains(dataItem)) continue;
                reasons.add(new Reason((Object)dataItem, 2, 111, "LookThroughDataSelection.InvalidResultItem.txt", new Object[0]));
                continue;
            }
            List<DataItem> nonrecursiveDataItemResources = dataItem.getResources(DataItem.class, 0);
            List<DataItem> recursiveParentResources = this.getRecursiveDataItemsUsedByParentResultItems();
            for (DataItem diResource : nonrecursiveDataItemResources) {
                if (dataItems.contains(diResource) || parentResultItems.contains(diResource) || recursiveParentResources.contains(diResource)) continue;
                reasons.add(new Reason((Object)diResource, 2, 111, "LookThroughDataSelection.InvalidResultItem.txt", new Object[0]));
            }
        }
        return reasons;
    }

    @Override
    public void addResultItems(@Nonnull List<? extends DataItem> dataItems, Role role) throws MetadataException {
        Preconditions.ensureNonNull(dataItems, "dataItems");
        super.addResultItems(dataItems, role);
    }

    @Override
    public void setResultItems(List<? extends DataItem> dataItems) throws MetadataException {
        Preconditions.ensureNonNull(dataItems, "dataItems");
        super.setResultItems(dataItems);
    }

    @Override
    public void insertResultItemsAt(DataItem dataItem, Role role, int index) throws MetadataException {
        Preconditions.ensureNonNull(dataItem, "dataItem");
        super.insertResultItemsAt(dataItem, role, index);
    }

    @Override
    public void insertSelectedItemAt(SelectedItem item, int index) throws MetadataException {
        Preconditions.ensureNonNull(item, "dataitem");
        super.insertSelectedItemAt(item, index);
    }

    @Override
    public EntityInterface getEntity() {
        if (this.aggregateEntity == null) {
            this.aggregateEntity = new AggregateEntity();
        }
        Map oldEntities = this.aggregateEntity.getEntities();
        Set keys = oldEntities.keySet();
        Object[] keyArray = keys.toArray();
        for (int index = 0; index < keyArray.length; ++index) {
            this.aggregateEntity.removeEntity((EntityInterface)keyArray[index]);
        }
        this.aggregateEntity.addEntity(super.getEntity(), this.getID());
        DataSelection parentDS = this.getParentDS();
        if (parentDS != null) {
            this.aggregateEntity.addEntity(parentDS.getEntity(), parentDS.getID());
        }
        return this.aggregateEntity.getEntityInterface();
    }

    @Override
    public EntityInterface getNonInheritedEntity() {
        return super.getInternalEntity();
    }

    @Override
    public PromptValuesInterface getPromptValues(EffectiveObjectsCache effectiveObjectsCache) {
        return this.getPromptValues(true, effectiveObjectsCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final PromptValuesInterface getPromptValues(boolean recursive) {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            PromptValuesInterface promptValuesInterface = this.getPromptValues(recursive, effectiveObjectCache);
            return promptValuesInterface;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    protected PromptValuesInterface getPromptValues(boolean recursive, EffectiveObjectsCache effectiveObjectsCache) {
        PromptValuesInterface values = super.getPromptValues(effectiveObjectsCache);
        if (recursive) {
            PromptValues allValues = new PromptValues((PromptGroupInterface)new PromptGroup());
            DataSelection parentDS = this.getParentDS();
            PromptValuesInterface parentPromptValues = null;
            if (parentDS instanceof DataSelectionImpl) {
                parentPromptValues = ((DataSelectionImpl)parentDS).getPromptValues(effectiveObjectsCache);
                allValues.addPromptValuesDelegate(parentPromptValues);
            } else if (parentDS != null) {
                parentPromptValues = parentDS.getPromptValues();
                allValues.addPromptValuesDelegate(parentPromptValues);
            }
            allValues.addPromptValuesDelegate(values);
            values = allValues;
        }
        return values;
    }

    @Override
    @Nonnull
    protected Map<FilterSetMember, List<Prompt>> getPromptsInDataSourcePrefilters(EffectiveObjectsCache effectiveObjectsCache) {
        return Collections.emptyMap();
    }

    @Override
    protected List<RunStoredProcess> getParameterizedStoredProcesses() {
        return this.getObjects(false, RunStoredProcess.class);
    }

    @Override
    public List<DataItem> getEffectiveSortOrderPrecedence() {
        List<DataItem> sortOrder = this.getLookThroughSortOrderPrecedence();
        return this.getEffectiveSortOrderPrecedence(sortOrder);
    }

    private List<DataItem> getLookThroughSortOrderPrecedence() {
        DataSelection parentDS;
        List<DataItem> sortOrder = this.sortOrderPrecedenceModified ? super.getSortOrderPrecedence() : ((parentDS = this.getParentDS()) instanceof LookThroughDataSelectionImpl ? ((LookThroughDataSelectionImpl)parentDS).getLookThroughSortOrderPrecedence() : (parentDS != null ? parentDS.getSortOrderPrecedence() : new ArrayList<DataItem>()));
        return sortOrder;
    }

    @Override
    public void setSortOrderPrecedence(List sortOrderPrecedence) throws MetadataException {
        boolean savedFlag = this.sortOrderPrecedenceModified;
        try {
            this.sortOrderPrecedenceModified = true;
            super.setSortOrderPrecedence(sortOrderPrecedence);
        }
        catch (MetadataException e) {
            this.sortOrderPrecedenceModified = savedFlag;
            throw e;
        }
    }

    @Override
    public void resetSortOrderPrecedence() throws MetadataException {
        this.sortOrderPrecedenceModified = false;
        this.fireChangeEvent("The sort order list has changed");
    }

    @Override
    public boolean isSortOrderPrecedenceModified() {
        return this.sortOrderPrecedenceModified;
    }

    @Override
    public void resetSolveOrderPrecedence() throws MetadataException {
    }

    @Override
    public boolean isSolveOrderPrecedenceModified() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object objThatChanged = event.getSource();
        if (objThatChanged instanceof DataSelection) {
            String propertyName = event.getPropertyName();
            if (propertyName.equals("The query's definition has changed and may cause different resultset results since prior to the definition change.")) {
                super.fireChangeEvent(propertyName);
            } else if (propertyName.equals("child business model added") || propertyName.equals("child business model removed")) {
                this.aggregateEntity = null;
                super.fireChangeEvent(propertyName);
            }
        } else {
            super.propertyChange(event);
        }
    }

    @Override
    protected String getDefinitionElementName() {
        return ELEMENT_LOOK_THROUGH_DATA_SELECTION;
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this.totalModeModified = attrsProvider.consumeBooleanAttr("totalModeModified", false);
        this.emptyDataFormatModified = attrsProvider.consumeBooleanAttr("emptyDataFormatModified", false);
        this.sortOrderPrecedenceModified = attrsProvider.consumeBooleanAttr("sortOrderPrecedenceModified", false);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        OverriddenQueryProperties tempQueryProperties = (OverriddenQueryProperties)riHolder.consumeObject("OverriddenQueryProps");
        if (tempQueryProperties != null) {
            this.overriddenQueryProperties = tempQueryProperties;
        }
    }

    @Override
    public void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        if (this.emptyDataFormatModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "emptyDataFormatModified", this.emptyDataFormatModified);
        } else {
            IQModelImplUtilities.removeAttr(thisElement, "emptyDataFormat");
        }
        if (this.totalModeModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "totalModeModified", this.totalModeModified);
        } else {
            IQModelImplUtilities.removeAttr(thisElement, "totalMode");
        }
        if (this.sortOrderPrecedenceModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "sortOrderPrecedenceModified", this.sortOrderPrecedenceModified);
        } else {
            IQModelImplUtilities.removeSubelement(thisElement, "SortOrderPrecedence");
        }
        if (this.overriddenQueryProperties.containsPersistableValues()) {
            LookThroughDataSelectionImpl.writeRelatedObject(this.overriddenQueryProperties, thisElement, writingContext, "OverriddenQueryProps");
        }
    }

    public static LookThroughDataSelection readInNewLookThroughDataSelection(SessionContextInterface session, IntelligentQueryMetadataServiceInterface iqService, Element ltdsElement, Map reuseModels) throws MetadataException {
        LookThroughDataSelectionImpl outLTDS = new LookThroughDataSelectionImpl(session, iqService);
        ModelVersion ver = IQModelImplUtilities.getModelVersionAttr(ltdsElement, "ver");
        boolean v2XML = outLTDS.checkModelVersion(ver);
        if (v2XML) {
            ReadingContextV2 readingContext = new ReadingContextV2(outLTDS);
            readingContext.setModelsToReuse(reuseModels);
            outLTDS.readV2(ltdsElement, readingContext);
        } else {
            DataSelectionReadingContext readingContext = new DataSelectionReadingContext(outLTDS, reuseModels);
            outLTDS.readV1(ltdsElement, readingContext);
        }
        return outLTDS;
    }

    @Override
    protected void readDefinitionV1(Element bqElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(bqElement, readingContext);
        this.emptyDataFormatModified = IQModelImplUtilities.getBooleanAttr(bqElement, "emptyDataFormatModified", false);
        this.sortOrderPrecedenceModified = IQModelImplUtilities.getBooleanAttr(bqElement, "sortOrderPrecedenceModified", false);
    }

    @Override
    protected void getAndSetPropertyValue(Element element, BusinessQueryProperty property) throws MetadataException {
        String attr = IQModelImplUtilities.getAttr(element, property.getPersistentForm());
        if (attr != null) {
            boolean bool = IQModelImplUtilities.getBooleanAttr(element, property.getPersistentForm(), false);
            this.overriddenQueryProperties.set(property, bool);
        }
    }

    @Override
    public List<Reason> getReasonsNotValid() {
        List<Reason> reasons = super.getReasonsNotValid();
        List<DataItem> allResultItems = this.getResultItems();
        reasons.addAll(this.reasonsNotValidToUseAsResultItems(allResultItems));
        return reasons;
    }

    @Override
    public CascadeRuleSet getCascadeRuleSet(EffectiveObjectsCache effectiveObjectsCache) throws MetadataException {
        CascadeRuleSet ruleSet = super.getCascadeRuleSet(effectiveObjectsCache);
        PromptValuesInterface promptValues = this.getPromptValues(false, effectiveObjectsCache);
        DataSelection parentDS = this.getParentDS();
        Object parentPromptValues = null;
        parentPromptValues = parentDS instanceof EffectiveObjectsCacheSupport ? ((EffectiveObjectsCacheSupport)((Object)parentDS)).getPromptValues(effectiveObjectsCache) : (parentDS != null ? parentDS.getPromptValues() : new PromptValues((PromptGroupInterface)new PromptGroup()));
        List ltdsPrompts = promptValues.getPromptGroup().getPromptDefinitions(true);
        for (PromptDefinitionInterface ltdsPrompt : ltdsPrompts) {
            CascadeRule rule = ruleSet.getRuleBasedOn(ltdsPrompt, promptValues);
            if (rule != null) {
                this.addCascadeDependencies((CascadeRuleImpl)rule, (PromptValuesInterface)parentPromptValues, effectiveObjectsCache);
                continue;
            }
            rule = new CascadeRuleImpl(new CascadeRuleItemImpl(ltdsPrompt, promptValues));
            this.addCascadeDependencies((CascadeRuleImpl)rule, (PromptValuesInterface)parentPromptValues, effectiveObjectsCache);
            ((CascadeRuleSetImpl)ruleSet).addCascade(rule);
        }
        return ruleSet;
    }

    private void addCascadeDependencies(CascadeRuleImpl rule, PromptValuesInterface promptValues, EffectiveObjectsCache effectiveObjectsCache) {
        List<FilterItem> filters = this.getEffectiveFilters(effectiveObjectsCache);
        List pds = promptValues.getPromptGroup().getPromptDefinitions(true);
        for (PromptDefinitionInterface pd : pds) {
            if (!rule.hasDependentItemFor(pd, promptValues)) {
                rule.addDependentItem(new CascadeRuleItemImpl(pd, promptValues));
            }
            for (FilterItem filter : filters) {
                List<Prompt> businessPrompts = filter.getPrompts(65535);
                for (Prompt bprompt : businessPrompts) {
                    if (!bprompt.getPromptDefinition().equals(pd) || rule.containsDependentFilter(filter)) continue;
                    rule.addDependentFilter(filter);
                }
            }
        }
    }

    @Override
    public void setComputationalLocale(Locale newLocale) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void clearReferencesToModelItems() {
        super.clearReferencesToModelItems();
        this.overriddenQueryProperties.dispose();
        this.overriddenQueryProperties = null;
    }
}

