/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.ForeignKey;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.JoinRelationshipType;
import com.sas.iquery.metadata.business.JoinType;
import com.sas.iquery.metadata.business.JoinTypeList;
import com.sas.iquery.metadata.business.KeyRelationships;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.UniqueKey;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class KeyRelationshipsImpl
implements KeyRelationships {
    private HashMap<DataSourceTable, KeyList> dataSourceTablesKeys = new HashMap();
    private static final int FILTER_JOINS_NONE = 0;
    private static final int FILTER_JOINS_BASED_ON_TABLES = 1;
    private static final int FILTER_JOINS_BASED_ON_TABLES_COLUMNS = 2;

    KeyRelationshipsImpl() {
    }

    public void addTableAndKeys(DataSourceTable dataSourceTable, List<UniqueKey> uniqueKeys, List<ForeignKey> foreignKeys) throws MetadataException {
        KeyList keys = new KeyList(uniqueKeys, foreignKeys);
        this.dataSourceTablesKeys.put(dataSourceTable, keys);
    }

    @Override
    @Nonnull
    public List<Join> getPotentialJoins(DataSourceTable dataSourceTable) throws MetadataException {
        return this.getJoinsForDataSource(dataSourceTable, 0);
    }

    @Nonnull
    private List<Join> getJoinsForDataSource(DataSourceTable dataSourceTable, int filterJoinBehavior) throws MetadataException {
        ArrayList<Join> joins = new ArrayList<Join>();
        BusinessModel sourceBusinessModel = dataSourceTable.getBusinessModel();
        KeyList keys = this.dataSourceTablesKeys.get(dataSourceTable);
        if (keys != null) {
            List<UniqueKey> uniqueKeys = keys.getUniqueKeys();
            List<ForeignKey> foreignKeys = keys.getForeignKeys();
            for (UniqueKey uniqueKey : uniqueKeys) {
                joins.addAll(this.getUniqueKeyJoins(uniqueKey, sourceBusinessModel, filterJoinBehavior));
            }
            UniqueKey uniqueKey = null;
            for (ForeignKey foreignKey : foreignKeys) {
                uniqueKey = foreignKey.getUniqueKey();
                joins.addAll(this.getForeignKeyJoins(uniqueKey, foreignKey, sourceBusinessModel, filterJoinBehavior));
            }
        }
        return joins;
    }

    private List<Join> getUniqueKeyJoins(UniqueKey uniqueKey, BusinessModel sourceBusinessModel, int filterOutJoinBehavior) throws MetadataException {
        ArrayList<Join> joinList = new ArrayList<Join>();
        List<ForeignKey> foreignKeys = null;
        if (uniqueKey != null) {
            foreignKeys = uniqueKey.getForeignKeys();
            for (ForeignKey foreignKey : foreignKeys) {
                joinList.addAll(this.getForeignKeyJoins(uniqueKey, foreignKey, sourceBusinessModel, filterOutJoinBehavior));
            }
        }
        return joinList;
    }

    private List<Join> getForeignKeyJoins(UniqueKey uniqueKey, ForeignKey foreignKey, BusinessModel sourceBusinessModel, int filterOutJoinBehavior) throws MetadataException {
        DataSourceTable rightTable;
        DataSourceTable leftTable;
        ArrayList<Join> joinList = new ArrayList<Join>();
        List<QualifiedColumn[]> columnPairs = foreignKey.getColumnPairs();
        ArrayList<QualifiedColumn> leftColumns = new ArrayList<QualifiedColumn>();
        ArrayList<QualifiedColumn> rightColumns = new ArrayList<QualifiedColumn>();
        for (QualifiedColumn[] qualifiedColumns : columnPairs) {
            leftColumns.add(qualifiedColumns[0]);
            rightColumns.add(qualifiedColumns[1]);
        }
        if (uniqueKey != null && foreignKey != null && !this.isJoinAlreadyInBusinessModel(leftTable = uniqueKey.getTable(), rightTable = foreignKey.getTable(), leftColumns, rightColumns, sourceBusinessModel, filterOutJoinBehavior)) {
            Join join = this.buildJoin(leftTable, rightTable, leftColumns, rightColumns, sourceBusinessModel);
            joinList.add(join);
        }
        return joinList;
    }

    private Join buildJoin(DataSourceTable leftTable, DataSourceTable rightTable, List<QualifiedColumn> leftColumns, List<QualifiedColumn> rightColumns, BusinessModel sourceBusinessModel) throws MetadataException {
        Join join = sourceBusinessModel.newJoin();
        join.setLabel(IQMetadataResourceBundle.getStringResource("KeyRelationshipsImpl.JoinLabel.txt"));
        String msg = IQMetadataResourceBundle.getMessageString("KeyRelationshipsImpl.JoinDescription.fmt.txt", leftTable.getLabel(), rightTable.getLabel());
        join.setDescription(msg);
        join.setRelationshipType(JoinRelationshipType.ALLOWED);
        join.setLeftDataSource(leftTable);
        join.setRightDataSource(rightTable);
        JoinTypeList joinTypeList = new JoinTypeList();
        joinTypeList.add(JoinType.INNER);
        join.setAllowedTypes(joinTypeList);
        join.setType(JoinType.INNER);
        CompoundConditionalExpression compoundExpression = new CompoundConditionalExpression();
        compoundExpression.setRelationType(ConditionalRelationType.AND);
        CompoundConditionalExpression previousCompoundExpression = null;
        join.setJoinCondition(compoundExpression);
        Iterator<QualifiedColumn> it1 = leftColumns.iterator();
        Iterator<QualifiedColumn> it2 = rightColumns.iterator();
        while (it1.hasNext()) {
            QualifiedColumn leftColumn = it1.next();
            QualifiedColumn rightColumn = it2.next();
            SimpleConditionalExpression_Comparison expression = new SimpleConditionalExpression_Comparison();
            expression.setLeftExpression(leftColumn);
            expression.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
            expression.setRightExpression(rightColumn);
            if (compoundExpression.getLeftExpression() == null) {
                compoundExpression.setLeftExpression(expression);
                continue;
            }
            CompoundConditionalExpression newCompoundExpression = new CompoundConditionalExpression();
            newCompoundExpression.setRelationType(ConditionalRelationType.AND);
            newCompoundExpression.setLeftExpression(expression);
            compoundExpression.setRightExpression(newCompoundExpression);
            previousCompoundExpression = compoundExpression;
            compoundExpression = newCompoundExpression;
        }
        if (previousCompoundExpression == null) {
            join.setJoinCondition((ConditionalExpression)compoundExpression.getLeftExpression());
        } else {
            previousCompoundExpression.setRightExpression(compoundExpression.getLeftExpression());
        }
        return join;
    }

    private boolean isJoinAlreadyInBusinessModel(DataSourceTable leftTable, DataSourceTable rightTable, List<QualifiedColumn> leftColumns, List<QualifiedColumn> rightColumns, BusinessModel sourceBusinessModel, int filterOutJoinBehavior) throws MetadataException {
        boolean returnValue = false;
        List<Join> businessModelJoins = sourceBusinessModel.getObjects(true, Join.class);
        Iterator<Join> it = businessModelJoins.iterator();
        while (it.hasNext() && !returnValue && filterOutJoinBehavior != 0) {
            Join join = it.next();
            DataSourceTable leftDataSource = join.getLeftDataSource();
            DataSourceTable rightDataSource = join.getRightDataSource();
            ConditionalExpression joinExpression = join.getJoinCondition();
            if ((!rightTable.getSasName().equalsIgnoreCase(rightDataSource.getSasName()) || !leftTable.getSasName().equalsIgnoreCase(leftDataSource.getSasName())) && (!rightTable.getSasName().equalsIgnoreCase(leftDataSource.getSasName()) || !leftTable.getSasName().equalsIgnoreCase(rightDataSource.getSasName()))) continue;
            if (filterOutJoinBehavior == 1) {
                returnValue = true;
                continue;
            }
            if (filterOutJoinBehavior != 2) continue;
            ArrayList<String> joinColumnNames = new ArrayList<String>();
            List<ModelItem> items = joinExpression.getDirectlyReferencedItemsInDownwardDefinition();
            for (ModelItem item : items) {
                if (!(item instanceof QualifiedColumn)) continue;
                QualifiedColumn qc = (QualifiedColumn)item;
                joinColumnNames.add(qc.getSasName());
            }
            ArrayList<String> sourceColumnNames = new ArrayList<String>();
            for (QualifiedColumn col : leftColumns) {
                sourceColumnNames.add(col.getSasName());
            }
            for (QualifiedColumn col : rightColumns) {
                sourceColumnNames.add(col.getSasName());
            }
            if (!sourceColumnNames.containsAll(joinColumnNames) || !joinColumnNames.contains(sourceColumnNames)) continue;
            returnValue = true;
        }
        return returnValue;
    }

    private class KeyList {
        private List<UniqueKey> uniqueKeys;
        private List<ForeignKey> foreignKeys;

        public KeyList(List<UniqueKey> uniqueKeys, List<ForeignKey> foreignKeys) {
            this.uniqueKeys = uniqueKeys;
            this.foreignKeys = foreignKeys;
        }

        public List<UniqueKey> getUniqueKeys() {
            return this.uniqueKeys;
        }

        public List<ForeignKey> getForeignKeys() {
            return this.foreignKeys;
        }
    }
}

