/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.impl.JoinFeeder;
import com.sas.iquery.metadata.business.impl.JoinInfo;
import com.sas.iquery.metadata.business.impl.JoinNodeTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JoinAutoJoiner {
    public static final int JOIN_STARTLEVEL = 0;
    public static final int JOIN_STARTCOST = 0;
    public static final int JOIN_INITIAL_COST_FOUND = -1;
    public static final int JOIN_DEFAULT_COST = 30;
    protected List<JoinNodeTree> toLookForJoinNodes = new ArrayList<JoinNodeTree>();
    protected JoinFeeder joinFeeder = new JoinFeeder();

    protected void assignToBeLookedForJoinNodes(List<DataSource> lookforDataSources) {
        JoinNodeTree joinNode = null;
        for (DataSource dataSource : lookforDataSources) {
            joinNode = new JoinNodeTree(dataSource, this.joinFeeder);
            this.toLookForJoinNodes.add(joinNode);
        }
    }

    public List<List<DataSource>> findPathsForAllGroups(Map joinTableMap, List<List<DataSource>> joinGroups) {
        ArrayList<List<DataSource>> listOfFoundPaths = new ArrayList<List<DataSource>>();
        List<DataSource> tempPath = null;
        this.joinFeeder.setJoinMap(joinTableMap);
        int numberOfJoinGroups = joinGroups.size();
        List<DataSource> initialScoutDataSources = joinGroups.get(0);
        for (int index = 1; index < numberOfJoinGroups; ++index) {
            List<DataSource> tempToBeLookFor = joinGroups.get(index);
            boolean alReadyfound = false;
            for (DataSource dataSource : tempToBeLookFor) {
                if (!initialScoutDataSources.contains(dataSource)) continue;
                alReadyfound = true;
                break;
            }
            if (alReadyfound) {
                for (DataSource dataSource : tempToBeLookFor) {
                    if (initialScoutDataSources.contains(dataSource)) continue;
                    initialScoutDataSources.add(dataSource);
                }
                continue;
            }
            this.joinFeeder.setStartLookforDataSources(tempToBeLookFor);
            this.toLookForJoinNodes.clear();
            this.assignToBeLookedForJoinNodes(tempToBeLookFor);
            tempPath = this.search(initialScoutDataSources);
            if (tempPath.size() == 0) {
                listOfFoundPaths.clear();
                return listOfFoundPaths;
            }
            listOfFoundPaths.add(tempPath);
            initialScoutDataSources.addAll(tempToBeLookFor);
            for (DataSource dataSource : tempPath) {
                if (initialScoutDataSources.contains(dataSource)) continue;
                initialScoutDataSources.add(dataSource);
            }
        }
        return listOfFoundPaths;
    }

    protected List<DataSource> search(List<DataSource> initialScoutDataSources) {
        int lowestCostFound = -1;
        int defaultCost = 30;
        boolean anyNewSetup = false;
        ArrayList<JoinInfo> allToLookForDataSources = new ArrayList<JoinInfo>();
        ArrayList<DataSource> foundPath = new ArrayList<DataSource>();
        int maxlevel = 2;
        anyNewSetup = this.setUpStartingLookForNodes(maxlevel, lowestCostFound);
        if (!anyNewSetup) {
            return foundPath;
        }
        do {
            allToLookForDataSources.clear();
            this.extractAllToLookForDataSources(maxlevel, allToLookForDataSources);
            for (DataSource scoutDataSource : initialScoutDataSources) {
                DataSource lookforDataSource = null;
                for (JoinInfo joinInfo : allToLookForDataSources) {
                    lookforDataSource = joinInfo.getDataSource();
                    if (!scoutDataSource.equals(lookforDataSource)) continue;
                    int thisCost = joinInfo.getCost();
                    if (thisCost == 0) {
                        thisCost = defaultCost;
                    }
                    if (thisCost >= lowestCostFound && lowestCostFound != -1) continue;
                    foundPath.clear();
                    foundPath.addAll(joinInfo.getJoinPath());
                    foundPath.add(scoutDataSource);
                    lowestCostFound = thisCost;
                }
            }
        } while (anyNewSetup = this.setUpStartingLookForNodes(++maxlevel, lowestCostFound));
        return foundPath;
    }

    protected boolean setUpStartingLookForNodes(int maxlevel, int lowestCostFound) {
        int startCost = 0;
        int startLevel = 0;
        boolean returnvalue = false;
        boolean returnFromMethod = false;
        for (JoinNodeTree lookforJoinNode : this.toLookForJoinNodes) {
            lookforJoinNode.setMyCost(startCost);
            lookforJoinNode.setMyLevel(startLevel);
            returnFromMethod = lookforJoinNode.setup(maxlevel, lowestCostFound);
            if (!returnFromMethod) continue;
            returnvalue = true;
        }
        return returnvalue;
    }

    protected void extractAllToLookForDataSources(int maxlevel, List<JoinInfo> allToLookForDataSources) {
        for (JoinNodeTree joinNode : this.toLookForJoinNodes) {
            joinNode.returnAllDataSources(maxlevel, allToLookForDataSources);
        }
    }
}

