/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractLocalizableBusinessModelObject;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class GroupImpl
extends AbstractLocalizableBusinessModelObject
implements BusinessGroup {
    private BusinessGroup.Type _type;
    private List<BusinessModelObject> _items = new ArrayList<BusinessModelObject>();
    private String _note;
    private String _localizationId;

    public GroupImpl() {
    }

    @SASScope
    public GroupImpl(AbstractBusinessModel businessModel, BusinessGroup.Type type) {
        super(businessModel);
        this._type = type;
        this._localizationId = this.getDefaultLocalizationID();
    }

    @Override
    @SASScope
    public BusinessGroup.Type getType() {
        return this._type;
    }

    @Override
    @Nonnull
    @SASScope
    public List<BusinessModelObject> getItems() {
        return new ArrayList<BusinessModelObject>(this._items);
    }

    @Override
    @SASScope
    public void setItems(@Nonnull List<? extends BusinessModelObject> items) {
        this._items.clear();
        for (BusinessModelObject businessModelObject : items) {
            FilterItem filter;
            ExpressionInterface filterExpression;
            if (!(businessModelObject instanceof FilterItem) || !((filterExpression = (filter = (FilterItem)businessModelObject).getExpression()) instanceof MemberFilterExpression)) continue;
            MemberFilterExpression memberFilterExpression = (MemberFilterExpression)filterExpression;
        }
        if (items != null) {
            this._items.addAll(items);
            this.fireChangeEvent("The group's items have changed.");
        }
    }

    @Override
    @SASScope
    public String getNote() {
        return this._note;
    }

    @Override
    @SASScope
    public void setNote(String note) {
        if (this._note == null) {
            if (note != null) {
                this._note = note;
                this.fireChangeEvent("The business group's notes value has changed.", null, this._note);
            }
        } else if (!this._note.equals(note)) {
            String oldValue = this._note;
            this._note = note;
            this.fireChangeEvent("The business group's notes value has changed.", oldValue, this._note);
        }
    }

    @Override
    public boolean contains(BusinessModelObject businessModelObject) {
        return this.contains(businessModelObject, false);
    }

    @Override
    public boolean contains(BusinessModelObject businessModelObject, boolean recursive) {
        boolean found;
        block1: {
            BusinessModelObject bmo;
            found = this._items.contains(businessModelObject);
            if (found || !recursive) break block1;
            Iterator<BusinessModelObject> iterator = this._items.iterator();
            while (!(!iterator.hasNext() || (bmo = iterator.next()) instanceof BusinessGroup && (found = ((BusinessGroup)bmo).contains(businessModelObject, recursive)))) {
            }
        }
        return found;
    }

    @Override
    public List<BusinessGroup> getContainedGroups() {
        ArrayList<BusinessGroup> groups = new ArrayList<BusinessGroup>();
        for (BusinessModelObject bmo : this._items) {
            if (!(bmo instanceof BusinessGroup)) continue;
            groups.add((BusinessGroup)bmo);
        }
        return groups;
    }

    @Override
    @SASScope
    public int size() {
        return this._items.size();
    }

    @Override
    @SASScope
    public void clear() {
        for (BusinessModelObject item : this._items) {
            FilterItem filter;
            ExpressionInterface filterExpression;
            if (!(item instanceof FilterItem) || !((filterExpression = (filter = (FilterItem)item).getExpression()) instanceof MemberFilterExpression)) continue;
            MemberFilterExpression memberFilterExpression = (MemberFilterExpression)filterExpression;
        }
        this._items.clear();
        this.fireChangeEvent("The group's items have changed.");
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "Group";
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "BGP_";
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        GroupImpl.writeRelatedObjects(this._items, thisElement, writingContext, "Items", ModelVersion.VERSION_93);
        IQModelImplUtilities.setAttr(thisElement, "type", this._type.name());
        IQModelImplUtilities.setAttr(thisElement, "lid", this._localizationId);
        IQModelImplUtilities.setAttr(thisElement, "note", this._note);
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._type = BusinessGroup.Type.valueOf(attrsProvider.consumeAttr("type"));
        this._localizationId = attrsProvider.consumeAttrEmptyDefault("lid");
        this._note = attrsProvider.consumeAttr("note");
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._items.addAll(riHolder.consumeObjects("Items", BusinessModelObject.class));
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.addAll(this._items);
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        GroupImpl.replaceInList(this._items, oldObject, newObject);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        for (int i = 0; i < this._items.size(); ++i) {
            BusinessModelObject bmo = this._items.get(i);
            BusinessModelObject newRes = (BusinessModelObject)Utils.replaceResource(bmo, oldResource, newResource, model, recursive);
            this._items.set(i, newRes);
        }
    }

    @Override
    public String getLocalizationPrependKey() {
        return "BusinessGroup";
    }

    @Override
    public String getLocalizationID() throws MetadataException {
        return this._localizationId;
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws MetadataException {
        return super.newLocalizableProperties(locale, this);
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws MetadataException {
        super.setLocalizableProperties(locale, this, map);
    }

    private synchronized String getDefaultLocalizationID() {
        String defaultID = null;
        String prefix = this.getDefaultIDPrefix() + "LID_";
        AbstractModel model = this.getModel();
        while (model.containsObjectWithID(defaultID = prefix + model.newDefaultIDNumber())) {
        }
        return defaultID;
    }

    void remove(@Nonnull BusinessModelObject item) {
        this._items.remove(item);
    }
}

