/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.StructuredExternalResources;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.IdentityHashMap;
import java.util.List;

public class FlattenedExternalResources {
    private AbstractModel _model;
    private IdentityList _metadataRepositoryResources = new IdentityList();
    private IdentityList _modelItemResources = new IdentityList();
    private IdentityList _modelResources = new IdentityList();
    private AbstractModel _outermostModel;
    private boolean _allowInnerIQModelsToReferToIQModelsInBITrees;

    FlattenedExternalResources(AbstractModel model, AbstractModel outermostModel) {
        this._model = model;
        this._outermostModel = outermostModel;
        this._allowInnerIQModelsToReferToIQModelsInBITrees = System.getProperty("SASQueryServices.AllowInnerIQModelsToReferToIQModelsInBITrees") != null;
    }

    boolean add(AbstractBase obj) throws MetadataException {
        boolean recognizedAsExternal = false;
        if (obj.isLocatedExternalToGivenModel(this._model)) {
            if (obj instanceof MetadataRepositoryResource) {
                recognizedAsExternal = true;
                this._metadataRepositoryResources.add(obj);
            } else if (obj instanceof AbstractModelItem) {
                AbstractModelItem item = (AbstractModelItem)obj;
                if (item.isReachableViaPersistenceFromGivenModel(this._model)) {
                    recognizedAsExternal = true;
                    this._modelItemResources.add(obj);
                } else {
                    FlattenedExternalResources.objIsNotPersistablyReachableFromModel(item, this._model);
                }
            } else if (obj instanceof AbstractModel) {
                AbstractModel model = (AbstractModel)obj;
                if (this._model != this._outermostModel && !this._allowInnerIQModelsToReferToIQModelsInBITrees && model.hasPersistedStorageLocation() && model != this._outermostModel) {
                    MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("FlattenedExternalResources.ModelNotReferrableFromInnerModel.fmt.txt", model.getIdentityString());
                    throw new MetadataException(messageFormatter);
                }
                recognizedAsExternal = true;
                this._modelResources.add(model);
            } else {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("UnexpectedCodePathTaken.txt", new Object[0]));
            }
        }
        return recognizedAsExternal;
    }

    List getMetadataRepositoryResourcesList() {
        return this._metadataRepositoryResources.toList();
    }

    IdentityList getMetadataRepositoryResources() {
        return new IdentityList(this._metadataRepositoryResources.toList());
    }

    IdentityList getModelItemResources() {
        return new IdentityList(this._modelItemResources.toList());
    }

    IdentityList getModelResources() {
        return new IdentityList(this._modelResources.toList());
    }

    StructuredExternalResources getStructuredForm(IdentityHashMap resourceConstraints) throws MetadataException {
        StructuredExternalResources out = new StructuredExternalResources(this._model);
        out.initializeWithUsedResources(this, resourceConstraints);
        return out;
    }

    private static void objIsNotPersistablyReachableFromModel(AbstractModelItem item, AbstractModel model) throws MetadataException {
        String msgid = item.getModel() == model ? "FlattenedExternalResources.ObjectReferencedButNotAdded.fmt.txt" : "FlattenedExternalResources.ObjectReferencedButNotPersistablyReachable.fmt.txt";
        throw new MetadataException(IQModelImplUtilities.getMessageFormatter(msgid, item.getIdentityString()));
    }
}

