/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.FilterSetRuleItems;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FilterSetRuleItemsImpl
extends AbstractModelItem
implements FilterSetRuleItems {
    protected boolean _isUnion = false;
    protected List _items;
    protected boolean _isPostFilters = false;
    private static final Logger _logger = LogManager.getLogger(FilterSetRuleItemsImpl.class);
    private static final Logger _sessionLogger = LogManager.getLogger((String)"com.sas.services.session.SessionService");

    public FilterSetRuleItemsImpl(List items, boolean unionResults) {
        this._isUnion = unionResults;
        this._items = new ArrayList(items);
    }

    public FilterSetRuleItemsImpl() {
        this._items = new ArrayList();
    }

    @Override
    public int size() {
        if (this._items == null) {
            return 0;
        }
        return this._items.size();
    }

    @Override
    public boolean isUnionList() {
        return this._isUnion;
    }

    public List getList() {
        return ListUtils.newList(this._items);
    }

    public static boolean mergeIntoFilterList(BusinessModel subQuery, List current, FilterSetRuleItems FSRIfilters) throws MetadataException {
        boolean isDirty = false;
        if (FSRIfilters == null) {
            return false;
        }
        List<Object> newFilters = FSRIfilters.getList();
        if (newFilters == null) {
            return false;
        }
        if (FSRIfilters.isUnionList() && newFilters.size() > 0) {
            FilterItem nestedFilters = FilterSetRuleItemsImpl.convertToFilterTree(subQuery, FSRIfilters);
            if (nestedFilters != null && FilterSetRuleItemsImpl._isUniqueFilter(current, nestedFilters)) {
                current.add(nestedFilters);
                isDirty = true;
            }
        } else {
            for (int i = 0; i < newFilters.size(); ++i) {
                Object item = newFilters.get(i);
                if (!FilterSetRuleItemsImpl._mergeIntoFilterList(subQuery, current, item)) continue;
                isDirty = true;
            }
        }
        return isDirty;
    }

    public static FilterItem convertToFilterTree(BusinessModel subQuery, FilterSetRuleItems FSRIfilters) throws MetadataException {
        if (FSRIfilters == null) {
            return null;
        }
        List<Object> newFilters = FSRIfilters.getList();
        if (newFilters == null || newFilters.size() == 0) {
            return null;
        }
        ConditionalRelationType type = FSRIfilters.isUnionList() ? ConditionalRelationType.OR : ConditionalRelationType.AND;
        Object item = newFilters.get(0);
        FilterItem left = FilterSetRuleItemsImpl._convertToFilterTree(subQuery, item);
        for (int i = 1; i < newFilters.size(); ++i) {
            item = newFilters.get(i);
            FilterItem right = FilterSetRuleItemsImpl._convertToFilterTree(subQuery, item);
            CompoundFilter compound = subQuery.newCompoundFilter();
            compound.setRelationType(type);
            compound.setLeftFilter(left);
            compound.setRightFilter(right);
            subQuery.addBusinessItem(compound);
            left = compound;
        }
        return left;
    }

    private static FilterItem _convertToFilterTree(BusinessModel subQuery, Object condition) throws MetadataException {
        if (condition instanceof FilterItem) {
            return (FilterItem)condition;
        }
        if (condition instanceof FilterSetRuleItemsImpl) {
            return FilterSetRuleItemsImpl.convertToFilterTree(subQuery, (FilterSetRuleItems)condition);
        }
        Object[] msgArgs = new Object[]{FilterSetRuleItemsImpl.class.getName(), FilterItem.class.getName(), "" + condition, condition == null ? "" : "(" + condition.getClass().getName() + ")"};
        MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("FilterSetRuleItemsImpl.UnknownObjectType.fmt.txt", msgArgs);
        if (_logger.isEnabled(Level.WARN)) {
            if (_sessionLogger.isEnabled(Level.WARN)) {
                _sessionLogger.warn(msg.toString());
            } else {
                _logger.warn(msg.toString());
            }
        }
        throw new MetadataException(msg);
    }

    private static boolean _mergeIntoFilterList(BusinessModel subQuery, List current, Object condition) throws MetadataException {
        boolean isDirty = false;
        if (condition instanceof FilterItem) {
            FilterItem filterItem = (FilterItem)condition;
            if (filterItem != null && FilterSetRuleItemsImpl._isUniqueFilter(current, filterItem)) {
                current.add(filterItem);
                isDirty = true;
            }
        } else if (condition instanceof FilterSetRuleItemsImpl) {
            isDirty = FilterSetRuleItemsImpl.mergeIntoFilterList(subQuery, current, (FilterSetRuleItems)condition);
        } else if (condition != null) {
            Object[] msgArgs = new Object[]{FilterSetRuleItemsImpl.class.getName(), FilterItem.class.getName(), "" + condition, condition == null ? "" : "(" + condition.getClass().getName() + ")"};
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("FilterSetRuleItemsImpl.UnknownObjectType.fmt.txt", msgArgs);
            if (_logger.isEnabled(Level.WARN)) {
                if (_sessionLogger.isEnabled(Level.WARN)) {
                    _sessionLogger.warn(msg.toString());
                } else {
                    _logger.warn(msg.toString());
                }
            }
            throw new MetadataException(msg);
        }
        return isDirty;
    }

    private static boolean _isUniqueFilter(List filters, FilterItem item) throws MetadataException {
        StringExpressionUtil util = StringExpressionUtil.getInstance();
        ExpressionInterface expr = item.getExpression();
        if (expr == null) {
            return false;
        }
        String startText = util.getText(expr);
        for (int i = 0; i < filters.size(); ++i) {
            String itemText;
            Object obj = filters.get(i);
            if (!(obj instanceof FilterItem) || startText.compareTo(itemText = util.getText(((FilterItem)obj).getExpression())) != 0) continue;
            return false;
        }
        return true;
    }

    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        if (this._items != null) {
            intoList.addAll(this._items);
        }
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        FilterSetRuleItemsImpl.replaceInList(this._items, oldObject, newObject);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        if (this._items != null) {
            for (int i = 0; i < this._items.size(); ++i) {
                Object newValue;
                Object value = this._items.get(i);
                boolean valueSame = IQModelImplUtilities.same(value, newValue = Utils.replaceResource(value, oldResource, newResource, model, recursive));
                if (valueSame) continue;
                this._items.set(i, newValue);
                if (!(value instanceof ModelItem) || !(newValue instanceof ModelItem)) continue;
                this.moveListeningTo((ModelItem)value, (ModelItem)newValue);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FilterSetRuleItemsImpl clone = (FilterSetRuleItemsImpl)super.clone();
        ArrayList list = new ArrayList();
        for (Object entry : this._items) {
            if (entry instanceof FilterSetRuleItemsImpl) {
                entry = ((FilterSetRuleItemsImpl)entry).clone();
            }
            list.add(entry);
        }
        clone._items = list;
        return clone;
    }

    public boolean equals(Object o) {
        return o instanceof FilterSetRuleItemsImpl ? this._isUnion == ((FilterSetRuleItemsImpl)o)._isUnion && this._items.equals(((FilterSetRuleItemsImpl)o)._items) : false;
    }

    public int hashCode() {
        return (this._items == null ? 0 : this._items.hashCode()) + (this._isUnion ? 7 : 0) + this.getClass().hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this._isUnion ? (char)'{' : '[');
        if (this._isPostFilters) {
            buffer.append("post:");
        }
        for (int i = 0; i < this._items.size(); ++i) {
            Object item = this._items.get(i);
            if (item != null) {
                String text = item instanceof BusinessItem ? ((BusinessItem)item).getIntraModelID() : item.toString();
                buffer.append(text);
            }
            if (i >= this._items.size() - 1) continue;
            buffer.append(",");
        }
        buffer.append(this._isUnion ? (char)'}' : ']');
        return buffer.toString();
    }

    public static FilterSetRuleItems flattenFilterSetRuleItems(FilterSetRuleItems rulesToFlatten) {
        boolean workingOnUnionList = rulesToFlatten.isUnionList();
        List<Object> listOfFilterSetLists = rulesToFlatten.getList();
        boolean again = true;
        while (again) {
            again = false;
            ArrayList<Object> optimizedList = new ArrayList<Object>();
            for (Object obj : listOfFilterSetLists) {
                if (obj == null) continue;
                if (obj instanceof FilterSetRuleItems) {
                    FilterSetRuleItems fsl = (FilterSetRuleItems)obj;
                    boolean nestedUnionList = fsl.isUnionList();
                    if (workingOnUnionList == nestedUnionList) {
                        again = true;
                        for (Object item : fsl.getList()) {
                            if (item == null || optimizedList.contains(item)) continue;
                            optimizedList.add(item);
                        }
                        continue;
                    }
                    fsl = FilterSetRuleItemsImpl.flattenFilterSetRuleItems(fsl);
                    optimizedList.add(fsl);
                    continue;
                }
                if (optimizedList.contains(obj)) continue;
                optimizedList.add(obj);
            }
            if (!again) continue;
            listOfFilterSetLists = optimizedList;
        }
        FilterSetRuleItemsImpl filterSetList = new FilterSetRuleItemsImpl(listOfFilterSetLists, workingOnUnionList);
        return filterSetList;
    }

    public static FilterSetRuleItems removePreOrPostFilters(FilterSetRuleItems rulesToSubset, boolean removePreFilters) {
        if (rulesToSubset == null) {
            return null;
        }
        boolean isPreList = !rulesToSubset.isPostFilters();
        ArrayList<Object> newList = new ArrayList<Object>(rulesToSubset.getList());
        for (int index = newList.size() - 1; index >= 0; --index) {
            Object obj = newList.get(index);
            if (obj instanceof FilterSetRuleItems) {
                FilterSetRuleItems fsl = (FilterSetRuleItems)obj;
                FilterSetRuleItems newFsl = FilterSetRuleItemsImpl.removePreOrPostFilters(fsl, removePreFilters);
                newList.remove(index);
                if (newFsl == null) continue;
                newList.add(index, newFsl);
                continue;
            }
            if (obj != null) {
                if (isPreList != removePreFilters) continue;
                newList.remove(index);
                continue;
            }
            newList.remove(index);
        }
        FilterSetRuleItems filterSetList = null;
        if (!newList.isEmpty()) {
            filterSetList = new FilterSetRuleItemsImpl(newList, rulesToSubset.isUnionList());
            filterSetList = FilterSetRuleItemsImpl.flattenFilterSetRuleItems(filterSetList);
            if (removePreFilters) {
                filterSetList.setPostFilters(true);
            }
        }
        return filterSetList;
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setBooleanAttr(thisElement, "isUnionList", this._isUnion, false);
        if (this._isPostFilters) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "postFilters", this._isPostFilters, false);
            writingContext.adjustModelVersion(ModelVersion.VERSION_93a);
        }
        FilterSetRuleItemsImpl.writeRelatedObjects(this._items, thisElement, writingContext, "Items");
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._isUnion = attrsProvider.consumeBooleanAttr("isUnionList", false);
        this._isPostFilters = attrsProvider.consumeBooleanAttr("postFilters", false);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._items = riHolder.consumeObjects("Items", Object.class);
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._isUnion = IQModelImplUtilities.getBooleanAttr(thisElement, "isUnionList", false);
        this._items = FilterSetRuleItemsImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "Items", new Class[]{FilterItem.class, FilterSetRuleItems.class});
    }

    @Override
    protected String getDefinitionElementName() {
        return "FilterSetRuleItems";
    }

    @Override
    public boolean isPostFilters() {
        return this._isPostFilters;
    }

    @Override
    public void setPostFilters(boolean isPostFilters) {
        this._isPostFilters = isPostFilters;
    }
}

