/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportProperties;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.ExportSelectionMetadata;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.ExportAbstract;
import com.sas.iquery.metadata.business.impl.ExportCubeDataDsBuilder;
import com.sas.iquery.metadata.business.impl.ExportCubeMlsLanguageFactory;
import com.sas.iquery.metadata.business.impl.ExportCubeProcessor;
import com.sas.iquery.metadata.business.impl.ExportMetadataFactory;
import com.sas.iquery.metadata.business.impl.ExportRuleImpl;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.MdException;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ExportOlapImpl
extends ExportAbstract
implements Export {
    private ExportCubeProcessor _tmpCubeProcessor = null;

    ExportOlapImpl(BusinessModel businessModel, ExportType usage, ExportProperties ... properties) throws MetadataException {
        super(businessModel, usage, properties);
    }

    @Override
    protected DataSelection newExportDataSelection(BusinessModel origBusinessModel) throws MetadataException {
        boolean isOlap = origBusinessModel.getStructure().isOLAP();
        if (!isOlap) {
            throw new MetadataException(ExportOlapImpl.getMsgInvalidUseOfExportOlapForRelationalDS());
        }
        DataSelection exportDS = DataSelectionFactory.newDataSelection(origBusinessModel);
        exportDS.setID("ExportOlapDS");
        exportDS.setLabel("Export OLAP DS");
        return exportDS;
    }

    @Override
    protected void addRefToSelectedItems(DataSelection dataSelection, DataItem itemRef, Role role, Set<String> alreadyAdded) throws MetadataException {
        StructureOfDataItem structure;
        Role newRole = Role.COLUMN;
        if (itemRef.getUsage().equals(DataItemActionType.USAGE_CATEGORY)) {
            newRole = Role.ROW;
        }
        if ((structure = itemRef.getStructure()) != null && structure.equals(StructureOfDataItem.STRUCTURE_HIERARCHY)) {
            ExpressionInterface olapExpr = itemRef.getExpression();
            Hierarchy hier = null;
            hier = olapExpr instanceof OLAPResourceAwareStringExpression ? ((OLAPResourceAwareStringExpression)olapExpr).getHierarchy() : (Hierarchy)olapExpr;
            Dimension dim = hier.getOwningDimension();
            String dimUniqueName = dim.getUniqueName();
            if (!alreadyAdded.contains(dimUniqueName)) {
                super.addRefToSelectedItems(dataSelection, itemRef, newRole, alreadyAdded);
                alreadyAdded.add(dimUniqueName);
            }
        } else {
            super.addRefToSelectedItems(dataSelection, itemRef, newRole, alreadyAdded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String buildUdfFormatCode(boolean onlyReferencedResultItems) throws MetadataException, DataRetrievalException {
        if (this._tmpCubeProcessor == null) {
            DataSelection exportDS = this.getExportDataSelection();
            DataSourceCube dataSourceCube = this.getDataSourceCube(exportDS);
            this._tmpCubeProcessor = new ExportCubeProcessor(dataSourceCube);
            try {
                String string = super.buildUdfFormatCode(onlyReferencedResultItems);
                return string;
            }
            finally {
                this._tmpCubeProcessor.close();
                this._tmpCubeProcessor = null;
            }
        }
        return super.buildUdfFormatCode(onlyReferencedResultItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<String> getBaseFormatNames(boolean onlyReferencedResultItems, DataSelection uploadDS) throws MetadataException, DataRetrievalException {
        if (this._tmpCubeProcessor == null) {
            DataSelection exportDS = this.getExportDataSelection();
            DataSourceCube dataSourceCube = this.getDataSourceCube(exportDS);
            this._tmpCubeProcessor = new ExportCubeProcessor(dataSourceCube);
            try {
                Set<String> set = this._getBaseFormatNames(onlyReferencedResultItems, uploadDS, this._tmpCubeProcessor);
                return set;
            }
            finally {
                this._tmpCubeProcessor.close();
                this._tmpCubeProcessor = null;
            }
        }
        return this._getBaseFormatNames(onlyReferencedResultItems, uploadDS, this._tmpCubeProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> _getBaseFormatNames(boolean onlyReferencedResultItems, DataSelection uploadDS, ExportCubeProcessor ecp) throws MetadataException, DataRetrievalException {
        Set<String> baseFmtNames = super.getBaseFormatNames(onlyReferencedResultItems, uploadDS);
        if (!onlyReferencedResultItems) {
            try {
                Set<String> cubeFormats;
                try {
                    cubeFormats = ecp.getReferencedFormats(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY);
                }
                catch (RemoteException e) {
                    throw new DataRetrievalException(e);
                }
                catch (MdException e) {
                    throw new DataRetrievalException(e);
                }
                Set<String> cubeBases = this.getBaseFormatNames(cubeFormats);
                baseFmtNames.addAll(cubeBases);
            }
            finally {
                ecp.close();
            }
        }
        return baseFmtNames;
    }

    @Override
    protected void buildUploadMetadata() throws MetadataException {
        if (this._tmpCubeProcessor == null) {
            DataSelection exportDS = this.getExportDataSelection();
            DataSourceCube dataSourceCube = this.getDataSourceCube(exportDS);
            this._tmpCubeProcessor = new ExportCubeProcessor(dataSourceCube);
            try {
                super.buildUploadMetadata();
            }
            finally {
                this._tmpCubeProcessor.close();
                this._tmpCubeProcessor = null;
            }
        } else {
            super.buildUploadMetadata();
        }
    }

    @Override
    protected void buildUploadDataSelection() throws MetadataException {
        if (this._tmpCubeProcessor == null) {
            DataSelection exportDS = this.getExportDataSelection();
            DataSourceCube dataSourceCube = this.getDataSourceCube(exportDS);
            this._tmpCubeProcessor = new ExportCubeProcessor(dataSourceCube);
            try {
                this._buildUploadDataSelection(this._tmpCubeProcessor);
            }
            finally {
                this._tmpCubeProcessor.close();
                this._tmpCubeProcessor = null;
            }
        } else {
            this._buildUploadDataSelection(this._tmpCubeProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _buildUploadDataSelection(ExportCubeProcessor cubeProcessor) throws MetadataException {
        ExportRule exportRule;
        boolean ignoreReachThruTable = this.getIgnoreReachThruTable();
        boolean includeAllColumns = this.getIncludeAllColumns();
        DataSelection exportDS = this.getExportDataSelection();
        DataSourceCube dataSourceCube = this.getDataSourceCube(exportDS);
        SessionContextInterface session = exportDS.getSession();
        IntelligentQueryMetadataServiceInterface service = exportDS.getMetadataService();
        Locale computationLocale = LocaleUtilities.getDefaultComputationalLocale(exportDS);
        OlapSchema owningOlapSchema = dataSourceCube.getCube().getOwningOlapSchema();
        ExportCubeProcessor.ensureAllLogicalServersLoaded(owningOlapSchema);
        DataSelection uploadDS = null;
        boolean usePreSummarized = false;
        try (ExportCubeDataDsBuilder dsBuilder = new ExportCubeDataDsBuilder(session, service, dataSourceCube);){
            dsBuilder.setExportCubeProcessor(cubeProcessor);
            uploadDS = dsBuilder.newDataSelection(computationLocale, ignoreReachThruTable, includeAllColumns);
            usePreSummarized = dsBuilder.usePreSummarized();
        }
        List<ExportRule> exportRules = exportDS.getEffectiveRules(ExportRule.class);
        ExportRule exportRule2 = exportRule = exportRules.isEmpty() ? null : exportRules.get(0);
        if (exportRule != null) {
            BusinessModel businessModel = uploadDS.getBusinessModel();
            ExportRuleImpl newRule = new ExportRuleImpl((AbstractBusinessModel)businessModel);
            newRule.setExport(this);
            uploadDS.addBusinessRule(newRule);
        }
        this.setPreSummarized(usePreSummarized);
        this.setUploadDataSelection(uploadDS);
    }

    private DataSourceCube getDataSourceCube(DataSelection exportDS) throws MetadataException {
        List<DataSourceCube> dsCubes = exportDS.getObjects(true, DataSourceCube.class);
        if (dsCubes.isEmpty()) {
            throw new MetadataException(this.getMsgNoCubeInDataSelection());
        }
        DataSourceCube dataSourceCube = dsCubes.get(0);
        return dataSourceCube;
    }

    @Override
    protected void buildExportMetadata() throws MetadataException {
        DataSelection exportDS = this.getExportDataSelection();
        ExportSelectionMetadata exportMD = ExportMetadataFactory.newExportMetadataOlap(exportDS);
        this.setExportMetadata(exportMD);
    }

    private MessageFormatter getMsgNoCubeInDataSelection() {
        return IQMetadataResourceBundle.getMessageFormatter("ExportOlap.NoCubeInDataSelection.fmt.txt", new Object[0]);
    }

    private static MessageFormatter getMsgInvalidUseOfExportOlapForRelationalDS() {
        return IQMetadataResourceBundle.getMessageFormatter("ExportOlap.NoCubeInDataSelection.fmt.txt", new Object[0]);
    }

    public ExportCubeProcessor getCubeProcessor() {
        return this._tmpCubeProcessor;
    }

    public void setCubeProcessor(ExportCubeProcessor tmpCubeProcessor) {
        this._tmpCubeProcessor = tmpCubeProcessor;
    }
}

