/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ExportDiscoveryType;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportObjectFactoryInterface;
import com.sas.iquery.metadata.business.ExportOlapMetadata;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.List;

abstract class ExportObjectFactoryAbstract<U, X>
implements ExportObjectFactoryInterface<U, X> {
    ExportObjectFactoryAbstract() {
    }

    protected List<X> newInstances(ExportGeneralMetadata exportMetadata, List<U> objectsToExport, Object ... options) throws MetadataException {
        ArrayList exportObjects = new ArrayList();
        if (objectsToExport != null) {
            for (U objectToExport : objectsToExport) {
                Object exportObject = this.createObject(null, objectToExport, exportMetadata, options);
                exportObjects.add(exportObject);
            }
        }
        return exportObjects;
    }

    protected static StringBuffer qualifyName(StringBuffer name, Object ... qualifiers) {
        if (qualifiers != null && qualifiers.length > 0) {
            for (Object qualifier : qualifiers) {
                if (qualifier == null) continue;
                if (qualifier.getClass().isArray()) {
                    Object[] qualifiers2;
                    for (Object qualifier2 : qualifiers2 = (Object[])qualifier) {
                        String text = String.valueOf(qualifier2);
                        name.append(text);
                    }
                    continue;
                }
                String text = String.valueOf(qualifier);
                name.append(text);
            }
        }
        return name;
    }

    @Override
    public List<U> find(List<String> list, Class<U> cls, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        DataSelection dataSelection = exportMetadata.getDataSelection();
        List<U> objectsToCheck = dataSelection.getObjects(true, cls);
        ArrayList<U> objectsToExport = new ArrayList<U>();
        for (U objectToCheck : objectsToCheck) {
            String checkName = this.makeUniqueExportName(objectToCheck, exportMetadata, qualifiers);
            if (list != null && !list.contains(checkName)) continue;
            objectsToExport.add(objectToCheck);
        }
        return objectsToExport;
    }

    @Override
    public List<X> discover(ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        List objectsToExport = this.discoverUnderlyingObjects(discoveryType, exportMetadata, qualifiers);
        return this.newInstances(exportMetadata, objectsToExport, qualifiers);
    }

    protected MessageFormatter getInvalidExportMetadataMessage() {
        return IQMetadataResourceBundle.getMessageFormatter("ExportObjectFactoryAbstract.InvalidExportMetadata.fmt.txt", ExportOlapMetadata.class.getSimpleName());
    }

    protected MessageFormatter getInvalidDiscoveryTypeMessage(ExportDiscoveryType discoveryType) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportObjectFactoryAbstract.InvalidDiscoveryType.fmt.txt", discoveryType);
    }
}

