/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.ExportColumn;
import com.sas.iquery.metadata.business.ExportColumnGroup;
import com.sas.iquery.metadata.business.ExportDataSource;
import com.sas.iquery.metadata.business.ExportFilter;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportJoin;
import com.sas.iquery.metadata.business.ExportObject;
import com.sas.iquery.metadata.business.ExportOlapMetadata;
import com.sas.iquery.metadata.business.ExportSelectionMetadata;
import com.sas.iquery.metadata.business.ExportUploadMetadata;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.impl.ExportColumnFactory;
import com.sas.iquery.metadata.business.impl.ExportColumnGroupFactory;
import com.sas.iquery.metadata.business.impl.ExportColumnGroupImpl;
import com.sas.iquery.metadata.business.impl.ExportCubeDataDsBuilder;
import com.sas.iquery.metadata.business.impl.ExportDataSourceFactory;
import com.sas.iquery.metadata.business.impl.ExportFilterFactory;
import com.sas.iquery.metadata.business.impl.ExportJoinFactory;
import com.sas.iquery.metadata.business.impl.ExportMetadataAbstract;
import com.sas.iquery.metadata.physical.Hierarchy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ExportMetadataUploadedImpl
extends ExportMetadataAbstract
implements ExportUploadMetadata {
    private final boolean _preSummarizedData;
    private final ExportDataSourceFactory uploadDataSources = ExportDataSourceFactory.getSingleton();
    private final ExportColumnFactory uploadColumns = ExportColumnFactory.getSingleton();
    private final ExportFilterFactory uploadFilters = ExportFilterFactory.getSingleton();
    private final ExportJoinFactory uploadJoins = ExportJoinFactory.getSingleton();
    private final ExportColumnGroupFactory uploadColumnGroups = ExportColumnGroupFactory.getSingleton();
    private final ExportSelectionMetadata _metadataSelection;
    private Boolean _isStarSchema = null;
    private boolean _isStarFactChecked = false;
    private ExportDataSource _starFact = null;
    private List<ExportDataSource> _starDims = null;

    ExportMetadataUploadedImpl(DataSelection uploadDataSelection, boolean preSummarizedData, ExportSelectionMetadata metadataSelection) throws MetadataException {
        super(uploadDataSelection);
        this._preSummarizedData = preSummarizedData;
        this._metadataSelection = metadataSelection;
    }

    @Override
    public List<ExportDataSource> getUploadDataSourcesUsed() throws MetadataException {
        List<ExportDataSource> collection = this.getCollection("UploadDataSourcesUsed", this.uploadDataSources, ExportDataSourceFactory.DiscoverDataSources.AllDataSourcesUsed, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportColumn> getUploadColumnsUsed() throws MetadataException {
        List<ExportColumn> collection = this.getCollection("UploadColumnsUsed", this.uploadColumns, ExportColumnFactory.DiscoverResultItems.AllResultItemsUsed, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportFilter> getUploadFiltersUsed() throws MetadataException {
        List<ExportFilter> collection = this.getCollection("UploadFilterItems", this.uploadFilters, ExportFilterFactory.DiscoverFilterItems.AllFilterItemsUsed, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportJoin> getUploadJoinsUsed() throws MetadataException {
        List<ExportJoin> collection = this.getCollection("UploadJoinsUsed", this.uploadJoins, ExportJoinFactory.DiscoverJoins.AllJoinsUsed, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportColumnGroup> getUploadColumnGroups() throws MetadataException {
        List<ExportColumnGroup> collection = this.getCollection("UploadColumnGroups", this.uploadColumnGroups, ExportColumnGroupFactory.DiscoverColumnGroups.AllColumnGroups, this, new Object[0]);
        LinkedHashMap<String, LinkedHashMap<Integer, ExportColumn>> sort = new LinkedHashMap<String, LinkedHashMap<Integer, ExportColumn>>();
        List<ExportColumn> uploadColumnsUsed = this.getUploadColumnsUsed();
        for (ExportColumn uploadColumn : uploadColumnsUsed) {
            DataItem dataItem = (DataItem)uploadColumn.getUnderlyingObject();
            List<String> usedBy = ExportCubeDataDsBuilder.getUsedByFormattedHierarchies(dataItem);
            if (usedBy == null) continue;
            for (String hierColFormatInfo : usedBy) {
                String[] parts = hierColFormatInfo.split("#");
                if (parts == null || parts.length < 2) continue;
                String hierarchyUniqueName = parts[0];
                String columnPosition = parts[1];
                LinkedHashMap<Integer, ExportColumn> map = (LinkedHashMap<Integer, ExportColumn>)sort.get(hierarchyUniqueName);
                if (map == null) {
                    map = new LinkedHashMap<Integer, ExportColumn>();
                    sort.put(hierarchyUniqueName, map);
                }
                map.put(Integer.parseInt(columnPosition), uploadColumn);
            }
        }
        List<ExportColumnGroup> exportColumnGroups = this._metadataSelection.getExportColumnGroups();
        for (ExportColumnGroup exportColumnGroup : exportColumnGroups) {
            Hierarchy hierarchy;
            String hierarchyUniqueName;
            Map map;
            ExportColumnGroup.ExportGroupType groupType = exportColumnGroup.getGroupType();
            if (groupType != ExportColumnGroup.ExportGroupType.HIERARCHY || (map = (Map)sort.get(hierarchyUniqueName = (hierarchy = (Hierarchy)exportColumnGroup.getUnderlyingObject()).getHierarchyUniqueName())) == null) continue;
            ArrayList<ExportColumn> underlyingUploadColumns = new ArrayList<ExportColumn>();
            Set keys = map.keySet();
            ArrayList keySet = new ArrayList(keys);
            Collections.sort(keySet);
            for (Integer key : keySet) {
                ExportColumn exportColumn = (ExportColumn)map.get(key);
                underlyingUploadColumns.add(exportColumn);
            }
            ExportColumnGroupImpl exportColumnGroupImpl = new ExportColumnGroupImpl(hierarchy, hierarchy.getHierarchyUniqueName(), this.uploadColumnGroups, this, ExportColumnGroup.ExportGroupType.HIERARCHY, underlyingUploadColumns);
            collection.add(exportColumnGroupImpl);
            sort.remove(hierarchyUniqueName);
        }
        if (!sort.isEmpty()) {
            for (Map.Entry entry : sort.entrySet()) {
                ExportOlapMetadata olapMD;
                List<Hierarchy> found;
                ArrayList<ExportColumn> underlyingUploadColumns = new ArrayList<ExportColumn>();
                String hierarchyUniqueName = (String)entry.getKey();
                Map map = (Map)entry.getValue();
                Set keys = map.keySet();
                ArrayList keySet = new ArrayList(keys);
                Collections.sort(keySet);
                for (Integer key : keySet) {
                    ExportColumn exportColumn = (ExportColumn)map.get(key);
                    underlyingUploadColumns.add(exportColumn);
                }
                BusinessModelResourceReferencer underlyingObject = null;
                if (this._metadataSelection instanceof ExportOlapMetadata && (found = (olapMD = (ExportOlapMetadata)this._metadataSelection).getAvailableHierarchies(Collections.singletonList(hierarchyUniqueName), new Object[0])).size() > 0) {
                    underlyingObject = found.get(0);
                }
                if (underlyingObject == null) {
                    underlyingObject = underlyingUploadColumns.size() > 0 ? ((ExportColumn)underlyingUploadColumns.get(0)).getUnderlyingObject() : this.getUnderlyingObject();
                }
                ExportColumnGroupImpl exportColumnGroupImpl = new ExportColumnGroupImpl(underlyingObject, hierarchyUniqueName, this.uploadColumnGroups, this, ExportColumnGroup.ExportGroupType.HIERARCHY, underlyingUploadColumns);
                collection.add(exportColumnGroupImpl);
            }
        }
        return collection;
    }

    @Override
    public ExportColumn getUploadColumn(DataItem underlyingDataItem) throws MetadataException {
        ExportColumn found = null;
        List<ExportColumn> uploadColumnsUsed = this.getUploadColumnsUsed();
        for (ExportColumn column : uploadColumnsUsed) {
            if (!((DataItem)column.getUnderlyingObject()).equals(underlyingDataItem)) continue;
            found = column;
            break;
        }
        if (found == null) {
            Object[] options = new Object[]{};
            String uniqueExportName = this.uploadColumns.makeUniqueExportName(underlyingDataItem, (ExportGeneralMetadata)this, options);
            List<String> singletonList = Collections.singletonList(uniqueExportName);
            throw new MetadataException(this.getCannotFindByUniqueObjectNamesMessage(this.uploadColumns, singletonList));
        }
        return found;
    }

    @Override
    public boolean isPreSummarizedData() throws MetadataException {
        return this._preSummarizedData;
    }

    @Override
    public List<ExportColumn> getPreSummarizedGroupByColumns() throws MetadataException {
        ArrayList<ExportColumn> summarizedBy = new ArrayList<ExportColumn>();
        List<ExportColumn> uploadColumnsUsed = this.getUploadColumnsUsed();
        for (ExportColumn column : uploadColumnsUsed) {
            boolean isSummarized = column.isPreAggregated() || column.getUsage().equals(DataItemActionType.USAGE_AGGREGATE);
            if (isSummarized) continue;
            summarizedBy.add(column);
        }
        return summarizedBy;
    }

    @Override
    public List<ExportColumn> getPreSummarizedColumns() throws MetadataException {
        ArrayList<ExportColumn> summarized = new ArrayList<ExportColumn>();
        List<ExportColumn> uploadColumnsUsed = this.getUploadColumnsUsed();
        for (ExportColumn column : uploadColumnsUsed) {
            boolean isSummarized = column.isPreAggregated() || column.getUsage().equals(DataItemActionType.USAGE_AGGREGATE);
            if (!isSummarized) continue;
            summarized.add(column);
        }
        return summarized;
    }

    @Override
    public boolean isStarSchema() throws MetadataException {
        if (this._isStarSchema == null) {
            ExportDataSource starFactDataSource = this.getStarFactDataSource();
            this._isStarSchema = starFactDataSource == null ? Boolean.FALSE : Boolean.TRUE;
        }
        return this._isStarSchema;
    }

    @Override
    public ExportDataSource getStarFactDataSource() throws MetadataException {
        if (!this._isStarFactChecked) {
            List<ExportJoin> uploadJoinsUsed = this.getUploadJoinsUsed();
            if (uploadJoinsUsed.isEmpty()) {
                this._starFact = null;
            } else if (uploadJoinsUsed.size() == 1) {
                ExportDataSource from1;
                ExportJoin join1 = uploadJoinsUsed.get(0);
                this._starFact = from1 = join1.getFromTable();
            } else {
                ExportJoin join1 = uploadJoinsUsed.get(0);
                ExportDataSource from1 = join1.getFromTable();
                ExportDataSource to1 = join1.getToTable();
                ExportJoin join2 = uploadJoinsUsed.get(1);
                ExportDataSource from2 = join2.getFromTable();
                ExportDataSource to2 = join2.getToTable();
                this._starFact = ((DataSource)from1.getUnderlyingObject()).equals(from2.getUnderlyingObject()) ? from1 : (((DataSource)from1.getUnderlyingObject()).equals(to2.getUnderlyingObject()) ? from1 : (((DataSource)to1.getUnderlyingObject()).equals(from2.getUnderlyingObject()) ? to1 : (((DataSource)to1.getUnderlyingObject()).equals(to2.getUnderlyingObject()) ? to1 : to1)));
            }
            this._isStarFactChecked = true;
        }
        return this._starFact;
    }

    @Override
    public List<ExportDataSource> getStarDimDataSources() throws MetadataException {
        if (this._starDims == null) {
            this._starDims = new ArrayList<ExportDataSource>();
            ExportDataSource starFact = this.getStarFactDataSource();
            List<ExportDataSource> uploadDataSourcesUsed = this.getUploadDataSourcesUsed();
            for (ExportDataSource dataSource : uploadDataSourcesUsed) {
                if (((DataSource)dataSource.getUnderlyingObject()).equals(starFact.getUnderlyingObject())) continue;
                this._starDims.add(dataSource);
            }
        }
        return this._starDims;
    }

    @Override
    public Map<ExportDataSource, Set<QualifiedColumn>> getUploadColumnsUsedByHierarchies() throws MetadataException {
        LinkedHashMap<ExportDataSource, Set<QualifiedColumn>> usedHierColumns = new LinkedHashMap<ExportDataSource, Set<QualifiedColumn>>();
        List<ExportDataSource> uploadDataSourcesUsed = this.getUploadDataSourcesUsed();
        List<ExportColumnGroup> uploadColumnGroups = this.getUploadColumnGroups();
        for (ExportColumnGroup uploadColumnGroup : uploadColumnGroups) {
            if (uploadColumnGroup.getGroupType() != ExportColumnGroup.ExportGroupType.HIERARCHY) continue;
            List<ExportColumn> columns = uploadColumnGroup.getColumns();
            for (ExportColumn column : columns) {
                DataItem underlyingObject = (DataItem)column.getUnderlyingObject();
                List<QualifiedColumn> resources = underlyingObject.getResources(QualifiedColumn.class, 65535);
                for (QualifiedColumn qualifiedColumn : resources) {
                    for (ExportDataSource exportDataSource : uploadDataSourcesUsed) {
                        if (!exportDataSource.containsColumn(qualifiedColumn)) continue;
                        LinkedHashSet<QualifiedColumn> usedHierColumnsTable = (LinkedHashSet<QualifiedColumn>)usedHierColumns.get(exportDataSource);
                        if (usedHierColumnsTable == null) {
                            usedHierColumnsTable = new LinkedHashSet<QualifiedColumn>();
                            usedHierColumns.put(exportDataSource, usedHierColumnsTable);
                        }
                        usedHierColumnsTable.add(qualifiedColumn);
                    }
                }
            }
        }
        return usedHierColumns;
    }

    @Override
    public ExportDataSource getExportDataSource(DataSource dataSource, Object ... createOptions) throws MetadataException {
        ExportDataSource exportObject;
        String uniqueExportName = this.uploadDataSources.makeUniqueExportName(dataSource, (ExportGeneralMetadata)this, createOptions);
        ExportObject<?, ?> alreadyCached = this.getUniqueExportObject(uniqueExportName);
        if (alreadyCached != null) {
            Object underlyingObject = alreadyCached.getUnderlyingObject();
            if (underlyingObject != dataSource) {
                throw new MetadataException(this.getDuplicateUniqueExportNameMessage(uniqueExportName, dataSource, underlyingObject));
            }
            exportObject = (ExportDataSource)alreadyCached;
        } else {
            exportObject = this.uploadDataSources.createObject(uniqueExportName, dataSource, (ExportGeneralMetadata)this, createOptions);
            this.putUniqueExportObject(uniqueExportName, exportObject);
        }
        return exportObject;
    }
}

