/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.ExportColumn;
import com.sas.iquery.metadata.business.ExportColumnGroup;
import com.sas.iquery.metadata.business.ExportDataSource;
import com.sas.iquery.metadata.business.ExportFilter;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportObject;
import com.sas.iquery.metadata.business.ExportSelectionMetadata;
import com.sas.iquery.metadata.business.impl.ExportColumnFactory;
import com.sas.iquery.metadata.business.impl.ExportColumnGroupFactory;
import com.sas.iquery.metadata.business.impl.ExportDataSourceFactory;
import com.sas.iquery.metadata.business.impl.ExportFilterFactory;
import com.sas.iquery.metadata.business.impl.ExportMetadataAbstract;
import java.util.Collections;
import java.util.List;

abstract class ExportMetadataSelectedAbstract
extends ExportMetadataAbstract
implements ExportSelectionMetadata {
    private final ExportDataSourceFactory exportDataSources = ExportDataSourceFactory.getSingleton();
    private final ExportColumnFactory exportColumns = ExportColumnFactory.getSingleton();
    private final ExportFilterFactory exportFilters = ExportFilterFactory.getSingleton();
    private final ExportColumnGroupFactory exportColumnGroups = ExportColumnGroupFactory.getSingleton();

    public ExportMetadataSelectedAbstract(DataSelection dataSelection) throws MetadataException {
        super(dataSelection);
    }

    @Override
    public List<ExportDataSource> getExportDataSourcesUsed() throws MetadataException {
        List<ExportDataSource> collection = this.getCollection("AllDataSourcesUsed", this.exportDataSources, ExportDataSourceFactory.DiscoverDataSources.AllDataSourcesUsed, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportColumn> getExportColumnsUsed() throws MetadataException {
        List<ExportColumn> collection = this.getCollection("ExportColumnsUsed", this.exportColumns, ExportColumnFactory.DiscoverResultItems.AllResultItemsUsed, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportColumn> getExportColumnsAvailable() throws MetadataException {
        List<ExportColumn> collection = this.getCollection("ExportColumnsAvailable", this.exportColumns, ExportColumnFactory.DiscoverResultItems.AvailableResultItems, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportFilter> getExportFiltersUsed() throws MetadataException {
        List<ExportFilter> collection = this.getCollection("AllFilterItemsUsed", this.exportFilters, ExportFilterFactory.DiscoverFilterItems.AllFilterItemsUsed, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportFilter> getExportFiltersSelected() throws MetadataException {
        List<ExportFilter> collection = this.getCollection("SelectedFilterItems", this.exportFilters, ExportFilterFactory.DiscoverFilterItems.SelectedFilterItems, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportFilter> getExportFiltersAvailable() throws MetadataException {
        List<ExportFilter> collection = this.getCollection("AvailableFilterItems", this.exportFilters, ExportFilterFactory.DiscoverFilterItems.AvailableFilterItems, this, new Object[0]);
        return collection;
    }

    @Override
    public List<ExportColumnGroup> getExportColumnGroups() throws MetadataException {
        List<ExportColumnGroup> collection = this.getCollection("ExportColumnGroups", this.exportColumnGroups, ExportColumnGroupFactory.DiscoverColumnGroups.AllColumnGroups, this, new Object[0]);
        return collection;
    }

    @Override
    public ExportColumn getExportColumn(DataItem underlyingDataItem) throws MetadataException {
        Object[] options = new Object[0];
        String uniqueExportName = this.exportColumns.makeUniqueExportName(underlyingDataItem, (ExportGeneralMetadata)this, options);
        List<String> singletonList = Collections.singletonList(uniqueExportName);
        List<ExportColumn> exportObjects = this.exportColumns.find(singletonList, this, options);
        if (exportObjects.size() < 1) {
            throw new MetadataException(this.getCannotFindByUniqueObjectNamesMessage(this.exportColumns, singletonList));
        }
        ExportColumn exportColumn = exportObjects.get(0);
        return exportColumn;
    }

    @Override
    public ExportDataSource getExportDataSource(DataSource dataSource, Object ... createOptions) throws MetadataException {
        ExportDataSource exportObject;
        String uniqueExportName = this.exportDataSources.makeUniqueExportName(dataSource, (ExportGeneralMetadata)this, createOptions);
        ExportObject<?, ?> alreadyCached = this.getUniqueExportObject(uniqueExportName);
        if (alreadyCached != null) {
            Object underlyingObject = alreadyCached.getUnderlyingObject();
            if (underlyingObject != dataSource) {
                throw new MetadataException(this.getDuplicateUniqueExportNameMessage(uniqueExportName, dataSource, underlyingObject));
            }
            exportObject = (ExportDataSource)alreadyCached;
        } else {
            exportObject = this.exportDataSources.createObject(uniqueExportName, dataSource, (ExportGeneralMetadata)this, createOptions);
            this.putUniqueExportObject(uniqueExportName, exportObject);
        }
        return exportObject;
    }
}

