/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.ExportDiscoveryType;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportObject;
import com.sas.iquery.metadata.business.ExportObjectFactoryInterface;
import com.sas.iquery.metadata.business.impl.ExportCubeProcessor;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

abstract class ExportMetadataAbstract
implements ExportGeneralMetadata {
    private final DataSelection _dataSelection;
    private final Map<String, List<String>> _collectedfUniqueExportNames = new LinkedHashMap<String, List<String>>();
    private final Map<String, ExportObject<?, ?>> _uniqueExportObjectCache = new LinkedHashMap();

    public ExportMetadataAbstract(DataSelection dataSelection) throws MetadataException {
        this._dataSelection = dataSelection;
    }

    @Override
    public DataSelection getDataSelection() {
        return this._dataSelection;
    }

    @Override
    public DataSelection getUnderlyingObject() {
        return this._dataSelection;
    }

    @Override
    public StructureOfData getStructureOfData() {
        return this._dataSelection.getInputStructure();
    }

    @Override
    public String getID() {
        return this._dataSelection.getID();
    }

    public boolean containsUniqueExportObject(String uniqueExportName) {
        return this._uniqueExportObjectCache.containsKey(uniqueExportName);
    }

    @Override
    public ExportObject<?, ?> getUniqueExportObject(String uniqueExportName) throws MetadataException {
        ExportObject<?, ?> exportObject = this._uniqueExportObjectCache.get(uniqueExportName);
        return exportObject;
    }

    public <U, X> ExportObject<?, ?> putUniqueExportObject(String uniqueExportName, ExportObject<U, X> exportObject) {
        ExportObject<U, X> object = this._uniqueExportObjectCache.put(uniqueExportName, exportObject);
        return object;
    }

    protected List<String> putCollection(String collectionName, List<String> newUniqueExportNamesList) {
        return this._collectedfUniqueExportNames.put(collectionName, newUniqueExportNamesList);
    }

    protected List<String> getCollection(String collectionName) {
        return this._collectedfUniqueExportNames.get(collectionName);
    }

    public <U, X extends ExportObject<U, X>> List<X> getCollection(@Nonnull String collectionName, @Nonnull ExportObjectFactoryInterface<U, X> factory, @Nonnull ExportDiscoveryType discoveryType, @Nonnull ExportGeneralMetadata exportMetadata, Object ... options) throws MetadataException {
        List<String> list = this.getCollection(collectionName);
        Collection<X> discovered = this.extract(collectionName, factory, discoveryType, exportMetadata, list, options);
        ArrayList<ExportObject> exportObjects = new ArrayList<ExportObject>(discovered.size());
        ArrayList<String> newUniqueExportNamesList = list == null ? new ArrayList<String>(discovered.size()) : null;
        for (ExportObject exportObject : discovered) {
            String uniqueExportName = exportObject.getUniqueExportName();
            ExportObject<?, ?> existingObject = this.getUniqueExportObject(uniqueExportName);
            if (existingObject == null) {
                this.putUniqueExportObject(uniqueExportName, exportObject);
            } else if (existingObject != exportObject) {
                throw new MetadataException(this.getDuplicateUniqueExportNameMessage(uniqueExportName, exportObject, existingObject));
            }
            if (newUniqueExportNamesList != null) {
                newUniqueExportNamesList.add(uniqueExportName);
            }
            exportObjects.add(exportObject);
        }
        if (newUniqueExportNamesList != null) {
            this.putCollection(collectionName, newUniqueExportNamesList);
        }
        return exportObjects;
    }

    protected <X extends ExportObject<U, X>, U> Collection<X> extract(String collectionName, ExportObjectFactoryInterface<U, X> factory, ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, List<String> list, Object ... options) throws MetadataException {
        Collection discovered;
        LinkedHashMap<String, ExportObject> found = new LinkedHashMap<String, ExportObject>();
        ArrayList<String> needInstances = new ArrayList<String>();
        if (list == null) {
            List<U> underlyingObjects = factory.discoverUnderlyingObjects(discoveryType, exportMetadata, options);
            Iterator<Object> iterator = underlyingObjects.iterator();
            while (iterator.hasNext()) {
                Object objectToExport = iterator.next();
                String uniqueExportName = factory.makeUniqueExportName(objectToExport, exportMetadata, options);
                ExportObject<?, ?> alreadyCached = this.getUniqueExportObject(uniqueExportName);
                if (alreadyCached != null) {
                    if (alreadyCached.getUnderlyingObject() != objectToExport) {
                        throw new MetadataException(this.getDuplicateUniqueExportNameMessage(uniqueExportName, objectToExport, alreadyCached));
                    }
                    found.put(uniqueExportName, alreadyCached);
                    continue;
                }
                ExportObject exportObject = (ExportObject)factory.createObject(uniqueExportName, objectToExport, exportMetadata, options);
                found.put(uniqueExportName, exportObject);
            }
        } else {
            for (String uniqueExportName : list) {
                ExportObject<?, ?> alreadyCached = this.getUniqueExportObject(uniqueExportName);
                if (alreadyCached != null) {
                    found.put(uniqueExportName, alreadyCached);
                    continue;
                }
                needInstances.add(uniqueExportName);
                found.put(uniqueExportName, null);
            }
        }
        if (needInstances.size() > 0) {
            List<X> newInstances = factory.find(needInstances, exportMetadata, options);
            for (ExportObject x : newInstances) {
                found.put(x.getUniqueExportName(), x);
            }
        }
        if ((discovered = found.values()).contains(null)) {
            throw new MetadataException(this.getErrorDiscoveringObjectsMessage(collectionName, factory, discoveryType));
        }
        return discovered;
    }

    protected DataSourceCube getDataSouceCube(DataSource underlyingObject) throws MetadataException {
        DataSourceCube dataSourceCube = (DataSourceCube)underlyingObject;
        OlapSchema owningOlapSchema = dataSourceCube.getCube().getOwningOlapSchema();
        ExportCubeProcessor.ensureAllLogicalServersLoaded(owningOlapSchema);
        return dataSourceCube;
    }

    protected MessageFormatter getCannotFindByUniqueObjectNamesMessage(String collectionName, Object factory, List<String> list) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportMetadataAbstract.CannotFindByUniqueObjectNamesInCollection.fmt.txt", new ArrayMessageFormatter(list.toArray()), factory, factory.getClass().getName(), collectionName);
    }

    protected MessageFormatter getCannotFindByUniqueObjectNamesMessage(Object factory, List<String> list) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportMetadataAbstract.CannotFindByUniqueObjectNames.fmt.txt", new ArrayMessageFormatter(list.toArray()), factory, factory.getClass().getName());
    }

    protected MessageFormatter getErrorDiscoveringObjectsMessage(String collectionName, Object factory, ExportDiscoveryType discoveryType) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportMetadataAbstract.ErrorDiscoveringObjects.fmt.txt", factory, factory.getClass().getName(), discoveryType, collectionName);
    }

    protected MessageFormatter getDuplicateUniqueExportNameMessage(String uniqueExportName, Object underlyingObject, Object alreadyCachedUnderlyingObject) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportMetadataAbstract.DuplicateUniqueExportName.fmt.txt", uniqueExportName, alreadyCachedUnderlyingObject, alreadyCachedUnderlyingObject.getClass().getName(), underlyingObject, underlyingObject.getClass().getName());
    }

    protected MessageFormatter getUniqueNameAlreadyInUse(String uniqueExportName, Class<?> expectedType, Object alreadyCachedUnderlyingObject) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportMetadataAbstract.getUniqueNameAlreadyInUse.fmt.txt", uniqueExportName, alreadyCachedUnderlyingObject, alreadyCachedUnderlyingObject.getClass().getName(), expectedType.getName());
    }
}

