/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ExportDiscoveryType;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportMember;
import com.sas.iquery.metadata.business.ExportOlapMetadata;
import com.sas.iquery.metadata.business.impl.ExportMemberImpl;
import com.sas.iquery.metadata.business.impl.ExportObjectFactoryAbstract;
import com.sas.iquery.metadata.physical.Member;
import java.util.List;
import javax.annotation.Nonnull;

public final class ExportMemberFactory
extends ExportObjectFactoryAbstract<Member, ExportMember> {
    private static final ExportMemberFactory SINGLETON_FACTORY = new ExportMemberFactory();

    private ExportMemberFactory() {
    }

    public static ExportMemberFactory getSingleton() {
        return SINGLETON_FACTORY;
    }

    private ExportMember createExportObject(Member objectToExport, String uniqueExportName, ExportGeneralMetadata exportMetadata) throws MetadataException {
        return new ExportMemberImpl(objectToExport, uniqueExportName, this, exportMetadata);
    }

    @Override
    public String makeUniqueExportName(@Nonnull Member objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String objectToExportUniqueID = objectToExport.getMemberUniqueName();
        return ExportMemberFactory.qualifyName(new StringBuffer(objectToExportUniqueID), qualifiers).toString();
    }

    @Override
    public ExportMember createObject(String useUniqueExportName, Member objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String uniqueExportName = useUniqueExportName != null && useUniqueExportName.length() > 0 ? useUniqueExportName : this.makeUniqueExportName(objectToExport, exportMetadata, qualifiers);
        ExportMember exportMember = this.createExportObject(objectToExport, uniqueExportName, exportMetadata);
        return exportMember;
    }

    @Override
    public List<ExportMember> find(List<String> list, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        if (!(exportMetadata instanceof ExportOlapMetadata)) {
            throw new MetadataException(this.getInvalidExportMetadataMessage());
        }
        List<Member> objectsToExport = ((ExportOlapMetadata)exportMetadata).getAvailableMembers(list, qualifiers);
        return this.newInstances(exportMetadata, objectsToExport, qualifiers);
    }

    @Override
    public List<Member> discoverUnderlyingObjects(ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        if (!(exportMetadata instanceof ExportOlapMetadata)) {
            throw new MetadataException(this.getInvalidExportMetadataMessage());
        }
        if (discoveryType != DiscoverMembers.AvailableMembers) {
            throw new MetadataException(this.getInvalidDiscoveryTypeMessage(discoveryType));
        }
        List<Member> objectsToExport = ((ExportOlapMetadata)exportMetadata).getAvailableMembers(null, qualifiers);
        return objectsToExport;
    }

    public static enum DiscoverMembers implements ExportDiscoveryType
    {
        AvailableMembers;

    }
}

