/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.ExportColumn;
import com.sas.iquery.metadata.business.ExportDiscoveryType;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportHierarchy;
import com.sas.iquery.metadata.business.ExportLevel;
import com.sas.iquery.metadata.business.ExportOlapMetadata;
import com.sas.iquery.metadata.business.QualifiedLevel;
import com.sas.iquery.metadata.business.impl.ExportLevelImpl;
import com.sas.iquery.metadata.business.impl.ExportObjectFactoryAbstract;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import java.util.List;

public class ExportLevelFactory
extends ExportObjectFactoryAbstract<Level, ExportLevel> {
    private static final ExportLevelFactory SINGLETON_FACTORY = new ExportLevelFactory();

    private ExportLevelFactory() {
    }

    public static ExportLevelFactory getSingleton() {
        return SINGLETON_FACTORY;
    }

    private ExportLevel createExportObject(Level objectToExport, String uniqueExportName, ExportGeneralMetadata exportMetadata) throws MetadataException {
        ExportHierarchy owningExportHierarchy;
        ExportColumn exportColumn;
        ExportOlapMetadata olapMetadata = (ExportOlapMetadata)exportMetadata;
        if (objectToExport instanceof QualifiedLevel) {
            QualifiedLevel qLevel = (QualifiedLevel)objectToExport;
            String qLevelText = StringExpressionUtil.getInstance().getText(qLevel);
            List<ExportColumn> exportColumnsAvailable = olapMetadata.getExportColumnsAvailable();
            ExportColumn matchingColumn = null;
            for (ExportColumn exportColumnAvailable : exportColumnsAvailable) {
                DataItem dataItem = (DataItem)exportColumnAvailable.getUnderlyingObject();
                ExpressionInterface expression = dataItem.getExpression();
                if (expression.equals(qLevel)) {
                    matchingColumn = exportColumnAvailable;
                    break;
                }
                String exprText = StringExpressionUtil.getInstance().getText(expression);
                if (!qLevelText.equals(exprText)) continue;
                matchingColumn = exportColumnAvailable;
                break;
            }
            Hierarchy owningHierarchy = qLevel.getOwningHierarchy();
            if (matchingColumn == null) {
                String owningHierarchyText = StringExpressionUtil.getInstance().getText(owningHierarchy);
                for (ExportColumn exportColumnAvailable : exportColumnsAvailable) {
                    DataItem dataItem = (DataItem)exportColumnAvailable.getUnderlyingObject();
                    ExpressionInterface expression = dataItem.getExpression();
                    if (expression.equals(owningHierarchy)) {
                        matchingColumn = exportColumnAvailable;
                        break;
                    }
                    String exprText = StringExpressionUtil.getInstance().getText(expression);
                    if (!owningHierarchyText.equals(exprText)) continue;
                    matchingColumn = exportColumnAvailable;
                    break;
                }
            }
            exportColumn = matchingColumn;
            String owningHierarchyUniqueName = owningHierarchy.getHierarchyUniqueName();
            owningExportHierarchy = (ExportHierarchy)exportMetadata.getUniqueExportObject(owningHierarchyUniqueName);
        } else {
            owningExportHierarchy = null;
            exportColumn = null;
        }
        return new ExportLevelImpl(objectToExport, uniqueExportName, this, exportMetadata, owningExportHierarchy, exportColumn);
    }

    @Override
    public String makeUniqueExportName(Level objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String objectToExportUniqueID = objectToExport.getLevelUniqueName();
        return ExportLevelFactory.qualifyName(new StringBuffer(objectToExportUniqueID), qualifiers).toString();
    }

    @Override
    public ExportLevel createObject(String useUniqueExportName, Level objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String uniqueExportName = useUniqueExportName != null && useUniqueExportName.length() > 0 ? useUniqueExportName : this.makeUniqueExportName(objectToExport, exportMetadata, qualifiers);
        ExportLevel exportLevel = this.createExportObject(objectToExport, uniqueExportName, exportMetadata);
        return exportLevel;
    }

    @Override
    public List<ExportLevel> find(List<String> list, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        if (!(exportMetadata instanceof ExportOlapMetadata)) {
            throw new MetadataException(this.getInvalidExportMetadataMessage());
        }
        List<Level> objectsToExport = ((ExportOlapMetadata)exportMetadata).getAvailableLevels(list, qualifiers);
        return this.newInstances(exportMetadata, objectsToExport, qualifiers);
    }

    @Override
    public List<Level> discoverUnderlyingObjects(ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        if (!(exportMetadata instanceof ExportOlapMetadata)) {
            throw new MetadataException(this.getInvalidExportMetadataMessage());
        }
        if (discoveryType != DiscoverLevels.AvailableLevels) {
            throw new MetadataException(this.getInvalidDiscoveryTypeMessage(discoveryType));
        }
        List<Level> objectsToExport = ((ExportOlapMetadata)exportMetadata).getAvailableLevels(null, qualifiers);
        return objectsToExport;
    }

    public static enum DiscoverLevels implements ExportDiscoveryType
    {
        AvailableLevels;

    }
}

