/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.ExportDataSource;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportJoin;
import com.sas.iquery.metadata.business.ExportJoinColumnPair;
import com.sas.iquery.metadata.business.ExportObjectFactoryInterface;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.JoinType;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.impl.ExportJoinColumnPairImpl;
import com.sas.iquery.metadata.business.impl.ExportObjectAbstract;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.iqtextparser.NodeParser;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.ParserUtil;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.serverprop.Function;
import java.util.ArrayList;
import java.util.List;

class ExportJoinImpl
extends ExportObjectAbstract<Join, ExportJoin>
implements ExportJoin {
    private List<ExportJoinColumnPair> _joinDefs = null;
    private ExportDataSource _fromTable = null;
    private ExportDataSource _toTable = null;

    public ExportJoinImpl(Join objectToExport, String uniqueExportName, ExportObjectFactoryInterface<Join, ExportJoin> factory, ExportGeneralMetadata exportMetadata) throws MetadataException {
        super(objectToExport, uniqueExportName, factory, exportMetadata);
    }

    @Override
    public String getID() throws MetadataException {
        return ((Join)this.getUnderlyingObject()).getID();
    }

    @Override
    public String getLabel() {
        return ((Join)this.getUnderlyingObject()).getLabel();
    }

    @Override
    public String getDescription() {
        return ((Join)this.getUnderlyingObject()).getDescription();
    }

    @Override
    public ExportDataSource getFromTable() throws MetadataException {
        if (this._fromTable == null) {
            DataSourceTable fromDST = ((Join)this.getUnderlyingObject()).getLeftDataSource();
            ExportGeneralMetadata exportMetadata = this.getExportMetadata();
            this._fromTable = exportMetadata.getExportDataSource(fromDST, new Object[0]);
        }
        return this._fromTable;
    }

    @Override
    public ExportDataSource getToTable() throws MetadataException {
        if (this._toTable == null) {
            DataSourceTable toDST = ((Join)this.getUnderlyingObject()).getRightDataSource();
            ExportGeneralMetadata exportMetadata = this.getExportMetadata();
            this._toTable = exportMetadata.getExportDataSource(toDST, new Object[0]);
        }
        return this._toTable;
    }

    @Override
    public JoinType getJoinType() throws MetadataException {
        return ((Join)this.getUnderlyingObject()).getType();
    }

    @Override
    public ConditionalExpression getJoinCondition() throws MetadataException {
        return ((Join)this.getUnderlyingObject()).getJoinCondition();
    }

    @Override
    public List<ExportJoinColumnPair> getJoinColumnPairs() throws MetadataException {
        if (this._joinDefs == null) {
            this._joinDefs = new ArrayList<ExportJoinColumnPair>();
            try {
                this.build(this._joinDefs);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                this._joinDefs.clear();
            }
        }
        return this._joinDefs;
    }

    private void build(List<ExportJoinColumnPair> joinDefs) throws MetadataException, IllegalArgumentException {
        Join join = (Join)this.getUnderlyingObject();
        BusinessModel model = join.getBusinessModel();
        DataSourceTable fromDST = join.getLeftDataSource();
        DataSourceTable toDST = join.getRightDataSource();
        ConditionalExpression joinCondition = join.getJoinCondition();
        this.build(joinDefs, model, fromDST, toDST, false, joinCondition);
    }

    private void build(List<ExportJoinColumnPair> joinDefs, BusinessModel model, DataSourceTable fromDST, DataSourceTable toDST, boolean isNegated, ExpressionInterface condition) throws MetadataException {
        if (condition instanceof MultipleConditionalExpression) {
            this.build(joinDefs, model, fromDST, toDST, isNegated, (MultipleConditionalExpression)condition);
        } else if (condition instanceof CompoundConditionalExpression) {
            this.build(joinDefs, model, fromDST, toDST, isNegated, (CompoundConditionalExpression)condition);
        } else if (condition instanceof SimpleConditionalExpression_Comparison) {
            this.build(joinDefs, fromDST, toDST, isNegated, (SimpleConditionalExpression_Comparison)condition);
        } else {
            this.buildByParsing(joinDefs, model, fromDST, toDST, isNegated, condition);
        }
    }

    private void buildByParsing(List<ExportJoinColumnPair> joinDefs, BusinessModel model, DataSourceTable fromDST, DataSourceTable toDST, boolean isNegated, ExpressionInterface condition) throws MetadataException {
        String text;
        NodeParser parser = ParserUtil.newParser();
        ParsedNode predicate = parser.parsePredicate(text = this.cleanupText(this.toText(condition), true), false, false, false, false);
        ExpressionInterface expr = ParserUtil.newExpressionInterface(predicate, model, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
        if (expr instanceof FunctionCall) {
            boolean isOnlyTwoArgs;
            String trim;
            FunctionCall fc = (FunctionCall)expr;
            Function function = fc.getFunction();
            List<ExpressionInterface> arguments = fc.getArguments();
            String syntaxToken = function.getSyntaxToken();
            String string = trim = syntaxToken == null ? "" : syntaxToken.trim();
            boolean isEQ = isNegated ? trim.equals("<>") || trim.equals("!=") || trim.equals("NEQ") : trim.equals("=") || trim.equals("==") || trim.equals("EQ");
            boolean bl = isOnlyTwoArgs = arguments != null && arguments.size() == 2;
            if (isEQ && isOnlyTwoArgs) {
                ExpressionInterface xl = arguments.get(0);
                ExpressionInterface xr = arguments.get(1);
                this.build(joinDefs, fromDST, toDST, xl, xr);
            }
        } else if (expr instanceof SimpleConditionalExpression_Comparison) {
            SimpleConditionalExpression_Comparison scec = (SimpleConditionalExpression_Comparison)expr;
            this.build(joinDefs, fromDST, toDST, isNegated, scec);
        } else {
            throw new IllegalArgumentException(this.getMsgConditionTooComplex(condition));
        }
    }

    private void build(List<ExportJoinColumnPair> joinDefs, BusinessModel model, DataSourceTable fromDST, DataSourceTable toDST, boolean isNegated, MultipleConditionalExpression mce) throws MetadataException {
        boolean isAnd;
        boolean isCceNegated = mce.isNegated();
        isNegated = isNegated ? !isCceNegated : isCceNegated;
        ConditionalRelationType relationType = mce.getRelationType();
        boolean bl = isAnd = isNegated ? relationType.equals(ConditionalRelationType.OR) : relationType.equals(ConditionalRelationType.AND);
        if (isAnd) {
            List<ExpressionInterface> expressionList = mce.getExpressionList();
            for (ExpressionInterface expr : expressionList) {
                this.build(joinDefs, model, fromDST, toDST, isNegated, expr);
            }
        } else {
            throw new IllegalArgumentException(this.getMsgConditionTooComplex(mce));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void build(List<ExportJoinColumnPair> joinDefs, BusinessModel model, DataSourceTable fromDST, DataSourceTable toDST, boolean isNegated, CompoundConditionalExpression cce) throws MetadataException {
        boolean isCceNegated = cce.isNegated();
        isNegated = isNegated ? !isCceNegated : isCceNegated;
        ConditionalRelationType relationType = cce.getRelationType();
        ExpressionInterface xl = cce.getLeftExpression();
        ExpressionInterface xr = cce.getRightExpression();
        if (relationType == null || xl == null && xr != null || xl != null && xr == null) {
            ExpressionInterface expr = xl;
            if (expr == null) {
                expr = xr;
            }
            if (expr == null) {
                throw new IllegalArgumentException(this.getMsgAnExpressionIsNull());
            }
            this.build(joinDefs, model, fromDST, toDST, isNegated, expr);
            return;
        } else {
            boolean isAnd;
            if (relationType == null || xl == null || xr == null) throw new IllegalArgumentException(this.getMsgAnExpressionIsNull());
            boolean bl = isAnd = isNegated ? relationType.equals(ConditionalRelationType.OR) : relationType.equals(ConditionalRelationType.AND);
            if (!isAnd) throw new IllegalArgumentException(this.getMsgConditionTooComplex(cce));
            this.build(joinDefs, model, fromDST, toDST, isNegated, xl);
            this.build(joinDefs, model, fromDST, toDST, isNegated, xr);
        }
    }

    private void build(List<ExportJoinColumnPair> joinDefs, DataSourceTable fromDST, DataSourceTable toDST, boolean isNegated, SimpleConditionalExpression_Comparison scec) throws MetadataException {
        boolean isEQ;
        boolean isScecNegated = scec.isNegated();
        isNegated = isNegated ? !isScecNegated : isScecNegated;
        ComparisonOperator comparisonOperator = scec.getComparisonOperator();
        boolean bl = isEQ = isNegated ? comparisonOperator.equals(ComparisonOperator.COMPARE_NEQ) : comparisonOperator.equals(ComparisonOperator.COMPARE_EQ);
        if (!isEQ) {
            throw new IllegalArgumentException(this.getMsgConditionTooComplex(scec));
        }
        ExpressionInterface xl = scec.getLeftExpression();
        ExpressionInterface xr = scec.getRightExpression();
        this.build(joinDefs, fromDST, toDST, xl, xr);
    }

    private void build(List<ExportJoinColumnPair> joinDefs, DataSourceTable fromDST, DataSourceTable toDST, ExpressionInterface a, ExpressionInterface b) throws MetadataException, IllegalArgumentException {
        QualifiedColumn toQC;
        QualifiedColumn fromQC;
        if (a == null) {
            throw new IllegalArgumentException(this.getMsgFromColumnIsNull());
        }
        if (!(a instanceof QualifiedColumn)) {
            throw new IllegalArgumentException(this.getMsgFromExpressionNotColumn(a));
        }
        QualifiedColumn qa = (QualifiedColumn)a;
        if (b == null) {
            throw new IllegalArgumentException(this.getMsgToExpressionIsNull());
        }
        if (!(b instanceof QualifiedColumn)) {
            throw new IllegalArgumentException(this.getMsgToExpressionNotColumn(b));
        }
        QualifiedColumn qb = (QualifiedColumn)b;
        boolean aIsLeftColumn = qa.getDataSource().equals(fromDST);
        boolean bIsRightColumn = qb.getDataSource().equals(toDST);
        boolean bIsLeftColumn = qb.getDataSource().equals(fromDST);
        boolean aIsRightColumn = qa.getDataSource().equals(toDST);
        if (aIsLeftColumn && bIsRightColumn) {
            fromQC = qa;
            toQC = qb;
        } else if (bIsLeftColumn && aIsRightColumn) {
            fromQC = qb;
            toQC = qa;
        } else {
            if (!aIsRightColumn || !aIsLeftColumn) {
                throw new IllegalArgumentException(this.getMsgFromColumnNotInTables(fromDST, toDST, a));
            }
            throw new IllegalArgumentException(this.getMsgToColumnNotInTables(fromDST, toDST, b));
        }
        joinDefs.add(new ExportJoinColumnPairImpl(fromQC, toQC));
    }

    private String toText(ExpressionInterface b) throws MetadataException {
        BusinessModel model = ((Join)this.getUnderlyingObject()).getBusinessModel();
        return StringExpressionUtil.getInstance().getText(b, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, model);
    }

    private String cleanupText(String text, boolean stripParens) {
        text = text.trim();
        if (stripParens) {
            while (text.startsWith("(") && text.endsWith(")")) {
                text = text.substring(1, text.length() - 1).trim();
            }
        }
        return text;
    }

    private String getMsgAnExpressionIsNull() {
        return "An expression in the join condition is null.";
    }

    private String getMsgConditionTooComplex(ExpressionInterface expr) throws MetadataException {
        return "The conditional expression, \"" + this.cleanupText(this.toText(expr), true) + "\", for the join is to complex to parse into from and to columns.";
    }

    private String getMsgFromColumnIsNull() {
        return "The from expression of the join condition is null.";
    }

    private String getMsgFromExpressionNotColumn(ExpressionInterface a) throws MetadataException {
        return "The from expression of the join condition, \"" + this.cleanupText(this.toText(a), false) + "\", is not a simple qualified column but is instead an object of class " + a.getClass() + ".";
    }

    private String getMsgToExpressionIsNull() {
        return "The to expression of the join condition is null.";
    }

    private String getMsgToExpressionNotColumn(ExpressionInterface b) throws MetadataException {
        return "The to expression of the join condition, \"" + this.cleanupText(this.toText(b), false) + "\", is not a simple qualified column but is instead an object of class " + b.getClass() + ".";
    }

    private String getMsgFromColumnNotInTables(DataSourceTable fromDataSource, DataSourceTable toDataSource, ExpressionInterface a) throws MetadataException {
        return "The from column of the join condition, \"" + this.cleanupText(this.toText(a), false) + "\", is not in either the from \"" + fromDataSource.getIntraModelID() + "\" or to \"" + toDataSource.getIntraModelID() + "\" tables.";
    }

    private String getMsgToColumnNotInTables(DataSourceTable fromDataSource, DataSourceTable toDataSource, ExpressionInterface b) throws MetadataException {
        return "The to column of the join condition, \"" + this.cleanupText(this.toText(b), false) + "\", is not in either the from \"" + fromDataSource.getIntraModelID() + "\" or to \"" + toDataSource.getIntraModelID() + "\" tables.";
    }
}

