/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ExportDiscoveryType;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportHierarchy;
import com.sas.iquery.metadata.business.ExportOlapMetadata;
import com.sas.iquery.metadata.business.impl.ExportHierarchyImpl;
import com.sas.iquery.metadata.business.impl.ExportObjectFactoryAbstract;
import com.sas.iquery.metadata.physical.Hierarchy;
import java.util.List;

public class ExportHierarchyFactory
extends ExportObjectFactoryAbstract<Hierarchy, ExportHierarchy> {
    private static final ExportHierarchyFactory SINGLETON_FACTORY = new ExportHierarchyFactory();

    private ExportHierarchyFactory() {
    }

    public static ExportHierarchyFactory getSingleton() {
        return SINGLETON_FACTORY;
    }

    private ExportHierarchy createExportObject(Hierarchy objectToExport, String uniqueExportName, ExportGeneralMetadata exportMetadata) throws MetadataException {
        return new ExportHierarchyImpl(objectToExport, uniqueExportName, this, exportMetadata);
    }

    @Override
    public String makeUniqueExportName(Hierarchy objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String objectToExportUniqueID = objectToExport.getHierarchyUniqueName();
        return ExportHierarchyFactory.qualifyName(new StringBuffer(objectToExportUniqueID), qualifiers).toString();
    }

    @Override
    public ExportHierarchy createObject(String useUniqueExportName, Hierarchy objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String uniqueExportName = useUniqueExportName != null && useUniqueExportName.length() > 0 ? useUniqueExportName : this.makeUniqueExportName(objectToExport, exportMetadata, qualifiers);
        ExportHierarchy exportHierarchy = this.createExportObject(objectToExport, uniqueExportName, exportMetadata);
        return exportHierarchy;
    }

    @Override
    public List<ExportHierarchy> find(List<String> list, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        if (!(exportMetadata instanceof ExportOlapMetadata)) {
            throw new MetadataException(this.getInvalidExportMetadataMessage());
        }
        List<Hierarchy> objectsToExport = ((ExportOlapMetadata)exportMetadata).getAvailableHierarchies(list, qualifiers);
        return this.newInstances(exportMetadata, objectsToExport, qualifiers);
    }

    @Override
    public List<Hierarchy> discoverUnderlyingObjects(ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        if (!(exportMetadata instanceof ExportOlapMetadata)) {
            throw new MetadataException(this.getInvalidExportMetadataMessage());
        }
        if (discoveryType != DiscoverHierarchies.AvailableHierarchies) {
            throw new MetadataException(this.getInvalidDiscoveryTypeMessage(discoveryType));
        }
        List<Hierarchy> objectsToExport = ((ExportOlapMetadata)exportMetadata).getAvailableHierarchies(null, qualifiers);
        return objectsToExport;
    }

    public static enum DiscoverHierarchies implements ExportDiscoveryType
    {
        AvailableHierarchies;

    }
}

