/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ExportDiscoveryType;
import com.sas.iquery.metadata.business.ExportFilter;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.impl.ExportFilterImpl;
import com.sas.iquery.metadata.business.impl.ExportObjectFactoryAbstract;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public final class ExportFilterFactory
extends ExportObjectFactoryAbstract<FilterItem, ExportFilter> {
    private static final ExportFilterFactory SINGLETON_FACTORY = new ExportFilterFactory();

    private ExportFilterFactory() {
    }

    public static ExportFilterFactory getSingleton() {
        return SINGLETON_FACTORY;
    }

    private ExportFilter createExportObject(FilterItem objectToExport, String uniqueExportName, ExportGeneralMetadata exportMetadata, Object ... options) throws MetadataException {
        return new ExportFilterImpl(objectToExport, uniqueExportName, this, exportMetadata);
    }

    @Override
    public String makeUniqueExportName(@Nonnull FilterItem objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String objectToExportUniqueID = objectToExport.getID();
        return ExportFilterFactory.qualifyName(new StringBuffer(objectToExportUniqueID), qualifiers).toString();
    }

    @Override
    public ExportFilter createObject(String useUniqueExportName, FilterItem objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String uniqueExportName = useUniqueExportName != null && useUniqueExportName.length() > 0 ? useUniqueExportName : this.makeUniqueExportName(objectToExport, exportMetadata, qualifiers);
        ExportFilter exportFilter = this.createExportObject(objectToExport, uniqueExportName, exportMetadata, new Object[0]);
        return exportFilter;
    }

    @Override
    public List<ExportFilter> find(List<String> list, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        List objectsToExport = this.find((List)list, FilterItem.class, exportMetadata, qualifiers);
        return this.newInstances(exportMetadata, objectsToExport, qualifiers);
    }

    @Override
    public List<FilterItem> discoverUnderlyingObjects(ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        List<FilterItem> objectsToExport;
        DataSelection dataSelection = exportMetadata.getDataSelection();
        if (discoveryType == DiscoverFilterItems.AllFilterItemsUsed) {
            objectsToExport = dataSelection.getEffectiveFilters();
        } else if (discoveryType == DiscoverFilterItems.SelectedFilterItems) {
            objectsToExport = dataSelection.getFilters();
        } else if (discoveryType == DiscoverFilterItems.AvailableFilterItemsIncludeHidden || discoveryType == DiscoverFilterItems.AvailableFilterItemsIncludeHiddenFromAllModels) {
            boolean allModels = discoveryType == DiscoverFilterItems.AvailableFilterItemsIncludeHiddenFromAllModels;
            objectsToExport = dataSelection.getObjects(allModels, FilterItem.class);
        } else if (discoveryType == DiscoverFilterItems.AvailableFilterItems || discoveryType == DiscoverFilterItems.AvailableFilterItemsFromAllModels) {
            boolean allModels = discoveryType == DiscoverFilterItems.AvailableFilterItemsFromAllModels;
            objectsToExport = new ArrayList<FilterItem>(dataSelection.getObjects(allModels, FilterItem.class));
            Iterator<FilterItem> iter = objectsToExport.iterator();
            while (iter.hasNext()) {
                FilterItem item = iter.next();
                if (!item.isHidden()) continue;
                iter.remove();
            }
        } else {
            throw new MetadataException(this.getInvalidDiscoveryTypeMessage(discoveryType));
        }
        return objectsToExport;
    }

    public static enum DiscoverFilterItems implements ExportDiscoveryType
    {
        AllFilterItemsUsed,
        SelectedFilterItems,
        AvailableFilterItems,
        AvailableFilterItemsIncludeHidden,
        AvailableFilterItemsFromAllModels,
        AvailableFilterItemsIncludeHiddenFromAllModels;

    }
}

