/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ExportDimension;
import com.sas.iquery.metadata.business.ExportDiscoveryType;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportOlapMetadata;
import com.sas.iquery.metadata.business.impl.ExportDimensionImpl;
import com.sas.iquery.metadata.business.impl.ExportObjectFactoryAbstract;
import com.sas.iquery.metadata.physical.Dimension;
import java.util.List;
import javax.annotation.Nonnull;

public final class ExportDimensionFactory
extends ExportObjectFactoryAbstract<Dimension, ExportDimension> {
    private static final ExportDimensionFactory SINGLETON_FACTORY = new ExportDimensionFactory();

    private ExportDimensionFactory() {
    }

    public static ExportDimensionFactory getSingleton() {
        return SINGLETON_FACTORY;
    }

    private ExportDimension createExportObject(Dimension objectToExport, String uniqueExportName, ExportGeneralMetadata exportMetadata, Object ... options) throws MetadataException {
        return new ExportDimensionImpl(objectToExport, uniqueExportName, this, exportMetadata);
    }

    @Override
    public String makeUniqueExportName(@Nonnull Dimension objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String objectToExportUniqueID = objectToExport.getDimensionUniqueName();
        return ExportDimensionFactory.qualifyName(new StringBuffer(objectToExportUniqueID), qualifiers).toString();
    }

    @Override
    public ExportDimension createObject(String useUniqueExportName, Dimension objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String uniqueExportName = useUniqueExportName != null && useUniqueExportName.length() > 0 ? useUniqueExportName : this.makeUniqueExportName(objectToExport, exportMetadata, qualifiers);
        ExportDimension exportDimension = this.createExportObject(objectToExport, uniqueExportName, exportMetadata, qualifiers);
        return exportDimension;
    }

    @Override
    public List<ExportDimension> find(List<String> list, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        if (!(exportMetadata instanceof ExportOlapMetadata)) {
            throw new MetadataException(this.getInvalidExportMetadataMessage());
        }
        List<Dimension> objectsToExport = ((ExportOlapMetadata)exportMetadata).getAvailableDimensions(list, qualifiers);
        return this.newInstances(exportMetadata, objectsToExport, qualifiers);
    }

    @Override
    public List<Dimension> discoverUnderlyingObjects(ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        if (!(exportMetadata instanceof ExportOlapMetadata)) {
            throw new MetadataException(this.getInvalidExportMetadataMessage());
        }
        if (discoveryType != DiscoverDimensions.AvailableDimensions) {
            throw new MetadataException(this.getInvalidDiscoveryTypeMessage(discoveryType));
        }
        List<Dimension> objectsToExport = ((ExportOlapMetadata)exportMetadata).getAvailableDimensions(null, qualifiers);
        return objectsToExport;
    }

    public static enum DiscoverDimensions implements ExportDiscoveryType
    {
        AvailableDimensions;

    }
}

