/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.ExportDataSource;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportObjectFactoryInterface;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.impl.ExportObjectAbstract;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import java.util.List;

class ExportDataSourceImpl
extends ExportObjectAbstract<DataSource, ExportDataSource>
implements ExportDataSource {
    public ExportDataSourceImpl(DataSource objectToExport, String uniqueExportName, ExportObjectFactoryInterface<DataSource, ExportDataSource> factory, ExportGeneralMetadata exportMetadata) throws MetadataException {
        super(objectToExport, uniqueExportName, factory, exportMetadata);
    }

    @Override
    public String getID() throws MetadataException {
        return ((DataSource)this.getUnderlyingObject()).getID();
    }

    @Override
    public String getLabel() {
        return ((DataSource)this.getUnderlyingObject()).getLabel();
    }

    @Override
    public String getDescription() {
        return ((DataSource)this.getUnderlyingObject()).getDescription();
    }

    @Override
    public boolean containsColumn(QualifiedColumn toColumn) throws MetadataException {
        boolean isColumnOf = false;
        DataSource underlyingObject = (DataSource)this.getUnderlyingObject();
        if (underlyingObject instanceof Table) {
            Table table = (Table)((Object)underlyingObject);
            List<Column> columns = table.getColumns();
            isColumnOf = columns.contains(toColumn);
        }
        return isColumnOf;
    }

    @Override
    public String getSASTableNameFullyQualified() throws MetadataException {
        String libref = this.getSASLibref();
        String simpleName = this.getSASTableNameShort();
        String fullTableName = libref == null || libref.trim().isEmpty() ? GenerationUtil.generateEscapedIdentifier(simpleName) : GenerationUtil.generateFullyQualifiedIdentifier(libref, simpleName);
        return fullTableName;
    }

    @Override
    public String getSASLibnameStatement(boolean ignorePreAssigned) throws MetadataException {
        String libdef = "";
        SASLibrary sasLibrary = this.getSASLibrary();
        if (sasLibrary != null) {
            libdef = sasLibrary.getLibnameStatement(ignorePreAssigned);
        }
        return libdef;
    }

    @Override
    public boolean isLibraryPreassigned() throws MetadataException {
        boolean isPreAssigned = false;
        SASLibrary sasLibrary = this.getSASLibrary();
        if (sasLibrary != null) {
            isPreAssigned = sasLibrary.isPreassigned();
        }
        return isPreAssigned;
    }

    @Override
    public String getSASLibref() throws MetadataException {
        String libref = null;
        SASLibrary sasLibrary = this.getSASLibrary();
        if (sasLibrary != null) {
            libref = sasLibrary.getLibref();
        }
        return libref;
    }

    @Override
    public String getSASTableNameShort() throws MetadataException {
        String simpleName = null;
        DataSource underlyingObject = (DataSource)this.getUnderlyingObject();
        if (underlyingObject instanceof Table) {
            Table table = (Table)((Object)underlyingObject);
            simpleName = table.getSasName();
        } else if (underlyingObject instanceof Cube) {
            Cube cube = (Cube)((Object)underlyingObject);
            simpleName = cube.getCubeName();
        }
        return simpleName;
    }

    private SASLibrary getSASLibrary() {
        Schema schema;
        SASLibrary sasLibrary = null;
        AccessPath accessPath = ((DataSource)this.getUnderlyingObject()).getAbstractAccessPath();
        if (accessPath != null && (schema = accessPath.getSchema()) instanceof SASLibrary) {
            sasLibrary = (SASLibrary)schema;
        }
        return sasLibrary;
    }
}

