/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.ExportDataSource;
import com.sas.iquery.metadata.business.ExportDiscoveryType;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.impl.ExportDataSourceImpl;
import com.sas.iquery.metadata.business.impl.ExportObjectFactoryAbstract;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public final class ExportDataSourceFactory
extends ExportObjectFactoryAbstract<DataSource, ExportDataSource> {
    private static final ExportDataSourceFactory SINGLETON_FACTORY = new ExportDataSourceFactory();

    private ExportDataSourceFactory() {
    }

    public static ExportDataSourceFactory getSingleton() {
        return SINGLETON_FACTORY;
    }

    private ExportDataSource createExportObject(DataSource objectToExport, String uniqueExportName, ExportGeneralMetadata exportMetadata, Object ... options) throws MetadataException {
        return new ExportDataSourceImpl(objectToExport, uniqueExportName, this, exportMetadata);
    }

    @Override
    public String makeUniqueExportName(@Nonnull DataSource objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String objectToExportUniqueID = objectToExport.getID();
        return ExportDataSourceFactory.qualifyName(new StringBuffer(objectToExportUniqueID), qualifiers).toString();
    }

    @Override
    public ExportDataSource createObject(String useUniqueExportName, DataSource objectToExport, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        String uniqueExportName = useUniqueExportName != null && useUniqueExportName.length() > 0 ? useUniqueExportName : this.makeUniqueExportName(objectToExport, exportMetadata, qualifiers);
        ExportDataSource exportDataSource = this.createExportObject(objectToExport, uniqueExportName, exportMetadata, new Object[0]);
        return exportDataSource;
    }

    @Override
    public List<ExportDataSource> find(List<String> list, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        List objectsToExport = this.find((List)list, DataSource.class, exportMetadata, qualifiers);
        return this.newInstances(exportMetadata, objectsToExport, qualifiers);
    }

    @Override
    public List<DataSource> discoverUnderlyingObjects(ExportDiscoveryType discoveryType, ExportGeneralMetadata exportMetadata, Object ... qualifiers) throws MetadataException {
        List<DataSource> objectsToExport;
        DataSelection dataSelection = exportMetadata.getDataSelection();
        if (discoveryType == DiscoverDataSources.AllDataSourcesUsed) {
            objectsToExport = dataSelection.getEffectiveDataSources();
        } else if (discoveryType == DiscoverDataSources.AvailableDataSourcesIncludeHidden || discoveryType == DiscoverDataSources.AvailableDataSourcesIncludeHiddenFromAllModels) {
            boolean allModels = discoveryType == DiscoverDataSources.AvailableDataSourcesIncludeHiddenFromAllModels;
            objectsToExport = dataSelection.getObjects(allModels, DataSource.class);
        } else if (discoveryType == DiscoverDataSources.AvailableDataSources || discoveryType == DiscoverDataSources.AvailableDataSourcesFromAllModels) {
            boolean allModels = discoveryType == DiscoverDataSources.AvailableDataSourcesFromAllModels;
            objectsToExport = new ArrayList<DataSource>(dataSelection.getObjects(allModels, DataSource.class));
            Iterator<DataSource> iter = objectsToExport.iterator();
            while (iter.hasNext()) {
                DataSource item = iter.next();
                if (!item.isHidden()) continue;
                iter.remove();
            }
        } else {
            throw new MetadataException(this.getInvalidDiscoveryTypeMessage(discoveryType));
        }
        return objectsToExport;
    }

    public static enum DiscoverDataSources implements ExportDiscoveryType
    {
        AllDataSourcesUsed,
        AvailableDataSources,
        AvailableDataSourcesIncludeHidden,
        AvailableDataSourcesFromAllModels,
        AvailableDataSourcesIncludeHiddenFromAllModels;

    }
}

