/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.GUID;
import com.sas.iom.SAS.IOptionService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMCommon.IServerLocale;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.ExportCubeMlsLanguage;
import com.sas.iquery.metadata.business.ExportHierarchyColumnDef;
import com.sas.iquery.metadata.business.impl.ExportCubeDataDsBuilder;
import com.sas.iquery.metadata.business.impl.ExportCubeMlsLanguageFactory;
import com.sas.iquery.metadata.business.impl.ExportHierarchyColumnDefImpl;
import com.sas.iquery.metadata.business.impl.ExportOutputColumnDef;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.oma.OMAOlapSchema;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.Aggregation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CalculatedMeasure;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Transformation;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.olap.OLAPException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.omg.CORBA.Object;

public class ExportCubeProcessor {
    private static final String DIMENSION_TYPE_OF_MEASURES = "MEASURES";
    private static final String MEASURE_STATISTIC_NUNIQUE = "NUNIQUE";
    private static final String MEASURE_TARGET_TRANSFORM_ROLE_OLAPNUNIQUE = "OLAPNUnique";
    private static final String MEASURE_TARGET_FEATURE_MAP_ROLE_TRNSFORM = "TRNSFORM";
    private static final String LEVEL_FEATURE_MAP_ROLE_ONETOONE = "ONETOONE";
    private static final String LEVEL_FEATURE_MAP_CLASSIFIER_ROLE_STARDIM = "STARDIM";
    private static final String TRANSFORMATION_ROLE_VALUE_FOR_STARFACT = "STARFACT";
    private static final String TRANSFORMATION_ROLE_VALUE_FOR_NWAY = "NWAY";
    private static final String CUBE_PROPERTY_VALUE_FOR_DISABLING_NO_NWAY = "NO";
    private static final String AGGREGATION_PROPERTY_NAME_FOR_NRACKS = "NRACKS";
    private static final String CUBE_PROPERTY_NAME_FOR_NO_NWAY = "NO_NWAY";
    private static final String PARTNERNAME_FACT_KEY_DIMENSION = "FactKeyDimension";
    private static final String PARTNERNAME_DIM_KEY_DIMENSION = "DimKeyDimension";
    private static final String PUBLICTYPE_SHARED_DIMENSION = "SharedDimension";
    private static final String CUBE_PROPERTYSETROLE_OLAP_UDT = "OLAP UDT";
    private static final String LANGUAGES_PROPERTYSET_PROPERTYNAME_UDT = "UDT";
    private static final String LANGUAGES_PROPERTYSET_PROPERTYROLE_OLAP_UDT = "OLAP UDT";
    private static final String PROPERTY_NAME_DIMENSIONTABLE_OPTIONS = "DimensionTable_options";
    private static final String PROPERTY_NAME_AGGREGATIONTABLE_OPTIONS = "AggregationTable_options";
    private static final String PROPERTY_NAME_REACHTHRUTABLE_OPTIONS = "ReachthruTable_options";
    private static final String PROPERTY_NAME_LOADTABLE_OPTIONS = "LoadTable_options";
    private boolean _closed = false;
    private final Server _iqServer;
    private final Schema _iqSchema;
    private final Cube _iqCube;
    private final com.sas.metadata.remote.Cube _omrCube;
    private transient OLAPDataType _olapDataType = null;
    private transient String _transformRole = null;
    private transient Boolean _isNoNWay = null;
    private transient Integer _nRacks = null;
    private transient String _nRacksUpdated = null;
    private transient String _nRacksCreated = null;
    private transient List<Measure> _measures = null;
    private transient List<Dimension> _dimensions = null;
    private transient Boolean _useReachThruTable = null;
    private transient List<DataTable> _reachThruTables = null;
    private transient List<DataTable> _loadMapDetailsTables = null;
    private transient List<Aggregation> _aggregations = null;
    private transient List<Property> _nRacksProperties = null;
    private transient List<PropertySet> _cubePropertySets = null;
    private transient List<ExportCubeMlsLanguage> _cubeLanguages = null;
    private transient Map<String, java.lang.Object> _columnSourceDictionary = null;
    private transient Map<java.lang.Object, List<ExportOutputColumnDef>> _outputColumnReferences = null;
    private transient Map<Dimension, ExportOutputColumnDef> _factKeyColumnReferences = null;
    private transient Map<Dimension, ExportOutputColumnDef> _dimKeyColumnReferences = null;
    private transient boolean _didGetNoNWayProperty = false;
    private transient Property _noNWayProperty = null;
    private transient boolean _didGetNRacksProperty = false;
    private transient Property _nRacksProperty = null;
    private transient boolean _didGetCubeLoadMap = false;
    private transient ClassifierMap _cubeLoadMap = null;
    private transient Map<Dimension, List<CustomAssociation>> _dimCustomAssocs = new LinkedHashMap<Dimension, List<CustomAssociation>>();
    private transient Map<Dimension, List<Hierarchy>> _dimHierarchies = new LinkedHashMap<Dimension, List<Hierarchy>>();
    private transient Map<Hierarchy, List<Level>> _hierLevels = new LinkedHashMap<Hierarchy, List<Level>>();
    private transient Map<DataTable, List<Column>> _tableColumns = new LinkedHashMap<DataTable, List<Column>>();
    private transient Map<Hierarchy, List<ExportHierarchyColumnDef>> _hierColumnDefs = new LinkedHashMap<Hierarchy, List<ExportHierarchyColumnDef>>();
    private transient Map<Root, List<Property>> _objectProperties = new LinkedHashMap<Root, List<Property>>();
    private transient Map<ExportCubeMlsLanguage, Map<Dimension, List<Column>>> _dimKeyColumnsByLanguage = new LinkedHashMap<ExportCubeMlsLanguage, Map<Dimension, List<Column>>>();
    private transient Map<ExportCubeMlsLanguage, Map<Dimension, List<Column>>> _factKeyColumnsByLanguage = new LinkedHashMap<ExportCubeMlsLanguage, Map<Dimension, List<Column>>>();
    private transient Map<ExportCubeMlsLanguage, DataTable> _reachThruTablesByLanguage = new LinkedHashMap<ExportCubeMlsLanguage, DataTable>();
    private transient Map<ExportCubeMlsLanguage, DataTable> _detailTablesByLanguage = new LinkedHashMap<ExportCubeMlsLanguage, DataTable>();
    private transient Map<ExportCubeMlsLanguage, DataTable> _loadMapDetailTablesByLanguage = new LinkedHashMap<ExportCubeMlsLanguage, DataTable>();

    public ExportCubeProcessor(@Nonnull Server iqServer, @Nonnull Schema iqSchema, @Nonnull Cube iqCube) {
        this._iqServer = iqServer;
        this._iqSchema = iqSchema;
        this._iqCube = iqCube;
        this._omrCube = (com.sas.metadata.remote.Cube)((OMAWrapper)((java.lang.Object)this._iqCube)).getOMAObject();
    }

    public ExportCubeProcessor(@Nonnull AccessPath accessPath, @Nonnull Cube iqCube) {
        this._iqServer = accessPath.getServer();
        this._iqSchema = accessPath.getSchema();
        this._iqCube = iqCube;
        this._omrCube = (com.sas.metadata.remote.Cube)((OMAWrapper)((java.lang.Object)this._iqCube)).getOMAObject();
    }

    public ExportCubeProcessor(@Nonnull DataSourceCube dataSourceCube) {
        this._iqServer = dataSourceCube.getAccessPath().getServer();
        this._iqSchema = dataSourceCube.getAccessPath().getSchema();
        this._iqCube = dataSourceCube.getCube();
        this._omrCube = (com.sas.metadata.remote.Cube)((OMAWrapper)((java.lang.Object)this._iqCube)).getOMAObject();
    }

    public void clear() {
        this._useReachThruTable = null;
        this._olapDataType = null;
        this._transformRole = null;
        this._isNoNWay = null;
        this._nRacks = null;
        this._nRacksUpdated = null;
        this._nRacksCreated = null;
        this._measures = null;
        this._dimensions = null;
        this._reachThruTables = null;
        this._loadMapDetailsTables = null;
        this._aggregations = null;
        this._nRacksProperties = null;
        this._cubePropertySets = null;
        this._cubeLanguages = null;
        if (this._columnSourceDictionary != null) {
            this._columnSourceDictionary.clear();
            this._columnSourceDictionary = null;
        }
        if (this._outputColumnReferences != null) {
            this._outputColumnReferences.clear();
            this._outputColumnReferences = null;
        }
        if (this._factKeyColumnReferences != null) {
            this._factKeyColumnReferences.clear();
            this._factKeyColumnReferences = null;
        }
        if (this._dimKeyColumnReferences != null) {
            this._dimKeyColumnReferences.clear();
            this._dimKeyColumnReferences = null;
        }
        this._didGetNoNWayProperty = false;
        this._noNWayProperty = null;
        this._didGetNRacksProperty = false;
        this._nRacksProperty = null;
        this._didGetCubeLoadMap = false;
        this._cubeLoadMap = null;
        this._dimCustomAssocs.clear();
        this._objectProperties.clear();
        this._hierLevels.clear();
        this._tableColumns.clear();
        this._dimHierarchies.clear();
        this._hierColumnDefs.clear();
        this._dimKeyColumnsByLanguage.clear();
        this._factKeyColumnsByLanguage.clear();
        this._reachThruTablesByLanguage.clear();
        this._loadMapDetailTablesByLanguage.clear();
    }

    public void close() {
        if (!this._closed) {
            this.clear();
            this._closed = true;
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    private final void checkClosed() throws MetadataException {
        if (this._closed) {
            throw new MetadataException(this.getMsgCubeProcessorIsClosed());
        }
    }

    public com.sas.metadata.remote.Cube getOmrCube() {
        return this._omrCube;
    }

    public Server getIqServer() {
        return this._iqServer;
    }

    public Schema getIqSchema() {
        return this._iqSchema;
    }

    public Cube getIqCube() {
        return this._iqCube;
    }

    public List<Column> getLevelSourceColumns(Level level) throws RemoteException, MdException {
        List<FeatureMap> levelFeatureMaps = AssociationListUtil.filteredSnapshot(level.getTargetFeatureMaps(true), FeatureMap.class);
        List<Column> levelSourceColumns = levelFeatureMaps.size() > 0 ? this.getLevelSourceColumns(levelFeatureMaps) : this.getLevelSourceColumnsStarDim(level);
        return levelSourceColumns;
    }

    private List<Column> getLevelSourceColumnsStarDim(Level level) throws RemoteException, MdException {
        FeatureMap featureMap;
        String transformRole;
        List<Column> levelSourceColumns = null;
        List<FeatureMap> levelFeatureMaps = AssociationListUtil.filteredSnapshot(level.getTargetTransformations(true), FeatureMap.class);
        Collections.reverse(levelFeatureMaps);
        Iterator<FeatureMap> iterator = levelFeatureMaps.iterator();
        while (iterator.hasNext() && (!(transformRole = (featureMap = iterator.next()).getTransformRole().trim()).equalsIgnoreCase(LEVEL_FEATURE_MAP_ROLE_ONETOONE) || (levelSourceColumns = this.findColumnsInFeatureMapStarDim(featureMap)) == null)) {
        }
        if (levelSourceColumns == null) {
            iterator = levelFeatureMaps.iterator();
            while (iterator.hasNext() && (!(transformRole = (featureMap = iterator.next()).getTransformRole().trim()).isEmpty() || (levelSourceColumns = this.findColumnsInFeatureMapStarDim(featureMap)) == null)) {
            }
        }
        if (levelSourceColumns == null && levelFeatureMaps.size() > 0) {
            levelSourceColumns = this.findColumnsInFeatureMapStarDim(levelFeatureMaps.get(0));
        }
        if (levelSourceColumns == null) {
            levelSourceColumns = Collections.emptyList();
        }
        return levelSourceColumns;
    }

    private List<Column> findColumnsInFeatureMapStarDim(FeatureMap featureMap) throws RemoteException, MdException {
        List<Column> levelSourceColumns = null;
        List<ClassifierMap> classifierMaps = AssociationListUtil.filteredSnapshot(featureMap.getAssociatedClassifierMaps(true), ClassifierMap.class);
        for (ClassifierMap classifierMap : classifierMaps) {
            List<Column> maybe;
            String classifierMapRole = classifierMap.getTransformRole().trim();
            if (!classifierMapRole.equalsIgnoreCase(LEVEL_FEATURE_MAP_CLASSIFIER_ROLE_STARDIM) || (maybe = AssociationListUtil.filteredSnapshot(featureMap.getTransformationSources(true), Column.class)).size() <= 0) continue;
            levelSourceColumns = maybe;
            break;
        }
        return levelSourceColumns;
    }

    private List<Column> getLevelSourceColumns(List<FeatureMap> levelFeatureMaps) throws RemoteException, MdException {
        List<Column> maybe;
        String transformRole;
        List<Column> levelSourceColumns = null;
        for (FeatureMap featureMap : levelFeatureMaps) {
            transformRole = featureMap.getTransformRole().trim();
            if (!transformRole.equalsIgnoreCase(LEVEL_FEATURE_MAP_ROLE_ONETOONE) || (maybe = AssociationListUtil.filteredSnapshot(featureMap.getFeatureSources(true), Column.class)).size() <= 0) continue;
            levelSourceColumns = maybe;
            break;
        }
        if (levelSourceColumns == null) {
            for (FeatureMap featureMap : levelFeatureMaps) {
                transformRole = featureMap.getTransformRole().trim();
                if (!transformRole.isEmpty() || (maybe = AssociationListUtil.filteredSnapshot(featureMap.getFeatureSources(true), Column.class)).size() <= 0) continue;
                levelSourceColumns = maybe;
                break;
            }
        }
        return levelSourceColumns;
    }

    public List<ExportCubeMlsLanguage> getCubeLanguages() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._cubeLanguages == null) {
            ArrayList<ExportCubeMlsLanguage> languages = new ArrayList<ExportCubeMlsLanguage>();
            boolean first = true;
            List<PropertySet> cubePropertySets = this.getCubePropertySets();
            for (PropertySet propertySet : cubePropertySets) {
                if (!propertySet.getSetRole().equalsIgnoreCase("OLAP UDT")) continue;
                List<Property> udts = this.getSetProperties(propertySet);
                for (Property udt : udts) {
                    if (!udt.getPropertyName().equalsIgnoreCase(LANGUAGES_PROPERTYSET_PROPERTYNAME_UDT) || !udt.getPropertyRole().equalsIgnoreCase("OLAP UDT")) continue;
                    String defaultValue = udt.getDefaultValue();
                    Locale javaLocale = IOMServerUtils.ConvertSASLocaleToJavaLocale(defaultValue);
                    String fileSuffix = first ? "" : defaultValue;
                    ExportCubeMlsLanguage language = ExportCubeMlsLanguageFactory.newCubeMlsLanguage(defaultValue, javaLocale, fileSuffix, first);
                    languages.add(language);
                    first = false;
                }
            }
            this._cubeLanguages = languages;
        }
        return this._cubeLanguages;
    }

    public List<PropertySet> getCubePropertySets() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._cubePropertySets == null) {
            com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
            this._cubePropertySets = AssociationListUtil.filteredSnapshot(omrCube.getPropertySets(true), PropertySet.class);
        }
        return this._cubePropertySets;
    }

    public List<Property> getSetProperties(PropertySet propertySet) throws RemoteException, MdException {
        return AssociationListUtil.filteredSnapshot(propertySet.getSetProperties(true), Property.class);
    }

    public Property getNoNWayProperty() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (!this._didGetNoNWayProperty) {
            com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
            List<Property> cubeProperties = this.getProperties((Root)omrCube);
            for (Property property : cubeProperties) {
                if (!property.getPropertyName().equalsIgnoreCase(CUBE_PROPERTY_NAME_FOR_NO_NWAY)) continue;
                this._noNWayProperty = property;
                break;
            }
            this._didGetNoNWayProperty = true;
        }
        return this._noNWayProperty;
    }

    public Property getNRacksProperty() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (!this._didGetNRacksProperty) {
            List<Property> nRacksProperties = this.getNRacksProperties();
            this._nRacksProperty = nRacksProperties.size() > 0 ? nRacksProperties.get(0) : null;
            this._didGetNRacksProperty = true;
        }
        return this._nRacksProperty;
    }

    @Nonnull
    public List<Property> getNRacksProperties() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._nRacksProperties == null) {
            ArrayList<Property> nRacksProperties = new ArrayList<Property>();
            List<Aggregation> aggregations = this.getAggregations();
            for (Aggregation aggr : aggregations) {
                List<Property> aggrProperties = this.getProperties((Root)aggr);
                for (Property aggrProperty : aggrProperties) {
                    if (!aggrProperty.getPropertyName().equalsIgnoreCase(AGGREGATION_PROPERTY_NAME_FOR_NRACKS)) continue;
                    nRacksProperties.add(aggrProperty);
                }
            }
            this._nRacksProperties = nRacksProperties;
        }
        return this._nRacksProperties;
    }

    @Nonnull
    public List<Property> getProperties(Root object) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        List<Property> aggrProperties = this._objectProperties.get(object);
        if (aggrProperties == null) {
            aggrProperties = AssociationListUtil.filteredSnapshot(object.getProperties(true), Property.class);
            this._objectProperties.put(object, aggrProperties);
        }
        return aggrProperties;
    }

    @Nonnull
    public List<Aggregation> getAggregations() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._aggregations == null) {
            com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
            this._aggregations = AssociationListUtil.filteredSnapshot(omrCube.getAggregations(true), Aggregation.class);
        }
        return this._aggregations;
    }

    public boolean getIsNoNWay() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._isNoNWay == null) {
            this._isNoNWay = Boolean.FALSE;
            Property noNWayProperty = this.getNoNWayProperty();
            if (noNWayProperty != null) {
                String defaultValue = noNWayProperty.getDefaultValue();
                this._isNoNWay = !defaultValue.equalsIgnoreCase(CUBE_PROPERTY_VALUE_FOR_DISABLING_NO_NWAY);
            }
        }
        return this._isNoNWay;
    }

    public int getNRacks() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._nRacks == null) {
            String aggDefaultValue;
            this._nRacks = 0;
            Property nRacksProperty = this.getNRacksProperty();
            if (nRacksProperty != null && (aggDefaultValue = nRacksProperty.getDefaultValue()) != null && aggDefaultValue.trim().length() > 0) {
                this._nRacks = Integer.valueOf(aggDefaultValue.trim());
            }
        }
        return this._nRacks;
    }

    public String getNRacksUpdated() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._nRacksUpdated == null) {
            String value;
            this._nRacksUpdated = "";
            Property nRacksProperty = this.getNRacksProperty();
            if (nRacksProperty != null && (value = nRacksProperty.getMetadataUpdated()) != null && value.trim().length() > 0) {
                this._nRacksUpdated = value.trim();
            }
        }
        return this._nRacksUpdated;
    }

    public String getNRacksCreated() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._nRacksCreated == null) {
            String value;
            this._nRacksCreated = "";
            Property nRacksProperty = this.getNRacksProperty();
            if (nRacksProperty != null && (value = nRacksProperty.getMetadataCreated()) != null && value.trim().length() > 0) {
                this._nRacksCreated = value.trim();
            }
        }
        return this._nRacksCreated;
    }

    public List<DataTable> getReachThruTables() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._reachThruTables == null) {
            com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
            this._reachThruTables = AssociationListUtil.filteredSnapshot(omrCube.getReachThruTables(true), DataTable.class);
        }
        return this._reachThruTables;
    }

    public DataTable getReachThruTable() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        java.lang.Object reachThruTable = null;
        if (this._reachThruTablesByLanguage.containsKey(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY)) {
            reachThruTable = this._reachThruTablesByLanguage.get(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY);
        } else {
            List<DataTable> tables = this.getReachThruTables();
            reachThruTable = tables.size() > 0 ? tables.get(0) : null;
            this._reachThruTablesByLanguage.put(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY, (DataTable)reachThruTable);
        }
        return reachThruTable;
    }

    public DataTable getDetailTable() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        DataTable detailTable = null;
        if (this._detailTablesByLanguage.containsKey(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY)) {
            detailTable = this._detailTablesByLanguage.get(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY);
        } else {
            detailTable = this.getLoadMapDetailsTable();
            this._detailTablesByLanguage.put(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY, detailTable);
        }
        return detailTable;
    }

    public OLAPDataType getOlapDataType() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._olapDataType == null) {
            String transformRole;
            DataTable reachThruTable = this.getReachThruTable();
            this._olapDataType = reachThruTable != null ? OLAPDataType.DRILL : ((transformRole = this.getTransformRole()).equalsIgnoreCase(TRANSFORMATION_ROLE_VALUE_FOR_NWAY) ? OLAPDataType.NWAY : (transformRole.equalsIgnoreCase(TRANSFORMATION_ROLE_VALUE_FOR_STARFACT) ? OLAPDataType.STAR : OLAPDataType.OTHERS));
        }
        return this._olapDataType;
    }

    public ClassifierMap getCubeLoadMap() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (!this._didGetCubeLoadMap) {
            com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
            List<ClassifierMap> loadMaps = AssociationListUtil.filteredSnapshot(omrCube.getTargetClassifierMaps(true), ClassifierMap.class);
            this._cubeLoadMap = loadMaps != null && loadMaps.size() > 0 ? loadMaps.get(0) : null;
            this._didGetCubeLoadMap = true;
        }
        return this._cubeLoadMap;
    }

    public String getTransformRole() throws RemoteException, MdException, MetadataException {
        ClassifierMap loadMap;
        this.checkClosed();
        if (this._transformRole == null && (loadMap = this.getCubeLoadMap()) != null) {
            this._transformRole = loadMap.getTransformRole();
        }
        return this._transformRole;
    }

    public List<DataTable> getLoadMapDetailsTables() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._loadMapDetailsTables == null) {
            ClassifierMap loadMap = this.getCubeLoadMap();
            this._loadMapDetailsTables = loadMap != null ? AssociationListUtil.filteredSnapshot(loadMap.getClassifierSources(true), DataTable.class) : Collections.emptyList();
        }
        return this._loadMapDetailsTables;
    }

    public DataTable getLoadMapDetailsTable() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        java.lang.Object detailsTable = null;
        if (this._loadMapDetailTablesByLanguage.containsKey(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY)) {
            detailsTable = this._loadMapDetailTablesByLanguage.get(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY);
        } else {
            List<DataTable> tables = this.getLoadMapDetailsTables();
            detailsTable = tables.size() > 0 ? tables.get(0) : null;
            this._loadMapDetailTablesByLanguage.put(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY, (DataTable)detailsTable);
        }
        return detailsTable;
    }

    public Map<java.lang.Object, List<ExportOutputColumnDef>> getOutputColumnReferences(ExportCubeMlsLanguage language) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._outputColumnReferences == null) {
            LinkedHashMap<java.lang.Object, List<ExportOutputColumnDef>> outputColumns = new LinkedHashMap<java.lang.Object, List<ExportOutputColumnDef>>();
            DataTable detailsTable = this.getDetailTable(language);
            List<Measure> measures = this.getMeasures();
            this.getMeasureColumnDefs(outputColumns, detailsTable, measures);
            List<Dimension> dimensions = this.getDimensions();
            for (Dimension dimension : dimensions) {
                String dimensionType = dimension.getDimensionType();
                if (dimensionType.equals(DIMENSION_TYPE_OF_MEASURES)) continue;
                this.getDimensionColumnDefs(outputColumns, dimension);
            }
            this._outputColumnReferences = outputColumns;
        }
        return this._outputColumnReferences;
    }

    public List<Measure> getMeasures() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._measures == null) {
            com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
            this._measures = AssociationListUtil.filteredSnapshot(omrCube.getMeasures(true), Measure.class);
        }
        return this._measures;
    }

    private void getMeasureColumnDefs(Map<java.lang.Object, List<ExportOutputColumnDef>> outputColumns, DataTable detailsTable, List<Measure> measures) throws RemoteException, MdException, MetadataException {
        for (Measure measure : measures) {
            StringBuffer format = new StringBuffer();
            this.getCalculatedMeasureColumns(measure, null, null, null, null, format);
            Column measureSourceColumn = this.getMeasureSourceColumn(measure);
            String sasColumnName = measureSourceColumn == null ? measure.getColumnName() : measureSourceColumn.getSASColumnName();
            String tableName = measureSourceColumn == null ? detailsTable.getTableName() : measureSourceColumn.getTable().getTableName();
            String sasFormat = format.length() > 0 ? format.toString() : measure.getSASFormat();
            ArrayList<ExportOutputColumnDef> resources = new ArrayList<ExportOutputColumnDef>();
            outputColumns.put(measure, resources);
            ExportOutputColumnDef def = new ExportOutputColumnDef(tableName, sasColumnName, sasFormat, measureSourceColumn, "MEASURE");
            resources.add(def);
        }
    }

    public List<Dimension> getDimensions() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._dimensions == null) {
            com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
            this._dimensions = AssociationListUtil.filteredSnapshot(omrCube.getDimensions(true), Dimension.class);
        }
        return this._dimensions;
    }

    private List<Hierarchy> getDimensionColumnDefs(Map<java.lang.Object, List<ExportOutputColumnDef>> outputColumns, Dimension dimension) throws RemoteException, MdException, MetadataException {
        List<Hierarchy> hierarchies = this.getHierarchies(dimension);
        for (Hierarchy hierarchy : hierarchies) {
            List<ExportHierarchyColumnDef> levelMemberColumnDefs = this.getHierarchyColumnDefs(dimension, hierarchy);
            if (levelMemberColumnDefs == null || levelMemberColumnDefs.size() <= 0) continue;
            for (ExportHierarchyColumnDef memberColumnDef : levelMemberColumnDefs) {
                if (outputColumns.containsKey(memberColumnDef)) continue;
                Column col = memberColumnDef.getCol();
                ExportOutputColumnDef def = new ExportOutputColumnDef(col.getTable().getTableName(), col.getSASColumnName(), col.getSASFormat(), col, "LEVEL");
                outputColumns.put(memberColumnDef, Collections.singletonList(def));
            }
        }
        return hierarchies;
    }

    public List<Hierarchy> getHierarchies(Dimension dimension) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        List<Hierarchy> hierarchies = this._dimHierarchies.get(dimension);
        if (hierarchies == null) {
            hierarchies = AssociationListUtil.filteredSnapshot(dimension.getHierarchies(true), Hierarchy.class);
            this._dimHierarchies.put(dimension, hierarchies);
        }
        return hierarchies;
    }

    public List<ExportHierarchyColumnDef> getHierarchyColumnDefs(Dimension dimension, Hierarchy hierarchy) throws RemoteException, MdException, MetadataException {
        com.sas.metadata.remote.Cube cube = this.getOmrCube();
        this.checkClosed();
        List<ExportHierarchyColumnDef> hierColumnDefs = this._hierColumnDefs.get(hierarchy);
        if (hierColumnDefs == null) {
            hierColumnDefs = new ArrayList<ExportHierarchyColumnDef>();
            List<Level> levels = this.getLevels(hierarchy);
            for (int levelOrd = 1; levelOrd <= levels.size(); ++levelOrd) {
                Level level = levels.get(levelOrd - 1);
                List<Column> levelSourceColumns = this.getLevelSourceColumns(level);
                if (levelSourceColumns == null || levelSourceColumns.size() <= 0) continue;
                Column column = levelSourceColumns.get(0);
                ExportHierarchyColumnDefImpl columnLevelDef = new ExportHierarchyColumnDefImpl(cube, dimension, hierarchy, level, column, levelOrd);
                hierColumnDefs.add(columnLevelDef);
            }
            this._hierColumnDefs.put(hierarchy, hierColumnDefs);
        }
        return hierColumnDefs;
    }

    public List<Level> getLevels(Hierarchy hierarchy) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        List<Level> levels = this._hierLevels.get(hierarchy);
        if (levels == null) {
            levels = AssociationListUtil.filteredSnapshot(hierarchy.getLevels(true), Level.class);
            this._hierLevels.put(hierarchy, levels);
        }
        return levels;
    }

    public List<Column> getColumns(DataTable table) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        List<Column> columns = this._tableColumns.get(table);
        if (columns == null) {
            columns = AssociationListUtil.filteredSnapshot(table.getColumns(true), Column.class);
            this._tableColumns.put(table, columns);
        }
        return columns;
    }

    public List<CustomAssociation> getCustomAssociations(Dimension dimension) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        List<CustomAssociation> dimCustomAssociations = this._dimCustomAssocs.get(dimension);
        if (dimCustomAssociations == null) {
            dimCustomAssociations = AssociationListUtil.filteredSnapshot(dimension.getCustomAssociations(true), CustomAssociation.class);
            this._dimCustomAssocs.put(dimension, dimCustomAssociations);
        }
        return dimCustomAssociations;
    }

    public static SASLibrary getLibrary(DataTable dataTable) throws RemoteException, MdException {
        DatabaseSchema dbSchema;
        List<SASLibrary> usedByPackages;
        RelationalSchema tablePackage = dataTable.getTablePackage();
        java.lang.Object library = tablePackage instanceof SASLibrary ? (SASLibrary)tablePackage : (tablePackage instanceof DatabaseSchema ? (!(usedByPackages = AssociationListUtil.filteredSnapshot((dbSchema = (DatabaseSchema)tablePackage).getUsedByPackages(true), SASLibrary.class)).isEmpty() ? usedByPackages.get(0) : null) : null);
        return library;
    }

    public static ServerContext getServerContext(RelationalSchema schema) throws RemoteException, MdException {
        AssociationList associations = schema.getDeployedComponents(true);
        List<ServerContext> serverContexts = AssociationListUtil.filteredSnapshot(associations, ServerContext.class);
        ServerContext serverContext = serverContexts.size() > 0 ? serverContexts.get(0) : null;
        return serverContext;
    }

    public boolean getIsIncrementalUpdated() throws MetadataException, RemoteException, MdException {
        boolean incrementalUpdate = false;
        boolean NO_NWAY = this.getIsNoNWay();
        if (!NO_NWAY) {
            int nRacks = this.getNRacks();
            if (nRacks > 1) {
                incrementalUpdate = true;
            } else if (!this.getNRacksUpdated().equals(this.getNRacksCreated())) {
                incrementalUpdate = true;
            }
        }
        return incrementalUpdate;
    }

    public static void ensureAllLogicalServersLoaded(OlapSchema owningOlapSchema) throws MetadataException {
        try {
            boolean toServerForSCs = true;
            boolean toServerForLSs = true;
            if (owningOlapSchema instanceof OMAOlapSchema) {
                DeployedDataPackage ddPkg = (DeployedDataPackage)((OMAOlapSchema)owningOlapSchema).getOMAObject();
                List<ServerContext> serverContexts = AssociationListUtil.filteredSnapshot(ddPkg.getDeployedComponents(toServerForSCs), ServerContext.class);
                for (ServerContext sc : serverContexts) {
                    AssociationListUtil.filteredSnapshot(sc.getUsingComponents(toServerForLSs), LogicalServer.class);
                }
            }
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        catch (MdException e) {
            throw new MetadataException(e);
        }
    }

    public String getTimeStampCubeCreated() throws RemoteException, MdException, MetadataException {
        com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
        return omrCube.getMetadataCreated();
    }

    public String getTimeStampCubeUpdated() throws RemoteException, MdException, MetadataException {
        com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
        return omrCube.getMetadataUpdated();
    }

    public String getTimeStampDataLoaded() throws RemoteException, MdException, MetadataException {
        return this.getNRacksCreated();
    }

    public String getTimeStampDataUpdated() throws RemoteException, MdException, MetadataException {
        return this.getNRacksUpdated();
    }

    public DataTable getReachThruTable(ExportCubeMlsLanguage language) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        DataTable reachThruTable = null;
        if (language == null || language == ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY) {
            reachThruTable = this.getReachThruTable();
        } else if (this._reachThruTablesByLanguage.containsKey(language)) {
            reachThruTable = this._reachThruTablesByLanguage.get(language);
        } else {
            DataTable defaultReachThru = this.getReachThruTable();
            if (defaultReachThru != null) {
                reachThruTable = this.getMlsTable(defaultReachThru, language);
            }
            this._reachThruTablesByLanguage.put(language, reachThruTable);
        }
        return reachThruTable;
    }

    public DataTable getDetailTable(ExportCubeMlsLanguage language) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        DataTable detailTable = null;
        if (language == null || language == ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY) {
            detailTable = this.getDetailTable();
        } else if (this._detailTablesByLanguage.containsKey(language)) {
            detailTable = this._detailTablesByLanguage.get(language);
        } else {
            DataTable defaultDetailTable = this.getDetailTable();
            detailTable = this.getMlsTable(defaultDetailTable, language);
            this._detailTablesByLanguage.put(language, detailTable);
        }
        return detailTable;
    }

    public DataTable getLoadMapDetailsTable(ExportCubeMlsLanguage language) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        DataTable detailsTable = null;
        if (language == null || language == ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY) {
            detailsTable = this.getLoadMapDetailsTable();
        } else if (this._loadMapDetailTablesByLanguage.containsKey(language)) {
            detailsTable = this._loadMapDetailTablesByLanguage.get(language);
        } else {
            DataTable defaultDetailsTable = this.getLoadMapDetailsTable();
            detailsTable = this.getMlsTable(defaultDetailsTable, language);
            this._loadMapDetailTablesByLanguage.put(language, detailsTable);
        }
        return detailsTable;
    }

    public Map<Dimension, ExportOutputColumnDef> getDimKeyColumnReferences(ExportCubeMlsLanguage language) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._dimKeyColumnReferences == null) {
            LinkedHashMap<Dimension, ExportOutputColumnDef> dimKeyColumns = new LinkedHashMap<Dimension, ExportOutputColumnDef>();
            for (Dimension dimension : this.getDimensions()) {
                List<CustomAssociation> dimCustomAssocs;
                String dimensionType = dimension.getDimensionType();
                if (dimensionType.equals(DIMENSION_TYPE_OF_MEASURES) || (dimCustomAssocs = this.getCustomAssociations(dimension)).isEmpty()) continue;
                this.getDimKeyColumnDefs(dimKeyColumns, dimension, language);
            }
            this._dimKeyColumnReferences = dimKeyColumns;
        }
        return this._dimKeyColumnReferences;
    }

    private void getDimKeyColumnDefs(Map<Dimension, ExportOutputColumnDef> dimKeyColumns, Dimension dimension, ExportCubeMlsLanguage language) throws RemoteException, MdException, MetadataException {
        List<Column> dimKeyColumns2 = this.getDimKeyColumns(dimension, language);
        if (dimKeyColumns2.size() == 0) {
            com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
            throw new MetadataException(this.getMsgCouldNotFindDimTableKey(omrCube, dimension));
        }
        if (dimKeyColumns2.size() != 1) {
            com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
            throw new MetadataException(this.getMsgMoreThanOneColumnForDimTableKey(omrCube, dimension));
        }
        for (Column dimKeyColumn : dimKeyColumns2) {
            if (dimKeyColumn == null) {
                com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
                throw new MetadataException(this.getMsgCouldNotFindDimTableKeyColumn(omrCube, dimension));
            }
            if (dimKeyColumns.containsKey(dimension)) continue;
            ExportOutputColumnDef def = new ExportOutputColumnDef(dimKeyColumn.getTable().getTableName(), dimKeyColumn.getSASColumnName(), dimKeyColumn.getSASFormat(), dimKeyColumn, "DIMKEY");
            dimKeyColumns.put(dimension, def);
        }
    }

    public List<Column> getDimKeyColumns(Dimension dimension, ExportCubeMlsLanguage language) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        List<Column> dimKeyColumns = null;
        if (language == null || language == ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY) {
            dimKeyColumns = this.getDimKeyColumns(dimension);
        } else {
            Map<Dimension, List<Column>> dimKeyColumnsByDimension = this._dimKeyColumnsByLanguage.get(language);
            if (dimKeyColumnsByDimension != null) {
                dimKeyColumns = dimKeyColumnsByDimension.get(dimension);
            }
            if (dimKeyColumns == null) {
                List<Column> defaultDimKeyColumns = this.getDimKeyColumns(dimension);
                dimKeyColumns = this.getMlsColumns(language, defaultDimKeyColumns);
                if (dimKeyColumnsByDimension == null) {
                    dimKeyColumnsByDimension = new LinkedHashMap<Dimension, List<Column>>();
                    this._dimKeyColumnsByLanguage.put(language, dimKeyColumnsByDimension);
                }
                dimKeyColumnsByDimension.put(dimension, dimKeyColumns);
            }
        }
        return dimKeyColumns;
    }

    public List<Column> getDimKeyColumns(Dimension dimension) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        Map<Dimension, List<Column>> defaultDimKeyColumnsByDimension = this._dimKeyColumnsByLanguage.get(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY);
        List<java.lang.Object> dimKeyColumns = null;
        if (defaultDimKeyColumnsByDimension != null) {
            dimKeyColumns = defaultDimKeyColumnsByDimension.get(dimension);
        }
        if (dimKeyColumns == null) {
            List<CustomAssociation> dimCustomAssocs = this.getCustomAssociations(dimension);
            for (CustomAssociation dimCustomAssoc : dimCustomAssocs) {
                String partnerName = dimCustomAssoc.getPartnerName();
                boolean isDimKey = partnerName.equalsIgnoreCase(PARTNERNAME_DIM_KEY_DIMENSION);
                if (!isDimKey) continue;
                dimKeyColumns = AssociationListUtil.filteredSnapshot(dimCustomAssoc.getAssociatedObjects(true), Column.class);
                break;
            }
            if (dimKeyColumns == null) {
                dimKeyColumns = Collections.emptyList();
            }
            if (defaultDimKeyColumnsByDimension == null) {
                defaultDimKeyColumnsByDimension = new LinkedHashMap<Dimension, List<Column>>();
                this._dimKeyColumnsByLanguage.put(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY, defaultDimKeyColumnsByDimension);
            }
            this._dimKeyColumnsByLanguage.put(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY, defaultDimKeyColumnsByDimension);
        }
        return dimKeyColumns;
    }

    public Map<Dimension, ExportOutputColumnDef> getFactKeyColumnReferences(ExportCubeMlsLanguage language) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._factKeyColumnReferences == null) {
            LinkedHashMap<Dimension, ExportOutputColumnDef> factKeyColumns = new LinkedHashMap<Dimension, ExportOutputColumnDef>();
            DataTable detailsTable = this.getDetailTable(language);
            for (Dimension dimension : this.getDimensions()) {
                List<CustomAssociation> dimCustomAssocs;
                String dimensionType = dimension.getDimensionType();
                if (dimensionType.equals(DIMENSION_TYPE_OF_MEASURES) || (dimCustomAssocs = this.getCustomAssociations(dimension)).isEmpty()) continue;
                this.getFactKeyColumnDefs(factKeyColumns, dimension, language, detailsTable);
            }
            this._factKeyColumnReferences = factKeyColumns;
        }
        return this._factKeyColumnReferences;
    }

    private void getFactKeyColumnDefs(Map<Dimension, ExportOutputColumnDef> factKeyColumns, Dimension dimension, ExportCubeMlsLanguage language, DataTable detailsTable) throws RemoteException, MdException, MetadataException {
        List<Column> factKeyColumns1 = this.getFactKeyColumns(dimension, detailsTable, language);
        if (factKeyColumns1.size() == 0) {
            com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
            throw new MetadataException(this.getMsgCouldNotFindFactTableKey(omrCube, dimension));
        }
        if (factKeyColumns1.size() != 1) {
            com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
            throw new MetadataException(this.getMsgMoreThanOneColumnForFactTableKey(omrCube, dimension));
        }
        for (Column factKeyColumn : factKeyColumns1) {
            if (factKeyColumn == null) {
                com.sas.metadata.remote.Cube omrCube = this.getOmrCube();
                throw new MetadataException(this.getMsgCouldNotFindFactTableKeyColumn(omrCube, dimension));
            }
            if (factKeyColumns.containsKey(dimension)) continue;
            ExportOutputColumnDef def = new ExportOutputColumnDef(factKeyColumn.getTable().getTableName(), factKeyColumn.getSASColumnName(), factKeyColumn.getSASFormat(), factKeyColumn, "FACTKEY");
            factKeyColumns.put(dimension, def);
        }
    }

    public List<Column> getFactKeyColumns(Dimension dimension, DataTable detailsTable, ExportCubeMlsLanguage language) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        List<Column> factKeyColumns = null;
        if (language == null || language == ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY) {
            factKeyColumns = this.getFactKeyColumns(dimension, detailsTable);
        } else {
            Map<Dimension, List<Column>> factKeyColumnsByDimension = this._factKeyColumnsByLanguage.get(language);
            if (factKeyColumnsByDimension != null) {
                factKeyColumns = factKeyColumnsByDimension.get(dimension);
            }
            if (factKeyColumns == null) {
                List<Column> defaultFactKeyColumns = this.getFactKeyColumns(dimension, detailsTable);
                factKeyColumns = this.getMlsColumns(language, defaultFactKeyColumns);
                if (factKeyColumnsByDimension == null) {
                    factKeyColumnsByDimension = new LinkedHashMap<Dimension, List<Column>>();
                    this._factKeyColumnsByLanguage.put(language, factKeyColumnsByDimension);
                }
                factKeyColumnsByDimension.put(dimension, factKeyColumns);
            }
        }
        return factKeyColumns;
    }

    public List<Column> getFactKeyColumns(Dimension dimension, DataTable detailsTable) throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        Map<Dimension, List<Column>> defaultFactKeyColumnsByDimension = this._factKeyColumnsByLanguage.get(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY);
        List<java.lang.Object> factKeyColumns = null;
        if (defaultFactKeyColumnsByDimension != null) {
            factKeyColumns = defaultFactKeyColumnsByDimension.get(dimension);
        }
        if (factKeyColumns == null) {
            if (dimension.getPublicType().equalsIgnoreCase(PUBLICTYPE_SHARED_DIMENSION)) {
                AssociationList refObjALs = dimension.getReferencedObjects(true);
                List<CustomAssociation> refObjs = AssociationListUtil.filteredSnapshot(refObjALs, CustomAssociation.class);
                for (CustomAssociation refObj : refObjs) {
                    String partnerName = refObj.getPartnerName();
                    boolean isFactKey = partnerName.equalsIgnoreCase(PARTNERNAME_FACT_KEY_DIMENSION);
                    if (!isFactKey) continue;
                    List<Column> sharedDimKeys = AssociationListUtil.filteredSnapshot(refObj.getAssociatedObjects(true), Column.class);
                    factKeyColumns = sharedDimKeys;
                    break;
                }
            } else {
                List<CustomAssociation> dimCustomAssocs = this.getCustomAssociations(dimension);
                for (CustomAssociation dimCustomAssoc : dimCustomAssocs) {
                    String partnerName = dimCustomAssoc.getPartnerName();
                    boolean isFactKey = partnerName.equalsIgnoreCase(PARTNERNAME_FACT_KEY_DIMENSION);
                    if (!isFactKey) continue;
                    factKeyColumns = AssociationListUtil.filteredSnapshot(dimCustomAssoc.getAssociatedObjects(true), Column.class);
                }
            }
            if (factKeyColumns == null) {
                factKeyColumns = Collections.emptyList();
            }
            if (defaultFactKeyColumnsByDimension == null) {
                defaultFactKeyColumnsByDimension = new LinkedHashMap<Dimension, List<Column>>();
                this._factKeyColumnsByLanguage.put(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY, defaultFactKeyColumnsByDimension);
            }
            this._factKeyColumnsByLanguage.put(ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY, defaultFactKeyColumnsByDimension);
        }
        return factKeyColumns;
    }

    private DataTable getMlsTable(DataTable dataTable, ExportCubeMlsLanguage language) throws RemoteException, MdException {
        DataTable foundTable = dataTable;
        if (language != null && language != ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY) {
            SASLibrary schema = ExportCubeProcessor.getLibrary(dataTable);
            String tableName = dataTable.getTableName();
            String suffix = language.getSASLocale();
            String mlsTableName = tableName + suffix;
            List<DataTable> schemaTables = AssociationListUtil.filteredSnapshot(schema.getTables(true), DataTable.class);
            for (DataTable schemaTable : schemaTables) {
                if (!schemaTable.getTableName().equalsIgnoreCase(mlsTableName)) continue;
                foundTable = schemaTable;
                break;
            }
        }
        return foundTable;
    }

    public List<Column> getMlsColumns(ExportCubeMlsLanguage language, List<Column> defaultColumns) throws MetadataException, RemoteException, MdException {
        ArrayList<Column> foundMlsColumns = new ArrayList<Column>();
        for (Column defaultColumn : defaultColumns) {
            String columnName = defaultColumn.getSASColumnName();
            DataTable defaultTable = defaultColumn.getTable();
            DataTable mlsTable = this.getMlsTable(defaultTable, language);
            List<Column> possibleMlsColumns = AssociationListUtil.filteredSnapshot(mlsTable.getColumns(true), Column.class);
            Column found = null;
            for (Column column : possibleMlsColumns) {
                if (!columnName.equalsIgnoreCase(column.getSASColumnName())) continue;
                found = column;
                break;
            }
            if (found == null) {
                SASLibrary library = ExportCubeProcessor.getLibrary(mlsTable);
                String libref = library.getLibref();
                String tableName = defaultTable.getName();
                throw new MetadataException(this.getMsgCouldNotFindMLSLanguage(language, columnName, libref, tableName));
            }
            foundMlsColumns.add(found);
        }
        return foundMlsColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportCubeMlsLanguage getCubeLanguageFromLocale(SessionContextInterface session, Locale locale) throws MetadataException, IllegalStateException, RemoteException, ServiceException, ConnectionFactoryException, DataServicesException, MdException, GenericError, OLAPException {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale(session);
        }
        ExportCubeMlsLanguage language = null;
        String lockSessionKey = GUID.newGUID() + ".lock";
        Locale connectionLocale = LocaleUtilities.getDefaultViewerLocale(session);
        UserContextInterface userContext = session.getUserContext();
        RetrievalPolicy policy = new RetrievalPolicy();
        policy.getConnectionConfiguration().setConnectionLifetime(1);
        SoftwareServer iqServer = (SoftwareServer)this.getIqServer();
        LogicalServerInterface lsi = iqServer.getLogicalServerInterface();
        java.lang.Object sessionLock = null;
        ConnectionRecycler recycler = ConnectionRecycler.getInstance(session);
        try {
            sessionLock = session.lock(lockSessionKey);
            ConnectionInterface connection = null;
            try {
                connection = recycler.getWorkspaceConnection(lsi, userContext, policy, connectionLocale);
                Object iomConnectionObject = connection.getObject();
                language = this.getCubeLanguageFromLocale(iomConnectionObject, locale);
            }
            finally {
                if (connection != null) {
                    recycler.closeConnection(connection);
                }
            }
        }
        finally {
            if (sessionLock != null) {
                session.unlock(sessionLock);
            }
        }
        return language;
    }

    private ExportCubeMlsLanguage getCubeLanguageFromLocale(Object iomConnectionObject, Locale locale) throws MetadataException, RemoteException, MdException, DataServicesException {
        String sasLocale;
        if (locale == null) {
            IWorkspace iWorkspace = IOMServerUtils.GetIWorkspace(iomConnectionObject);
            IOptionService iOpts = IOMServerUtils.GetIOptionService(iWorkspace);
            sasLocale = IOMServerUtils.GetWorkspaceLocale(iOpts);
        } else {
            IServerLocale iServerLocale = IOMServerUtils.GetIServerLocale(iomConnectionObject);
            sasLocale = IOMServerUtils.GetValidLocaleFromServer(iServerLocale, locale.toString());
        }
        ExportCubeMlsLanguage language1 = null;
        ExportCubeMlsLanguage language2 = null;
        if (sasLocale != null) {
            List<ExportCubeMlsLanguage> languages = this.getCubeLanguages();
            for (ExportCubeMlsLanguage cubeMlsLanguage : languages) {
                String cubeSasLocale = cubeMlsLanguage.getSASLocale();
                if (cubeSasLocale == null) continue;
                if (sasLocale.toString().equalsIgnoreCase(cubeSasLocale)) {
                    language1 = cubeMlsLanguage;
                    break;
                }
                if (cubeSasLocale.length() <= 1 || sasLocale.length() <= 1) continue;
                String twoBitCheckLocale = cubeSasLocale.toString().substring(0, 2);
                String twoBitAltLocale = sasLocale.substring(0, 2);
                if (language2 == null || !twoBitCheckLocale.equalsIgnoreCase(twoBitAltLocale)) continue;
                language2 = cubeMlsLanguage;
            }
        }
        ExportCubeMlsLanguage language = language1 != null ? language1 : (language2 != null ? language2 : ExportCubeMlsLanguageFactory.DEFAULT_LANGUAGE_KEY);
        return language;
    }

    private MessageFormatter getMsgCubeProcessorIsClosed() {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeProcessor.CubeProcessorIsClosed.fmt.txt", new java.lang.Object[0]);
    }

    private MessageFormatter getMsgCouldNotFindMLSLanguage(ExportCubeMlsLanguage language, String columnName, String libref, String tableName) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeProcessor.CouldNotFindMLSLanguage.fmt.txt", language.getSASLocale(), columnName, tableName, libref);
    }

    private MessageFormatter getMsgMoreThanOneColumnForFactTableKey(com.sas.metadata.remote.Cube omrCube, Dimension dimension) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeDataDsBuilder.MoreThanOneColumnForFactTableKey.fmt.txt", dimension, omrCube);
    }

    private MessageFormatter getMsgCouldNotFindFactTableKey(com.sas.metadata.remote.Cube omrCube, Dimension dimension) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeDataDsBuilder.CouldNotFindFactTableKey.fmt.txt", dimension, omrCube);
    }

    private MessageFormatter getMsgCouldNotFindFactTableKeyColumn(com.sas.metadata.remote.Cube omrCube, Dimension dimension) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeDataDsBuilder.CouldNotFindFactTableKeyColumn.fmt.txt", dimension, omrCube);
    }

    private MessageFormatter getMsgCouldNotFindDimTableKey(com.sas.metadata.remote.Cube omrCube, Dimension dimension) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeDataDsBuilder.CouldNotFindDimTableKey.fmt.txt", dimension, omrCube);
    }

    private MessageFormatter getMsgMoreThanOneColumnForDimTableKey(com.sas.metadata.remote.Cube omrCube, Dimension dimension) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeDataDsBuilder.MoreThanOneColumnForDimTableKey.fmt.txt", dimension, omrCube);
    }

    private MessageFormatter getMsgCouldNotFindDimTableKeyColumn(com.sas.metadata.remote.Cube omrCube, Dimension dimension) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportCubeDataDsBuilder.CouldNotFindDimTableKeyColumn.fmt.txt", dimension, omrCube);
    }

    public String getDetailTableDataSetOptions() throws MetadataException, RemoteException, MdException {
        this.checkClosed();
        return this.getPropertyValue((Root)this.getOmrCube(), PROPERTY_NAME_LOADTABLE_OPTIONS);
    }

    public String getReachThruTableDataSetOptions() throws MetadataException, RemoteException, MdException {
        this.checkClosed();
        return this.getPropertyValue((Root)this.getOmrCube(), PROPERTY_NAME_REACHTHRUTABLE_OPTIONS);
    }

    public String getDimensionTableDataSetOptions(Dimension dimension) throws MetadataException, RemoteException, MdException {
        this.checkClosed();
        return this.getPropertyValue((Root)dimension, PROPERTY_NAME_DIMENSIONTABLE_OPTIONS);
    }

    public String getAggregationTableDataSetOptions(Aggregation aggregation) throws MetadataException, RemoteException, MdException {
        this.checkClosed();
        return this.getPropertyValue((Root)aggregation, PROPERTY_NAME_AGGREGATIONTABLE_OPTIONS);
    }

    private String getPropertyValue(Root remoteObject, String propertyName) throws RemoteException, MdException, MetadataException {
        String value = "";
        List<Property> properties = this.getProperties(remoteObject);
        for (Property property : properties) {
            if (!property.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            String found = property.getDefaultValue();
            if (found.trim().length() <= 0) break;
            value = found.trim();
            break;
        }
        return value;
    }

    public Map<String, java.lang.Object> getColumnSourceDictionary() throws RemoteException, MdException, MetadataException {
        this.checkClosed();
        if (this._columnSourceDictionary == null) {
            LinkedHashMap<String, java.lang.Object> dictionary = new LinkedHashMap<String, java.lang.Object>();
            for (Measure measure2 : this.getMeasures()) {
                dictionary.put(measure2.getUniqueName().toLowerCase().trim(), measure2);
            }
            for (Dimension dimension : this.getDimensions()) {
                dictionary.put(dimension.getUniqueName().toLowerCase().trim(), dimension);
                for (Hierarchy hierarchy : this.getHierarchies(dimension)) {
                    dictionary.put(hierarchy.getUniqueName().toLowerCase().trim(), hierarchy);
                    for (Level level : this.getLevels(hierarchy)) {
                        dictionary.put(level.getUniqueName().toLowerCase().trim(), level);
                    }
                }
            }
            this._columnSourceDictionary = dictionary;
        }
        return this._columnSourceDictionary;
    }

    public Column getMeasureSourceColumn(Measure measure) throws RemoteException, MdException {
        List<Column> featureSources;
        String transformRole;
        Column measureSourceColumn = null;
        List<FeatureMap> sourceFeatureMap = AssociationListUtil.filteredSnapshot(measure.getTargetFeatureMaps(true), FeatureMap.class);
        FeatureMap sourceFeature = null;
        for (FeatureMap featureMap : sourceFeatureMap) {
            transformRole = featureMap.getTransformRole();
            if (!transformRole.equalsIgnoreCase(MEASURE_TARGET_FEATURE_MAP_ROLE_TRNSFORM)) continue;
            sourceFeature = featureMap;
            break;
        }
        if (sourceFeature == null) {
            for (FeatureMap featureMap : sourceFeatureMap) {
                transformRole = featureMap.getTransformRole();
                if (!transformRole.isEmpty()) continue;
                sourceFeature = featureMap;
                break;
            }
        }
        if (sourceFeature != null && (featureSources = AssociationListUtil.filteredSnapshot(sourceFeature.getFeatureSources(true), Column.class)).size() > 0) {
            measureSourceColumn = featureSources.get(0);
        }
        return measureSourceColumn;
    }

    public boolean isNuniqueMeasureColumns(Measure measure) throws RemoteException, MdException, MetadataException {
        String stat = measure.getStatistic();
        boolean hasNunqiueStat = stat != null && stat.equalsIgnoreCase(MEASURE_STATISTIC_NUNIQUE);
        return hasNunqiueStat;
    }

    public List<Column> getNuniqueMeasureColumns(Measure measure) throws RemoteException, MdException, MetadataException {
        ArrayList<Column> levelColumns = new ArrayList<Column>();
        String stat = measure.getStatistic();
        if (stat != null && stat.equalsIgnoreCase(MEASURE_STATISTIC_NUNIQUE)) {
            String transformRole;
            List<Transformation> targetTransformations = AssociationListUtil.filteredSnapshot(measure.getTargetTransformations(true), Transformation.class);
            Transformation targetTransformation = null;
            for (Transformation transformation : targetTransformations) {
                transformRole = transformation.getTransformRole();
                if (!transformRole.equalsIgnoreCase(MEASURE_TARGET_TRANSFORM_ROLE_OLAPNUNIQUE)) continue;
                targetTransformation = transformation;
                break;
            }
            if (targetTransformation == null) {
                for (Transformation transformation : targetTransformations) {
                    transformRole = transformation.getTransformRole();
                    if (!transformRole.isEmpty()) continue;
                    targetTransformation = transformation;
                    break;
                }
            }
            if (targetTransformation != null) {
                List<Hierarchy> hierarchies = AssociationListUtil.filteredSnapshot(targetTransformation.getTransformationSources(true), Hierarchy.class);
                List<Level> upToLevels = AssociationListUtil.filteredSnapshot(targetTransformation.getTransformationSources(true), Level.class);
                Level upToLevel = null;
                if (upToLevels.size() > 0) {
                    upToLevel = upToLevels.get(0);
                }
                Hierarchy fromHierarchy = null;
                if (hierarchies.size() > 0) {
                    fromHierarchy = hierarchies.get(0);
                }
                if (fromHierarchy != null) {
                    Dimension owningDimension = fromHierarchy.getOwningDimension();
                    List<ExportHierarchyColumnDef> hierarchyColumnDefs = this.getHierarchyColumnDefs(owningDimension, fromHierarchy);
                    for (ExportHierarchyColumnDef def : hierarchyColumnDefs) {
                        Column col = def.getCol();
                        Level lev = def.getLev();
                        if (col != null) {
                            levelColumns.add(col);
                        }
                        if (lev == null || upToLevel == null || !lev.getUniqueName().equals(upToLevel.getUniqueName())) continue;
                        break;
                    }
                }
            }
        }
        return levelColumns;
    }

    public boolean isCalculatedMeasure(Measure measure) throws RemoteException, MetadataException, MdException {
        return measure instanceof CalculatedMeasure;
    }

    public List<Column> getCalculatedMeasureColumns(Measure measure, StringBuffer expressionText, Map<String, java.lang.Object> dictionary, Map<String, String> mapNamesToTemplateKeys, StringBuffer template, StringBuffer sasFormat) throws RemoteException, MetadataException, MdException {
        if (mapNamesToTemplateKeys == null) {
            mapNamesToTemplateKeys = new LinkedHashMap<String, String>();
        }
        if (dictionary == null) {
            dictionary = this.getColumnSourceDictionary();
        }
        LinkedHashSet<Column> columnsInExpression = new LinkedHashSet<Column>();
        if (measure instanceof CalculatedMeasure) {
            CalculatedMeasure cm = (CalculatedMeasure)measure;
            String fullExpression = cm.getExpression();
            if (expressionText != null) {
                expressionText.append(fullExpression);
            }
            this.parse(fullExpression, dictionary, mapNamesToTemplateKeys, template, sasFormat);
            if (!mapNamesToTemplateKeys.isEmpty()) {
                Set<String> keySet = mapNamesToTemplateKeys.keySet();
                for (String uniqueName : keySet) {
                    Level resource;
                    java.lang.Object what = dictionary.get(uniqueName);
                    if (what instanceof Level) {
                        resource = (Level)what;
                        columnsInExpression.addAll(this.getLevelSourceColumns(resource));
                        continue;
                    }
                    if (!(what instanceof Measure)) continue;
                    resource = (Measure)what;
                    Column measureSourceColumn = this.getMeasureSourceColumn((Measure)resource);
                    if (measureSourceColumn != null) {
                        columnsInExpression.add(measureSourceColumn);
                    }
                    if (!measure.equals(resource)) {
                        columnsInExpression.addAll(this.getCalculatedMeasureColumns((Measure)resource, null, dictionary, null, null, null));
                    }
                    columnsInExpression.addAll(this.getNuniqueMeasureColumns((Measure)resource));
                }
            }
        }
        return new ArrayList<Column>(columnsInExpression);
    }

    private void parse(String fullExpression, Map<String, java.lang.Object> dictionary, Map<String, String> mapNamesToTemplateKeys, StringBuffer template, StringBuffer sasFormat) {
        if (template == null) {
            template = new StringBuffer();
        }
        if (sasFormat == null) {
            sasFormat = new StringBuffer();
        }
        String work = this.stripFormatString(fullExpression, sasFormat);
        int inName = -1;
        int old = 0;
        for (int i = 0; i < work.length(); ++i) {
            char ch = work.charAt(i);
            if (inName == -1 && ch == '[') {
                inName = i;
                continue;
            }
            if (inName == -1 || ch != ']' || i <= work.length() - 2 && work.charAt(i + 1) == '.' && work.charAt(i + 2) == '[') continue;
            String name = work.substring(inName, i + 1);
            if (dictionary.containsKey(name.toLowerCase().trim())) {
                String key = mapNamesToTemplateKeys.get(name);
                if (key == null) {
                    key = String.valueOf(mapNamesToTemplateKeys.size());
                    mapNamesToTemplateKeys.put(name, key);
                }
                template.append(work.substring(old, inName)).append('{').append(key).append('}');
            } else {
                template.append(work.substring(old, i + 1));
            }
            old = i + 1;
            inName = -1;
        }
        if (old < work.length()) {
            int endIndex = work.length();
            template.append(work.substring(old, endIndex));
        }
    }

    private String stripFormatString(String fullExpression, StringBuffer sasFormat) {
        int co;
        String workExpression = fullExpression.trim();
        String test = workExpression.toLowerCase();
        int fs = test.lastIndexOf("format_string");
        if (fs > -1 && (co = test.substring(0, fs).lastIndexOf(44)) > -1) {
            String format = workExpression.substring(fs, workExpression.length());
            workExpression = workExpression.substring(0, co).trim();
            int q1 = format.indexOf(39);
            if (q1 > -1) {
                int q2 = format.indexOf(39, q1 + 1);
                if (q2 > -1) {
                    sasFormat.append(format.substring(q1 + 1, q2));
                    int c2 = format.indexOf(44, q2 + 1);
                    if (c2 > -1) {
                        workExpression = workExpression + format.substring(c2 + 1, format.length());
                    }
                }
            } else {
                int q4;
                int q3 = format.indexOf(34);
                if (q3 > -1 && (q4 = format.indexOf(34, q3 + 1)) > -1) {
                    sasFormat.append(format.substring(q3 + 1, q4));
                    int c3 = format.indexOf(44, q4 + 1);
                    if (c3 > -1) {
                        workExpression = workExpression + format.substring(c3 + 1, format.length());
                    }
                }
            }
        }
        return workExpression;
    }

    public Set<String> getReferencedFormats(ExportCubeMlsLanguage language) throws MetadataException, RemoteException, MdException {
        Map<java.lang.Object, List<ExportOutputColumnDef>> outputColumns = this.getOutputColumnReferences(language);
        LinkedHashSet<ExportOutputColumnDef> defs = new LinkedHashSet<ExportOutputColumnDef>();
        for (Map.Entry<java.lang.Object, List<ExportOutputColumnDef>> entry : outputColumns.entrySet()) {
            List<ExportOutputColumnDef> columns = entry.getValue();
            defs.addAll(columns);
        }
        LinkedHashSet<String> formats = new LinkedHashSet<String>();
        for (ExportOutputColumnDef column : defs) {
            String sasFormat = column.getSasFormat();
            if (sasFormat == null || sasFormat.trim().isEmpty()) continue;
            formats.add(sasFormat.toUpperCase());
        }
        return formats;
    }

    public boolean useReachThruTable(ExportCubeMlsLanguage language) throws RemoteException, MetadataException, MdException {
        if (this._useReachThruTable == null) {
            Map<java.lang.Object, List<ExportOutputColumnDef>> referencedColumns = this.getOutputColumnReferences(language);
            DataTable reachThruTable = this.getReachThruTable(language);
            if (reachThruTable != null) {
                boolean empty;
                LinkedHashSet<ExportOutputColumnDef> requiredColumns = new LinkedHashSet<ExportOutputColumnDef>(referencedColumns.size());
                for (Map.Entry<java.lang.Object, List<ExportOutputColumnDef>> entry : referencedColumns.entrySet()) {
                    List<ExportOutputColumnDef> values = entry.getValue();
                    requiredColumns.addAll(values);
                }
                ArrayList<ExportOutputColumnDef> columnsNotInReachThruTable = new ArrayList<ExportOutputColumnDef>();
                if (reachThruTable != null) {
                    List<Column> columns = this.getColumns(reachThruTable);
                    for (ExportOutputColumnDef def : requiredColumns) {
                        boolean found = false;
                        for (Column reachThruColumn : columns) {
                            String sasColumnName2;
                            String sasColumnName = reachThruColumn.getSASColumnName();
                            if (!sasColumnName.equalsIgnoreCase(sasColumnName2 = def.getSasColumnName())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        columnsNotInReachThruTable.add(def);
                    }
                }
                if (!(empty = columnsNotInReachThruTable.isEmpty())) {
                    ExportCubeDataDsBuilder._logger.warn("Could not use reachthru table \"" + reachThruTable.getTableName() + "\" for export values because it did contain column(s) " + columnsNotInReachThruTable + ".");
                }
                this._useReachThruTable = empty;
            } else {
                this._useReachThruTable = Boolean.FALSE;
            }
        }
        return this._useReachThruTable;
    }

    public static enum OLAPDataType {
        DRILL,
        STAR,
        NWAY,
        OTHERS;

    }
}

