/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.ExportColumn;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportObjectFactoryInterface;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.impl.ExportObjectAbstract;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ExportColumnImpl
extends ExportObjectAbstract<DataItem, ExportColumn>
implements ExportColumn {
    private final Role _role;

    public ExportColumnImpl(@Nonnull DataItem objectToExport, @Nonnull String uniqueExportName, @Nonnull ExportObjectFactoryInterface<DataItem, ExportColumn> factory, @Nonnull ExportGeneralMetadata exportMetadata, @Nullable Role role) throws MetadataException {
        super(objectToExport, uniqueExportName, factory, exportMetadata);
        this._role = role;
    }

    @Override
    public String getID() throws MetadataException {
        return ((DataItem)this.getUnderlyingObject()).getID();
    }

    @Override
    public String getLabel() {
        return ((DataItem)this.getUnderlyingObject()).getLabel();
    }

    @Override
    public String getDescription() {
        return ((DataItem)this.getUnderlyingObject()).getDescription();
    }

    @Override
    public boolean isCalculated() throws MetadataException {
        return ((DataItem)this.getUnderlyingObject()).isCalculatedItem();
    }

    @Override
    public String getText() throws MetadataException {
        return StringExpressionUtil.getInstance().getText(((DataItem)this.getUnderlyingObject()).getExpression());
    }

    @Override
    public String getFormat() throws MetadataException {
        return ((DataItem)this.getUnderlyingObject()).getFormat();
    }

    @Override
    public DataItemActionType getUsage() throws MetadataException {
        return ((DataItem)this.getUnderlyingObject()).getUsage();
    }

    @Override
    public Role getRole() throws MetadataException {
        return this._role;
    }

    @Override
    public String getType() throws MetadataException {
        String type = "";
        int expressionType = ((DataItem)this.getUnderlyingObject()).getExpressionType();
        type = expressionType == 3 || expressionType == 11 ? "C" : "N";
        return type;
    }

    @Override
    public boolean isPreAggregated() throws MetadataException {
        DataItemActionType usage = this.getUsage();
        boolean isPreAggregated = usage.equals(DataItemActionType.USAGE_AGGREGATE) ? ((DataItem)this.getUnderlyingObject()).containsUserTypedAggregation() || ((DataItem)this.getUnderlyingObject()).getAggregationType() != null : false;
        return isPreAggregated;
    }

    @Override
    public Function getAggregationType() throws MetadataException {
        Function aggregationType;
        DataItem di = (DataItem)this.getUnderlyingObject();
        DataItemActionType usage = this.getUsage();
        if (usage.equals(DataItemActionType.USAGE_AGGREGATE)) {
            Function diAggType = di.getAggregationType();
            aggregationType = diAggType == null && di.containsUserTypedAggregation() ? di.getBusinessModel().getServerProperties().getFunctionByNameID(FunctionNameID.INTERNAL_AGGREGATION) : diAggType;
        } else if (usage.equals(DataItemActionType.USAGE_DETAIL)) {
            Function foundDefaultType = di.getAggregationType();
            DataItem walk = di;
            while (foundDefaultType == null && walk instanceof DataItemReference) {
                if ((walk = ((DataItemReference)walk).getBaseDataItem()) == null) continue;
                foundDefaultType = walk.getAggregationType();
            }
            aggregationType = foundDefaultType;
        } else {
            aggregationType = null;
        }
        return aggregationType;
    }
}

