/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.ExportColumn;
import com.sas.iquery.metadata.business.ExportColumnGroup;
import com.sas.iquery.metadata.business.ExportGeneralMetadata;
import com.sas.iquery.metadata.business.ExportObjectFactoryInterface;
import com.sas.iquery.metadata.business.ExportSelectionMetadata;
import com.sas.iquery.metadata.business.ExportUploadMetadata;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.impl.ExportObjectAbstract;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.List;

class ExportColumnGroupImpl
extends ExportObjectAbstract<Object, ExportColumnGroup>
implements ExportColumnGroup {
    private final List<?> _underlyingSubObjects;
    private final ExportColumnGroup.ExportGroupType _groupType;
    private List<ExportColumn> _exportColumns = null;

    public ExportColumnGroupImpl(Object underlyingObject, String uniqueExportName, ExportObjectFactoryInterface<Object, ExportColumnGroup> exportObjectFactory, ExportGeneralMetadata exportMetadata, List<?> underlyingSubObjects) throws MetadataException {
        super(underlyingObject, uniqueExportName, exportObjectFactory, exportMetadata);
        this._underlyingSubObjects = underlyingSubObjects;
        Object obj = this.getUnderlyingObject();
        this._groupType = obj instanceof Hierarchy ? ExportColumnGroup.ExportGroupType.HIERARCHY : (obj instanceof Role ? ExportColumnGroup.ExportGroupType.ROLE : (obj instanceof DataItemActionType && (obj.equals(DataItemActionType.USAGE_CATEGORY) || obj.equals(DataItemActionType.USAGE_AGGREGATE) || obj.equals(DataItemActionType.USAGE_DETAIL)) ? ExportColumnGroup.ExportGroupType.USAGE : ExportColumnGroup.ExportGroupType.OTHER));
    }

    public ExportColumnGroupImpl(Object underlyingObject, String uniqueExportName, ExportObjectFactoryInterface<Object, ExportColumnGroup> exportObjectFactory, ExportGeneralMetadata exportMetadata, ExportColumnGroup.ExportGroupType groupType, List<?> underlyingSubObjects) throws MetadataException {
        super(underlyingObject, uniqueExportName, exportObjectFactory, exportMetadata);
        this._underlyingSubObjects = underlyingSubObjects;
        this._groupType = groupType;
    }

    @Override
    public ExportColumnGroup.ExportGroupType getGroupType() throws MetadataException {
        return this._groupType;
    }

    @Override
    public String getLabel() {
        String label;
        Object obj = this.getUnderlyingObject();
        try {
            ExportColumnGroup.ExportGroupType type = this.getGroupType();
            label = type == null ? "" : type.getLabel(obj);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            label = obj == null ? "" : obj.toString();
        }
        return label;
    }

    @Override
    public String getDescription() {
        String desc;
        Object obj = this.getUnderlyingObject();
        try {
            ExportColumnGroup.ExportGroupType type = this.getGroupType();
            desc = type == null ? "" : type.getDescription(obj);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            desc = obj == null ? "" : obj.toString();
        }
        return desc;
    }

    @Override
    public String getID() throws MetadataException {
        ExportColumnGroup.ExportGroupType type;
        Object obj = this.getUnderlyingObject();
        try {
            type = this.getGroupType();
        }
        catch (MetadataException e) {
            e.printStackTrace();
            type = null;
        }
        String id = type == null ? (obj == null ? "" : obj.toString()) : type.getID(obj);
        return id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ExportColumn> getColumns() throws MetadataException {
        if (this._exportColumns != null) return this._exportColumns;
        ArrayList<ExportColumn> exportColumns = new ArrayList<ExportColumn>();
        ExportGeneralMetadata exportMetadata = this.getExportMetadata();
        for (Object underlyingSubObject : this._underlyingSubObjects) {
            ExportColumn foundColumn = null;
            if (underlyingSubObject == null) {
                throw new MetadataException(this.getMsgNullUnderlyingColumnObjectInGroup(this.getUniqueExportName(), this._underlyingSubObjects));
            }
            if (underlyingSubObject instanceof ExportColumn) {
                foundColumn = (ExportColumn)underlyingSubObject;
            } else {
                if (!(underlyingSubObject instanceof DataItem)) throw new MetadataException(this.getMsgUnknownTypeOfUnderlyingColumnObject(this.getUniqueExportName(), underlyingSubObject, this._underlyingSubObjects));
                if (exportMetadata instanceof ExportSelectionMetadata) {
                    ExportSelectionMetadata selectMetadata = (ExportSelectionMetadata)exportMetadata;
                    foundColumn = selectMetadata.getExportColumn((DataItem)underlyingSubObject);
                } else {
                    if (!(exportMetadata instanceof ExportUploadMetadata)) throw new MetadataException(this.getMsgUnknownTypeOfMetadataObject(this.getUniqueExportName(), exportMetadata, underlyingSubObject, this._underlyingSubObjects));
                    ExportUploadMetadata uploadedMetadata = (ExportUploadMetadata)exportMetadata;
                    foundColumn = uploadedMetadata.getUploadColumn((DataItem)underlyingSubObject);
                }
            }
            exportColumns.add(foundColumn);
        }
        this._exportColumns = exportColumns;
        return this._exportColumns;
    }

    private MessageFormatter getMsgUnknownTypeOfUnderlyingColumnObject(String uniqueExportName, Object underlyingSubObject, List<?> underlyingObjects) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportColumnGroupImpl.UnknownTypeOfUnderlyingColumnObject.fmt.txt", uniqueExportName, underlyingSubObject, underlyingSubObject.getClass().getName(), new ArrayMessageFormatter(underlyingObjects));
    }

    private MessageFormatter getMsgUnknownTypeOfMetadataObject(String uniqueExportName, ExportGeneralMetadata exportMetadata, Object underlyingSubObject, List<?> underlyingObjects) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportColumnGroupImpl.UnderlyingColumnObjectInGroup.fmt.txt", uniqueExportName, exportMetadata, exportMetadata.getClass().getName(), underlyingSubObject, underlyingSubObject.getClass().getName(), new ArrayMessageFormatter(underlyingObjects));
    }

    private MessageFormatter getMsgNullUnderlyingColumnObjectInGroup(String uniqueExportName, List<?> underlyingObjects) {
        return IQMetadataResourceBundle.getMessageFormatter("ExportColumnGroupImpl.UnderlyingColumnObjectInGroup.fmt.txt", uniqueExportName, new ArrayMessageFormatter(underlyingObjects));
    }
}

