/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.EntityInterface;
import com.sas.entities.persist.EntityPersistenceUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EntityHandler
extends DefaultHandler {
    private EntityInterface _entity;
    private Document _doc;
    private Element _currentElement;
    private boolean _done = false;
    private StringBuffer _pendingText;

    public EntityHandler(Document docToPopulate) throws SAXException {
        this._doc = docToPopulate;
    }

    public EntityInterface getEntity() {
        return this._entity;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.consumeAnyPendingText();
        this._currentElement = this._currentElement == null ? EntityHandler.newSubelement(this._doc, qName) : EntityHandler.newSubelement(this._currentElement, qName);
        int attrCount = atts.getLength();
        for (int i = 0; i < attrCount; ++i) {
            String attrQName = atts.getQName(i);
            String attrURI = atts.getURI(i);
            String attrValue = atts.getValue(i);
            if (attrURI != null && attrURI.length() > 0) {
                this._currentElement.setAttributeNS(attrURI, attrQName, attrValue);
                continue;
            }
            this._currentElement.setAttribute(attrQName, attrValue);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.consumeAnyPendingText();
        Node parentNode = this._currentElement.getParentNode();
        if (parentNode == this._doc) {
            this._entity = EntityPersistenceUtility.read((Element)this._currentElement);
            Element topElement = this._doc.getDocumentElement();
            if (topElement != null) {
                this._doc.removeChild(topElement);
            }
            this._doc = null;
            this._currentElement = null;
            this._done = true;
        } else {
            this._currentElement = (Element)parentNode;
        }
    }

    public boolean isDone() {
        return this._done;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String str = new String(ch, start, length);
        this.addToPendingText(str);
    }

    private static Element newSubelement(Node parentNode, String newElementName) {
        Document doc = null;
        doc = parentNode instanceof Document ? (Document)parentNode : parentNode.getOwnerDocument();
        Element element = doc.createElement(newElementName);
        parentNode.appendChild(element);
        return element;
    }

    private void consumeAnyPendingText() {
        if (this._pendingText != null) {
            Text textNode = this._doc.createTextNode(this._pendingText.toString());
            this._pendingText = null;
            this._currentElement.appendChild(textNode);
        }
    }

    private void addToPendingText(String text) {
        if (this._pendingText == null) {
            this._pendingText = new StringBuffer();
        }
        this._pendingText.append(text);
    }
}

