/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessRule;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.RequiredDataSources;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCacheSupport;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class EffectiveObjectsCache {
    private static final Logger _logger = LogManager.getLogger(BusinessQuery.class);
    private Map<BusinessQuery, List<DataItem>> _cachedEffectiveResultItems = new LinkedHashMap<BusinessQuery, List<DataItem>>();
    private Map<BusinessQuery, List<DataItem>> _cachedEffectiveSortOrderPrecedence = new LinkedHashMap<BusinessQuery, List<DataItem>>();
    private Map<BusinessQuery, List<DataItem>> _cachedEffectiveSolveOrderPrecedence = new LinkedHashMap<BusinessQuery, List<DataItem>>();
    private Map<BusinessQuery, List<BusinessRule>> _cachedEffectiveBusinessRules = new LinkedHashMap<BusinessQuery, List<BusinessRule>>();
    private Map<BusinessQuery, List<RequiredDataSources>> _cachedEffectiveRequiredDataSources = new LinkedHashMap<BusinessQuery, List<RequiredDataSources>>();
    private Map<BusinessQuery, List<BusinessGroup>> _cachedEffectiveGroups = new LinkedHashMap<BusinessQuery, List<BusinessGroup>>();
    private Map<BusinessQuery, List<FilterItem>> _cachedEffectiveFilters = new LinkedHashMap<BusinessQuery, List<FilterItem>>();
    private Map<BusinessQuery, List<DataSource>> _cachedEffectiveDataSources = new LinkedHashMap<BusinessQuery, List<DataSource>>();

    public void clear() {
        this._cachedEffectiveResultItems.clear();
        this._cachedEffectiveSortOrderPrecedence.clear();
        this._cachedEffectiveSolveOrderPrecedence.clear();
        this._cachedEffectiveBusinessRules.clear();
        this._cachedEffectiveGroups.clear();
        this._cachedEffectiveFilters.clear();
        this._cachedEffectiveDataSources.clear();
    }

    public void remove(BusinessQuery query) {
        this._cachedEffectiveResultItems.remove(query);
        this._cachedEffectiveSortOrderPrecedence.remove(query);
        this._cachedEffectiveSolveOrderPrecedence.remove(query);
        this._cachedEffectiveBusinessRules.remove(query);
        this._cachedEffectiveGroups.remove(query);
        this._cachedEffectiveFilters.remove(query);
        this._cachedEffectiveDataSources.remove(query);
    }

    public List<DataItem> getEffectiveResultItems(BusinessQuery query) {
        List<DataItem> effectiveResultItems = this._cachedEffectiveResultItems.get(query);
        if (effectiveResultItems == null) {
            if (query instanceof EffectiveObjectsCacheSupport) {
                EffectiveObjectsCacheSupport r = (EffectiveObjectsCacheSupport)((Object)query);
                effectiveResultItems = r.getEffectiveResultItems(this);
            } else {
                effectiveResultItems = query.getEffectiveResultItems();
            }
            effectiveResultItems = Collections.unmodifiableList(effectiveResultItems);
            this._cachedEffectiveResultItems.put(query, effectiveResultItems);
        }
        return effectiveResultItems;
    }

    public List<DataItem> getEffectiveSortOrderPrecedence(BusinessQuery query) {
        List<DataItem> effectiveSortOrderPrecedence = this._cachedEffectiveSortOrderPrecedence.get(query);
        if (effectiveSortOrderPrecedence == null) {
            effectiveSortOrderPrecedence = query.getEffectiveSortOrderPrecedence();
            effectiveSortOrderPrecedence = Collections.unmodifiableList(effectiveSortOrderPrecedence);
            this._cachedEffectiveSortOrderPrecedence.put(query, effectiveSortOrderPrecedence);
        }
        return effectiveSortOrderPrecedence;
    }

    public List<DataItem> getEffectiveSolveOrderPrecedence(BusinessQuery query) {
        List<DataItem> effectiveSolveOrderPrecedence = this._cachedEffectiveSolveOrderPrecedence.get(query);
        if (effectiveSolveOrderPrecedence == null) {
            effectiveSolveOrderPrecedence = query.getSolveOrderPrecedence();
            effectiveSolveOrderPrecedence = Collections.unmodifiableList(effectiveSolveOrderPrecedence);
            this._cachedEffectiveSolveOrderPrecedence.put(query, effectiveSolveOrderPrecedence);
        }
        return effectiveSolveOrderPrecedence;
    }

    public List<BusinessRule> getEffectiveBusinessRules(BusinessQuery query) {
        List<BusinessRule> effectiveBusinessRules = this._cachedEffectiveBusinessRules.get(query);
        if (effectiveBusinessRules == null) {
            effectiveBusinessRules = query.getEffectiveRules(BusinessRule.class);
            effectiveBusinessRules = Collections.unmodifiableList(effectiveBusinessRules);
            this._cachedEffectiveBusinessRules.put(query, effectiveBusinessRules);
        }
        return effectiveBusinessRules;
    }

    public List<RequiredDataSources> getEffectiveRequiredDataSources(BusinessQuery query) {
        List<RequiredDataSources> effectiveRequiredDataSources = this._cachedEffectiveRequiredDataSources.get(query);
        if (effectiveRequiredDataSources == null) {
            effectiveRequiredDataSources = query.getEffectiveRules(RequiredDataSources.class);
            effectiveRequiredDataSources = Collections.unmodifiableList(effectiveRequiredDataSources);
            this._cachedEffectiveRequiredDataSources.put(query, effectiveRequiredDataSources);
        }
        return effectiveRequiredDataSources;
    }

    public List<BusinessGroup> getEffectiveGroups(BusinessQuery query) {
        List<BusinessGroup> effectiveGroups = this._cachedEffectiveGroups.get(query);
        if (effectiveGroups == null) {
            effectiveGroups = query.getEffectiveGroups();
            effectiveGroups = Collections.unmodifiableList(effectiveGroups);
            this._cachedEffectiveGroups.put(query, effectiveGroups);
        }
        return effectiveGroups;
    }

    public List<DataSource> getEffectiveDataSources(BusinessQuery query) throws MetadataException {
        List<DataSource> effectiveDataSources = this._cachedEffectiveDataSources.get(query);
        if (effectiveDataSources == null) {
            if (query instanceof EffectiveObjectsCacheSupport) {
                EffectiveObjectsCacheSupport r = (EffectiveObjectsCacheSupport)((Object)query);
                effectiveDataSources = r.getEffectiveDataSources(this);
            } else {
                effectiveDataSources = query.getEffectiveDataSources();
            }
            effectiveDataSources = Collections.unmodifiableList(effectiveDataSources);
            this._cachedEffectiveDataSources.put(query, effectiveDataSources);
        }
        return effectiveDataSources;
    }

    public List<FilterItem> getEffectiveFilters(BusinessQuery query) {
        List<FilterItem> effectiveFilters = this._cachedEffectiveFilters.get(query);
        if (effectiveFilters == null) {
            if (query instanceof EffectiveObjectsCacheSupport) {
                EffectiveObjectsCacheSupport r = (EffectiveObjectsCacheSupport)((Object)query);
                effectiveFilters = r.getEffectiveFilters(this);
            } else {
                effectiveFilters = query.getEffectiveFilters();
            }
            effectiveFilters = Collections.unmodifiableList(effectiveFilters);
            this._cachedEffectiveFilters.put(query, effectiveFilters);
        }
        return effectiveFilters;
    }

    public List<Join> getEffectiveJoinPath(BusinessQuery query) throws MetadataException {
        List<Join> effectiveJoinPath;
        if (query instanceof EffectiveObjectsCacheSupport) {
            EffectiveObjectsCacheSupport r = (EffectiveObjectsCacheSupport)((Object)query);
            effectiveJoinPath = r.getEffectiveJoinPath(this);
        } else {
            effectiveJoinPath = query.getEffectiveJoinPath();
        }
        return effectiveJoinPath;
    }
}

