/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DrillThroughToDetail;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModelObject;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DrillThroughToDetailImpl
extends AbstractBusinessModelObject
implements DrillThroughToDetail {
    private boolean _isDrillThroughAllowed = true;

    public DrillThroughToDetailImpl(AbstractBusinessModel businessModel) {
        super(businessModel);
    }

    public DrillThroughToDetailImpl() {
    }

    @Override
    public boolean isDrillThroughAllowed() {
        return this._isDrillThroughAllowed;
    }

    @Override
    public void setIsDrillThroughAllowed(boolean flag) throws MetadataException {
        this.changeableCheck();
        if (flag != this._isDrillThroughAllowed) {
            this._isDrillThroughAllowed = flag;
            this.fireChangeEvent("The \"Is drill-through allowed\" value has changed.");
        }
    }

    @Override
    protected String getDefaultIDPrefix() {
        return "DRL_";
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this._isDrillThroughAllowed = IQModelImplUtilities.getBooleanAttr(thisElement, "allowed", true);
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setBooleanAttr(thisElement, "allowed", this._isDrillThroughAllowed, true);
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._isDrillThroughAllowed = attrsProvider.consumeBooleanAttr("allowed", true);
    }

    @Override
    protected String getDefinitionElementName() {
        return "DrillThroughToDetail";
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }
}

