/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.dataservices.DataRetrievalUtil;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.generation2.MetadataDataSource;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.AssociationMatrix;
import com.sas.iquery.metadata.business.AssociationRule;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.BusinessQueryTotalLocationType;
import com.sas.iquery.metadata.business.BusinessQueryTotalModeType;
import com.sas.iquery.metadata.business.BusinessRule;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.metadata.business.CascadableFilter;
import com.sas.iquery.metadata.business.CascadeRuleSet;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.DrillThroughToDetail;
import com.sas.iquery.metadata.business.ExplicitJoinPathSupport;
import com.sas.iquery.metadata.business.FilterCascadeContainer;
import com.sas.iquery.metadata.business.FilterCascadeInterface;
import com.sas.iquery.metadata.business.FilterCascadeRule;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.FilterSet;
import com.sas.iquery.metadata.business.FilterSetMember;
import com.sas.iquery.metadata.business.FilterSetRuleItems;
import com.sas.iquery.metadata.business.FilterSetRulesContainer;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.LookThroughDataSelection;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.QueryWriteOption;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.RequiredDataSources;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RunStoredProcess;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModelObject;
import com.sas.iquery.metadata.business.impl.AbstractEnumerationObject;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelReference;
import com.sas.iquery.metadata.business.impl.AssociationMatrixImpl;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.BusinessModelReferenceInfoImpl;
import com.sas.iquery.metadata.business.impl.CascadeRuleImpl;
import com.sas.iquery.metadata.business.impl.CascadeRuleItemImpl;
import com.sas.iquery.metadata.business.impl.CascadeRuleSetImpl;
import com.sas.iquery.metadata.business.impl.CompoundFilterImpl;
import com.sas.iquery.metadata.business.impl.DataItemImpl;
import com.sas.iquery.metadata.business.impl.DataItemReferenceImpl;
import com.sas.iquery.metadata.business.impl.DataSelectionExternalResourceResolver;
import com.sas.iquery.metadata.business.impl.DataSelectionReadingContext;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCache;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCacheSupport;
import com.sas.iquery.metadata.business.impl.FilterItemImpl;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.business.impl.JoinImpl;
import com.sas.iquery.metadata.business.impl.JoinPathGeneratorImpl;
import com.sas.iquery.metadata.business.impl.LookThroughDataSelectionImpl;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.PersistenceProvider;
import com.sas.iquery.metadata.business.impl.QueryPrompts;
import com.sas.iquery.metadata.business.impl.QueryProperties;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.impl.XMLV2ModelHandler;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryTupleFilter;
import com.sas.iquery.metadata.business.step.olap.StepManager;
import com.sas.iquery.metadata.business.step.olap.TupleFilterMemberQualifier;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.BusinessGroupMemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.FilterSetQueryGeneration;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.DataSelectionOrganizer;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.PersistenceUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPUtilities;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.util.LocalizableString;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DataSelectionImpl
extends AbstractBusinessModel
implements DataSelection,
CancelQuerySupport.CancellableQuery,
ExplicitJoinPathSupport,
EffectiveObjectsCacheSupport {
    public static final String ELEMENT_DATA_SELECTION = "DataSelection";
    private static final int SELECTED_ITEMS_LIST = 0;
    private static final int RESULT_ITEMS_LIST = 1;
    private List<SelectedItem> selectedItems = new ArrayList<SelectedItem>();
    private Map cachedSelectedItemsByRole = new HashMap();
    private List cachedResultItems = ListUtils.newCOWList();
    private List<DataItem> sortOrderPrecedence = new ArrayList<DataItem>();
    private List<FilterItem> filters = new ArrayList<FilterItem>();
    private final List<BusinessQueryActionType> _disabledActions = new ArrayList<BusinessQueryActionType>(0);
    private List<BusinessQueryActionType> _validActions = new ArrayList<BusinessQueryActionType>();
    private QueryProperties queryProperties = new QueryProperties();
    private String emptyDataFormat = "";
    private List<StepInterface> _rowSteps = new ArrayList<StepInterface>();
    private List<StepInterface> _columnSteps = new ArrayList<StepInterface>();
    private List sortRowCriteria = new ArrayList();
    private List sortColumnCriteria = new ArrayList();
    private BusinessQueryActionType sortRowDirection = BusinessQueryActionType.SORT_NONE;
    private BusinessQueryActionType sortColumnDirection = BusinessQueryActionType.SORT_NONE;
    private BusinessQueryTotalLocationType totalLocation = BusinessQueryTotalLocationType.TOTAL_ROW_BOTTOM_COLUMN_RIGHT;
    private BusinessQueryTotalModeType totalMode = BusinessQueryTotalModeType.VISUAL_VALUES;
    private List<BusinessGroup> _groups = new ArrayList<BusinessGroup>();
    private String grandTotalRowLabel;
    private String grandTotalColumnLabel;
    private String subTotalRowLabel;
    private String subTotalColumnLabel;
    private TotalingType totalRowType = TotalingType.TOTAL_NONE;
    private TotalingType totalColumnType = TotalingType.TOTAL_NONE;
    private boolean coalescedIndicator = true;
    protected QueryPrompts _queryPrompts;
    private Map strategyProperties = new HashMap();
    private static final Logger _logger = LogManager.getLogger(DataSelectionImpl.class);
    private static final Class<?>[] VALID_TYPES_FILTER_IMPLS = new Class[]{FilterItemImpl.class, CompoundFilterImpl.class};
    private static final Class<?>[] VALID_TYPES_DATA_ITEM_IMPLS = new Class[]{DataItemImpl.class, DataItemReferenceImpl.class};
    private static final List<String> EVENTS_THAT_CAUSE_QUERY_DEFINITION_CHANGE = Collections.unmodifiableList(Arrays.asList("The role of a result item has changed", "The list of result items has changed", "The list of filters has changed", "The sort order list has changed", "The totaling of result items has changed", "The total label of result items has changed", "Olap sort direction has changed", "Olap sort criteria has changed", "The solve order has changed", "The step list has changed", "A query property has changed", "The empty data format has changed", "An object referenced by the BusinessQuery has changed"));
    protected static final List<BusinessQueryActionType> VALID_RELATIONAL_ACTIONS = new ArrayList<BusinessQueryActionType>();
    protected static final List<BusinessQueryActionType> VALID_OLAP_ACTIONS;
    boolean _cancelEnabled = CancelQuerySupport.isCancelQueryEnabledByDefault();
    private List _explicitJoinPath = new ArrayList();
    private static final Class[] VALID_TYPES_JOIN_PATH_IMPLS;

    protected DataSelectionFactory getDataSelectionFactory() {
        return DataSelectionFactory.getInstance();
    }

    public DataSelectionImpl() {
    }

    public DataSelectionImpl(AbstractBusinessModel parentBusinessModel) {
        super(parentBusinessModel);
        this.init();
    }

    public DataSelectionImpl(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service) {
        super(session, service);
        this.init();
    }

    public DataSelectionImpl(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Locale dataLocale) {
        super(session, service, dataLocale);
        this.init();
    }

    private void init() {
        this.initializeValidActions();
        if (this._queryPrompts == null) {
            this._queryPrompts = new QueryPrompts(this);
        }
    }

    @Override
    public BusinessQuery getParentQuery() {
        BusinessQuery parentQuery = null;
        BusinessModel parent = this.getParentBusinessModel();
        if (parent instanceof BusinessQuery) {
            parentQuery = (BusinessQuery)((Object)parent);
        }
        return parentQuery;
    }

    @Override
    public void addDataSource(int index, DataSource dataSource) throws MetadataException {
        super.addDataSource(index, dataSource);
        if (this._validActions == null || this._validActions.isEmpty()) {
            this.initializeValidActions();
        }
    }

    @Override
    public List<BusinessModelObject> removeDataSource(DataSource dataSource) throws MetadataException {
        List<BusinessModelObject> dependentObjects = super.removeDataSource(dataSource);
        List<DataSource> dataSources = this.getObjects(true, DataSource.class);
        if (dataSources.isEmpty() && this._validActions != null) {
            this._validActions.clear();
        }
        return dependentObjects;
    }

    @Override
    public DataSelection getParentDataSelection() {
        DataSelection parentDS = null;
        BusinessModel parent = this.getParentBusinessModel();
        if (parent instanceof DataSelection) {
            parentDS = (DataSelection)parent;
        }
        return parentDS;
    }

    @Override
    public void initialize(BusinessModel baseModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BusinessModel getBusinessModel() {
        return this;
    }

    @Override
    public LookThroughDataSelection insertNewChild(LookThroughDataSelection currentChildDS) throws MetadataException {
        Preconditions.ensureNonNullWithMessage(currentChildDS, "DataSelectionImplInsertNewChildNotEnabled.txt", "currentChildDS");
        ArrayList<LookThroughDataSelection> aboveTheseKids = new ArrayList<LookThroughDataSelection>();
        aboveTheseKids.add(currentChildDS);
        return this.insertNewChild(aboveTheseKids);
    }

    @Override
    public LookThroughDataSelection insertNewChild(@Nonnull List aboveTheseChildren) throws MetadataException {
        Preconditions.ensureNonNull(aboveTheseChildren, _logger);
        aboveTheseChildren = new ArrayList(aboveTheseChildren);
        if (_logger.isDebugEnabled()) {
            _logger.debug("DataSelectionImpl.insertNewChild() entered on " + this.getIdentityString());
            StringBuffer msg = new StringBuffer(200);
            msg.append(" ... inserting above these children: ").append(aboveTheseChildren.size()).append(": ");
            for (int i = 0; i < aboveTheseChildren.size(); ++i) {
                Object obj = aboveTheseChildren.get(i);
                if (!(obj instanceof DataSelection)) continue;
                msg.append(((DataSelection)obj).getIdentityString()).append(";");
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg.toString());
                _logger.debug("State of business model family BEFORE inserting new child:");
                String logthis = this.getFamilyStateDebugString();
                _logger.debug(logthis);
            }
        }
        Preconditions.ensureNonNullTypedElements(aboveTheseChildren, LookThroughDataSelectionImpl.class, _logger);
        Utils.removeDuplicates(aboveTheseChildren);
        List currentChildren = this.getChildren();
        for (Object kid : aboveTheseChildren) {
            if (currentChildren.contains(kid)) continue;
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplNotCurrentChild.txt", new Object[0]));
        }
        LookThroughDataSelectionImpl newChild = (LookThroughDataSelectionImpl)this.getDataSelectionFactory().newLookThroughDataSelectionNonStatic(this);
        for (AbstractBusinessModel child : aboveTheseChildren) {
            child.reParentLinkage(newChild);
        }
        HashMap<DataItem, DataItemReference> oldParentToNewParentDIRs = new HashMap<DataItem, DataItemReference>();
        for (Object kid : aboveTheseChildren) {
            List<DataItemReferenceImpl> childDIRs = ((AbstractBusinessModel)kid).getObjects(false, DataItemReferenceImpl.class);
            for (DataItemReferenceImpl dir : childDIRs) {
                DataItem parentDataItem = dir.getBaseDataItem();
                if (parentDataItem == null || parentDataItem.getBusinessModel() != this) continue;
                DataItemReference newDir = (DataItemReference)oldParentToNewParentDIRs.get(parentDataItem);
                if (newDir == null) {
                    newDir = newChild.newDataItemReference(parentDataItem);
                    newChild.addBusinessItem(newDir);
                    oldParentToNewParentDIRs.put(parentDataItem, newDir);
                }
                dir.setBaseDataItem(newDir);
            }
        }
        List<SelectedItem> parentSelectedItems = this.getSelectedItems();
        for (SelectedItem si : parentSelectedItems) {
            DataItem di = si.getItem();
            DataItem newChildResultItem = (DataItem)oldParentToNewParentDIRs.get(di);
            if (newChildResultItem == null) {
                if (di.getBusinessModel() == this) {
                    newChildResultItem = newChild.newDataItemReference(di);
                    newChild.addBusinessItem(newChildResultItem);
                } else {
                    newChildResultItem = di;
                }
            }
            SelectedItem newSelectedItem = new SelectedItem(newChildResultItem, si.getRole(), si.getFormatType());
            newChild.insertSelectedItemAt(newSelectedItem, 0);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("State of business model family AFTER inserting new child:");
            String logthis = this.getFamilyStateDebugString();
            _logger.debug(logthis);
        }
        this.fireChangeEvent("child business model added");
        return newChild;
    }

    @Override
    public void removeChildAndCollapse(LookThroughDataSelection child) throws MetadataException {
        List bmsThatReferenceIt;
        if (child == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplInsertNewChildNotEnabled.txt", new Object[0]));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("DataSelectionImpl.removeChildAndCollapse() entered on " + this.getIdentityString());
            _logger.debug(" ... removing this child: " + child.getIdentityString());
            _logger.debug("State of business model family BEFORE removing child:");
            String logthis = this.getFamilyStateDebugString();
            _logger.debug(logthis);
        }
        ArrayList<BusinessModelObject> lookThroughBmos = new ArrayList<BusinessModelObject>();
        ArrayList<BusinessModelObject> nonLookThroughBmos = new ArrayList<BusinessModelObject>();
        List<BusinessModelObject> childBmos = child.getObjects(false, BusinessModelObject.class);
        for (BusinessModelObject bmo : childBmos) {
            if (bmo instanceof DataItemReference) {
                lookThroughBmos.add(bmo);
                continue;
            }
            nonLookThroughBmos.add(bmo);
        }
        List<BusinessModel> descendents = child.getDescendents();
        HashMap<BusinessModel, List<BusinessModelObject>> bmToResourcesReferenced = new HashMap<BusinessModel, List<BusinessModelObject>>();
        HashMap<BusinessModelObject, ArrayList<BusinessModel>> resourceToBmThatReferencesIt = new HashMap<BusinessModelObject, ArrayList<BusinessModel>>();
        for (BusinessModel businessModel : descendents) {
            List<BusinessModelObject> descendentResources = businessModel.getResources(BusinessModelObject.class);
            for (BusinessModelObject resource : descendentResources) {
                ArrayList<BusinessModel> bmsThatReferenceResource = (ArrayList<BusinessModel>)resourceToBmThatReferencesIt.get(resource);
                if (bmsThatReferenceResource == null) {
                    bmsThatReferenceResource = new ArrayList<BusinessModel>();
                    resourceToBmThatReferencesIt.put(resource, bmsThatReferenceResource);
                }
                bmsThatReferenceResource.add(businessModel);
            }
            bmToResourcesReferenced.put(businessModel, descendentResources);
        }
        for (AbstractBusinessModelObject abstractBusinessModelObject : nonLookThroughBmos) {
            bmsThatReferenceIt = (List)resourceToBmThatReferencesIt.get(abstractBusinessModelObject);
            if (bmsThatReferenceIt == null) continue;
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("DataSelectionImplNoRemoveOfChild.fmt.txt", abstractBusinessModelObject.getIdentityString(), ((AbstractBusinessModel)bmsThatReferenceIt.get(0)).getIdentityString());
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString());
            }
            throw new MetadataException(msg);
        }
        for (DataItemReference dataItemReference : lookThroughBmos) {
            bmsThatReferenceIt = (List)resourceToBmThatReferencesIt.get(dataItemReference);
            if (bmsThatReferenceIt == null) continue;
            for (AbstractBusinessModel bmThatReferencesIt : bmsThatReferenceIt) {
                bmThatReferencesIt.replaceResource(dataItemReference, dataItemReference.getBaseDataItem());
            }
        }
        for (AbstractBusinessModel abstractBusinessModel : child.getChildren()) {
            abstractBusinessModel.reParentLinkage(this);
        }
        this.removeChild(child);
        if (_logger.isDebugEnabled()) {
            _logger.debug("State of business model family AFTER removing child:");
            String logthis = this.getFamilyStateDebugString();
            _logger.debug(logthis);
        }
        this.fireChangeEvent("child business model removed");
    }

    @Override
    public List<FilterItem> getFilters() {
        return new ArrayList<FilterItem>(this.filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<FilterItem> getEffectiveFilters() {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            List<FilterItem> effectiveFilters = effectiveObjectCache.getEffectiveFilters(this);
            ArrayList<FilterItem> arrayList = new ArrayList<FilterItem>(effectiveFilters);
            return arrayList;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public List<FilterItem> getEffectiveFilters(EffectiveObjectsCache effectiveObjectCache) {
        LinkedHashSet<FilterItem> effectiveFilters;
        block4: {
            effectiveFilters = new LinkedHashSet<FilterItem>(this.getFilters());
            try {
                boolean done = false;
                while (!done) {
                    List<DataSource> dataSources = this.getEffectiveDataSources(effectiveObjectCache, effectiveFilters);
                    if (FilterSetQueryGeneration.canHandle(this, dataSources)) {
                        FilterSetQueryGeneration filteredGen = new FilterSetQueryGeneration();
                        filteredGen.setDataSelection(this);
                        filteredGen.setEffectiveDataSources(dataSources);
                        List<FilterItem> postFilters = filteredGen.getPostFilters();
                        boolean newFiltersFound = effectiveFilters.addAll(postFilters);
                        boolean bl = done = !newFiltersFound;
                        if (newFiltersFound) continue;
                        done = true;
                        continue;
                    }
                    done = true;
                }
            }
            catch (IQueryServicesException e) {
                if (!_logger.isEnabled(Level.WARN)) break block4;
                _logger.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return new ArrayList<FilterItem>(effectiveFilters);
    }

    public void setFilters(List inputFilters) throws MetadataException {
        boolean OK = IQModelImplUtilities.objectsAreOfTypes(inputFilters = ListUtils.newList(inputFilters), VALID_TYPES_FILTER_IMPLS);
        if (!OK) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplAllObjectsNotFilterObjects.txt", new Object[0]));
        }
        if (!this.isActionSupported(BusinessQueryActionType.FILTER_ITEM)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplFilterNotEnabled.txt", new Object[0]));
        }
        for (FilterItem item : this.filters) {
            item.removeListener(this);
        }
        this.filters = inputFilters;
        for (FilterItem item : this.filters) {
            item.addListener(this);
        }
        this.fireChangeEvent("The list of filters has changed");
    }

    @Override
    public List<DataItem> getSortOrderPrecedence() {
        return ListUtils.newList(this.sortOrderPrecedence);
    }

    public void setSortOrderPrecedence(List inputPrecedence) throws MetadataException {
        boolean OK = IQModelImplUtilities.objectsAreOfTypes(inputPrecedence = ListUtils.newList(inputPrecedence), VALID_TYPES_DATA_ITEM_IMPLS);
        if (!OK) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplAllObjectsNotDataItem.txt", new Object[0]));
        }
        if (!this.isActionSupported(BusinessQueryActionType.SORT_ORDER_PRECEDENCE)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplSortOrderPrecedenceNotSupported.txt", new Object[0]));
        }
        this.sortOrderPrecedence = inputPrecedence;
        this.fireChangeEvent("The sort order list has changed");
    }

    @Override
    public List<DataItem> getSortItems() {
        return this.getEffectiveSortOrderPrecedence();
    }

    @Override
    public List<DataItem> getEffectiveSortOrderPrecedence() {
        return this.getEffectiveSortOrderPrecedence(this.getSortOrderPrecedence());
    }

    protected List<DataItem> getEffectiveSortOrderPrecedence(List<? extends DataItem> virtualSortOrder) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("<< DataSelectionImpl.getEffectiveSortOrderPrecedence()");
            _logger.debug("Virtual sort order found: " + IQModelImplUtilities.toString(virtualSortOrder));
        }
        HashMap<DataItem, SelectedItem> virtualDataItemToSelectedItemMap = new HashMap<DataItem, SelectedItem>();
        List<SelectedItem> selectedItemsList = this.getSelectedItems();
        for (SelectedItem selectedItem : selectedItemsList) {
            DataItem dataItem = selectedItem.getItem();
            DataItemActionType sortDirection = null;
            try {
                sortDirection = dataItem.getSortDirection();
            }
            catch (MetadataUnresolvedException metadataUnresolvedException) {
                // empty catch block
            }
            if (sortDirection == null || sortDirection.equals(DataItemActionType.SORT_NONE)) continue;
            DataItem di = dataItem;
            boolean done = false;
            while (!virtualSortOrder.contains(di) && !done) {
                if (di instanceof DataItemReferenceImpl) {
                    DataItemReferenceImpl diri = (DataItemReferenceImpl)di;
                    if (diri.isEquivalentToParent()) {
                        di = diri.getBaseDataItem();
                        if (di != null) continue;
                        done = true;
                        continue;
                    }
                    done = true;
                    continue;
                }
                done = true;
            }
            if (!virtualSortOrder.contains(di)) continue;
            virtualDataItemToSelectedItemMap.put(di, selectedItem);
        }
        ArrayList<DataItem> sortOnTheseItems = new ArrayList<DataItem>();
        for (DataItem dataItem : virtualSortOrder) {
            SelectedItem mappedItem = (SelectedItem)virtualDataItemToSelectedItemMap.get(dataItem);
            if (mappedItem != null) {
                sortOnTheseItems.add(mappedItem.getItem());
                continue;
            }
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug("Did not find an equivalent result item for : " + dataItem.getIdentityString());
        }
        for (SelectedItem selectedItem : selectedItemsList) {
            DataItem di = selectedItem.getItem();
            DataItemActionType sortDirection = null;
            try {
                sortDirection = di.getSortDirection();
            }
            catch (MetadataUnresolvedException metadataUnresolvedException) {
                // empty catch block
            }
            if (sortDirection == null || sortDirection.equals(DataItemActionType.SORT_NONE) || sortOnTheseItems.contains(di)) continue;
            sortOnTheseItems.add(di);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Actual sort order: " + Utils.toString(sortOnTheseItems));
        }
        return sortOnTheseItems;
    }

    @Override
    public void setSortCriteria(List<? extends Object> criteria, Role businessSortRole) throws MetadataException {
        if (!this.isActionSupported(BusinessQueryActionType.SORT_CRITERIA)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplSortCriteriaNotSupported.txt", new Object[0]));
        }
        if (criteria == null) {
            criteria = new ArrayList<Object>();
        }
        if (businessSortRole == Role.COLUMN) {
            this.sortColumnCriteria = ListUtils.newList(criteria);
        } else if (businessSortRole == Role.ROW) {
            this.sortRowCriteria = ListUtils.newList(criteria);
        } else if (businessSortRole == null) {
            this.sortColumnCriteria = ListUtils.newList(criteria);
        } else {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryImplSortCriteriaRoleError.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this.fireChangeEvent("Olap sort criteria has changed");
    }

    @Override
    public List<Object> getSortCriteria(Role businessSortRole) {
        if (businessSortRole == Role.COLUMN) {
            return ListUtils.newList(this.sortColumnCriteria);
        }
        if (businessSortRole == Role.ROW) {
            return ListUtils.newList(this.sortRowCriteria);
        }
        if (businessSortRole == null) {
            return ListUtils.newList(this.sortColumnCriteria);
        }
        if (_logger.isEnabled(Level.ERROR)) {
            _logger.error(IQModelImplUtilities.getMessage("BusinessQueryImplSortCriteriaRoleError.txt", new Object[0]));
        }
        return new ArrayList<Object>();
    }

    @Override
    public BusinessQueryActionType getSortDirection(Role businessSortRole) {
        if (businessSortRole == Role.COLUMN) {
            return this.sortColumnDirection;
        }
        if (businessSortRole == Role.ROW) {
            return this.sortRowDirection;
        }
        if (businessSortRole == null) {
            return this.sortColumnDirection;
        }
        if (_logger.isEnabled(Level.ERROR)) {
            _logger.error(IQModelImplUtilities.getMessage("BusinessQueryImplSortCriteriaRoleError.txt", new Object[0]));
        }
        return BusinessQueryActionType.SORT_NONE;
    }

    @Override
    public void setSortDirection(BusinessQueryActionType sortDirection, Role businessSortRole) throws MetadataException {
        if (!this.isActionSupported(sortDirection)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplSortDirectionNotSupported.txt", new Object[0]));
        }
        if (businessSortRole == Role.COLUMN) {
            this.sortColumnDirection = sortDirection;
        } else if (businessSortRole == Role.ROW) {
            this.sortRowDirection = sortDirection;
        } else if (businessSortRole == null) {
            this.sortColumnDirection = sortDirection;
        } else {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryImplSortCriteriaRoleError.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this.fireChangeEvent("Olap sort direction has changed");
    }

    @Override
    public void setTotalType(String totalingType, Role businessTotalRole) throws MetadataException {
        this.setTotalingType(TotalingType.fromValue(totalingType), businessTotalRole);
    }

    @Override
    public void setTotalingType(TotalingType totalingType, Role businessTotalRole) throws MetadataException {
        if (!this.isActionSupported(BusinessQueryActionType.TOTAL)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplTotalingNotSupported.txt", new Object[0]));
        }
        if (businessTotalRole == Role.COLUMN) {
            this.totalColumnType = totalingType;
        } else if (businessTotalRole == Role.ROW) {
            this.totalRowType = totalingType;
        } else if (businessTotalRole == null) {
            this.totalColumnType = totalingType;
        } else {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryImplTotalingRoleError.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this.fireChangeEvent("The totaling of result items has changed");
    }

    @Override
    public String getTotalType(Role businessTotalRole) {
        TotalingType totallingType = this.getTotalingType(businessTotalRole);
        return totallingType == null ? null : totallingType.getTotalType();
    }

    @Override
    public TotalingType getTotalingType(Role businessTotalRole) {
        if (businessTotalRole == Role.COLUMN) {
            return this.totalColumnType;
        }
        if (businessTotalRole == Role.ROW) {
            return this.totalRowType;
        }
        if (businessTotalRole == null) {
            return this.totalColumnType;
        }
        return TotalingType.TOTAL_NONE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setTotalLabel(String totalLabel, Role businessTotalRole, String typeOfTotal) throws IllegalArgumentException {
        block16: {
            block18: {
                block17: {
                    if (businessTotalRole != Role.COLUMN) break block17;
                    if (typeOfTotal.equals(BusinessQuery.ALLTOTAL)) {
                        this.grandTotalColumnLabel = totalLabel;
                        this.subTotalColumnLabel = totalLabel;
                        break block16;
                    } else if (typeOfTotal.equals(BusinessQuery.GRANDTOTAL) || typeOfTotal.equals(BusinessQuery.AXISTOTAL)) {
                        this.grandTotalColumnLabel = totalLabel;
                        break block16;
                    } else {
                        if (!typeOfTotal.equals(BusinessQuery.SUBTOTAL)) {
                            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryImplInvalidTotalLabel.txt", new Object[0]);
                            _logger.error((Object)msg);
                            throw new IQueryServicesIllegalArgumentException(msg);
                        }
                        this.subTotalColumnLabel = totalLabel;
                    }
                    break block16;
                }
                if (businessTotalRole != Role.ROW) break block18;
                if (typeOfTotal.equals(BusinessQuery.ALLTOTAL)) {
                    this.grandTotalRowLabel = totalLabel;
                    this.subTotalRowLabel = totalLabel;
                    break block16;
                } else if (typeOfTotal.equals(BusinessQuery.GRANDTOTAL) || typeOfTotal.equals(BusinessQuery.AXISTOTAL)) {
                    this.grandTotalRowLabel = totalLabel;
                    break block16;
                } else {
                    if (!typeOfTotal.equals(BusinessQuery.SUBTOTAL)) {
                        MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryImplInvalidTotalLabel.txt", new Object[0]);
                        _logger.error((Object)msg);
                        throw new IQueryServicesIllegalArgumentException(msg);
                    }
                    this.subTotalRowLabel = totalLabel;
                }
                break block16;
            }
            if (businessTotalRole != null) {
                MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryImplTotalingRoleError.txt", new Object[0]);
                _logger.error((Object)msg);
                throw new IQueryServicesIllegalArgumentException(msg);
            }
            if (typeOfTotal.equals(BusinessQuery.ALLTOTAL)) {
                this.grandTotalColumnLabel = totalLabel;
                this.subTotalColumnLabel = totalLabel;
            } else if (typeOfTotal.equals(BusinessQuery.GRANDTOTAL) || typeOfTotal.equals(BusinessQuery.AXISTOTAL)) {
                this.grandTotalColumnLabel = totalLabel;
            } else {
                if (!typeOfTotal.equals(BusinessQuery.SUBTOTAL)) {
                    MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryImplInvalidTotalLabel.txt", new Object[0]);
                    _logger.error((Object)msg);
                    throw new IQueryServicesIllegalArgumentException(msg);
                }
                this.subTotalColumnLabel = totalLabel;
            }
        }
        this.fireChangeEvent("The total label of result items has changed");
    }

    @Override
    public void setTotalLocation(BusinessQueryTotalLocationType totalLocation) throws IllegalArgumentException {
        if (totalLocation == null) {
            totalLocation = BusinessQueryTotalLocationType.TOTAL_ROW_BOTTOM_COLUMN_RIGHT;
        }
        if (!(totalLocation.equals(BusinessQueryTotalLocationType.TOTAL_ROW_BOTTOM_COLUMN_RIGHT) || totalLocation.equals(BusinessQueryTotalLocationType.TOTAL_TOTAL_ROW_TOP_COLUMN_LEFT) || totalLocation.equals(BusinessQueryTotalLocationType.TOTAL_PARENT_PLACEHOLDER))) {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryImplTotalingLocationError.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        if (this.totalLocation != totalLocation) {
            this.totalLocation = totalLocation;
            this.fireChangeEvent("Placement of totals have changed.");
        }
    }

    @Override
    public void setTotalMode(BusinessQueryTotalModeType totalMode) throws IllegalArgumentException {
        this.totalMode = totalMode;
        this.fireChangeEvent("The totaling mode for query has changed");
    }

    @Override
    public void setAxisValuesCoalesced(boolean coalescedIndicator) {
        this.coalescedIndicator = coalescedIndicator;
    }

    @Override
    public BusinessQueryTotalLocationType getTotalLocation() {
        return this.totalLocation;
    }

    @Override
    public BusinessQueryTotalModeType getTotalMode() {
        return this.totalMode;
    }

    @Override
    public String getTotalLabel(Role businessTotalRole, String typeOfTotal) {
        if (businessTotalRole == Role.COLUMN) {
            if (typeOfTotal.equals(BusinessQuery.ALLTOTAL)) {
                return this.getGrandTotalColumnLabel();
            }
            if (typeOfTotal.equals(BusinessQuery.GRANDTOTAL) || typeOfTotal.equals(BusinessQuery.AXISTOTAL)) {
                return this.getGrandTotalColumnLabel();
            }
            if (typeOfTotal.equals(BusinessQuery.SUBTOTAL)) {
                return this.getSubTotalColumnLabel();
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQModelImplUtilities.getMessage("BusinessQueryImplInvalidTotalLabel.txt", new Object[0]));
            }
            return " ";
        }
        if (businessTotalRole == Role.ROW) {
            if (typeOfTotal.equals(BusinessQuery.ALLTOTAL)) {
                return this.getGrandTotalRowLabel();
            }
            if (typeOfTotal.equals(BusinessQuery.GRANDTOTAL) || typeOfTotal.equals(BusinessQuery.AXISTOTAL)) {
                return this.getGrandTotalRowLabel();
            }
            if (typeOfTotal.equals(BusinessQuery.SUBTOTAL)) {
                return this.getSubTotalRowLabel();
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQModelImplUtilities.getMessage("BusinessQueryImplInvalidTotalLabel.txt", new Object[0]));
            }
            return " ";
        }
        if (businessTotalRole == null) {
            if (typeOfTotal.equals(BusinessQuery.ALLTOTAL)) {
                return this.getGrandTotalColumnLabel();
            }
            if (typeOfTotal.equals(BusinessQuery.GRANDTOTAL) || typeOfTotal.equals(BusinessQuery.AXISTOTAL)) {
                return this.getGrandTotalColumnLabel();
            }
            if (typeOfTotal.equals(BusinessQuery.SUBTOTAL)) {
                return this.getSubTotalColumnLabel();
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQModelImplUtilities.getMessage("BusinessQueryImplInvalidTotalLabel.txt", new Object[0]));
            }
            return " ";
        }
        return "";
    }

    private String getGrandTotalRowLabel() {
        return this.grandTotalRowLabel != null ? this.grandTotalRowLabel : IQModelImplUtilities.getMessage("BusinessQueryImplGrandTotalLabel.txt", new Object[0]);
    }

    private String getGrandTotalColumnLabel() {
        return this.grandTotalColumnLabel != null ? this.grandTotalColumnLabel : IQModelImplUtilities.getMessage("BusinessQueryImplGrandTotalLabel.txt", new Object[0]);
    }

    private String getSubTotalRowLabel() {
        return this.subTotalRowLabel != null ? this.subTotalRowLabel : IQModelImplUtilities.getMessage("BusinessQueryImplSubTotalLabel.txt", new Object[0]);
    }

    private String getSubTotalColumnLabel() {
        return this.subTotalColumnLabel != null ? this.subTotalColumnLabel : IQModelImplUtilities.getMessage("BusinessQueryImplSubTotalLabel.txt", new Object[0]);
    }

    @Override
    public void setSolveOrderPrecedence(List<? extends DataItem> solveOrderPrecedence) {
        String msg = IQModelImplUtilities.getMessage("DataSelectionImpl.SettingSolveOrderPrecedenceNotImplemented.txt", new Object[0]);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public List<DataItem> getSolveOrderPrecedence() {
        return Collections.emptyList();
    }

    @Override
    public boolean getQueryProperty(BusinessQueryProperty key) {
        if (key == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplkeyNull.txt", new Object[0]));
        }
        Boolean value = this.queryProperties.get(key);
        if (value == null) {
            return false;
        }
        return value;
    }

    QueryProperties getQueryProperties() {
        return this.queryProperties;
    }

    public Map<BusinessQueryProperty, Boolean> getProperties() {
        return this.queryProperties.getProperties();
    }

    @Override
    public void setQueryProperty(BusinessQueryProperty key, boolean value) throws MetadataException {
        this.setQueryPropertyCheck(key, value);
        if (this.queryProperties.set(key, value)) {
            this.fireChangeEvent("A query property has changed");
        }
    }

    protected void setQueryPropertyCheck(BusinessQueryProperty key, boolean value) throws MetadataException {
        if (key == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplQueryPropertyNoNull.txt", new Object[0]));
        }
        if (key == BusinessQueryProperty.RETURN_DISTINCT_VALUES && !this.isActionSupported(BusinessQueryActionType.PROPERTY_RETURN_DISTINCT_VALUES)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplPROPERTY_RETURN_DISTINCT_VALUESNotSupported.txt", new Object[0]));
        }
        if (key == BusinessQueryProperty.EXCLUDE_EMPTY_DATA && !this.isActionSupported(BusinessQueryActionType.PROPERTY_EXCLUDE_EMPTY_DATA)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplPROPERTY_EXCLUDE_EMPTY_DATANotSupported.txt", new Object[0]));
        }
        if (key == BusinessQueryProperty.RETURN_UNFORMATTED_DATA && !this.isActionSupported(BusinessQueryActionType.PROPERTY_RETURN_UNFORMATTED_DATA)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplPROPERTY_RETURN_UNFORMATTED_DATANotSupported.txt", new Object[0]));
        }
        if (key == BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION && !this.isActionSupported(BusinessQueryActionType.PROPERTY_INLINE_SETOPERATIONDATASELECTION)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplPROPERTY_INLINE_SETOPERATIONDATASELECTION.txt", new Object[0]));
        }
        if (key == BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS && !this.isActionSupported(BusinessQueryActionType.PROPERTY_EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplPROPERTY_EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS.txt", new Object[0]));
        }
        if (key == BusinessQueryProperty.JOIN_PATH_OPTIMIZATIONS_DISABLED && !this.isActionSupported(BusinessQueryActionType.PROPERTY_JOIN_PATH_OPTIMIZATIONS_DISABLED)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImpl.PROPERTY_JOIN_PATH_OPIMIZATIONS_DISABLED.NotSupported.txt", new Object[0]));
        }
    }

    @Override
    public String getEmptyDataFormat() {
        return this.emptyDataFormat;
    }

    @Override
    public void setEmptyDataFormat(String replacementString) throws MetadataException {
        if (replacementString == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplNullEmptyData.txt", new Object[0]));
        }
        if (!this.isActionSupported(BusinessQueryActionType.FORMAT_EMPTY)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplFORMAT_EMPTYNotSupported.txt", new Object[0]));
        }
        this.emptyDataFormat = replacementString;
        this.fireChangeEvent("The empty data format has changed");
    }

    protected List<String> getEventsThatCauseQueryDefinitionToChange() {
        return EVENTS_THAT_CAUSE_QUERY_DEFINITION_CHANGE;
    }

    @Override
    protected void fireChangeEvent(String eventID) {
        super.fireChangeEvent(eventID);
        List<String> events = this.getEventsThatCauseQueryDefinitionToChange();
        if (events.contains(eventID)) {
            super.fireChangeEvent("The query's definition has changed and may cause different resultset results since prior to the definition change.");
        }
    }

    @Override
    public void addResultItem(@Nonnull DataItem dataItem, Role role) throws MetadataException {
        Preconditions.ensureNonNull(dataItem, _logger);
        if (!this.isActionSupported(BusinessQueryActionType.RESULT_ITEM)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplAddResultItemNotEnabled.txt", new Object[0]));
        }
        this.warnOfPotentialIllegalModelUsage(dataItem);
        this.addDataItemToSelectedItems(dataItem, role);
        this.rebuildCachedItems();
        this.fireChangeEvent("The list of result items has changed");
    }

    @Override
    public void addResultItems(List<? extends DataItem> dataItems, Role role) throws MetadataException {
        Preconditions.ensureNonNull(dataItems, _logger);
        Preconditions.ensureNonNullTypedElements(dataItems, DataItem.class, _logger);
        if (!this.isActionSupported(BusinessQueryActionType.RESULT_ITEM)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplAddResultItemNotEnabled.txt", new Object[0]));
        }
        this.warnOfPotentialIllegalModelUsage(dataItems);
        for (DataItem dataItem : dataItems) {
            this.addDataItemToSelectedItems(dataItem, role);
        }
        this.rebuildCachedItems();
        this.fireChangeEvent("The list of result items has changed");
    }

    private void addDataItemToSelectedItems(DataItem dataItem, Role role) {
        SelectedItem newItem = new SelectedItem(dataItem, role);
        newItem.addListener(this);
        int index = this.getIndexOfSelectedItemFor(dataItem);
        if (index != -1) {
            this.selectedItems.set(index, newItem);
        } else {
            this.selectedItems.add(newItem);
        }
    }

    private boolean checkRelativeTimeMeasure() {
        boolean isTimePresent = false;
        boolean isValid = true;
        TimeExpressionMeasure timeExpressionMeasure = null;
        Role role = null;
        Role roleOfTimeMeasure = null;
        for (SelectedItem si : this.selectedItems) {
            DataItem dataItem = si.getItem();
            ExpressionInterface dataItemExpression = dataItem.getExpression();
            int dimType = 3;
            try {
                if (dataItem.getReasonsUnusable().size() != 0) continue;
                if (dataItemExpression instanceof TimeExpressionMeasure) {
                    timeExpressionMeasure = (TimeExpressionMeasure)dataItemExpression;
                    roleOfTimeMeasure = this.getResultItemRole(dataItem);
                } else if (dataItemExpression instanceof Hierarchy) {
                    Dimension omaDimension = ((Hierarchy)dataItemExpression).getOwningDimension();
                    dimType = omaDimension.getDimensionType();
                } else if (dataItemExpression instanceof ResourceAwareStringExpression && !dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE) && (dimType = BusinessQueryOLAPUtil.getDimensionType(dataItem, (Object)dataItemExpression)) == 1) {
                    dimType = 0;
                }
                if (dimType != 0) continue;
                isTimePresent = true;
                role = this.getResultItemRole(dataItem);
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("DataSelectionImplTimeMeasureCheckFailure.txt"), (Throwable)e);
                }
                isValid = false;
                break;
            }
        }
        if (isValid && roleOfTimeMeasure != null) {
            if (timeExpressionMeasure != null && !isTimePresent) {
                isValid = false;
            } else if (!Role.isOutputResultRole(this, role) && Role.isOutputResultRole(this, roleOfTimeMeasure)) {
                isValid = false;
            }
        }
        return isValid;
    }

    @Override
    public void insertResultItemsAt(DataItem dataItem, Role role, int index) throws MetadataException {
        if (dataItem == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplMapItemNull.txt", new Object[0]));
        }
        if (index < 0) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplIndexValueZero.txt", new Object[0]));
        }
        if (!this.isActionSupported(BusinessQueryActionType.RESULT_ITEM)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplAddResultItemNotEnabled.txt", new Object[0]));
        }
        this.insertSelectedItemAt(new SelectedItem(dataItem, role), index);
    }

    @Override
    public void insertSelectedItemAt(SelectedItem item, int index) throws MetadataException {
        if (item == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplMapItemNull.txt", new Object[0]));
        }
        if (index < 0) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplIndexValueZero.txt", new Object[0]));
        }
        if (!this.isActionSupported(BusinessQueryActionType.RESULT_ITEM)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplAddResultItemNotEnabled.txt", new Object[0]));
        }
        DataItem dataItem = item.getItem();
        int indexOf = this.getIndexOfSelectedItemFor(dataItem);
        if (indexOf == -1) {
            int numOfItems = this.selectedItems.size();
            if (index <= numOfItems) {
                this.selectedItems.add(index, item);
            } else {
                this.selectedItems.add(item);
            }
        } else {
            MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("BusinessQueryImplDataItemExist.fmt.txt", dataItem.getIdentityString());
            throw new MetadataException(messageFormatter);
        }
        item.addListener(this);
        this.rebuildCachedItems();
        this.fireChangeEvent("The list of result items has changed");
    }

    @Override
    public void removeResultItem(@Nonnull DataItem dataItem) throws MetadataException {
        Preconditions.ensureNonNull(dataItem);
        if (!this.isActionSupported(BusinessQueryActionType.RESULT_ITEM)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplAddResultItemNotEnabled.txt", new Object[0]));
        }
        this.removeSelectedItem(dataItem);
        this.rebuildCachedItems();
        this.fireChangeEvent("The list of result items has changed");
    }

    @Override
    public void removeResultItems(List<? extends DataItem> dataItems) throws MetadataException {
        dataItems = ListUtils.newList(dataItems);
        if (!this.isActionSupported(BusinessQueryActionType.RESULT_ITEM)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplAddResultItemNotEnabled.txt", new Object[0]));
        }
        for (DataItem dataItem : dataItems) {
            this.removeSelectedItem(dataItem);
        }
        this.rebuildCachedItems();
        this.fireChangeEvent("The list of result items has changed");
    }

    @Override
    public void removeSelectedItem(@Nonnull SelectedItem item) throws MetadataException {
        Preconditions.ensureNonNull(item);
        this.removeSelectedItem(item.getItem());
        this.rebuildCachedItems();
        this.fireChangeEvent("The list of result items has changed");
    }

    private void removeSelectedItem(DataItem dataItem) {
        this.checkDataItemToBeDeletedForSteps(dataItem);
        int indexOf = this.getIndexOfSelectedItemFor(dataItem);
        if (indexOf != -1) {
            SelectedItem item = this.selectedItems.get(indexOf);
            item.removeListener(this);
            this.selectedItems.remove(indexOf);
        }
    }

    private void checkDataItemToBeDeletedForSteps(DataItem dataItem) {
        block9: {
            List<StepInterface> steps;
            Role role;
            block8: {
                role = null;
                steps = null;
                try {
                    role = this.getResultItemRole(dataItem);
                    if (role == Role.ROW || role == Role.COLUMN) {
                        steps = this.getSteps(role);
                    }
                }
                catch (MetadataException ee) {
                    steps = null;
                    if (!_logger.isEnabled(Level.ERROR)) break block8;
                    _logger.error(IQModelImplUtilities.getMessage("DataSelectionImplResultItemCantRemove.txt", new Object[0]), (Throwable)ee);
                }
            }
            if (steps != null && !steps.isEmpty() && (PersistenceUtilities.isUnresolved(dataItem, true) || dataItem.isCalculatedItem())) {
                try {
                    String diId = dataItem.getID();
                    ListIterator<StepInterface> iStep = steps.listIterator();
                    block4: while (iStep.hasNext()) {
                        StepInterface step = iStep.next();
                        List<DataItem> dataItemsInStep = step.getResources(DataItem.class, 65535);
                        for (DataItem stepdi : dataItemsInStep) {
                            String stepDiId = stepdi.getID();
                            if (!diId.equals(stepDiId)) continue;
                            iStep.remove();
                            continue block4;
                        }
                    }
                    this.setSteps(steps, role);
                }
                catch (MetadataException ee) {
                    if (!_logger.isEnabled(Level.ERROR)) break block9;
                    _logger.error(IQModelImplUtilities.getMessage("DataSelectionImplResultItemCantRemove.txt", new Object[0]), (Throwable)ee);
                }
            }
        }
    }

    @Override
    public void setResultItems(List<? extends DataItem> dataItems) throws MetadataException {
        dataItems = ListUtils.newList(dataItems);
        if (!this.isActionSupported(BusinessQueryActionType.RESULT_ITEM)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplAddResultItemNotEnabled.txt", new Object[0]));
        }
        for (SelectedItem selectedItem : this.selectedItems) {
            selectedItem.removeListener(this);
        }
        this.selectedItems.clear();
        for (DataItem dataItem : dataItems) {
            SelectedItem selectedItem = new SelectedItem(dataItem);
            selectedItem.addListener(this);
            this.selectedItems.add(selectedItem);
        }
        this.rebuildCachedItems();
        this.fireChangeEvent("The list of result items has changed");
    }

    @Override
    public void setSelectedItems(List<? extends SelectedItem> newSelectedItems) throws MetadataException {
        if (!this.isActionSupported(BusinessQueryActionType.RESULT_ITEM)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplAddResultItemNotEnabled.txt", new Object[0]));
        }
        if (newSelectedItems != null) {
            LinkedHashSet<DataItem> dataItemSet = new LinkedHashSet<DataItem>();
            for (SelectedItem selectedItem : newSelectedItems) {
                DataItem di = selectedItem.getItem();
                if (dataItemSet.add(di)) continue;
                MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("DataSelectionImpl.SetSelectedItems.DuplicateItem.fmt", di);
                throw new MetadataException(messageFormatter);
            }
        }
        for (SelectedItem selectedItem : this.selectedItems) {
            selectedItem.removeListener(this);
        }
        this.selectedItems.clear();
        if (newSelectedItems != null) {
            for (SelectedItem selectedItem : newSelectedItems) {
                selectedItem.addListener(this);
                this.selectedItems.add(selectedItem);
            }
        }
        this.rebuildCachedItems();
        this.fireChangeEvent("The list of result items has changed");
    }

    @Override
    public List<SelectedItem> getSelectedItems() {
        return new ArrayList<SelectedItem>(this.selectedItems);
    }

    @Override
    public List<SelectedItem> getSelectedItems(Role withThisRole) throws MetadataException {
        Object[] selectedItemsWithRole = (Object[])this.cachedSelectedItemsByRole.get(withThisRole);
        List<SelectedItem> results = selectedItemsWithRole != null ? ListUtils.newCOWList((List)selectedItemsWithRole[0]) : new ArrayList<SelectedItem>();
        return results;
    }

    @Override
    public List<DataItem> getResultItems() {
        return ListUtils.newCOWList(this.cachedResultItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataItem> getEffectiveResultItems() {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            List<DataItem> effectiveDataSources = effectiveObjectCache.getEffectiveResultItems(this);
            ArrayList<DataItem> arrayList = new ArrayList<DataItem>(effectiveDataSources);
            return arrayList;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public List<DataItem> getEffectiveResultItems(EffectiveObjectsCache effectiveObjectCache) {
        List<DataItem> returnValue;
        BusinessQuery parentQuery = this.getParentQuery();
        boolean ignoreParentEffectiveItems = this.getQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS);
        if (parentQuery == null || ignoreParentEffectiveItems) {
            returnValue = this.getResultItems();
        } else {
            List<DataItem> resultItems = this.getResultItems();
            returnValue = ListUtils.newList(resultItems);
            List<DataItem> parentResultItems = effectiveObjectCache.getEffectiveResultItems(parentQuery);
            for (DataItem item : parentResultItems) {
                if (returnValue.contains(item)) continue;
                boolean found = false;
                for (DataItem resultItem : resultItems) {
                    if (!(resultItem instanceof DataItemReference) || ((DataItemReference)resultItem).getBaseDataItem() != item) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                returnValue.add(item);
            }
        }
        return returnValue;
    }

    @Override
    public <T extends BusinessRule> List<T> getRelevantRules(@Nonnull Class<T> type) {
        return this.getEffectiveRules(type);
    }

    @Override
    public <T extends BusinessRule> List<T> getEffectiveRules(@Nonnull Class<T> type) {
        List<Object> returnList = new ArrayList();
        BusinessModel businessModel = this.getBusinessModel();
        if (Governing.class.isAssignableFrom(type) || DrillThroughToDetail.class.isAssignableFrom(type) || RequiredDataSources.class.isAssignableFrom(type)) {
            List<T> tmpList = businessModel.getObjects(false, type);
            BusinessModel parentModel = businessModel.getParentBusinessModel();
            while (parentModel != null && tmpList.size() == 0) {
                businessModel = parentModel;
                parentModel = businessModel.getParentBusinessModel();
                tmpList = businessModel.getObjects(false, type);
            }
            int len = tmpList.size();
            if (len > 0) {
                returnList.add((BusinessRule)tmpList.get(len - 1));
            }
        } else {
            returnList = businessModel.getObjects(true, type);
        }
        return returnList;
    }

    @Override
    public Role getResultItemRole(DataItem dataItem) throws MetadataException {
        Role returnValue = null;
        SelectedItem item = null;
        int indexOf = this.getIndexOfSelectedItemFor(dataItem);
        if (indexOf != -1) {
            item = this.selectedItems.get(indexOf);
        }
        if (item != null) {
            returnValue = item.getRole();
        } else if (this.getEffectiveResultItems().contains(dataItem)) {
            returnValue = Role.HIDDEN;
        }
        return returnValue;
    }

    @Override
    public void setResultItemRole(DataItem dataItem, Role role) throws MetadataException {
        if (dataItem == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplMapItemNull.txt", new Object[0]));
        }
        if (!this.isActionSupported(BusinessQueryActionType.RESULT_ITEM)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplAddResultItemNotEnabled.txt", new Object[0]));
        }
        SelectedItem selectedItem = null;
        int indexOf = this.getIndexOfSelectedItemFor(dataItem);
        if (indexOf != -1) {
            selectedItem = this.selectedItems.get(indexOf);
        }
        if (selectedItem == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplDataItemNotResult.txt", new Object[0]));
        }
        selectedItem.setRole(role);
        this.rebuildCachedItems();
    }

    @Override
    public List<DataItem> getResultItems(Role withThisRole) {
        Object[] selectedItemsWithRole = (Object[])this.cachedSelectedItemsByRole.get(withThisRole);
        List<DataItem> results = selectedItemsWithRole != null ? ListUtils.newCOWList((List)selectedItemsWithRole[1]) : new ArrayList<DataItem>();
        return results;
    }

    private int getIndexOfSelectedItemFor(DataItem dataItem) {
        int index = -1;
        int numOfItems = this.selectedItems.size();
        for (int lIndex = 0; lIndex < numOfItems && index == -1; ++lIndex) {
            SelectedItem item = this.selectedItems.get(lIndex);
            DataItem selectedDataItem = item.getItem();
            if (!selectedDataItem.equals(dataItem)) continue;
            index = lIndex;
        }
        return index;
    }

    @Override
    public StructureOfData getInputStructure() {
        return super.getStructure();
    }

    private void getReasonsFilterAssignmentsNotValid(List<Reason> reasons, StructureOfData inputStructure) {
        for (FilterItem filter : this.filters) {
            List<FractionOfTotalExpression> exprs = filter.getResources(FractionOfTotalExpression.class, 65535);
            for (FractionOfTotalExpression fote : exprs) {
                String filterText = filter.getIdentityString();
                String filterExpressionText = "" + filter.getExpression();
                String offendingFoTText = "" + fote;
                try {
                    filterExpressionText = StringExpressionUtil.getInstance().getReadableText(filter.getExpression());
                }
                catch (MetadataException e) {
                    _logger.warn("MetadataException encountered getting StringExpression for FOT.");
                }
                Reason reason = new Reason((Object)filter, 4, 112, "DataSelectionImpl.Filters.FractionOfTotal.fmt.txt", filterText, filterExpressionText, offendingFoTText);
                reasons.add(reason);
            }
        }
        if (inputStructure.isOLAP()) {
            IdentityList filterBySelectedItem = new IdentityList();
            for (FilterItem filter : this.filters) {
                boolean foundMatchingDataItem = false;
                List<DataItem> filterDataItems = filter.getDataItems(0);
                for (DataItem filterDataItem : filterDataItems) {
                    List<Reason> dataItemReasons = filterDataItem.getReasonsUnusable();
                    if (dataItemReasons.isEmpty()) {
                        ExpressionInterface filterExpression;
                        while (filterDataItem instanceof DataItemReference) {
                            filterDataItem = ((DataItemReference)filterDataItem).getBaseDataItem();
                        }
                        List<SelectedItem> sItems = this.getSelectedItems();
                        Iterator<SelectedItem> resultIterator = sItems.iterator();
                        while (resultIterator.hasNext() && !foundMatchingDataItem) {
                            SelectedItem resultItem = resultIterator.next();
                            DataItem resultDataItem = resultItem.getItem();
                            while (resultDataItem instanceof DataItemReference) {
                                resultDataItem = ((DataItemReference)resultDataItem).getBaseDataItem();
                            }
                            if (resultDataItem != filterDataItem) continue;
                            foundMatchingDataItem = true;
                        }
                        if (!foundMatchingDataItem || (!((filterExpression = filter.getExpression()) instanceof MemberFilterExpression) || filterExpression instanceof BusinessGroupMemberFilterExpression) && !(filterExpression instanceof TimeFilterFirstLastPeriodsExpression) && !(filterExpression instanceof TimeFilterNParallelPeriodsExpression) && !(filterExpression instanceof TimeFilterNPeriodsExpression) && !(filterExpression instanceof TimeRangeFilterExpression)) continue;
                        if (!filterBySelectedItem.contains(filterDataItem)) {
                            filterBySelectedItem.add(filterDataItem);
                            continue;
                        }
                        Reason reason = new Reason((Object)filterDataItem, 4, 232, "DataSelectionImplOneFilterPerDataItem.fmt.txt", filterDataItem.getLabel());
                        reasons.add(reason);
                        continue;
                    }
                    reasons.addAll(dataItemReasons);
                }
            }
        }
    }

    private void getReasonsRoleAssignmentsNotValid(List<Reason> reasons, StructureOfData inputStructure) {
        List<SelectedItem> selectedItemsList = this.getSelectedItems();
        Iterator<SelectedItem> iterator = selectedItemsList.iterator();
        if (inputStructure.isRelational()) {
            Role measureRole = null;
            int rowCount = 0;
            int columnCount = 0;
            while (iterator.hasNext()) {
                Reason reason;
                boolean testForMeasureRoleDiff;
                SelectedItem selectedItem = iterator.next();
                Role role = selectedItem.getRole();
                DataItem dataItem = selectedItem.getItem();
                boolean isMeasure = dataItem.getUsage() == DataItemActionType.USAGE_AGGREGATE;
                boolean bl = testForMeasureRoleDiff = isMeasure && role != null && !Role.isInactiveRole(this, role);
                if (role != null && role != Role.COLUMN && role != Role.ROW && role != Role.BACKGROUND && role != Role.HIDDEN) {
                    reason = new Reason((Object)selectedItem.getItem(), 3, 10, "BusinessQueryImplRoleError.txt", new Object[0]);
                    reasons.add(reason);
                } else if (testForMeasureRoleDiff && role != null) {
                    if (measureRole == Role.HIDDEN || measureRole == null) {
                        measureRole = role;
                    } else if (role != Role.HIDDEN && role != measureRole) {
                        reason = new Reason((Object)dataItem, 3, 11, "BusinessQueryImplRoleToRoleError.txt", (Object[])null);
                        reasons.add(reason);
                    }
                }
                if (role == Role.COLUMN) {
                    ++columnCount;
                    continue;
                }
                if (role != Role.ROW) continue;
                ++rowCount;
            }
            if (rowCount > 0) {
                Reason reason;
                if (columnCount == 0) {
                    reason = new Reason(null, 3, 17, "BusinessQueryImplRoleOrderError.txt", (Object[])null);
                    reasons.add(reason);
                }
                if (measureRole == null || !Role.isOutputResultRole(this, measureRole)) {
                    reason = new Reason(null, 3, 204, "DataSelectionImpl.NoROLAPMeasure.txt", (Object[])null);
                    reasons.add(reason);
                }
            }
        } else if (inputStructure.isOLAP()) {
            HashMap<String, DataItemsReasonsHolder> dataItemDimMap;
            HashMap<String, Role> dimensionMap;
            boolean inMeasureDimension;
            String dimensionName;
            Role role;
            DataItem dataItem;
            block30: {
                dataItem = null;
                role = null;
                dimensionName = null;
                inMeasureDimension = false;
                dimensionMap = new HashMap<String, Role>();
                dataItemDimMap = new HashMap();
                try {
                    dataItemDimMap = this.getDataItemDimMap(selectedItemsList);
                }
                catch (MetadataException e1) {
                    if (!_logger.isEnabled(Level.WARN)) break block30;
                    _logger.warn(e1.getLocalizedMessage(), (Throwable)e1);
                }
            }
            int columnCount = 0;
            int rowCount = 0;
            while (iterator.hasNext()) {
                Reason reason;
                SelectedItem selectedItem = iterator.next();
                dataItem = selectedItem.getItem();
                role = selectedItem.getRole();
                if (role == Role.COLUMN) {
                    ++columnCount;
                } else if (role == Role.ROW) {
                    ++rowCount;
                } else if (role == Role.PAGE) {
                    Reason reason2 = new Reason((Object)dataItem, 3, 97, "BusinessQueryImplPageRoleError.txt", (Object[])null);
                    reasons.add(reason2);
                }
                try {
                    dimensionName = BusinessQueryOLAPUtil.getDimensionName(this, dataItem);
                    inMeasureDimension = BusinessQueryOLAPUtil.isInMeasureDimension(this, dataItem);
                    if (dimensionMap.containsKey(dimensionName)) {
                        Reason reason3;
                        String itemLabels;
                        if (!inMeasureDimension) {
                            if (this.isReasonCreated(dataItem, dimensionName, 12, dataItemDimMap)) continue;
                            String itemLabels2 = this.getDataItemLabels(dimensionName, dataItemDimMap);
                            reason = new Reason((Object)dataItem, 3, 12, "BusinessQueryImplRoleMeasureError.fmt.txt", itemLabels2);
                            reasons.add(reason);
                            this.addReasonToMap(reason, dataItem, dimensionName, dataItemDimMap);
                            continue;
                        }
                        Role existingRole = (Role)dimensionMap.get(dimensionName);
                        if (!(existingRole != Role.BACKGROUND && role != Role.BACKGROUND || role == Role.HIDDEN || this.isReasonCreated(dataItem, dimensionName, 14, dataItemDimMap))) {
                            itemLabels = this.getDataItemLabels(dimensionName, dataItemDimMap);
                            reason3 = new Reason((Object)dataItem, 3, 14, "BusinessQueryImplRoleOneMeasureError.fmt.txt", itemLabels);
                            reasons.add(reason3);
                            this.addReasonToMap(reason3, dataItem, dimensionName, dataItemDimMap);
                        }
                        if (!(role == null && existingRole == null || role == Role.HIDDEN || role == existingRole || this.isReasonCreated(dataItem, dimensionName, 11, dataItemDimMap))) {
                            itemLabels = this.getDataItemLabels(dimensionName, dataItemDimMap);
                            reason3 = new Reason((Object)dataItem, 3, 11, "BusinessQueryImplRoleToRoleError.fmt.txt", itemLabels);
                            reasons.add(reason3);
                            this.addReasonToMap(reason3, dataItem, dimensionName, dataItemDimMap);
                        }
                        if (role != null && existingRole == null) {
                            dimensionMap.put(dimensionName, role);
                        }
                    }
                }
                catch (MetadataException e) {
                    reason = new Reason((Object)dataItem, 3, 0, e);
                    reasons.add(reason);
                }
                if (role == Role.HIDDEN) continue;
                dimensionMap.put(dimensionName, role);
            }
            if (rowCount > 0 && columnCount == 0) {
                Reason reason = new Reason(null, 3, 17, "BusinessQueryImplRoleOrderError.txt", (Object[])null);
                reasons.add(reason);
            }
        }
    }

    private String getDataItemLabels(String dimensionName, Map<String, DataItemsReasonsHolder> dataItemDimMap) {
        StringBuffer sb = new StringBuffer();
        DataItemsReasonsHolder drh = dataItemDimMap.get(dimensionName);
        List dataItems = drh.getDataItems();
        Iterator iter = dataItems.iterator();
        while (iter.hasNext()) {
            DataItem item = (DataItem)iter.next();
            sb.append(iter.hasNext() ? item.getLabel() + ", " : item.getLabel());
        }
        return sb.toString();
    }

    private void addReasonToMap(Reason reason, DataItem dataItem, String dimensionName, Map<String, DataItemsReasonsHolder> dataItemDimMap) {
        DataItemsReasonsHolder drh = dataItemDimMap.get(dimensionName);
        List reasonList = drh.getReasons();
        reasonList.add(reason);
    }

    private boolean isReasonCreated(DataItem dataItem, String dimensionName, int subReason, Map<String, DataItemsReasonsHolder> dataItemDimMap) {
        boolean isReasonCreated = false;
        if (dataItemDimMap.containsKey(dimensionName)) {
            DataItemsReasonsHolder drh = dataItemDimMap.get(dimensionName);
            List dataItems = drh.getDataItems();
            List reasons = drh.getReasons();
            if (dataItems.contains(dataItem)) {
                for (Reason reason : reasons) {
                    if (subReason != reason.getSubReason()) continue;
                    isReasonCreated = true;
                    break;
                }
            }
        }
        return isReasonCreated;
    }

    private Map<String, DataItemsReasonsHolder> getDataItemDimMap(List<? extends SelectedItem> selectedItemsList) throws MetadataException {
        HashMap<String, DataItemsReasonsHolder> dataItemDimMap = new HashMap<String, DataItemsReasonsHolder>();
        for (SelectedItem selectedItem : selectedItemsList) {
            List dataItems;
            DataItemsReasonsHolder drh;
            DataItem dataItem = selectedItem.getItem();
            String dimName = BusinessQueryOLAPUtil.getDimensionName(dataItem.getBusinessModel(), dataItem);
            if (dataItemDimMap.containsKey(dimName)) {
                drh = (DataItemsReasonsHolder)dataItemDimMap.get(dimName);
                dataItems = drh.getDataItems();
                dataItems.add(dataItem);
                continue;
            }
            drh = new DataItemsReasonsHolder();
            dataItems = drh.getDataItems();
            dataItems.add(dataItem);
            dataItemDimMap.put(dimName, drh);
        }
        return dataItemDimMap;
    }

    private void getReasonsFractionOfTotalsNotValid(List<Reason> reasons, StructureOfData inputStructure) {
        List<DataItem> resultItemsList = this.getResultItems();
        List<SelectedItem> selectedItemsList = this.getSelectedItems();
        Iterator<SelectedItem> iterator = selectedItemsList.iterator();
        if (inputStructure.isRelational()) {
            boolean isRolap = false;
            HashMap<SelectedItem, List<FractionOfTotalExpression>> fractionOfTotalItems = null;
            while (iterator.hasNext()) {
                DataItem dataItem;
                List<FractionOfTotalExpression> foteList;
                SelectedItem selectedItem = iterator.next();
                Role role = selectedItem.getRole();
                if (role == Role.ROW && !isRolap) {
                    isRolap = true;
                }
                if (role == Role.BACKGROUND || Role.isInactiveRole(this, role) || (foteList = this.getFractionOfTotalItems(dataItem = selectedItem.getItem())) == null) continue;
                if (fractionOfTotalItems == null) {
                    fractionOfTotalItems = new HashMap<SelectedItem, List<FractionOfTotalExpression>>();
                }
                fractionOfTotalItems.put(selectedItem, foteList);
            }
            if (fractionOfTotalItems != null) {
                for (Map.Entry entry : fractionOfTotalItems.entrySet()) {
                    SelectedItem foteSelectedItem = (SelectedItem)entry.getKey();
                    DataItem dataItem = foteSelectedItem.getItem();
                    List foteList = (List)entry.getValue();
                    String dataitemText = dataItem.getIdentityString();
                    String expressionText = null;
                    try {
                        expressionText = StringExpressionUtil.getInstance().getReadableText(dataItem.getExpression());
                    }
                    catch (MetadataException e) {
                        expressionText = "" + dataItem.getExpression();
                    }
                    for (FractionOfTotalExpression fote : foteList) {
                        DataItem denominator = fote.getDenominator();
                        int denominatorType = fote.getDenominatorType();
                        if (isRolap) {
                            if (denominatorType != 0 || denominator == null) continue;
                            if (!resultItemsList.contains(denominator)) {
                                String offendingFoTText = denominator.getIdentityString();
                                Reason reason = new Reason((Object)dataItem, 8, 111, "DataSelectionImpl.FractionOfTotal.MissingDependency.fmt.txt", dataitemText, expressionText, offendingFoTText);
                                reasons.add(reason);
                                continue;
                            }
                            Role denRole = this.getSelectedItemRole(this.selectedItems, denominator);
                            if (denRole != null) continue;
                            String offendingFoTText = denominator.getIdentityString();
                            Reason reason = new Reason((Object)dataItem, 3, 111, "DataSelectionImpl.FractionOfTotal.NoRoleAssigned.fmt.txt", dataitemText, expressionText, offendingFoTText);
                            reasons.add(reason);
                            continue;
                        }
                        if (denominatorType == 1) continue;
                        Reason reason = new Reason((Object)dataItem, 3, 111, "DataSelectionImpl.FractionOfTotal.OnlyFractionOfGrandTotalsAllowed.fmt.txt", dataitemText, expressionText);
                        reasons.add(reason);
                    }
                }
            }
        }
    }

    private Role getSelectedItemRole(List<SelectedItem> selectedItems, DataItem item) {
        Role result = null;
        for (SelectedItem selectedItem : selectedItems) {
            DataItem dataItem = selectedItem.getItem();
            if (dataItem != item) continue;
            result = selectedItem.getRole();
            break;
        }
        return result;
    }

    protected List<FractionOfTotalExpression> getFractionOfTotalItems(DataItem dataItem) {
        DataItem test = dataItem;
        while (test instanceof DataItemReference) {
            test = ((DataItemReference)test).getBaseDataItem();
        }
        return test.getResources(FractionOfTotalExpression.class, 65535);
    }

    @Override
    public boolean isValid() {
        return this.getReasonsNotValid().size() == 0;
    }

    @Override
    public boolean isAxisValuesCoalesced() {
        return this.coalescedIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Reason> getReasonsNotValid() {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            List<Reason> reasonsNotValid;
            List<Reason> list = reasonsNotValid = this.getReasonsNotValid(effectiveObjectCache);
            return list;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public List<Reason> getReasonsNotValid(EffectiveObjectsCache effectiveObjectCache) {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        StructureOfData structureOfData = this.getStructure();
        try {
            List<Join> joinPath;
            block9: {
                this.getReasonsResultItemsNotValid(reasons, structureOfData);
                this.getReasonsRoleAssignmentsNotValid(reasons, structureOfData);
                this.getReasonsFractionOfTotalsNotValid(reasons, structureOfData);
                int preConstantSize = reasons.size();
                this.getConstantOnlyReasons(reasons, structureOfData, effectiveObjectCache.getEffectiveResultItems(this));
                boolean addReasons = preConstantSize == reasons.size();
                joinPath = null;
                try {
                    joinPath = this.getEffectiveJoinPath(effectiveObjectCache);
                    if (addReasons && joinPath == null) {
                        Reason reason = new Reason((Object)this, 2, 93, "DataSelectionImplJoinPathInvalid.txt", new Object[0]);
                        reasons.add(reason);
                    }
                }
                catch (UnsupportedOperationException e) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("UnsupportedOperationException is expected in some cases, do not worry.  Selection class= ", (Throwable)e);
                    }
                }
                catch (MetadataException e) {
                    if (!addReasons) break block9;
                    List<Reason> exceptionReasons = e.getReasons();
                    if (exceptionReasons.size() > 0) {
                        reasons.addAll(exceptionReasons);
                    }
                    Reason reason = new Reason((Object)this, 2, 93, e);
                    reasons.add(reason);
                }
            }
            this.addReasonsUnusable(reasons, effectiveObjectCache.getEffectiveResultItems(this), joinPath);
            this.addReasonsUnusable(reasons, effectiveObjectCache.getEffectiveSortOrderPrecedence(this), joinPath);
            this.addReasonsUnusable(reasons, effectiveObjectCache.getEffectiveFilters(this), joinPath);
            this.addReasonsUnusable(reasons, effectiveObjectCache.getEffectiveGroups(this), joinPath);
            this.addReasonsUnusable(reasons, effectiveObjectCache.getEffectiveBusinessRules(this), joinPath);
            this.getReasonsResultIDsNotValid(reasons);
            this.getReasonsGroupNotValid(reasons, structureOfData);
            this.getReasonsFilterAssignmentsNotValid(reasons, structureOfData);
            this.getReasonsBusinessQueryRankFilterNotValid(reasons, structureOfData);
            this.getReasonsStepFilterNotValid(reasons, structureOfData);
            this.getReasonsRelationalDataSourcesNotValid(reasons, structureOfData, effectiveObjectCache);
        }
        catch (MetadataUnresolvedException unresolvedException) {
            BusinessModelResource objectNotResolved = unresolvedException.getUnresolvedResource();
            String msgkey = objectNotResolved instanceof MetadataRepositoryResource ? "DataSelectionImpl.QueryNotRunnableBecauseOfUnresolvedOMRObject.fmt.txt" : "DataSelectionImpl.QueryNotRunnableBecauseOfUnresolvedIQObject.fmt.txt";
            Reason reason = new Reason((Object)this, 2, 22, msgkey, objectNotResolved.getIdentityString());
            reasons.add(reason);
        }
        if (!reasons.isEmpty() && _logger.isDebugEnabled()) {
            _logger.debug("DataSelectionImpl.getReasons() is returning a non-empty list for this data selection: " + this.getIdentityString());
            _logger.debug(" ... reasons are: " + ((Object)reasons).toString());
            _logger.debug("State of business model family:");
            String logthis = this.getFamilyStateDebugString();
            _logger.debug(logthis);
        }
        return reasons;
    }

    private void getReasonsRelationalDataSourcesNotValid(List<Reason> reasonsOut, StructureOfData inputStructure, EffectiveObjectsCache effectiveObjectCache) {
        if (!inputStructure.isOLAP()) {
            MetadataDataSource mds = new MetadataDataSource();
            try {
                mds.initializeDataForOneModel(this);
                List<DataSource> dataSources = mds.getUniqueDataSources(true);
                for (DataSource ds : dataSources) {
                    List<Reason> reasons = ds.getReasonsUnusable();
                    if (reasons.size() <= 0) continue;
                    reasonsOut.addAll(reasons);
                }
            }
            catch (IQueryServicesException e) {
                _logger.debug("Could not determine data sources for query.  Query will fail when executed.", (Throwable)e);
            }
        }
    }

    private void getReasonsResultItemsNotValid(List<Reason> reasons, StructureOfData inputStructure) {
        boolean isRolap;
        boolean hasRow;
        boolean atleastOneVisibleItem;
        block30: {
            atleastOneVisibleItem = false;
            hasRow = false;
            if (inputStructure.equals(StructureOfData.OLAP)) {
                try {
                    OLAPUtilities.findDuplicateLabels(this, reasons);
                }
                catch (MetadataException e) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(e.getLocalizedMessage());
                    }
                }
                catch (GenerationException e) {
                    if (!_logger.isEnabled(Level.ERROR)) break block30;
                    _logger.error(e.getLocalizedMessage());
                }
            }
        }
        int selectedCategoriesCount = 0;
        int activeCategoriesCount = 0;
        for (SelectedItem selectedItem : this.selectedItems) {
            boolean isCategory;
            Role role = selectedItem.getRole();
            if (role == Role.ROW && !hasRow) {
                hasRow = true;
            }
            boolean isOutputResultItem = Role.isOutputResultRole(this, role);
            if (!atleastOneVisibleItem && isOutputResultItem) {
                atleastOneVisibleItem = true;
            }
            boolean bl = isCategory = selectedItem.getItem().getUsage() == DataItemActionType.USAGE_CATEGORY;
            if (isCategory) {
                ++selectedCategoriesCount;
            }
            if (!isCategory || !isOutputResultItem) continue;
            ++activeCategoriesCount;
        }
        for (SelectedItem selectedItem : this.selectedItems) {
            DataItem baseItem = selectedItem.getItem();
            ExpressionInterface expression = baseItem.getExpression();
            String startingLevelName = null;
            try {
                startingLevelName = baseItem.getStartingLevelName();
            }
            catch (MetadataException metadataException) {
                Reason reason = new Reason((Object)this, 2, 227, metadataException);
                reasons.add(reason);
            }
            if (startingLevelName == null || expression instanceof Hierarchy) continue;
            Reason reason = new Reason((Object)this, 2, 228, "DataSelectionImplInvalidUseOfStartingLevel.txt", new Object[0]);
            reasons.add(reason);
        }
        boolean bl = isRolap = hasRow && inputStructure.isRelational();
        if (atleastOneVisibleItem) {
            boolean isValid = true;
            if (inputStructure.isOLAP()) {
                isValid = this.checkRelativeTimeMeasure();
            }
            if (!isValid) {
                Reason reason = new Reason((Object)this, 2, 203, "DataSelectionImplBadTimeMeasure.txt", new Object[0]);
                reasons.add(reason);
            }
            if (inputStructure.isRelational() && !hasRow) {
                boolean tooManyCats = false;
                if (activeCategoriesCount > DataRetrievalUtil.MAX_CATEGORIES_PER_ROLAP_QUERY) {
                    boolean hasTotals;
                    String totalType = this.getTotalType(Role.COLUMN);
                    boolean bl2 = hasTotals = totalType != null && !BusinessQuery.TOTAL_NONE.equals(totalType);
                    if (hasTotals) {
                        tooManyCats = true;
                    } else {
                        try {
                            List<DataItem> fotItems = FractionOfTotalUtilImpl.getFractionOfTotalItems(this);
                            tooManyCats = fotItems != null && fotItems.size() > 0;
                        }
                        catch (GenerationException e) {
                            _logger.debug("Exception occurred when trying to get fraction of total items ", (Throwable)e);
                        }
                    }
                }
                if (tooManyCats) {
                    Reason reason = new Reason((Object)this, 2, 239, "DataSelectionImpl.RelationalTooManyCategories.txt", new Object[0]);
                    reasons.add(reason);
                }
            } else if (isRolap) {
                int catCount = selectedCategoriesCount;
                try {
                    ROLAPBuilderInformation rbi = new ROLAPBuilderInformation(this);
                    catCount = rbi.getCategoryCount();
                }
                catch (GenerationException e) {
                    _logger.debug("Exception occurred when trying to get ROLAP builder information ", (Throwable)e);
                }
                if (catCount > DataRetrievalUtil.MAX_CATEGORIES_PER_ROLAP_QUERY) {
                    Reason reason = new Reason((Object)this, 2, 238, "DataSelectionImpl.RolapTooManyCategories.txt", new Object[0]);
                    reasons.add(reason);
                }
                for (SelectedItem selectedItem : this.selectedItems) {
                    FunctionNameID itemFunctionID;
                    Function itemFunction;
                    boolean usageIsNotSupport;
                    DataItem dataItem = selectedItem.getItem();
                    Role role = selectedItem.getRole();
                    if (!Role.isOutputResultRole(this, role)) continue;
                    DataItemActionType usage = dataItem.getUsage();
                    boolean bl3 = usageIsNotSupport = !usage.equals(DataItemActionType.USAGE_AGGREGATE) && !usage.equals(DataItemActionType.USAGE_CATEGORY);
                    if (usageIsNotSupport) {
                        String itemText = dataItem.getLabel();
                        Reason reason = new Reason((Object)dataItem, 2, 205, "DataSelectionImpl.UsageType.NotSupportedInROLAP.fmt.txt", itemText, usage.toString(), role.toString());
                        reasons.add(reason);
                        continue;
                    }
                    if (!usage.equals(DataItemActionType.USAGE_AGGREGATE) || (itemFunction = dataItem.getAggregationType()) == null || DataRetrievalUtil.isValidROLAPAggregation(itemFunctionID = itemFunction.getFunctionNameID())) continue;
                    String label = dataItem.getLabel();
                    Reason reason = new Reason((Object)dataItem, 2, 206, "DataSelectionImpl.CountDistinct.NotSupportedInROLAP.fmt.txt", label, usage.toString());
                    reasons.add(reason);
                }
            }
        } else {
            Reason reason = new Reason((Object)this, 2, 72, "DataSelectionImplNoReturnedResultItem.txt", new Object[0]);
            reasons.add(reason);
        }
    }

    private void addReasonsUnusable(List<Reason> reasons, List<? extends BusinessModelObject> bmos, List joinPath) {
        for (BusinessModelObject businessModelObject : bmos) {
            if (joinPath != null && businessModelObject instanceof Join && !joinPath.contains(businessModelObject)) continue;
            List<Reason> thisObjectsReasons = businessModelObject.getReasonsUnusable();
            reasons.addAll(thisObjectsReasons);
        }
    }

    private void getReasonsResultIDsNotValid(List<Reason> reasons) {
        HashMap<String, DataItem> resultItemMap = new HashMap<String, DataItem>();
        for (SelectedItem selectedItem : this.selectedItems) {
            DataItem di;
            DataItem resultItem = selectedItem.getItem();
            String resultSetID = resultItem.getResultSetID();
            String upperResultSetID = null;
            if (resultSetID != null) {
                upperResultSetID = resultSetID.toUpperCase();
            }
            if ((di = (DataItem)resultItemMap.get(upperResultSetID)) != null) {
                Reason reason = di == resultItem ? new Reason((Object)resultItem, 2, 24, "BusinessQueryImplSameDataItemMultiple.txt", new Object[0]) : new Reason((Object)resultItem, 2, 23, "BusinessQueryImplMultipleDataItemInQuery.txt", new Object[0]);
                reasons.add(reason);
                continue;
            }
            resultItemMap.put(upperResultSetID, resultItem);
        }
    }

    private void getReasonsGroupNotValid(List<Reason> reasons, StructureOfData inputStructure) {
        List<BusinessGroup> effectiveGroups = this.getEffectiveGroups();
        if (inputStructure.equals(StructureOfData.OLAP)) {
            for (BusinessGroup bg : effectiveGroups) {
                if (bg.getType() != BusinessGroup.Type.GROUPED_MEASURES || bg.getContainedGroups().size() <= 0) continue;
                Reason reason = new Reason((Object)this, 2, 249, "DataSelectionImpl.NestedMeasureGroup.txt", new Object[0]);
                reasons.add(reason);
            }
            this.getReasonsGroupedMeasuresNotValid(reasons, effectiveGroups);
        }
    }

    private void getReasonsGroupedMeasuresNotValid(List<Reason> reasons, List<BusinessGroup> groupsList) {
        LinkedHashMap<BusinessModelObject, BusinessGroup> biGroupMap = new LinkedHashMap<BusinessModelObject, BusinessGroup>();
        ArrayList<DataItem> invalidItems = new ArrayList<DataItem>();
        for (BusinessGroup businessGroup : groupsList) {
            List<BusinessModelObject> items = businessGroup.getItems();
            for (BusinessModelObject bmo : items) {
                boolean isMeasure;
                if (!(bmo instanceof DataItem)) continue;
                DataItem di = (DataItem)bmo;
                boolean isMeasureOlap = di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE;
                boolean isMeasureRelational = di.getStructure() == StructureOfDataItem.STRUCTURE_COLUMN && di.getUsage() == DataItemActionType.USAGE_AGGREGATE;
                boolean bl = isMeasure = isMeasureOlap || isMeasureRelational;
                if (businessGroup.getType() == BusinessGroup.Type.GROUPED_MEASURES && !isMeasure) {
                    invalidItems.add(di);
                }
                if (biGroupMap.containsKey(bmo)) {
                    BusinessGroup bg = (BusinessGroup)((HashMap)biGroupMap).get(bmo);
                    if (bg.getLabel().equalsIgnoreCase(businessGroup.getLabel())) continue;
                    Reason reason = new Reason((Object)this, 2, 248, "DataSelectionImpl.DuplicateMeasure.fmt.txt", bmo.getLabel());
                    reasons.add(reason);
                    continue;
                }
                if (!isMeasure || businessGroup.getType() != BusinessGroup.Type.GROUPED_MEASURES) continue;
                biGroupMap.put(bmo, businessGroup);
            }
        }
        if (invalidItems.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (DataItem dataItem : invalidItems) {
                sb.append(dataItem.getLabel());
            }
            Reason reason = new Reason((Object)this, 2, 250, "DataSelectionImpl.InvalidGroup.fmt.txt", sb.toString());
            reasons.add(reason);
        }
    }

    private void getConstantOnlyReasons(List<Reason> reasons, StructureOfData inputStructure, List<? extends DataItem> effectiveResultItems) {
        boolean constantsOnly = false;
        List<DataItem> effectResults = this.getEffectiveResultItems();
        if (inputStructure.isRelational()) {
            constantsOnly = true;
            Iterator<DataItem> it = effectResults.iterator();
            while (it.hasNext() && constantsOnly) {
                DataItem resultItem = it.next();
                if (resultItem.getExpression() instanceof ConstantExpression) continue;
                constantsOnly = false;
            }
        }
        if (effectResults.size() > 0 && constantsOnly) {
            Reason reason = new Reason((Object)this, 2, 26, "DataSelectionImpl.NoDataSources.txt", new Object[0]);
            reasons.add(reason);
        }
    }

    private void getReasonsBusinessQueryRankFilterNotValid(List<Reason> reasons, StructureOfData inputStructure) {
        if (!inputStructure.isOLAP()) {
            List<StepInterface> steps = this.getSteps(Role.ROW);
            steps.addAll(this.getSteps(Role.COLUMN));
            boolean foundOneAlready = false;
            boolean isROLAP = !this.getResultItems(Role.ROW).isEmpty();
            for (StepInterface step : steps) {
                Reason reason;
                if (!(step instanceof BusinessQueryRankFilter) && !(step instanceof BusinessQueryDataBasedFilter)) continue;
                BaseFilter baseFilter = (BaseFilter)step;
                String filterText = baseFilter.getIdentityString();
                String filterExpressionText = baseFilter.toString();
                if (!isROLAP) {
                    reason = new Reason((Object)step, 4, 0, "DataSelectionImpl.RankFilter.NonROLAPQuery.fmt.txt", filterText, filterExpressionText);
                    reasons.add(reason);
                    continue;
                }
                if (foundOneAlready) {
                    reason = new Reason((Object)step, 4, 0, "DataSelectionImpl.RankFilter.MultipleRankFilters.fmt.txt", filterText, filterExpressionText);
                    reasons.add(reason);
                }
                foundOneAlready = true;
                List<FractionOfTotalExpression> fotExprs = baseFilter.getResources(FractionOfTotalExpression.class, 65535);
                for (FractionOfTotalExpression fote : fotExprs) {
                    String offendingFoTText = "" + fote;
                    try {
                        offendingFoTText = StringExpressionUtil.getInstance().getReadableText(fote);
                    }
                    catch (MetadataException e) {
                        _logger.warn("MetadataException encountered getting StringExpression for FOT.");
                    }
                    Reason reason2 = new Reason((Object)step, 4, 112, "DataSelectionImpl.RankFilter.FractionOfTotal.fmt.txt", filterText, filterExpressionText, offendingFoTText);
                    reasons.add(reason2);
                }
            }
        }
    }

    private void getReasonsStepFilterNotValid(List<Reason> reasons, StructureOfData inputStructure) {
        if (inputStructure.isOLAP()) {
            List<StepInterface> steps = this.getSteps(Role.ROW);
            steps.addAll(this.getSteps(Role.COLUMN));
            for (StepInterface step : steps) {
                List<FractionOfTotalExpression> fotExprs = step.getResources(FractionOfTotalExpression.class, 65535);
                for (FractionOfTotalExpression fote : fotExprs) {
                    String offendingFoTText = " " + fote;
                    try {
                        offendingFoTText = StringExpressionUtil.getInstance().getReadableText(fote);
                    }
                    catch (MetadataException e) {
                        _logger.warn("MetadataException encountered getting StringExpression for FOT.");
                    }
                    Reason reason = new Reason((Object)step, 4, 112, "DataSelectionImpl.StepFilters.FractionOfTotal.fmt.txt", offendingFoTText, step.toString());
                    reasons.add(reason);
                }
                List<DataItem> rowDataItems = this.getResultItems(Role.ROW);
                this.checkTupleFilterAxis(reasons, rowDataItems, this._rowSteps);
                List<DataItem> colDataItems = this.getResultItems(Role.COLUMN);
                this.checkTupleFilterAxis(reasons, colDataItems, this._columnSteps);
            }
        }
    }

    private void checkTupleFilterAxis(List<Reason> reasons, List dataItemsOnAxis, List axisSteps) {
        for (StepInterface step : axisSteps) {
            List<TupleFilterMemberQualifier> memberQualifier;
            if (!(step instanceof BusinessQueryTupleFilter)) continue;
            BusinessQueryTupleFilter btf = (BusinessQueryTupleFilter)step;
            DataItem measureInTuple = btf.getMeasuresQualifier();
            if (measureInTuple != null) {
                if (!dataItemsOnAxis.contains(measureInTuple)) {
                    Reason reason = new Reason((Object)step, 4, 241, "DataSelectionImpl.StepFilters.FilterTuple.fmt.txt", btf.getMeasuresQualifier().getLabel());
                    reasons.add(reason);
                }
            } else {
                MDXGenerationUtil.applyDebugStatement("There are no measure qualifier for this filter", this.getClass());
            }
            if ((memberQualifier = btf.getMemberQualifiers()) != null) {
                for (TupleFilterMemberQualifier tfQ : memberQualifier) {
                    Reason reason;
                    if (tfQ == null) continue;
                    DataItem dataItemInMemberQualifier = tfQ.getMemberItem();
                    if (dataItemInMemberQualifier != null) {
                        if (dataItemsOnAxis.contains(dataItemInMemberQualifier)) continue;
                        reason = new Reason((Object)step, 4, 241, "DataSelectionImpl.StepFilters.FilterTuple.fmt.txt", dataItemInMemberQualifier.getLabel());
                        reasons.add(reason);
                        continue;
                    }
                    reason = new Reason((Object)step, 4, 241, "DataSelectionImpl.StepFilters.NullFilterTuple.fmt.txt", new Object[0]);
                    reasons.add(reason);
                }
                continue;
            }
            MDXGenerationUtil.applyDebugStatement("There are no member qualifiers for this filter", this.getClass());
        }
    }

    protected List<BusinessModelObject> getAllExplicitlyReferencedBusinessModelObjects() {
        LinkedHashSet<BusinessModelObject> bmos = new LinkedHashSet<BusinessModelObject>();
        bmos.addAll(this.getResultItems());
        bmos.addAll(this.getSortOrderPrecedence());
        bmos.addAll(this.getFilters());
        bmos.addAll(this.getGroups());
        return new ArrayList<BusinessModelObject>(bmos);
    }

    private void warnOfPotentialIllegalModelUsage(List listOfBusinessModelObjects) {
        if (_logger.isDebugEnabled()) {
            for (Object obj : listOfBusinessModelObjects) {
                this.warnOfPotentialIllegalModelUsage(obj);
            }
        }
    }

    private void warnOfPotentialIllegalModelUsage(Object obj) {
        if (_logger.isDebugEnabled()) {
            if (obj instanceof AbstractBusinessModelObject) {
                AbstractBusinessModelObject bmoi = (AbstractBusinessModelObject)obj;
                BusinessModel bm = bmoi.getBusinessModel();
                if (bm != this.getBusinessModel()) {
                    _logger.debug(IQModelImplUtilities.getMessage("BusinessQueryImplIllegalModelUsage.txt", new Object[0]));
                    String msg = IQModelImplUtilities.getMessage("BusinessQueryImplObjectAndAttributes.fmt.txt", bmoi.getIdentityString());
                    _logger.debug(msg);
                    String msg2 = IQModelImplUtilities.getMessage("BusinessQueryImplObjectUsedDirect.fmt.txt", bm.getID(), this.getBusinessModel().getID(), this.getBusinessModel().getID());
                    _logger.debug(msg2);
                }
            } else if (_logger.isDebugEnabled()) {
                String msg = IQModelImplUtilities.getMessage("BusinessQueryImplModelObjectExpected.fmt.txt", obj.toString());
                _logger.debug(msg);
            }
        }
    }

    @Override
    public void addStep(StepInterface step, Role stepRole) throws MetadataException {
        if (stepRole.equals(Role.ROW)) {
            StepManager.addStep(step, this._rowSteps);
        } else if (stepRole.equals(Role.COLUMN)) {
            StepManager.addStep(step, this._columnSteps);
        } else {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryBadRole.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this.fireChangeEvent("The step list has changed");
    }

    @Override
    public StepInterface getStep(int stepNumber, Role stepRole) {
        if (stepRole.equals(Role.ROW)) {
            return StepManager.getStep(stepNumber, this._rowSteps);
        }
        if (stepRole.equals(Role.COLUMN)) {
            return StepManager.getStep(stepNumber, this._columnSteps);
        }
        MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryBadRole.txt", new Object[0]);
        _logger.error((Object)msg);
        throw new IQueryServicesIllegalArgumentException(msg);
    }

    @Override
    public List<StepInterface> getSteps(Role stepRole) {
        if (stepRole.equals(Role.ROW)) {
            return StepManager.getSteps(this._rowSteps);
        }
        if (stepRole.equals(Role.COLUMN)) {
            return StepManager.getSteps(this._columnSteps);
        }
        MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryBadRole.txt", new Object[0]);
        _logger.error((Object)msg);
        throw new IQueryServicesIllegalArgumentException(msg);
    }

    @Override
    public void setSteps(List<StepInterface> steps, Role stepRole) throws MetadataException {
        if (stepRole.equals(Role.ROW)) {
            StepManager.setSteps(steps, this._rowSteps);
        } else if (stepRole.equals(Role.COLUMN)) {
            StepManager.setSteps(steps, this._columnSteps);
        } else {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryBadRole.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this.fireChangeEvent("The step list has changed");
    }

    @Override
    public void removeStep(int stepNumber, Role stepRole) throws MetadataException {
        if (stepRole.equals(Role.ROW)) {
            StepManager.removeStep(stepNumber, this._rowSteps);
        } else if (stepRole.equals(Role.COLUMN)) {
            StepManager.removeStep(stepNumber, this._columnSteps);
        } else {
            MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("BusinessQueryBadRole.txt", new Object[0]);
            _logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        this.fireChangeEvent("The step list has changed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getQueryResources(Class c, int flags) {
        ArrayList resourceList = new ArrayList();
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            this.addResources(resourceList, effectiveObjectCache.getEffectiveResultItems(this), c, flags);
            this.addResources(resourceList, effectiveObjectCache.getEffectiveSortOrderPrecedence(this), c, flags);
            this.addResources(resourceList, effectiveObjectCache.getEffectiveFilters(this), c, flags);
            this.addResources(resourceList, effectiveObjectCache.getEffectiveGroups(this), c, flags);
            this.addResources(resourceList, effectiveObjectCache.getEffectiveBusinessRules(this), c, flags);
        }
        finally {
            effectiveObjectCache.clear();
        }
        return resourceList;
    }

    private void addResources(List resources, List bmos, Class c, int flags) {
        for (BusinessModelObject item : bmos) {
            if (item == null) continue;
            List res = item.getResources(c, flags);
            resources.addAll(res);
        }
    }

    public List getValidActions() {
        return new ArrayList<BusinessQueryActionType>(this._validActions);
    }

    @Override
    public boolean isActionSupported(BusinessQueryActionType actionType) {
        if (actionType.equals(BusinessQueryActionType.STEP_EXCLUDE)) {
            return BusinessQueryTupleFilter.isFilterSelectionValid(this, null);
        }
        return this._validActions.contains(actionType) && !this._disabledActions.contains(actionType);
    }

    @Override
    public void setActionSupported(@Nonnull BusinessQueryActionType actionType, boolean actionSupported) throws MetadataException {
        Preconditions.ensureNonNull(actionType, _logger);
        if (actionSupported) {
            if (this._validActions.contains(actionType)) {
                this._disabledActions.remove(actionType);
            } else if (actionSupported) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplInvalidAction.txt", new Object[0]));
            }
        } else if (this._validActions.contains(actionType) && !this._disabledActions.contains(actionType)) {
            this._disabledActions.add(actionType);
        }
        this.fireChangeEvent("The list of supported actions has changed");
    }

    @Override
    public int getResultSetIndex(String dataItemID) {
        int indexToReturn = -1;
        int i = 0;
        if (dataItemID != null) {
            List<SelectedItem> selectedItems = this.getSelectedItems();
            Iterator<SelectedItem> it = selectedItems.iterator();
            while (it.hasNext() && indexToReturn == -1) {
                SelectedItem selectedItem = it.next();
                Role role = selectedItem.getRole();
                boolean isOutputResultItem = Role.isOutputResultRole(this, role);
                if (!isOutputResultItem) continue;
                try {
                    DataItem dataItem = selectedItem.getItem();
                    String id = dataItem.getID();
                    if (id != null && id.equals(dataItemID)) {
                        indexToReturn = i;
                        continue;
                    }
                    ++i;
                }
                catch (InvalidIDException e) {
                    ++i;
                }
            }
        }
        return indexToReturn;
    }

    protected EntityInterface getInternalEntity() {
        return this._queryPrompts.getEntityBasedPrompts();
    }

    @Override
    public final PromptValuesInterface getPromptValues() {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            PromptValuesInterface promptValuesInterface = this.getPromptValues(effectiveObjectCache);
            return promptValuesInterface;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public PromptValuesInterface getPromptValues(EffectiveObjectsCache effectiveObjectCache) {
        Locale labelLocale = LocaleUtilities.getDefaultViewerLocale(this);
        return this._queryPrompts.getParameterizedValues(effectiveObjectCache, labelLocale);
    }

    protected List<RunStoredProcess> getParameterizedStoredProcesses() {
        return this.getEffectiveRules(RunStoredProcess.class);
    }

    @Override
    public EntityInterface getEntity() {
        return this.getInternalEntity();
    }

    @Override
    public String retrieveStrategyClassName() {
        StructureOfData inputStructure = this.getInputStructure();
        String strategy = null;
        boolean runMFT = Boolean.getBoolean("IQ.Testing.MFT");
        List<AssociationRule> returnList = null;
        strategy = inputStructure.isRelational() ? (!(returnList = this.getEffectiveRules(AssociationRule.class)).isEmpty() ? "com.sas.iquery.strategies.sas.oma.relational.AssociationStrategy" : "com.sas.iquery.strategies.sas.oma.relational.RelationalStrategy") : "com.sas.iquery.strategies.sas.oma.olap.OLAPStrategy";
        return strategy;
    }

    @Override
    public BusinessModelReferenceInfo getReferenceInfo() {
        return new BusinessModelReferenceInfoImpl(this, this.getID());
    }

    @Override
    public AbstractModelReference getModelReference() {
        return (AbstractModelReference)((Object)this.getReferenceInfo());
    }

    public void setStrategyProperties(Map strategyProperties) {
        this.strategyProperties = strategyProperties;
    }

    public Map getStrategyProperties() {
        return this.strategyProperties;
    }

    @Override
    public DataSelection copy() throws MetadataException {
        HashMap<BusinessModelReferenceInfo, BusinessModel> reuseTheseBusinessModels = new HashMap<BusinessModelReferenceInfo, BusinessModel>();
        BusinessModel reusedParentBusinessModel = this.getParentBusinessModel();
        if (reusedParentBusinessModel != null) {
            BusinessModelReferenceInfo reusedParentBusinessModelRefInfo = reusedParentBusinessModel.getReferenceInfo();
            reuseTheseBusinessModels.put(reusedParentBusinessModelRefInfo, reusedParentBusinessModel);
        }
        Element fakeParent = IQModelImplUtilities.newDocumentWithElementName("bogus");
        Element dsElement = this.write(fakeParent);
        DataSelection newDataSelection = this.getDataSelectionFactory().readDataSelectionNonStatic(dsElement, reuseTheseBusinessModels, this.getMetadataService(), this.getSession());
        return newDataSelection;
    }

    private void rebuildCachedItems() {
        if (this.cachedSelectedItemsByRole == null) {
            this.cachedSelectedItemsByRole = new HashMap();
        } else {
            Set cachedValues = this.cachedSelectedItemsByRole.entrySet();
            for (Map.Entry entry : cachedValues) {
                Object[] value = (Object[])entry.getValue();
                ((List)value[0]).clear();
                ((List)value[1]).clear();
            }
        }
        if (this.cachedResultItems == null) {
            this.cachedResultItems = ListUtils.newCOWList(this.selectedItems.size());
        } else {
            this.cachedResultItems.clear();
        }
        for (SelectedItem item : this.selectedItems) {
            this.cachedResultItems.add(item.getItem());
            Role role = item.getRole();
            Object[] list = (Object[])this.cachedSelectedItemsByRole.get(role);
            if (list == null) {
                list = new Object[]{ListUtils.newCOWList(), ListUtils.newCOWList()};
                this.cachedSelectedItemsByRole.put(role, list);
            }
            ((List)list[0]).add(item);
            ((List)list[1]).add(item.getItem());
        }
    }

    @Override
    protected String getDefinitionElementName() {
        return ELEMENT_DATA_SELECTION;
    }

    public Map write(Element parentElement, Map<QueryWriteOption, Object> writeOptions) throws MetadataException {
        if (parentElement == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplMapItemNull.txt", new Object[0]));
        }
        DataSelectionImpl.validateBusinessQueryWriteOptions(writeOptions);
        AbstractModel.ModelWritingResults internalResults = this.writeAsInlineXMLUnder(parentElement, writeOptions);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("MODEL_ELEMENT", internalResults.getElement());
        resultMap.put("REFERENCED_INFOMAPS", internalResults.getReferencedInfoMaps());
        return resultMap;
    }

    public static void validateBusinessQueryWriteOptions(Map<QueryWriteOption, Object> writeOptions) {
        if (writeOptions != null && writeOptions.size() > 0) {
            for (Map.Entry<QueryWriteOption, Object> entry : writeOptions.entrySet()) {
                QueryWriteOption option = entry.getKey();
                Object obj = entry.getValue();
                if (obj == null || option.getAssociatedClass().isInstance(obj)) continue;
                MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("DataSelectionImpl.InvalidWriteOptionsDefined.fmt.txt", obj.getClass().getName(), option.ordinal());
                throw new IQueryServicesIllegalArgumentException(msg);
            }
        }
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "emptyDataFormat", this.emptyDataFormat);
        if (this.sortRowDirection != null && !this.sortRowDirection.equals(BusinessQueryActionType.SORT_NONE)) {
            IQModelImplUtilities.setEnumAttr(thisElement, "sortRowType", this.sortRowDirection);
        }
        if (this.sortColumnDirection != null && !this.sortColumnDirection.equals(BusinessQueryActionType.SORT_NONE)) {
            IQModelImplUtilities.setEnumAttr(thisElement, "sortColumnType", this.sortColumnDirection);
        }
        if (this.totalRowType != null && this.totalRowType != TotalingType.TOTAL_NONE) {
            IQModelImplUtilities.setEnumAttr(thisElement, "totalRow", this.totalRowType);
        }
        if (this.totalColumnType != null && this.totalColumnType != TotalingType.TOTAL_NONE) {
            IQModelImplUtilities.setEnumAttr(thisElement, "totalColumn", this.totalColumnType);
        }
        if (this.totalMode != null && !this.totalMode.equals(BusinessQueryTotalModeType.VISUAL_VALUES)) {
            IQModelImplUtilities.setEnumAttr(thisElement, "totalMode", this.totalMode);
        }
        if (this.totalLocation != null && !this.totalLocation.equals(BusinessQueryTotalLocationType.TOTAL_ROW_BOTTOM_COLUMN_RIGHT)) {
            IQModelImplUtilities.setEnumAttr(thisElement, "totalLocation", this.totalLocation);
        }
        if (!this.coalescedIndicator) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "axisOLAPCoalesced", this.coalescedIndicator);
        }
        IQModelImplUtilities.setAttr(thisElement, "subTotalRowLabel", this.subTotalRowLabel);
        IQModelImplUtilities.setAttr(thisElement, "subTotalColumnLabel", this.subTotalColumnLabel);
        IQModelImplUtilities.setAttr(thisElement, "grandTotalRowLabel", this.grandTotalRowLabel);
        IQModelImplUtilities.setAttr(thisElement, "grandTotalColumnLabel", this.grandTotalColumnLabel);
        this.writeOLAPSortCriteria(this.sortRowCriteria, thisElement, writingContext, "OLAPQuerySortRowCriteria");
        this.writeOLAPSortCriteria(this.sortColumnCriteria, thisElement, writingContext, "OLAPQuerySortColumnCriteria");
        DataSelectionImpl.writeRelatedObjects(this._rowSteps, thisElement, writingContext, "RowSteps");
        DataSelectionImpl.writeRelatedObjects(this._columnSteps, thisElement, writingContext, "ColumnSteps");
        DataSelectionImpl.writeDisabledActions(this._disabledActions, thisElement, writingContext);
        DataSelectionImpl.writeRelatedObjects(this.selectedItems, thisElement, writingContext, "SelectedItems");
        DataSelectionImpl.writeRelatedObjects(this.sortOrderPrecedence, thisElement, writingContext, "SortOrderPrecedence");
        DataSelectionImpl.writeRelatedObjects(this.filters, thisElement, writingContext, "Filters");
        if (this.queryProperties.containsPersistableValues()) {
            DataSelectionImpl.writeRelatedObject(this.queryProperties, thisElement, writingContext, "QueryProps");
        }
        DataSelectionImpl.writeRelatedObjects(this._explicitJoinPath, thisElement, writingContext, "ExplicitJoinPath");
        this._queryPrompts.writeDefinition(thisElement, writingContext);
        if (this._groups != null && this._groups.size() > 0 && this.getQueryProperty(BusinessQueryProperty.PERSIST_GROUPINGS)) {
            DataSelectionImpl.writeRelatedObjects(this._groups, thisElement, writingContext, "Groups");
            writingContext.adjustModelVersion(ModelVersion.VERSION_94);
        }
    }

    private static void writeDisabledActions(List actions, Element element, WritingContext writingContext) throws MetadataException {
        if (actions != null && actions.size() > 0) {
            IQModelImplUtilities.setEnumListAttr(element, "disabledActions", actions);
        }
    }

    @Override
    protected void writeDataLocale(Locale locale, Node parentNode, WritingContext writingContext, String newSubelementName) throws MetadataException {
        if (locale != null) {
            writingContext.adjustModelVersion(ModelVersion.VERSION_92M3);
        }
        super.writeDataLocale(locale, parentNode, writingContext, newSubelementName);
    }

    @Override
    void writeFolder(MapFolder folder, Node parentNode, WritingContext writingContext, String newSubelementName) throws MetadataException {
        if (folder != null) {
            if (folder.isEmpty()) {
                String label = folder.getLabel();
                String description = folder.getDescription();
                LocalizableString descriptions = folder.getDescriptions();
                LocalizableString labels = folder.getLabels();
                if (!(label != null && label.length() != 0 || description != null && description.length() != 0 || descriptions != null && (descriptions.getLocales().size() != 0 || descriptions.getDefaultLocale() != null) || labels != null && (labels.getLocales().size() != 0 || labels.getDefaultLocale() != null))) {
                    return;
                }
            }
            writingContext.adjustModelVersion(ModelVersion.VERSION_93a);
            super.writeFolder(folder, parentNode, writingContext, newSubelementName);
        }
    }

    private void writeOLAPSortCriteria(List criteria, Element thisElement, WritingContext writingContext, String relationshipElement) throws MetadataException {
        if (criteria != null && criteria.size() > 0) {
            ArrayList<PersistenceProvider> critPersistors = new ArrayList<PersistenceProvider>();
            for (int i = 0; i < criteria.size(); ++i) {
                Object oneCriteria = criteria.get(i);
                if (oneCriteria == null) continue;
                PersistenceProvider persistor = PersistenceProvider.newProviderForWritingOneOlapQuerySortCriteria(oneCriteria);
                critPersistors.add(persistor);
            }
            if (critPersistors.size() > 0) {
                DataSelectionImpl.writeRelatedObjects(critPersistors, thisElement, writingContext, relationshipElement);
            }
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this.emptyDataFormat = attrsProvider.consumeAttrEmptyDefault("emptyDataFormat");
        this.sortRowDirection = BusinessQueryActionType.consumeValue(attrsProvider, "sortRowType", BusinessQueryActionType.SORT_NONE);
        this.sortColumnDirection = BusinessQueryActionType.consumeValue(attrsProvider, "sortColumnType", BusinessQueryActionType.SORT_NONE);
        this.totalLocation = BusinessQueryTotalLocationType.consumeValue(attrsProvider, "totalLocation", BusinessQueryTotalLocationType.TOTAL_ROW_BOTTOM_COLUMN_RIGHT);
        this.totalMode = BusinessQueryTotalModeType.consumeValue(attrsProvider, "totalMode", BusinessQueryTotalModeType.VISUAL_VALUES);
        this.coalescedIndicator = attrsProvider.consumeBooleanAttr("axisOLAPCoalesced", true);
        this.totalRowType = TotalingType.consumeValue(attrsProvider, "totalRow", TotalingType.TOTAL_NONE);
        this.totalColumnType = TotalingType.consumeValue(attrsProvider, "totalColumn", TotalingType.TOTAL_NONE);
        this.subTotalRowLabel = attrsProvider.consumeAttr("subTotalRowLabel");
        this.subTotalColumnLabel = attrsProvider.consumeAttr("subTotalColumnLabel");
        this.grandTotalRowLabel = attrsProvider.consumeAttr("grandTotalRowLabel");
        this.grandTotalColumnLabel = attrsProvider.consumeAttr("grandTotalColumnLabel");
        this._disabledActions.clear();
        this._disabledActions.addAll(DataSelectionImpl.consumeDisabledActions(attrsProvider));
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this.sortRowCriteria = riHolder.consumeForeignObjects("OLAPQuerySortRowCriteria", Object.class);
        this.sortColumnCriteria = riHolder.consumeForeignObjects("OLAPQuerySortColumnCriteria", Object.class);
        this._rowSteps = riHolder.consumeObjects("RowSteps", StepInterface.class);
        this._columnSteps = riHolder.consumeObjects("ColumnSteps", StepInterface.class);
        this.selectedItems = riHolder.consumeObjects("SelectedItems", SelectedItem.class);
        this.sortOrderPrecedence = riHolder.consumeObjects("SortOrderPrecedence", DataItem.class);
        this.filters = riHolder.consumeObjects("Filters", FilterItem.class);
        this.queryProperties = (QueryProperties)riHolder.consumeObject("QueryProps");
        if (this.queryProperties == null) {
            this.queryProperties = new QueryProperties();
        }
        this._explicitJoinPath = riHolder.consumeObjects("ExplicitJoinPath", Join.class);
        if (this._queryPrompts == null) {
            this._queryPrompts = new QueryPrompts(this);
        }
        this._queryPrompts.consumeRelatedObjects(riHolder);
        this._groups = riHolder.consumeObjects("Groups", BusinessGroup.class);
    }

    private static List<BusinessQueryActionType> consumeDisabledActions(AttributesProvider attrsProvider) {
        List<BusinessQueryActionType> out = AbstractEnumerationObject.consumeCommaList(attrsProvider, "disabledActions", BusinessQueryActionType.class);
        if (out == null) {
            out = new ArrayList<BusinessQueryActionType>(0);
        }
        return out;
    }

    public static DataSelection readInNewDataSelection(SessionContextInterface session, IntelligentQueryMetadataServiceInterface iqService, Element dataSelectionElement, Map reuseModels) throws MetadataException {
        DataSelectionImpl out = new DataSelectionImpl(session, iqService);
        ModelVersion ver = IQModelImplUtilities.getModelVersionAttr(dataSelectionElement, "ver");
        boolean v2XML = out.checkModelVersion(ver);
        if (v2XML) {
            ReadingContextV2 readingContext = new ReadingContextV2(out);
            readingContext.setModelsToReuse(reuseModels);
            out.readV2(dataSelectionElement, readingContext);
        } else {
            DataSelectionReadingContext readingContext = new DataSelectionReadingContext(out, reuseModels);
            out.readV1(dataSelectionElement, readingContext);
        }
        return out;
    }

    protected void readV2(Element thisElement, ReadingContextV2 readingContext) throws MetadataException {
        XMLV2ModelHandler xmlHandler = new XMLV2ModelHandler(readingContext);
        this.pushXMLAndPostProcess(thisElement, xmlHandler, readingContext);
    }

    @Override
    protected void postPopulationProcessing(ReadingContextV2 readingContext) throws MetadataException {
        super.postPopulationProcessing(readingContext);
        this.rebuildCachedItems();
        this.initializeValidActions();
        AbstractModel pModel = this.getParent();
        if (pModel != null) {
            pModel.addParentToChildLink(this);
        }
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        List criteriaColumnDataItems;
        List criteriaRowElementDataItems;
        this.setIdentity(IQModelImplUtilities.getAttr(thisElement, "bmid"));
        List modelRefs = DataSelectionImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "ReferencedBusinessModels", new Class[]{AbstractModelReference.class});
        ((DataSelectionReadingContext)readingContext).trustedSetModelReferences(modelRefs);
        this.resolveReferencedModelV1((DataSelectionReadingContext)readingContext);
        this.readExternalReferencesV1(thisElement, readingContext);
        this.resolveExternalDependenciesV1(readingContext);
        super.readDefinitionV1(thisElement, readingContext);
        this.initializeValidActions();
        this.emptyDataFormat = IQModelImplUtilities.getAttr(thisElement, "emptyDataFormat");
        String actionType = null;
        actionType = IQModelImplUtilities.getAttr(thisElement, "sortRowType");
        if (actionType != null) {
            this.sortRowDirection = BusinessQueryActionType.fromPersistentForm(actionType);
        }
        if ((actionType = IQModelImplUtilities.getAttr(thisElement, "sortColumnType")) != null) {
            this.sortColumnDirection = BusinessQueryActionType.fromPersistentForm(actionType);
        }
        this.totalRowType = TotalingType.fromValue(IQModelImplUtilities.getAttr(thisElement, "totalRow"));
        this.totalColumnType = TotalingType.fromValue(IQModelImplUtilities.getAttr(thisElement, "totalColumn"));
        this.subTotalRowLabel = IQModelImplUtilities.getAttr(thisElement, "subTotalFormatRow");
        this.grandTotalRowLabel = IQModelImplUtilities.getAttr(thisElement, "grandTotalFormatRow");
        this.subTotalColumnLabel = IQModelImplUtilities.getAttr(thisElement, "subTotalFormatColumn");
        this.grandTotalColumnLabel = IQModelImplUtilities.getAttr(thisElement, "grandTotalFormatColumn");
        this.sortRowCriteria.clear();
        Element sortRowCriteriaListElement = IQModelImplUtilities.getFirstSubelementNamed(thisElement, "SortCriteriaRowList");
        if (sortRowCriteriaListElement != null) {
            List<Element> criteriaRowElements = IQModelImplUtilities.getSubelements(sortRowCriteriaListElement);
            for (Element oneRowCriteriaElement : criteriaRowElements) {
                ArrayList<String> oneRowCriteria = new ArrayList<String>();
                int index = 0;
                while (index != -1) {
                    String attrValue = IQModelImplUtilities.getAttr(oneRowCriteriaElement, "rowCrit" + index);
                    if (attrValue == null) {
                        index = -1;
                        continue;
                    }
                    oneRowCriteria.add(attrValue);
                    ++index;
                }
                int size = oneRowCriteria.size();
                String[] obj = null;
                if (size == 1) {
                    obj = (String[])oneRowCriteria.get(0);
                } else {
                    String[] array = new String[size];
                    for (int i = 0; i < size; ++i) {
                        array[i] = (String)oneRowCriteria.get(i);
                    }
                    obj = array;
                }
                this.sortRowCriteria.add(obj);
            }
        }
        if ((criteriaRowElementDataItems = DataSelectionImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "SortCriteriaRowExpList", new Class[]{ExpressionInterface.class})).size() > 0) {
            this.sortRowCriteria.add(criteriaRowElementDataItems);
        }
        criteriaRowElementDataItems = DataSelectionImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "SortCriteriaRowExp", new Class[]{ExpressionInterface.class});
        this.sortRowCriteria.addAll(criteriaRowElementDataItems);
        Element sortColumnCriteriaListElement = IQModelImplUtilities.getFirstSubelementNamed(thisElement, "SortCriteriaColumnList");
        this.sortColumnCriteria.clear();
        if (sortColumnCriteriaListElement != null) {
            List<Element> criteriaColumnElements = IQModelImplUtilities.getSubelements(sortColumnCriteriaListElement);
            for (Element oneColumnCriteriaElement : criteriaColumnElements) {
                ArrayList<String> oneColumnCriteria = new ArrayList<String>();
                int index = 0;
                while (index != -1) {
                    String attrValue = IQModelImplUtilities.getAttr(oneColumnCriteriaElement, "colCrit" + index);
                    if (attrValue == null) {
                        index = -1;
                        continue;
                    }
                    oneColumnCriteria.add(attrValue);
                    ++index;
                }
                int size = oneColumnCriteria.size();
                String[] obj = null;
                if (size == 1) {
                    obj = (String[])oneColumnCriteria.get(0);
                } else {
                    String[] array = new String[size];
                    for (int i = 0; i < size; ++i) {
                        array[i] = (String)oneColumnCriteria.get(i);
                    }
                    obj = array;
                }
                this.sortColumnCriteria.add(obj);
            }
        }
        if ((criteriaColumnDataItems = DataSelectionImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "SortCriteriaColumnExpList", new Class[]{ExpressionInterface.class})).size() > 0) {
            this.sortColumnCriteria.add(criteriaColumnDataItems);
        }
        criteriaColumnDataItems = DataSelectionImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "SortCriteriaColumnExp", new Class[]{ExpressionInterface.class});
        this.sortColumnCriteria.addAll(criteriaColumnDataItems);
        this._rowSteps = DataSelectionImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "RowSteps", new Class[]{StepInterface.class});
        this._columnSteps = DataSelectionImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "ColumnSteps", new Class[]{StepInterface.class});
        Element actionElement = IQModelImplUtilities.getFirstSubelementNamed(thisElement, "SupportedActions");
        if (actionElement != null) {
            NamedNodeMap map = actionElement.getAttributes();
            int mapCount = map.getLength();
            for (int index = 0; index < mapCount; ++index) {
                boolean actionEnabled;
                String nodeName;
                BusinessQueryActionType action;
                Node attrNode = map.item(index);
                if (attrNode.getNodeType() != 2 || (action = BusinessQueryActionType.fromPersistentForm(nodeName = attrNode.getNodeName())) == null || (actionEnabled = IQModelImplUtilities.getBooleanAttr(actionElement, nodeName, false)) || this._disabledActions.contains(action)) continue;
                this._disabledActions.add(action);
            }
        }
        this.readResultItemsV1(IQModelImplUtilities.getFirstSubelementNamed(thisElement, "ResultItems"), readingContext);
        this.sortOrderPrecedence = DataSelectionImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "SortOrderPrecedence", new Class[]{DataItem.class});
        this.filters = DataSelectionImpl.v1_readItemListUnderSubelement(thisElement, readingContext, "Filters", new Class[]{FilterItem.class});
        this.readQueryPropertiesV1(IQModelImplUtilities.getFirstSubelementNamed(thisElement, "QueryProperties"));
        if (this._queryPrompts == null) {
            this._queryPrompts = new QueryPrompts(this);
        }
        this._queryPrompts.readQueryPrompts(IQModelImplUtilities.getFirstSubelementNamed(thisElement, "QueryEntity"));
    }

    @Override
    protected void resolveExternalDependenciesV1(ReadingContext resolutionContext) throws MetadataException {
        this.resolveExternalItemReferences(resolutionContext);
    }

    @Override
    protected void postReadV1(ReadingContext readingContext) throws MetadataException {
        this.rebuildCachedItems();
        this.getParent().addParentToChildLink(this);
    }

    private AbstractModel resolveReferencedModelV1(DataSelectionReadingContext readingContext) throws MetadataException {
        AbstractModelReference modelRef;
        AbstractModel referencedModel = null;
        List<AbstractModelReference> modelRefs = readingContext.trustedGetModelReferences();
        if (modelRefs.size() > 0 && (referencedModel = readingContext.getModelToReuse(modelRef = modelRefs.get(0))) == null) {
            referencedModel = this.readFromLocationV1(modelRef, readingContext);
            if (referencedModel == null) {
                String modelIDWeNeed = modelRef.getReferencedContainerIdentity();
                MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("BusinessModelImplModelReadFailed.fmt.txt", modelIDWeNeed, modelRef.getReferencedContainerIdentity(), readingContext.getModelReferencesOfModelsToReuse());
                throw new MetadataException(messageFormatter);
            }
            referencedModel.markContainerAndContentsNeverChangeable();
        }
        this.setParent(referencedModel);
        return referencedModel;
    }

    protected void resolveExternalItemReferences(ReadingContext resolutionContext) throws MetadataException {
        DataSelectionExternalResourceResolver handler = new DataSelectionExternalResourceResolver(resolutionContext);
        handler.bindExternalResources();
    }

    private void readResultItemsV1(Element resultItemsElement, ReadingContext readingContext) throws MetadataException {
        if (resultItemsElement != null) {
            List<Element> kidElements = IQModelImplUtilities.getSubelements(resultItemsElement);
            for (Element kidElement : kidElements) {
                DataItem di = (DataItem)((Object)readingContext.readModelElement(kidElement));
                String roleAttr = IQModelImplUtilities.getAttr(kidElement, "role");
                Role role = null;
                if (roleAttr != null) {
                    role = Role.fromPersistentForm(roleAttr);
                }
                int formatType = 0;
                String formatTypeAttr = IQModelImplUtilities.getAttr(kidElement, "formatType");
                if (formatTypeAttr != null) {
                    formatType = 1;
                }
                SelectedItem selectedItem = new SelectedItem(di, role, formatType);
                selectedItem.addListener(this);
                readingContext.addItemCreatedDuringRead(selectedItem);
                this.selectedItems.add(selectedItem);
            }
            this.rebuildCachedItems();
        }
    }

    private void readQueryPropertiesV1(Element queryPropertiesElement) throws MetadataException {
        if (queryPropertiesElement != null) {
            this.getAndSetPropertyValue(queryPropertiesElement, BusinessQueryProperty.RETURN_DISTINCT_VALUES);
            this.getAndSetPropertyValue(queryPropertiesElement, BusinessQueryProperty.EXCLUDE_EMPTY_DATA);
            this.getAndSetPropertyValue(queryPropertiesElement, BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
            this.getAndSetPropertyValue(queryPropertiesElement, BusinessQueryProperty.BUSINESS_QUERY_OLAP_SORT_PRECEDENCE);
            this.getAndSetPropertyValue(queryPropertiesElement, BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION);
            this.getAndSetPropertyValue(queryPropertiesElement, BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS);
        }
    }

    protected void getAndSetPropertyValue(Element element, BusinessQueryProperty property) throws MetadataException {
        boolean bool = IQModelImplUtilities.getBooleanAttr(element, property.getPersistentForm(), false);
        this.queryProperties.set(property, bool);
    }

    private void initializeValidActions() {
        StructureOfData inputStructure = this.getInputStructure();
        if (inputStructure.isRelational()) {
            this._validActions = new ArrayList<BusinessQueryActionType>(VALID_RELATIONAL_ACTIONS);
        } else if (inputStructure.isOLAP()) {
            this._validActions = new ArrayList<BusinessQueryActionType>(VALID_OLAP_ACTIONS);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object objThatChanged = event.getSource();
        if (objThatChanged != null) {
            List<BusinessModelObject> bmos = this.getAllExplicitlyReferencedBusinessModelObjects();
            if (bmos.contains(objThatChanged)) {
                this.fireChangeEvent("An object referenced by the BusinessQuery has changed");
            } else if (objThatChanged instanceof SelectedItem) {
                this.fireChangeEvent(event.getPropertyName());
                this.rebuildCachedItems();
            }
        }
    }

    private Collection<? extends DataSource> getDataSources(Collection<? extends BusinessItem> businessItems) throws MetadataException {
        LinkedHashSet<DataSourceTable> dataSources = new LinkedHashSet<DataSourceTable>();
        for (BusinessItem businessItem : businessItems) {
            List<QualifiedColumn> columns = businessItem.getResources(QualifiedColumn.class, 65531);
            for (QualifiedColumn qc : columns) {
                dataSources.add(qc.getDataSource());
            }
        }
        return dataSources;
    }

    private List<DataSource> getEffectiveDataSources(EffectiveObjectsCache effectiveObjectCache, Collection<FilterItem> filters) throws MetadataException {
        List<DataSource> requiredDataSources = this.findRequiredDataSources(effectiveObjectCache);
        LinkedHashSet<DataSource> effectiveDataSources = new LinkedHashSet<DataSource>(requiredDataSources);
        if (this.getStructure().isRelational()) {
            if (filters == null) {
                filters = effectiveObjectCache.getEffectiveFilters(this);
            }
            JoinPathGeneratorImpl joinPathGenerator = new JoinPathGeneratorImpl(this);
            joinPathGenerator.generateJoinPath(filters, effectiveObjectCache);
            effectiveDataSources.addAll(joinPathGenerator.getUniqueDataSources());
            effectiveDataSources.addAll(this.getDataSources(effectiveObjectCache.getEffectiveResultItems(this)));
            effectiveDataSources.addAll(this.getDataSources(effectiveObjectCache.getEffectiveSortOrderPrecedence(this)));
            effectiveDataSources.addAll(this.getDataSources(filters));
        } else {
            effectiveDataSources.addAll(this.getObjects(true, DataSource.class));
        }
        return new ArrayList<DataSource>(effectiveDataSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getEffectiveDataSources() throws MetadataException {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            List<DataSource> effectiveDataSources = effectiveObjectCache.getEffectiveDataSources(this);
            ArrayList<DataSource> arrayList = new ArrayList<DataSource>(effectiveDataSources);
            return arrayList;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public List<DataSource> getEffectiveDataSources(EffectiveObjectsCache effectiveObjectCache) throws MetadataException {
        return this.getEffectiveDataSources(effectiveObjectCache, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Join> getEffectiveJoinPath() throws MetadataException {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            List<Join> effectiveJoinPath;
            List<Join> list = effectiveJoinPath = this.getEffectiveJoinPath(effectiveObjectCache);
            return list;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public List<Join> getEffectiveJoinPath(EffectiveObjectsCache effectiveObjectCache) throws MetadataException {
        List<Join> joinPath;
        if (this.getStructure().isRelational()) {
            JoinPathGeneratorImpl joinPathGenerator = new JoinPathGeneratorImpl(this);
            List<BusinessModelObject> generatedPath = joinPathGenerator.generateJoinPath(effectiveObjectCache);
            if (generatedPath.isEmpty()) {
                joinPath = Collections.emptyList();
            } else if (!(generatedPath.get(0) instanceof Join)) {
                joinPath = Collections.emptyList();
            } else {
                joinPath = new ArrayList<Join>(generatedPath.size());
                for (BusinessModelObject bmo : generatedPath) {
                    if (!(bmo instanceof Join)) continue;
                    joinPath.add((Join)bmo);
                }
            }
        } else {
            joinPath = Collections.emptyList();
        }
        return joinPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CascadeRuleSet getCascadeRuleSet() throws MetadataException {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            CascadeRuleSet cascadeRuleSet;
            CascadeRuleSet cascadeRuleSet2 = cascadeRuleSet = this.getCascadeRuleSet(effectiveObjectCache);
            return cascadeRuleSet2;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public CascadeRuleSet getCascadeRuleSet(EffectiveObjectsCache effectiveObjectCache) throws MetadataException {
        CascadeRuleSetImpl results = new CascadeRuleSetImpl();
        IdentityHashMap dependentPrompts = new IdentityHashMap();
        PromptValuesInterface queryPv = this.getPromptValues(effectiveObjectCache);
        List allUnusedBusinessPrompts = this.getBusinessPrompts(effectiveObjectCache);
        ArrayList<FilterItem> allUsedFilters = new ArrayList<FilterItem>(effectiveObjectCache.getEffectiveFilters(this));
        ArrayList<FilterCascadeInterface> filterCascades = new ArrayList<FilterCascadeInterface>();
        for (Object filter : allUsedFilters.toArray()) {
            if (filter instanceof FilterCascadeContainer) {
                FilterCascadeContainer fcc = (FilterCascadeContainer)filter;
                filterCascades.addAll(fcc.getCascades(true));
            }
            IQModelImplUtilities.addButNoDuplicates(allUsedFilters, ((FilterItem)filter).getResources(FilterItem.class, 1));
        }
        List<FilterCascadeRule> filterCascadeRules = this.getObjects(true, FilterCascadeRule.class);
        int numOfCascades = filterCascades.size() + filterCascadeRules.size();
        if (numOfCascades > 0) {
            for (FilterCascadeInterface filterCascadeInterface : filterCascadeRules) {
                Prompt prompt = filterCascadeInterface.getBusinessPrompt();
                if (prompt == null || !this.validateFilterUsage(filterCascadeInterface.getDependentFilter(), allUsedFilters)) continue;
                this.updateDependentPrompts(dependentPrompts, queryPv, filterCascadeInterface);
                allUnusedBusinessPrompts.remove(prompt);
            }
            for (FilterCascadeInterface filterCascadeInterface : filterCascades) {
                Prompt prompt = filterCascadeInterface.getBusinessPrompt();
                if (prompt == null) continue;
                this.updateDependentPrompts(dependentPrompts, queryPv, filterCascadeInterface);
                allUnusedBusinessPrompts.remove(prompt);
            }
        }
        List<DataSelection> subqueries = DataSelectionOrganizer.getAllSubqueries(this);
        for (BusinessQuery businessQuery : subqueries) {
            CascadeRuleSet subQueryRuleSet = businessQuery.getCascadeRuleSet();
            results.addAllCascadeRules(subQueryRuleSet.getRules());
        }
        List<PromptDefinitionInterface> list = this.getPromptDefinitionsInPrefilters(effectiveObjectCache);
        if (!list.isEmpty()) {
            this.addPromptDependenciesFromCollection(dependentPrompts, queryPv, allUnusedBusinessPrompts, list);
        }
        results.addAllCascadeRules(dependentPrompts.values());
        Collection<PromptDefinitionInterface> spd = this._queryPrompts.getDependentStoredProcessPrompts(effectiveObjectCache);
        if (!spd.isEmpty()) {
            this.addPromptDependenciesFromCollection(dependentPrompts, queryPv, allUnusedBusinessPrompts, spd);
        }
        results.addAllCascadeRules(dependentPrompts.values());
        return results;
    }

    private List<PromptDefinitionInterface> getPromptDefinitionsInPrefilters(EffectiveObjectsCache effectiveObjectCache) {
        ArrayList<PromptDefinitionInterface> promptDefinitions = new ArrayList<PromptDefinitionInterface>();
        Map<FilterSetMember, List<Prompt>> promptsUsedByDataSources = this.getPromptsInDataSourcePrefilters(effectiveObjectCache);
        LinkedHashSet<Prompt> promptsFound = new LinkedHashSet<Prompt>();
        Iterator<FilterSetMember> iter = promptsUsedByDataSources.keySet().iterator();
        while (iter.hasNext()) {
            List<Prompt> prompts = promptsUsedByDataSources.get(iter.next());
            for (Prompt prompt : prompts) {
                if (!promptsFound.add(prompt)) continue;
                PromptDefinitionInterface promptDefinition = prompt.getPromptDefinition();
                promptDefinitions.add(promptDefinition);
            }
        }
        return promptDefinitions;
    }

    private void addPromptDependenciesFromCollection(IdentityHashMap dependentPrompts, PromptValuesInterface queryPv, List allUnusedBusinessPrompts, Collection promptsToBeDependentOn) {
        ArrayList<CascadeRuleImpl> ccrWithDynamicValueProviders = new ArrayList<CascadeRuleImpl>();
        Set allCascadeRules = dependentPrompts.entrySet();
        for (Map.Entry ruleEntry : allCascadeRules) {
            CascadeRuleImpl rule = (CascadeRuleImpl)ruleEntry.getValue();
            if (!this.usesADynamicValueProvider(rule.getItem().getPrompt())) continue;
            ccrWithDynamicValueProviders.add(rule);
        }
        int numOfUnusedPrompts = allUnusedBusinessPrompts.size();
        for (int i = 0; i < numOfUnusedPrompts; ++i) {
            Prompt businessPrompt = (Prompt)allUnusedBusinessPrompts.get(i);
            PromptDefinitionInterface pd = businessPrompt.getPromptDefinition();
            if (!this.usesADynamicValueProvider(pd)) continue;
            if (!dependentPrompts.keySet().contains(pd)) {
                PromptValuesInterface pv = queryPv.findPromptValuesForPromptDefinition(pd);
                CascadeRuleImpl rule = new CascadeRuleImpl(new CascadeRuleItemImpl(pd, pv));
                dependentPrompts.put(pd, rule);
                ccrWithDynamicValueProviders.add(rule);
                continue;
            }
            CascadeRuleImpl rule = (CascadeRuleImpl)dependentPrompts.get(pd);
            ccrWithDynamicValueProviders.add(rule);
        }
        if (!ccrWithDynamicValueProviders.isEmpty()) {
            for (PromptDefinitionInterface pd : promptsToBeDependentOn) {
                PromptValuesInterface pdpv = queryPv.findPromptValuesForPromptDefinition(pd);
                CascadeRuleItemImpl crItem = new CascadeRuleItemImpl(pd, pdpv);
                for (CascadeRuleImpl rule : ccrWithDynamicValueProviders) {
                    if (rule.getItem().getPrompt() == crItem.getPrompt()) continue;
                    rule.addDependentItem(0, crItem);
                }
            }
        }
    }

    private boolean usesADynamicValueProvider(PromptDefinitionInterface pd) {
        ValueProviderDefinitionInterface vp;
        boolean result = false;
        if (pd instanceof ValueProviderDefinitionInterface && (vp = (ValueProviderDefinitionInterface)pd).getValueProvider() instanceof DynamicValueProviderInterface) {
            result = true;
        }
        return result;
    }

    private void updateDependentPrompts(IdentityHashMap dependentPrompts, PromptValuesInterface queryPv, FilterCascadeInterface fc) {
        PromptDefinitionInterface pd = fc.getPrompt();
        CascadableFilter filter = fc.getDependentFilter();
        CascadeRuleImpl rule = (CascadeRuleImpl)dependentPrompts.get(pd);
        if (rule == null) {
            PromptValuesInterface pv = queryPv.findPromptValuesForPromptDefinition(pd);
            rule = new CascadeRuleImpl(new CascadeRuleItemImpl(pd, pv));
            dependentPrompts.put(pd, rule);
        }
        rule.addDependentFilter(filter);
        Collection<PromptDefinitionInterface> dps = fc.getDependentPrompts();
        for (PromptDefinitionInterface dpd : dps) {
            PromptValuesInterface pdpv = queryPv.findPromptValuesForPromptDefinition(dpd);
            rule.addDependentItem(new CascadeRuleItemImpl(dpd, pdpv));
        }
    }

    @Nonnull
    protected Map<FilterSetMember, List<Prompt>> getPromptsInDataSourcePrefilters(EffectiveObjectsCache effectiveObjectCache) {
        LinkedHashMap<FilterSetMember, List<Prompt>> promptsUsedByDataSources = new LinkedHashMap<FilterSetMember, List<Prompt>>();
        if (!this.getStructure().isOLAP()) {
            try {
                List<DataSource> dataSources = this.getEffectiveDataSources(effectiveObjectCache);
                ArrayList pcValues = new ArrayList();
                for (BusinessModel model = this.getBusinessModel(); model != null; model = model.getParentBusinessModel()) {
                    if (!(model instanceof FilterSetRulesContainer)) continue;
                    pcValues.clear();
                    if (model instanceof InformationMapImpl2) {
                        ((InformationMapImpl2)model).getOmrPermissionConditions(pcValues);
                    }
                    FilterSetRulesContainer fsrc = (FilterSetRulesContainer)((Object)model);
                    FilterSet generalFilterSet = fsrc.getGeneralFilterSet();
                    for (DataSource dataSource : dataSources) {
                        if (!(dataSource instanceof FilterSetMember)) continue;
                        FilterSetMember fsm = (FilterSetMember)((Object)dataSource);
                        try {
                            if (generalFilterSet != null) {
                                FilterSetRuleItems generalRules = generalFilterSet.getFilterSetRuleItems(fsm);
                                this.extractPrompts(promptsUsedByDataSources, fsm, generalRules);
                            }
                            FilterSetRuleItems sessionRules = fsrc.getSessionFilterSetRuleList(fsm, pcValues);
                            this.extractPrompts(promptsUsedByDataSources, fsm, sessionRules);
                        }
                        catch (MetadataException e) {
                            if (!_logger.isDebugEnabled()) continue;
                            String member = "" + fsm;
                            if (fsm instanceof AbstractModelItem) {
                                member = ((AbstractModelItem)((Object)fsm)).getIdentityString();
                            }
                            String set = "" + fsrc;
                            if (fsrc instanceof AbstractModelItem) {
                                set = ((AbstractModelItem)((Object)fsrc)).getIdentityString();
                            }
                            _logger.debug("Exception trying to get prefilters for " + member + " from " + set, (Throwable)e);
                        }
                    }
                }
            }
            catch (MetadataException e) {
                _logger.debug("Exception trying to get a prompt from filters on data sources", (Throwable)e);
            }
        }
        return promptsUsedByDataSources;
    }

    private void extractPrompts(Map<FilterSetMember, List<Prompt>> promptsUsedByDataSources, FilterSetMember fsm, FilterSetRuleItems rules) {
        if (rules != null) {
            List<Prompt> bmoPrompts = rules.getResources(Prompt.class, 65535);
            for (Prompt prompt : bmoPrompts) {
                List<Prompt> promptsUsed = promptsUsedByDataSources.get(fsm);
                if (promptsUsed == null) {
                    promptsUsed = new ArrayList<Prompt>();
                    promptsUsedByDataSources.put(fsm, promptsUsed);
                }
                if (promptsUsed.contains(prompt)) continue;
                promptsUsed.add(prompt);
            }
        }
    }

    private boolean validateFilterUsage(CascadableFilter filter, List allUsedFilters) {
        return true;
    }

    protected List getBusinessPrompts(EffectiveObjectsCache effectiveObjectCache) {
        ArrayList promptsUsed = new ArrayList();
        Map<FilterSetMember, List<Prompt>> promptsUsedByDataSources = this.getPromptsInDataSourcePrefilters(effectiveObjectCache);
        for (Map.Entry<FilterSetMember, List<Prompt>> entry : promptsUsedByDataSources.entrySet()) {
            List<Prompt> valueList = entry.getValue();
            Utils.addButNoDuplicates(promptsUsed, valueList);
        }
        this.addPrompts(promptsUsed, effectiveObjectCache.getEffectiveResultItems(this));
        this.addPrompts(promptsUsed, effectiveObjectCache.getEffectiveSortOrderPrecedence(this));
        this.addPrompts(promptsUsed, effectiveObjectCache.getEffectiveFilters(this));
        this.addPrompts(promptsUsed, effectiveObjectCache.getEffectiveGroups(this));
        this.addPrompts(promptsUsed, effectiveObjectCache.getEffectiveBusinessRules(this));
        return promptsUsed;
    }

    private void addPrompts(List prompts, List objs) {
        for (BusinessModelObject bmo : objs) {
            List<Prompt> bmoPrompts = bmo.getResources(Prompt.class, 65535);
            Utils.addButNoDuplicates(prompts, bmoPrompts);
        }
    }

    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
        super.accumulateDirectlyReferencedItemsInDownwardDefinition(intoList);
        if (this._explicitJoinPath != null) {
            intoList.addAll(this._explicitJoinPath);
        }
        if (this._columnSteps != null) {
            intoList.addAll(this._columnSteps);
        }
        if (this.filters != null) {
            intoList.addAll(this.filters);
        }
        if (this._rowSteps != null) {
            intoList.addAll(this._rowSteps);
        }
        if (this.selectedItems != null) {
            intoList.addAll(this.selectedItems);
        }
        if (this.sortOrderPrecedence != null) {
            intoList.addAll(this.sortOrderPrecedence);
        }
        if (this.sortColumnCriteria != null) {
            this.accumulateFromSortCriteria(intoList, this.sortColumnCriteria);
        }
        if (this.sortRowCriteria != null) {
            this.accumulateFromSortCriteria(intoList, this.sortRowCriteria);
        }
        if (this._groups != null) {
            intoList.addAll(this._groups);
        }
    }

    private void accumulateFromSortCriteria(List intoList, List sortCriteria) {
        if (sortCriteria != null) {
            int size = sortCriteria.size();
            for (int i = 0; i < size; ++i) {
                Object obj = sortCriteria.get(i);
                if (obj instanceof List) {
                    intoList.addAll((List)obj);
                    continue;
                }
                if (!(obj instanceof AbstractBase)) continue;
                intoList.add(obj);
            }
        }
    }

    @Override
    protected void replaceDirectReferences(Object replaceThis, Object withThis) {
        super.replaceDirectReferences(replaceThis, withThis);
        DataSelectionImpl.replaceInList(this.cachedResultItems, replaceThis, withThis);
        DataSelectionImpl.replaceInJavaMap(this.cachedSelectedItemsByRole, replaceThis, withThis);
        DataSelectionImpl.replaceInList(this._columnSteps, replaceThis, withThis);
        DataSelectionImpl.replaceInList(this.filters, replaceThis, withThis);
        DataSelectionImpl.replaceInList(this._rowSteps, replaceThis, withThis);
        DataSelectionImpl.replaceInList(this.selectedItems, replaceThis, withThis);
        DataSelectionImpl.replaceInList(this.sortColumnCriteria, replaceThis, withThis);
        DataSelectionImpl.replaceInList(this.sortOrderPrecedence, replaceThis, withThis);
        DataSelectionImpl.replaceInList(this.sortRowCriteria, replaceThis, withThis);
        DataSelectionImpl.replaceInList(this._explicitJoinPath, replaceThis, withThis);
        DataSelectionImpl.replaceInList(this._groups, replaceThis, withThis);
    }

    @Override
    protected void clearReferencesToModelItems() {
        super.clearReferencesToModelItems();
        CancelQuerySupport.unRegisterQuery(this);
        this.cachedResultItems = (List)this.clearItemUsages(this.cachedResultItems);
        this.cachedSelectedItemsByRole = (HashMap)this.clearItemUsages(this.cachedSelectedItemsByRole);
        this._columnSteps = (List)this.clearItemUsages(this._columnSteps);
        this.filters = (List)this.clearItemUsages(this.filters);
        this._rowSteps = (List)this.clearItemUsages(this._rowSteps);
        this.selectedItems = (List)this.clearItemUsages(this.selectedItems);
        this.sortColumnCriteria = (List)this.clearItemUsages(this.sortColumnCriteria);
        this.sortOrderPrecedence = (List)this.clearItemUsages(this.sortOrderPrecedence);
        this.sortRowCriteria = (List)this.clearItemUsages(this.sortRowCriteria);
        this._explicitJoinPath = (List)this.clearItemUsages(this._explicitJoinPath);
        this.queryProperties.dispose();
        this.queryProperties = null;
        this._queryPrompts.dispose();
        this._queryPrompts = null;
        this._groups.clear();
    }

    @Override
    public boolean isCancelEnabled() {
        return this._cancelEnabled;
    }

    @Override
    public void setCancelEnabled(boolean enable) {
        if (!enable) {
            CancelQuerySupport.unRegisterQuery(this);
        }
        this._cancelEnabled = enable;
    }

    public void setExplicitJoinPath(List explicitJoinPath) throws MetadataException {
        boolean ok = IQModelImplUtilities.objectsAreOfTypes(explicitJoinPath = ListUtils.newList(explicitJoinPath), VALID_TYPES_JOIN_PATH_IMPLS);
        if (!ok) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("BusinessQueryImplAllObjectsNotJoinObjects.txt", new Object[0]));
        }
        if (!this.isActionSupported(BusinessQueryActionType.EXPLICIT_JOIN_PATH)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionImplJoinPathNotEnabled.txt", new Object[0]));
        }
        Iterator iterator = null;
        if (!this._explicitJoinPath.isEmpty()) {
            for (Join join : this._explicitJoinPath) {
                join.removeListener(this);
            }
        }
        this._explicitJoinPath = explicitJoinPath;
        if (!this._explicitJoinPath.isEmpty()) {
            for (Join join : this._explicitJoinPath) {
                join.addListener(this);
            }
        }
        this.fireChangeEvent("The list of explicit joins to use has changed");
    }

    public List getExplicitJoinPath() {
        return ListUtils.newList(this._explicitJoinPath);
    }

    @Override
    public AssociationMatrix newAssociationMatrix() throws MetadataException {
        AssociationMatrixImpl matrix = new AssociationMatrixImpl(this);
        return matrix;
    }

    @Override
    public void setGroups(List<BusinessGroup> groupsList) throws MetadataException {
        this._groups = groupsList;
    }

    @Override
    public List<BusinessGroup> getGroups() {
        ArrayList<BusinessGroup> gp = new ArrayList<BusinessGroup>(this._groups);
        return gp;
    }

    @Override
    public List<BusinessGroup> getEffectiveGroups() {
        ArrayList<BusinessGroup> gp = new ArrayList<BusinessGroup>(this._groups);
        return gp;
    }

    @Override
    public List<BusinessGroup> getEffectiveGroupsByType(BusinessGroup.Type type) {
        ArrayList<BusinessGroup> gpByType = new ArrayList<BusinessGroup>();
        for (BusinessGroup bgp : this._groups) {
            if (bgp.getType() != type) continue;
            gpByType.add(bgp);
        }
        return gpByType != null ? gpByType : Collections.emptyList();
    }

    @Override
    public List<BusinessGroup> getEffectiveGroupsContaining(BusinessModelObject bi) {
        return this.getEffectiveGroupsContaining(bi, null);
    }

    @Override
    public List<BusinessGroup> getEffectiveGroupsContaining(BusinessModelObject bi, BusinessGroup.Type type) {
        ArrayList<BusinessGroup> foundGroups = new ArrayList<BusinessGroup>();
        for (BusinessGroup group : this._groups) {
            List<BusinessModelObject> bmos = group.getItems();
            for (BusinessModelObject bmo : bmos) {
                if ((bmo != null || bi != null) && (bmo == null || bi == null || !bi.equals(bmo)) || type != null && group.getType() != type || foundGroups.contains(group)) continue;
                foundGroups.add(group);
            }
        }
        return foundGroups;
    }

    private List<DataSource> findRequiredDataSources(EffectiveObjectsCache effectiveObjectCache) throws MetadataException {
        List<DataSource> requiredDataSources;
        List<RequiredDataSources> effectiveRequiredDataSources = effectiveObjectCache.getEffectiveRequiredDataSources(this);
        if (effectiveRequiredDataSources.size() > 0) {
            RequiredDataSources rds = effectiveRequiredDataSources.get(effectiveRequiredDataSources.size() - 1);
            try {
                requiredDataSources = rds.getDataSources();
            }
            catch (IQueryServicesException e) {
                if (_logger.isEnabled(Level.WARN)) {
                    _logger.warn(e.getLocalizedMessage(), (Throwable)e);
                }
                throw new MetadataException(e);
            }
        } else {
            requiredDataSources = Collections.emptyList();
        }
        return requiredDataSources;
    }

    static {
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.FILTER_ITEM);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.PROPERTY_RETURN_DISTINCT_VALUES);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.PROPERTY_RETURN_UNFORMATTED_DATA);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.PROPERTY_EXCLUDE_EMPTY_DATA);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.PROPERTY_EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.RESULT_ITEM);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.SORT_CRITERIA);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.SORT_ORDER_PRECEDENCE);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.TOTAL);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.EXPLICIT_JOIN_PATH);
        VALID_RELATIONAL_ACTIONS.add(BusinessQueryActionType.PROPERTY_JOIN_PATH_OPTIMIZATIONS_DISABLED);
        VALID_OLAP_ACTIONS = new ArrayList<BusinessQueryActionType>();
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.FILTER_ITEM);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.FORMAT_EMPTY);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.STEP_EXCLUDE);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.PROPERTY_EXCLUDE_EMPTY_DATA);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.PROPERTY_RETURN_UNFORMATTED_DATA);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.RESULT_ITEM);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.SORT_ASCENDING);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.SORT_DESCENDING);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.SORT_NONE);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.SORT_CRITERIA);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.SORT_ORDER_PRECEDENCE);
        VALID_OLAP_ACTIONS.add(BusinessQueryActionType.TOTAL);
        VALID_TYPES_JOIN_PATH_IMPLS = new Class[]{JoinImpl.class};
    }

    private static class DataItemsReasonsHolder {
        ArrayList<DataItem> _dataItems = new ArrayList();
        List<Reason> _reasons = new ArrayList<Reason>();

        private List<DataItem> getDataItems() {
            return this._dataItems;
        }

        private List<Reason> getReasons() {
            return this._reasons;
        }
    }
}

