/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemExtendedType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.FolderItem;
import com.sas.iquery.metadata.business.Lookup;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractDataItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.DataItemImpl;
import com.sas.iquery.metadata.business.impl.OlapDataItemSortCriteria;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.StepManager;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.util.LocalizableString;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DataItemReferenceImpl
extends AbstractDataItem
implements DataItemReference,
FolderItem {
    private static final String DEFAULT_ID_PREFIX = "DIR_";
    private DataItem baseDataItem;
    private boolean labelModified = false;
    private boolean descriptionModified = false;
    private boolean labelsModified = false;
    private boolean descriptionsModified = false;
    private boolean formatModified = false;
    private String modifiedFormat;
    private boolean lookupModified = false;
    private Lookup modifiedLookupType;
    private boolean extendedTypeModified = false;
    private DataItemExtendedType modifiedExtendedType;
    private boolean aggregationTypeModified = false;
    private Function modifiedAggregationType;
    private boolean sortDirectionModified = false;
    private DataItemActionType modifiedSortDirection;
    private boolean groupFormattingModified = false;
    private DataItemActionType modifiedGroupFormatting;
    private boolean sortFormattingModified = false;
    private DataItemActionType modifiedSortFormatting;
    private boolean usageModified = false;
    private DataItemActionType modifiedUsage;
    private boolean formattingForcedModified = false;
    private boolean modifiedFormattingForced = false;
    private boolean extendedAttributesModified = false;
    private List<DataItemActionType> _disabledActions = new ArrayList<DataItemActionType>(0);
    private List<Function> _disabledAggregationTypes = new ArrayList<Function>(0);
    private boolean sortCriteriaModified = false;
    private OlapDataItemSortCriteria modifiedSortCriteria;
    private boolean startingLevelModified = false;
    private boolean startingLevelNameModified = false;
    private com.sas.iquery.metadata.physical.Level modifiedStartingLevel = null;
    private String modifiedStartingLevelName = null;
    private boolean memberPropertiesModified = false;
    private List<String> modifiedMemberProperties = new ArrayList<String>();
    private List<StepInterface> steps = new ArrayList<StepInterface>();
    private boolean userConsidersEquivalentToParent = true;
    private String resultSetID;
    private static final Logger _logger = LogManager.getLogger(DataItemReferenceImpl.class);

    DataItemReferenceImpl(AbstractBusinessModel businessModel, DataItem dataItem) throws MetadataException {
        super(businessModel);
        this.setBaseDataItem(dataItem);
        this.resultSetID = super.getIntraModelID();
    }

    DataItemReferenceImpl(AbstractBusinessModel businessModel) {
        super(businessModel);
    }

    public DataItemReferenceImpl() {
    }

    @Override
    protected String getDefaultIDPrefix() {
        return DEFAULT_ID_PREFIX;
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        this.baseDataItem = (DataItem)Utils.replaceResource(this.baseDataItem, oldResource, newResource, model, recursive);
        if (this.steps != null) {
            for (int i = 0; i < this.steps.size(); ++i) {
                StepInterface obj = this.steps.get(i);
                if (!(obj instanceof BusinessModelResourceReferencer)) continue;
                BusinessModelResourceReferencer refr = obj;
                refr.replaceResource(oldResource, newResource, model, recursive);
            }
        }
    }

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        DataItemActionType currentUsage;
        String currentFormat;
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (!this.formatModified || !this.isActionSupported(DataItemActionType.OTHER_FORMAT)) {
            // empty if block
        }
        if (!this.isValidFormat(currentFormat = this.getFormat())) {
            reasons.add(new Reason((Object)this, 2, 27, "DataItem.InvalidFormat.fmt.txt", currentFormat, this.getLabel()));
        }
        if (!this.isValidUsage(currentUsage = this.getUsage())) {
            reasons.add(new Reason((Object)this, 2, 70, "DataItem.InvalidUsage.fmt.txt", currentUsage, this.getLabel()));
        }
        if (this.aggregationTypeModified && this.modifiedAggregationType != null && !this.isAggregationTypeSupported(this.modifiedAggregationType)) {
            reasons.add(new Reason((Object)this, 2, 57, "DataItemReferenceImpl.AggregationFunctionModifiedWithIllegalValue.fmt.txt", this.getIdentityString(), this.modifiedAggregationType.toString()));
        }
        if (this.usageModified && this.modifiedUsage != null && !this.isActionSupported(this.modifiedUsage)) {
            reasons.add(new Reason((Object)this, 2, 58, "DataItemReferenceImpl.UsageModifiedButNotAllowed.fmt.txt", this.getIdentityString(), this.modifiedUsage.toString()));
        }
        if (this.sortDirectionModified && this.modifiedSortDirection != null && !this.isActionSupported(this.modifiedSortDirection)) {
            reasons.add(new Reason((Object)this, 2, 59, "DataItemReferenceImpl.SortDirectionModifiedButNotAllowed.fmt.txt", this.getIdentityString(), this.modifiedSortDirection.toString()));
        }
        if (this.groupFormattingModified && this.modifiedGroupFormatting != null && !this.isActionSupported(this.modifiedGroupFormatting)) {
            reasons.add(new Reason((Object)this, 2, 242, "DataItemReferenceImpl.GroupFormattingModifiedButNotAllowed.fmt.txt", this.getIdentityString(), this.modifiedGroupFormatting));
        }
        if (this.sortFormattingModified && this.modifiedSortFormatting != null && !this.isActionSupported(this.modifiedSortFormatting)) {
            reasons.add(new Reason((Object)this, 2, 243, "DataItemReferenceImpl.SortFormattingModifiedButNotAllowed.fmt.txt", this.getIdentityString(), this.modifiedSortFormatting));
        }
        if (this.sortCriteriaModified && !this.isActionSupported(DataItemActionType.SORT_CRITERIA)) {
            reasons.add(new Reason((Object)this, 2, 60, "DataItemReferenceImpl.SortCriteriaModifiedButNotAllowed.fmt.txt", this.getIdentityString()));
        }
        try {
            boolean isValidResultSetID = this.isValidResultSetID(this.resultSetID, this);
            if (!isValidResultSetID) {
                reasons.add(new Reason((Object)this, 2, 229, "DataItem.InvalidResultID.fmt.txt", this.resultSetID));
            }
        }
        catch (MetadataException e) {
            reasons.add(new Reason((Object)this, 2, 229, e));
        }
    }

    @Override
    protected String getDefinitionElementName() {
        return "DataItemReference";
    }

    @Override
    public DataItem getBaseDataItem() {
        return this.baseDataItem;
    }

    @Override
    public void setExpression(ExpressionInterface expression) throws MetadataException {
        throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemReferenceImplIllegalUseOnExpression.txt", new Object[0]));
    }

    @Override
    public ExpressionInterface getExpression() {
        return this.baseDataItem.getExpression();
    }

    @Override
    public StructureOfDataItem getStructure() {
        return this.baseDataItem.getStructure();
    }

    @Override
    public boolean isEquivalentToParent() {
        return this.userConsidersEquivalentToParent;
    }

    @Override
    public void setIsEquivalentToParent(boolean equiv) {
        this.userConsidersEquivalentToParent = equiv;
    }

    @Override
    public String getLabel() {
        String returnValue = null;
        if (this.isLabelModified()) {
            returnValue = super.getLabel();
        } else if (this.baseDataItem != null) {
            returnValue = this.baseDataItem.getLabel();
        }
        return returnValue;
    }

    @Override
    public void setLabel(String label) throws MetadataException {
        this.changeableCheck();
        this.unresolvedCheck();
        List<Reason> reasons = DataItemImpl.getReasonsLabelNotValid(this, label);
        if (!reasons.isEmpty()) {
            Reason reason = reasons.get(0);
            if (reason.getSubReason() == 251) {
                MetadataException exception = new MetadataException(IQMetadataResourceBundle.getMessageFormatter("AbstractBusinessModel.InvalidLabelChars.txt", new Object[0]));
                throw exception;
            }
            MetadataException exception = new MetadataException(null, reasons);
            throw exception;
        }
        this.labelModified = true;
        super.setLabel(label);
    }

    @Override
    public List<Reason> getReasonsLabelNotValid(String label) throws MetadataException {
        return DataItemImpl.getReasonsLabelNotValid(this, label);
    }

    @Override
    public boolean isLabelModified() {
        return this.labelModified;
    }

    @Override
    public void resetLabel() throws MetadataException {
        this.changeableCheck();
        this.labelModified = false;
        this.fireChangeEvent("label changed");
    }

    @Override
    public String getDescription() {
        String returnValue = null;
        returnValue = this.isDescriptionModified() ? super.getDescription() : this.baseDataItem.getDescription();
        return returnValue;
    }

    @Override
    public void setDescription(String description) throws MetadataException {
        this.changeableCheck();
        this.descriptionModified = true;
        super.setDescription(description);
    }

    @Override
    public boolean isDescriptionModified() {
        return this.descriptionModified;
    }

    @Override
    public void resetDescription() throws MetadataException {
        this.changeableCheck();
        this.descriptionModified = false;
        this.fireChangeEvent("description changed");
    }

    @Override
    public String getFormat() {
        String returnValue = null;
        if (this.isFormatModified()) {
            returnValue = this.modifiedFormat;
        } else if (this.baseDataItem != null) {
            returnValue = this.baseDataItem.getFormat();
        }
        return returnValue;
    }

    @Override
    public void setFormat(String format) throws MetadataException {
        if (format == null && this.modifiedFormat == null && this.formatModified) {
            return;
        }
        if (format != null) {
            format = format.trim();
        }
        if (format != null && this.modifiedFormat != null && format.equals(this.modifiedFormat)) {
            return;
        }
        this.changeableCheck();
        if (!this.isActionSupported(DataItemActionType.OTHER_FORMAT)) {
            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItem.FormatNotAllowed.fmt.txt", this.getIdentityString());
            throw new MetadataException(messageFormatter);
        }
        DataItemImpl.setFormatCheck(this, format);
        this.modifiedFormat = format;
        this.formatModified = true;
        this.fireChangeEvent("The data item's format changed.");
    }

    @Override
    public boolean isFormatModified() {
        return this.formatModified;
    }

    @Override
    public void resetFormat() throws MetadataException {
        this.changeableCheck();
        this.modifiedFormat = null;
        this.formatModified = false;
        this.fireChangeEvent("The data item's format changed.");
    }

    @Override
    public boolean isValidFormat(String inputFormat) {
        boolean usageChanged = this.isUsageModified();
        ExpressionInterface expression = null;
        DataItemActionType newUsage = null;
        Function aggregationFunction = null;
        try {
            expression = this.getExpression();
            newUsage = this.getUsage();
            aggregationFunction = this.getAggregationType();
        }
        catch (MetadataUnresolvedException e) {
            BusinessModelResource unresolvedRes = e.getUnresolvedResource();
            String idString = unresolvedRes.getIdentityString();
            MessageFormatter warnMsg = IQMetadataResourceBundle.getMessageFormatter("DataItemImpl.UnresolvedResourceValidatingFmt.fmt.txt", expression == null ? "null" : idString);
            if (_logger.isEnabled(Level.WARN)) {
                _logger.warn(warnMsg.toString(), (Throwable)e);
            }
            return true;
        }
        boolean valid = DataItemImpl.isValidFormat(inputFormat, expression, newUsage, aggregationFunction);
        if (!valid && usageChanged && GenerationUtil.isTypeChanged(this)) {
            valid = true;
        }
        return valid;
    }

    protected boolean isValidUsage(DataItemActionType usage) {
        boolean returnValue = true;
        if (usage == null || !this.isActionSupported(usage)) {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public void setLookupType(Lookup lookupType) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNullWithMessage(lookupType, "DataItemReferenceImplNullLookup.txt", "lookupType");
        if (!this.isActionSupported(DataItemActionType.OTHER_LOOKUP)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemReferenceImplModLookNotAllowed.txt", new Object[0]));
        }
        this.lookupModified = true;
        this.modifiedLookupType = lookupType;
        this.fireChangeEvent("The data item's lookup type changed.");
    }

    @Override
    public Lookup getLookupType() {
        Lookup returnValue = null;
        if (this.isLookupTypeModified()) {
            returnValue = this.modifiedLookupType;
        } else if (this.baseDataItem != null) {
            returnValue = this.baseDataItem.getLookupType();
        }
        return returnValue;
    }

    @Override
    public boolean isLookupTypeModified() {
        return this.lookupModified;
    }

    @Override
    public void resetLookupType() throws MetadataException {
        this.changeableCheck();
        this.lookupModified = false;
        this.fireChangeEvent("The data item's lookup type changed.");
    }

    @Override
    public boolean isCalculatedItem() {
        boolean rc = false;
        if (this.baseDataItem != null) {
            rc = this.baseDataItem.isCalculatedItem();
        }
        return rc;
    }

    @Override
    public List<DataItemActionType> getValidActions() {
        List<DataItemActionType> outList = this.baseDataItem != null ? this.baseDataItem.getSupportedActionsList() : new ArrayList<DataItemActionType>();
        return outList;
    }

    @Override
    public List<DataItemActionType> getSupportedActionsList() {
        ArrayList<DataItemActionType> outList = new ArrayList<DataItemActionType>();
        List<Object> baseList = new ArrayList();
        if (this.baseDataItem != null) {
            baseList = this.baseDataItem.getSupportedActionsList();
        }
        for (DataItemActionType action : baseList) {
            if (this._disabledActions.contains(action)) continue;
            outList.add(action);
        }
        return outList;
    }

    @Override
    public boolean isActionSupported(DataItemActionType actionType) {
        Preconditions.ensureNonNull(actionType, "actionType");
        return this.getSupportedActionsList().contains(actionType);
    }

    @Override
    public void setActionSupported(DataItemActionType actionType, boolean actionSupported) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNull(actionType, "actionType");
        if (_logger.isDebugEnabled()) {
            _logger.debug("DataItemReferenceImpl.setActionSupported(" + actionType.toString() + "," + actionSupported + ")");
        }
        if (this.getValidActions().contains(actionType)) {
            if (!this._disabledActions.contains(actionType)) {
                if (!actionSupported) {
                    this._disabledActions.add(actionType);
                }
            } else if (actionSupported) {
                this._disabledActions.remove(actionType);
            }
        } else if (actionSupported) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemActionTypeInvalid.fmt.txt", actionType));
        }
        this.fireChangeEvent("The data item's supported actions changed.");
    }

    @Override
    public DataItemActionType getSortDirection() {
        DataItemActionType resultValue = null;
        resultValue = this.isSortDirectionModified() ? this.modifiedSortDirection : this.baseDataItem.getSortDirection();
        return resultValue;
    }

    @Override
    public void setSortDirection(DataItemActionType sortDirection) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNullWithMessage(sortDirection, "DataItemReferenceNullSortDirection.txt", "sortDirection");
        if (!this.isActionSupported(sortDirection)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemSortDirectionNotEnabled.txt", new Object[0]));
        }
        this.modifiedSortDirection = sortDirection;
        this.sortDirectionModified = true;
        this.fireChangeEvent("The data item's sort direction changed.");
    }

    @Override
    public boolean isSortDirectionModified() {
        return this.sortDirectionModified;
    }

    @Override
    public void resetSortDirection() throws MetadataException {
        this.changeableCheck();
        this.sortDirectionModified = false;
        this.fireChangeEvent("The data item's sort direction changed.");
    }

    @Override
    public DataItemActionType getGroupFormatting() throws MetadataException {
        DataItemActionType resultValue = null;
        resultValue = this.isGroupFormattingModified() ? this.modifiedGroupFormatting : this.baseDataItem.getGroupFormatting();
        return resultValue;
    }

    @Override
    public void setGroupFormatting(DataItemActionType formattingActionType) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNullWithMessage(formattingActionType, "DataItem.GroupFormattingIsNull.txt", "formattingActionType");
        if (!this.isActionSupported(formattingActionType)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItem.GroupFormattingNotEnabled.txt", new Object[0]));
        }
        boolean oldModified = this.groupFormattingModified;
        DataItemActionType oldFormatting = this.getGroupFormatting();
        this.groupFormattingModified = true;
        this.modifiedGroupFormatting = formattingActionType;
        if (!oldModified || oldFormatting != formattingActionType) {
            this.fireChangeEvent("The data item's gorup formatting changed.", oldFormatting, formattingActionType);
        }
    }

    @Override
    public boolean isGroupFormattingModified() {
        return this.groupFormattingModified;
    }

    @Override
    public void resetGroupFormatting() throws MetadataException {
        this.changeableCheck();
        if (this.groupFormattingModified) {
            DataItemActionType oldFormatting = this.getGroupFormatting();
            this.groupFormattingModified = false;
            DataItemActionType newFormatting = this.getGroupFormatting();
            this.fireChangeEvent("The data item's gorup formatting changed.", oldFormatting, newFormatting);
        }
    }

    @Override
    public void setSortFormatting(DataItemActionType formattingActionType) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNullWithMessage(formattingActionType, "DataItem.SortFormattingIsNull.txt", "formattingActionType");
        if (!this.isActionSupported(formattingActionType)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItem.SortFormattingNotEnabled.txt", new Object[0]));
        }
        boolean oldModified = this.sortFormattingModified;
        DataItemActionType oldFormatting = this.getSortFormatting();
        this.sortFormattingModified = true;
        this.modifiedSortFormatting = formattingActionType;
        if (!oldModified || oldFormatting != formattingActionType) {
            this.fireChangeEvent("The data item's sort formatting changed.", oldFormatting, formattingActionType);
        }
    }

    @Override
    public DataItemActionType getSortFormatting() throws MetadataException {
        DataItemActionType resultValue = null;
        resultValue = this.isSortFormattingModified() ? this.modifiedSortFormatting : this.baseDataItem.getSortFormatting();
        return resultValue;
    }

    @Override
    public boolean isSortFormattingModified() {
        return this.sortFormattingModified;
    }

    @Override
    public void resetSortFormatting() throws MetadataException {
        this.changeableCheck();
        if (this.sortFormattingModified) {
            DataItemActionType oldFormatting = this.getSortFormatting();
            this.sortFormattingModified = false;
            DataItemActionType newFormatting = this.getSortFormatting();
            this.fireChangeEvent("The data item's sort formatting changed.", oldFormatting, newFormatting);
        }
    }

    @Override
    public void setSortCriteria(List<String[]> sortCriteria) throws MetadataException {
        this.changeableCheck();
        if (!this.isActionSupported(DataItemActionType.SORT_CRITERIA)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemSortCriteriaNotEnabled.txt", new Object[0]));
        }
        this.modifiedSortCriteria = new OlapDataItemSortCriteria(sortCriteria);
        this.sortCriteriaModified = true;
        this.fireChangeEvent("The data item's sort criteria changed.");
    }

    public List getSortCriteria() {
        List<String[]> outList = null;
        outList = this.isSortCriteriaModified() ? this.modifiedSortCriteria.get() : this.baseDataItem.getSortCriteria();
        return outList;
    }

    @Override
    public boolean isSortCriteriaModified() {
        return this.sortCriteriaModified;
    }

    @Override
    public void resetSortCriteria() throws MetadataException {
        this.changeableCheck();
        this.sortCriteriaModified = false;
        this.fireChangeEvent("The data item's sort criteria changed.");
    }

    @Override
    public DataItemActionType getUsage() {
        DataItemActionType resultValue = null;
        if (this.isUsageModified()) {
            resultValue = this.modifiedUsage;
        } else if (this.baseDataItem != null) {
            resultValue = this.baseDataItem.getUsage();
        }
        return resultValue;
    }

    @Override
    public void setUsage(DataItemActionType usage) throws MetadataException {
        this.changeableCheck();
        if (_logger.isDebugEnabled()) {
            _logger.debug("DataItemReferenceImpl.setUsage(" + usage + ")");
        }
        if (!this.isActionSupported(usage)) {
            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItemUsageNotEnabled.fmt.txt", usage, this.getIdentityString());
            throw new MetadataException(messageFormatter);
        }
        this.usageModified = true;
        this.modifiedUsage = usage;
        this.fireChangeEvent("The data item's usage changed.");
    }

    @Override
    public boolean isUsageModified() {
        return this.usageModified;
    }

    @Override
    public void resetUsage() throws MetadataException {
        this.changeableCheck();
        this.usageModified = false;
        this.fireChangeEvent("The data item's usage changed.");
    }

    @Override
    public boolean isFormattingForced() {
        boolean resultValue = false;
        if (this.isFormattingForcedModified()) {
            resultValue = this.modifiedFormattingForced;
        } else if (this.baseDataItem != null) {
            resultValue = this.baseDataItem.isFormattingForced();
        }
        return resultValue;
    }

    @Override
    public void setFormattingForced(boolean value) throws MetadataException {
        this.changeableCheck();
        if (this.getStructure() != StructureOfDataItem.STRUCTURE_COLUMN) {
            StructureOfDataItem structure = this.getStructure();
            int choiceIndex = 1;
            if (structure == StructureOfDataItem.STRUCTURE_HIERARCHY) {
                choiceIndex = 2;
            } else if (structure == StructureOfDataItem.STRUCTURE_LEVEL) {
                choiceIndex = 3;
            } else if (structure == StructureOfDataItem.STRUCTURE_MEASURE) {
                choiceIndex = 4;
            } else if (structure == StructureOfDataItem.STRUCTURE_NAMED_SET) {
                choiceIndex = 5;
            } else if (structure == StructureOfDataItem.STRUCTURE_CALCULATED_MEMBER) {
                choiceIndex = 6;
            }
            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItem.FormattingForcedNotAllowed.fmt.txt", this.getLabel(), choiceIndex);
            throw new MetadataException(messageFormatter);
        }
        this.formattingForcedModified = true;
        this.modifiedFormattingForced = value;
        this.fireChangeEvent("This data item's attribute \"formatting forced\" has changed.");
    }

    @Override
    public boolean isFormattingForcedModified() {
        return this.formattingForcedModified;
    }

    @Override
    public void resetFormattingForced() {
        this.changeableCheck();
        this.formattingForcedModified = false;
        this.fireChangeEvent("This data item's attribute \"formatting forced\" has changed.");
    }

    @Override
    public boolean isMemberPropertiesModified() {
        return this.memberPropertiesModified;
    }

    @Override
    public boolean isStartingLevelModified() {
        return this.startingLevelModified;
    }

    @Override
    public boolean isStartingLevelNameModified() {
        return this.startingLevelNameModified;
    }

    @Override
    public void resetMemberProperties() throws MetadataException {
        this.changeableCheck();
        this.memberPropertiesModified = false;
        this.fireChangeEvent("The data item's list of member properties has changed.");
    }

    @Override
    public void resetStartingLevel() throws MetadataException {
        this.changeableCheck();
        this.startingLevelModified = false;
        this.fireChangeEvent("The data item's starting level has changed.");
    }

    @Override
    public void resetStartingLevelName() throws MetadataException {
        this.changeableCheck();
        this.startingLevelNameModified = false;
        this.fireChangeEvent("The data item's starting level name has changed.");
    }

    @Override
    public List<String> getMemberProperties() throws MetadataException {
        List<String> outList = this.isMemberPropertiesModified() ? ListUtils.newList(this.modifiedMemberProperties) : this.baseDataItem.getMemberProperties();
        return outList;
    }

    @Override
    public com.sas.iquery.metadata.physical.Level getStartingLevel() throws MetadataException {
        com.sas.iquery.metadata.physical.Level level = null;
        level = this.isStartingLevelModified() ? this.modifiedStartingLevel : this.baseDataItem.getStartingLevel();
        return level;
    }

    @Override
    public String getStartingLevelName() throws MetadataException {
        String level = null;
        level = this.isStartingLevelNameModified() ? this.modifiedStartingLevelName : this.baseDataItem.getStartingLevelName();
        return level;
    }

    @Override
    public void setMemberProperties(List<String> properties) throws MetadataException {
        this.changeableCheck();
        properties = ListUtils.newList(properties);
        Utils.ensureProperArgumentTypes(properties, new Class[]{String.class});
        if (!(this.getExpression() instanceof Hierarchy) && !(this.getExpression() instanceof OLAPResourceAwareStringExpression)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemExpressionInvalidForMemberProps.txt", new Object[0]));
        }
        if (!IQModelImplUtilities.same(this.modifiedMemberProperties, properties)) {
            this.modifiedMemberProperties = properties;
            this.memberPropertiesModified = true;
            this.fireChangeEvent("The data item's list of member properties has changed.");
        }
    }

    @Override
    public void setStartingLevel(com.sas.iquery.metadata.physical.Level level) throws MetadataException {
        this.changeableCheck();
        if (!(this.getExpression() instanceof Hierarchy)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemExpressionInvalidForStartingLevel.txt", new Object[0]));
        }
        this.modifiedStartingLevel = level;
        this.startingLevelModified = true;
        this.modifiedStartingLevelName = null;
        this.startingLevelNameModified = true;
    }

    @Override
    public void setStartingLevelName(String levelName) throws MetadataException {
        this.changeableCheck();
        this.modifiedStartingLevelName = levelName;
        this.startingLevelNameModified = true;
        this.modifiedStartingLevel = null;
        this.startingLevelModified = true;
    }

    @Override
    public Function getAggregationType() {
        Function resultValue = null;
        if (this.isAggregationTypeModified()) {
            resultValue = this.modifiedAggregationType;
        } else if (this.baseDataItem != null) {
            resultValue = this.baseDataItem.getAggregationType();
        }
        return resultValue;
    }

    @Override
    public void setAggregationType(Function aggregationType) throws MetadataException {
        this.changeableCheck();
        if (!this.isAggregationTypeSupported(aggregationType)) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemAggregationNotEnabled.fmt.txt", aggregationType, this.getIdentityString()));
        }
        this.aggregationTypeModified = true;
        this.modifiedAggregationType = aggregationType;
        this.fireChangeEvent("The data item's aggregation type changed.");
    }

    @Override
    public boolean isAggregationTypeModified() {
        return this.aggregationTypeModified;
    }

    @Override
    public void resetAggregationType() throws MetadataException {
        this.changeableCheck();
        this.aggregationTypeModified = false;
        this.fireChangeEvent("The data item's aggregation type changed.");
    }

    public List getValidAggregationTypes() {
        return this.baseDataItem.getSupportedAggregationTypesList();
    }

    @Override
    public List<Function> getSupportedAggregationTypesList() {
        ArrayList<Function> outList = new ArrayList<Function>();
        List<Object> baseList = new ArrayList();
        if (this.baseDataItem != null) {
            baseList = this.baseDataItem.getSupportedAggregationTypesList();
        }
        for (Function function : baseList) {
            if (this._disabledAggregationTypes.contains(function)) continue;
            outList.add(function);
        }
        return outList;
    }

    @Override
    public void setAggregationTypeSupported(Function aggregationType, boolean aggregationTypeSupported) throws MetadataException {
        this.changeableCheck();
        if (_logger.isDebugEnabled()) {
            _logger.debug("DataItemReferenceImpl.setAggregationTypeSupported(" + aggregationType.toString() + "," + aggregationTypeSupported + ")");
        }
        if (this.getValidAggregationTypes().contains(aggregationType)) {
            if (!this._disabledAggregationTypes.contains(aggregationType)) {
                if (!aggregationTypeSupported) {
                    if (aggregationType == this.getAggregationType()) {
                        MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItem.CannotDisableUsedAggregateFunction.fmt.txt", aggregationType, this.getIdentityString());
                        throw new MetadataException(messageFormatter);
                    }
                    this._disabledAggregationTypes.add(aggregationType);
                }
            } else if (aggregationTypeSupported) {
                this._disabledAggregationTypes.remove(aggregationType);
            }
        } else if (aggregationTypeSupported) {
            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("DataItemAggregationNotValidOrSupport.fmt.txt", aggregationType);
            throw new MetadataException(messageFormatter);
        }
        this.fireChangeEvent("The data item's list of supported/enabled aggregation types changed.");
    }

    @Override
    public boolean isAggregationTypeSupported(Function aggregationType) {
        Preconditions.ensureNonNull(aggregationType, "aggregationType");
        return this.getSupportedAggregationTypesList().contains(aggregationType);
    }

    @Override
    public boolean hasSteps() {
        boolean returnValue = false;
        if (this.steps.size() > 0) {
            returnValue = true;
        }
        if (!returnValue && this.baseDataItem != null) {
            returnValue = this.baseDataItem.hasSteps();
        }
        return returnValue;
    }

    @Override
    public List<StepInterface> getSteps(boolean recurse) {
        this.unresolvedCheck();
        ArrayList<StepInterface> outList = new ArrayList<StepInterface>();
        if (recurse && this.baseDataItem != null) {
            outList.addAll(this.baseDataItem.getSteps(true));
        }
        outList.addAll(StepManager.getSteps(this.steps));
        return outList;
    }

    @Override
    public int getExpressionType() {
        int expressionType = 0;
        if (this.getExpression() != null) {
            expressionType = this.isFormattingForced() ? 3 : IQModelImplUtilities.getExpressionTypeFactoringInAggregation(this.getExpression(), this.getUsage(), this.getAggregationType());
        }
        return expressionType;
    }

    @Override
    public DataItemExtendedType getExtendedType() {
        DataItemExtendedType result = null;
        result = this.extendedTypeModified ? this.modifiedExtendedType : this.baseDataItem.getExtendedType();
        return result;
    }

    @Override
    public void setExtendedType(DataItemExtendedType type) throws MetadataException {
        this.changeableCheck();
        Preconditions.ensureNonNull(type, "type");
        this.extendedTypeModified = true;
        this.modifiedExtendedType = type;
        this.fireChangeEvent("The data item's extended type changed.");
    }

    @Override
    public void resetExtendedType() throws MetadataException {
        this.changeableCheck();
        this.extendedTypeModified = false;
        this.modifiedExtendedType = null;
        this.fireChangeEvent("The data item's extended type changed.");
    }

    @Override
    public boolean isExtendedTypeModified() {
        return this.extendedTypeModified;
    }

    void setBaseDataItem(DataItem dataItem) throws MetadataException {
        Preconditions.ensureNonNull(dataItem, "dataItem");
        boolean ok = this.getBusModel().isBasedUpon(dataItem.getBusinessModel());
        if (!ok) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataItemReferenceNotLegalCreateOfDataItemRef.txt", new Object[0]));
        }
        this.baseDataItem = dataItem;
    }

    @Override
    public String getResultSetID() {
        return this.resultSetID;
    }

    @Override
    public void setResultSetID(String id) throws MetadataException {
        if (_logger.isDebugEnabled()) {
            _logger.debug(">> DataItemReference.setResultSetID() with arguments: " + (id == null ? "null" : id));
        }
        this.changeableCheck();
        Preconditions.ensureNonNull(id, "ID");
        boolean isValidResultSetID = this.isValidResultSetID(this.resultSetID, this);
        if (!isValidResultSetID) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("DataItem.InvalidResultID.fmt.txt", id));
        }
        this.resultSetID = id;
        this.fireChangeEvent("The data item's resultset ID has changed.");
    }

    @Override
    public void setExtendedAttributes(EntityInterface attrEntity) throws MetadataException {
        super.setExtendedAttributes(attrEntity);
        this.extendedAttributesModified = true;
    }

    @Override
    public EntityInterface getExtendedAttributes() {
        EntityInterface result = null;
        result = this.extendedAttributesModified ? super.getExtendedAttributes() : this.baseDataItem.getExtendedAttributes();
        return result;
    }

    @Override
    public void resetExtendedAttributes() throws MetadataException {
        super.setExtendedAttributes(null);
        this.extendedAttributesModified = false;
    }

    @Override
    public boolean isExtendedAttributesModified() {
        return this.extendedAttributesModified;
    }

    @Override
    public LocalizableString getLabels() {
        LocalizableString returnValue = null;
        if (this.isLabelsModified()) {
            returnValue = super.getLabels();
        } else if (this.baseDataItem != null) {
            returnValue = this.baseDataItem.getLabels();
        }
        return returnValue;
    }

    @Override
    protected LocalizableString _getLabels() {
        LocalizableString returnValue = null;
        if (this.isLabelsModified()) {
            returnValue = super._getLabels();
        } else if (this.baseDataItem != null) {
            returnValue = this.baseDataItem.getLabels();
        }
        return returnValue;
    }

    @Override
    public void setLabel(String label, Locale locale) throws MetadataException {
        this.changeableCheck();
        this.unresolvedCheck();
        this.labelsModified = true;
        super.setLabels(this.baseDataItem.getLabels());
        super.setLabel(label, locale);
    }

    @Override
    public boolean isLabelsModified() {
        return this.labelsModified;
    }

    @Override
    public void resetLabels() throws MetadataException {
        this.changeableCheck();
        this.labelsModified = false;
        super.setLabels(null);
    }

    @Override
    public LocalizableString getDescriptions() {
        LocalizableString returnValue = null;
        returnValue = this.isDescriptionsModified() ? super.getDescriptions() : this.baseDataItem.getDescriptions();
        return returnValue;
    }

    @Override
    protected LocalizableString _getDescriptions() {
        LocalizableString returnValue = null;
        if (this.isDescriptionsModified()) {
            returnValue = super._getDescriptions();
        } else if (this.baseDataItem != null) {
            returnValue = this.baseDataItem.getDescriptions();
        }
        return returnValue;
    }

    @Override
    public void setDescription(String description, Locale locale) throws MetadataException {
        this.changeableCheck();
        this.descriptionsModified = true;
        super.setDescriptions(this.baseDataItem.getDescriptions());
        super.setDescription(description, locale);
    }

    @Override
    public boolean isDescriptionsModified() {
        return this.descriptionsModified;
    }

    @Override
    public void resetDescriptions() throws MetadataException {
        this.changeableCheck();
        this.descriptionsModified = false;
        super.setDescriptions(null);
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        DataItemReferenceImpl.writeRelatedObject(this.baseDataItem, thisElement, writingContext, "BaseDataItem");
        if (this.labelModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "labelModified", true);
        } else {
            IQModelImplUtilities.removeAttr(thisElement, "label");
        }
        if (this.descriptionModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "descModified", true);
        } else {
            IQModelImplUtilities.removeAttr(thisElement, "desc");
        }
        if (this.extendedAttributesModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "extendedAttributesModified", true);
        } else {
            IQModelImplUtilities.removeSubelement(thisElement, "ExtendedAttributes");
        }
        IQModelImplUtilities.setBooleanAttr(thisElement, "equiv", this.userConsidersEquivalentToParent, true);
        if (this.formatModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "fmtModified", true);
            if (this.modifiedFormat != null) {
                IQModelImplUtilities.setAttr(thisElement, "fmt", this.modifiedFormat);
            }
        }
        if (this.aggregationTypeModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "aggrFtnModified", true);
            if (this.modifiedAggregationType != null) {
                IQModelImplUtilities.setAttr(thisElement, "aggrFtn", this.modifiedAggregationType.getID());
            }
        }
        if (this.sortDirectionModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "sortDirectionModified", true);
            if (this.modifiedSortDirection != null) {
                IQModelImplUtilities.setEnumAttr(thisElement, "sortDirection", this.modifiedSortDirection);
            }
        }
        if (this.groupFormattingModified) {
            writingContext.adjustModelVersion(ModelVersion.VERSION_93a);
            IQModelImplUtilities.setBooleanAttr(thisElement, "groupFormattingModified", true);
            if (this.modifiedGroupFormatting != null) {
                IQModelImplUtilities.setEnumAttr(thisElement, "groupFormatting", this.modifiedGroupFormatting);
            }
        }
        if (this.sortFormattingModified) {
            writingContext.adjustModelVersion(ModelVersion.VERSION_93a);
            IQModelImplUtilities.setBooleanAttr(thisElement, "sortFormattingModified", true);
            if (this.modifiedSortFormatting != null) {
                IQModelImplUtilities.setEnumAttr(thisElement, "sortFormatting", this.modifiedSortFormatting);
            }
        }
        if (this.usageModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "usageModified", true);
            if (this.modifiedUsage != null) {
                IQModelImplUtilities.setEnumAttr(thisElement, "usage", this.modifiedUsage);
            }
        }
        if (this.formattingForcedModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "formattingForcedModified", true);
            IQModelImplUtilities.setBooleanAttr(thisElement, "formattingForced", this.modifiedFormattingForced);
        }
        if (this.extendedTypeModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "extendedTypeModified", true);
            if (this.modifiedExtendedType != null) {
                IQModelImplUtilities.setEnumAttr(thisElement, "extendedType", this.modifiedExtendedType);
            }
        }
        DataItemImpl.writeDisabledActions(this._disabledActions, thisElement);
        if (this._disabledActions != null) {
            for (DataItemActionType action : this._disabledActions) {
                if (!DataItemActionType.ALL_GROUP_FORMATTING_ACTIONS.contains(action) && !DataItemActionType.ALL_SORT_FORMATTING_ACTIONS.contains(action)) continue;
                writingContext.adjustModelVersion(ModelVersion.VERSION_93a);
                break;
            }
        }
        DataItemImpl.writeDisabledAggregateFunctions(this._disabledAggregationTypes, thisElement);
        if (this.sortCriteriaModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "sortCriteriaModified", true);
            DataItemReferenceImpl.writeRelatedObject(this.modifiedSortCriteria, thisElement, writingContext, "SortCriteria");
        }
        DataItemReferenceImpl.writeRelatedObjects(this.steps, thisElement, writingContext, "Steps");
        if (this.memberPropertiesModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "memberPropertiesModified", true);
            IQModelImplUtilities.setCommaSeparatedStringAttr(thisElement, "memberProperties", this.modifiedMemberProperties);
        }
        if (this.startingLevelModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "startingLevelModified", true);
            DataItemReferenceImpl.writeRelatedObject(this.modifiedStartingLevel, thisElement, writingContext, "StartingLevel");
        }
        if (this.startingLevelNameModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "startingLevelNameModified", true);
            IQModelImplUtilities.setAttr(thisElement, "startingLevelName", this.modifiedStartingLevelName);
        }
        if (!IQModelImplUtilities.same(this.resultSetID, this.getIntraModelID())) {
            IQModelImplUtilities.setAttr(thisElement, "rsID", this.resultSetID);
        }
        if (this.labelsModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "labelsModified", true);
        }
        if (this.descriptionsModified) {
            IQModelImplUtilities.setBooleanAttr(thisElement, "descsModified", true);
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this.labelModified = attrsProvider.consumeBooleanAttr("labelModified", false);
        this.descriptionModified = attrsProvider.consumeBooleanAttr("descModified", false);
        this.extendedAttributesModified = attrsProvider.consumeBooleanAttr("extendedAttributesModified", false);
        this.userConsidersEquivalentToParent = attrsProvider.consumeBooleanAttr("equiv", true);
        this.formatModified = attrsProvider.consumeBooleanAttr("fmtModified", false);
        if (this.formatModified) {
            this.modifiedFormat = attrsProvider.consumeAttr("fmt");
        }
        this.aggregationTypeModified = attrsProvider.consumeBooleanAttr("aggrFtnModified", false);
        if (this.aggregationTypeModified) {
            this.modifiedAggregationType = attrsProvider.consumeFunction("aggrFtn");
        }
        this.sortDirectionModified = attrsProvider.consumeBooleanAttr("sortDirectionModified", false);
        if (this.sortDirectionModified) {
            this.modifiedSortDirection = DataItemActionType.consumeValue(attrsProvider, "sortDirection", null);
        }
        this.groupFormattingModified = attrsProvider.consumeBooleanAttr("groupFormattingModified", false);
        if (this.groupFormattingModified) {
            this.modifiedGroupFormatting = DataItemActionType.consumeValue(attrsProvider, "groupFormatting", null);
        }
        this.sortFormattingModified = attrsProvider.consumeBooleanAttr("sortFormattingModified", false);
        if (this.sortFormattingModified) {
            this.modifiedSortFormatting = DataItemActionType.consumeValue(attrsProvider, "sortFormatting", null);
        }
        this.usageModified = attrsProvider.consumeBooleanAttr("usageModified", false);
        if (this.usageModified) {
            this.modifiedUsage = DataItemActionType.consumeValue(attrsProvider, "usage", null);
        }
        this.formattingForcedModified = attrsProvider.consumeBooleanAttr("formattingForcedModified", false);
        if (this.formattingForcedModified) {
            this.modifiedFormattingForced = attrsProvider.consumeBooleanAttr("formattingForced", false);
        }
        this.extendedTypeModified = attrsProvider.consumeBooleanAttr("extendedTypeModified", false);
        if (this.extendedTypeModified) {
            this.modifiedExtendedType = DataItemExtendedType.consumeValue(attrsProvider, "extendedType", null);
        }
        this._disabledActions = DataItemImpl.consumeDisabledActions(attrsProvider);
        this._disabledAggregationTypes = DataItemImpl.consumeDisabledAggregateFunctions(attrsProvider);
        this.memberPropertiesModified = attrsProvider.consumeBooleanAttr("memberPropertiesModified", false);
        if (this.memberPropertiesModified) {
            this.modifiedMemberProperties = attrsProvider.consumeCommaSeparatedStringAsList("memberProperties");
        }
        this.resultSetID = attrsProvider.consumeAttr("rsID");
        if (this.resultSetID == null) {
            this.resultSetID = this.getIntraModelID();
        }
        this.startingLevelNameModified = attrsProvider.consumeBooleanAttr("startingLevelNameModified", false);
        if (this.startingLevelNameModified) {
            this.modifiedStartingLevelName = attrsProvider.consumeAttr("startingLevelName");
        }
        this.startingLevelModified = attrsProvider.consumeBooleanAttr("startingLevelModified", false);
        this.sortCriteriaModified = attrsProvider.consumeBooleanAttr("sortCriteriaModified", false);
        this.labelsModified = attrsProvider.consumeBooleanAttr("labelsModified", false);
        this.descriptionsModified = attrsProvider.consumeBooleanAttr("descsModified", false);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this.baseDataItem = (DataItem)((Object)riHolder.consumeObject("BaseDataItem"));
        this.steps = riHolder.consumeObjects("Steps", StepInterface.class);
        if (this.startingLevelModified) {
            this.modifiedStartingLevel = (com.sas.iquery.metadata.physical.Level)((Object)riHolder.consumeObject("StartingLevel"));
        }
        if (this.sortCriteriaModified) {
            this.modifiedSortCriteria = (OlapDataItemSortCriteria)riHolder.consumeObject("SortCriteria");
        }
    }

    @Override
    protected void readDefinitionV1(Element dataItemRefElement, ReadingContext readingContext) throws MetadataException {
        Element startingLevelElement;
        String extendedTypePersistentForm;
        String attrValue;
        String ftnID;
        super.readDefinitionV1(dataItemRefElement, readingContext);
        this.baseDataItem = (DataItem)((Object)DataItemReferenceImpl.v1_readItemUnderSubelement(dataItemRefElement, readingContext, "BaseDataItem", new Class[]{DataItem.class}));
        this.labelModified = IQModelImplUtilities.getBooleanAttr(dataItemRefElement, "labelModified", false);
        this.descriptionModified = IQModelImplUtilities.getBooleanAttr(dataItemRefElement, "descriptionModified", false);
        this.extendedAttributesModified = IQModelImplUtilities.getBooleanAttr(dataItemRefElement, "extendedAttributesModified", false);
        this.userConsidersEquivalentToParent = IQModelImplUtilities.getBooleanAttr(dataItemRefElement, "equiv", true);
        this.formatModified = IQModelImplUtilities.getBooleanAttr(dataItemRefElement, "formatModified", false);
        if (this.formatModified) {
            this.modifiedFormat = IQModelImplUtilities.getAttr(dataItemRefElement, "format");
        }
        this.aggregationTypeModified = IQModelImplUtilities.getBooleanAttr(dataItemRefElement, "aggregateFunctionModified", false);
        if (this.aggregationTypeModified && (ftnID = IQModelImplUtilities.getAttr(dataItemRefElement, "aggregateFunction")) != null) {
            this.modifiedAggregationType = ServerProperties.getFunctionByFullID(ftnID);
        }
        this.sortDirectionModified = IQModelImplUtilities.getBooleanAttr(dataItemRefElement, "sortDirectionModified", false);
        if (this.sortDirectionModified && (attrValue = IQModelImplUtilities.getAttr(dataItemRefElement, "sortDirection")) != null) {
            this.modifiedSortDirection = DataItemActionType.fromPersistentForm(attrValue);
        }
        this.usageModified = IQModelImplUtilities.getBooleanAttr(dataItemRefElement, "usageModified", false);
        if (this.usageModified && (attrValue = IQModelImplUtilities.getAttr(dataItemRefElement, "usage")) != null) {
            this.modifiedUsage = DataItemActionType.fromPersistentForm(attrValue);
        }
        this.formattingForcedModified = IQModelImplUtilities.getBooleanAttr(dataItemRefElement, "formattingForcedModified", false);
        if (this.formattingForcedModified) {
            this.modifiedFormattingForced = IQModelImplUtilities.getBooleanAttr(dataItemRefElement, "formattingForced", false);
        }
        this.extendedTypeModified = IQModelImplUtilities.getBooleanAttr(dataItemRefElement, "extendedTypeModified", false);
        if (this.extendedTypeModified && (extendedTypePersistentForm = IQModelImplUtilities.getAttr(dataItemRefElement, "extendedType")) != null) {
            this.modifiedExtendedType = DataItemExtendedType.fromPersistentForm(extendedTypePersistentForm);
        }
        Element disallowedActionsElement = IQModelImplUtilities.getFirstSubelementNamed(dataItemRefElement, "DisallowedActions");
        this._disabledActions.clear();
        if (disallowedActionsElement != null && disallowedActionsElement.hasAttributes()) {
            NamedNodeMap map = disallowedActionsElement.getAttributes();
            int mapCount = map.getLength();
            for (int index = 0; index < mapCount; ++index) {
                boolean value;
                String nodeName;
                DataItemActionType action;
                Node attrNode = map.item(index);
                if (attrNode.getNodeType() != 2 || (action = DataItemActionType.fromPersistentForm(nodeName = attrNode.getNodeName())) == null || !(value = IQModelImplUtilities.getBooleanAttr(disallowedActionsElement, nodeName, false))) continue;
                this._disabledActions.add(action);
            }
        }
        Element disallowedAggregationTypesElement = IQModelImplUtilities.getFirstSubelementNamed(dataItemRefElement, "DisallowedAggregateFunctions");
        this._disabledAggregationTypes.clear();
        if (disallowedAggregationTypesElement != null && disallowedAggregationTypesElement.hasAttributes()) {
            NamedNodeMap map = disallowedAggregationTypesElement.getAttributes();
            int mapCount = map.getLength();
            for (int index = 0; index < mapCount; ++index) {
                boolean value;
                String nodeName;
                Function ftn;
                Node attrNode = map.item(index);
                if (attrNode.getNodeType() != 2 || (ftn = ServerProperties.getFunctionByFullID(nodeName = attrNode.getNodeName())) == null || !(value = IQModelImplUtilities.getBooleanAttr(disallowedAggregationTypesElement, nodeName, false))) continue;
                this._disabledAggregationTypes.add(ftn);
            }
        }
        Element sortCriteriaListElement = IQModelImplUtilities.getFirstSubelementNamed(dataItemRefElement, "SortCriteriaList");
        this.sortCriteriaModified = false;
        if (sortCriteriaListElement != null) {
            this.sortCriteriaModified = true;
            ArrayList<String[]> readSortCriteria = new ArrayList<String[]>();
            List<Element> criteriaElements = IQModelImplUtilities.getSubelements(sortCriteriaListElement);
            for (Element oneCriteriaElement : criteriaElements) {
                ArrayList<String> oneCriteria = new ArrayList<String>();
                int index = 0;
                while (index != -1) {
                    String attrValue2 = IQModelImplUtilities.getAttr(oneCriteriaElement, "crit" + index);
                    if (attrValue2 == null) {
                        index = -1;
                        continue;
                    }
                    oneCriteria.add(attrValue2);
                    ++index;
                }
                String[] array = new String[oneCriteria.size()];
                for (int i = 0; i < oneCriteria.size(); ++i) {
                    array[i] = (String)oneCriteria.get(i);
                }
                readSortCriteria.add(array);
            }
            this.modifiedSortCriteria = new OlapDataItemSortCriteria(readSortCriteria);
        }
        this.steps = DataItemReferenceImpl.v1_readItemListUnderSubelement(dataItemRefElement, readingContext, "Steps", new Class[]{StepInterface.class});
        Element memberPropsElement = IQModelImplUtilities.getFirstSubelementNamed(dataItemRefElement, "MemberProperties");
        if (memberPropsElement != null) {
            this.modifiedMemberProperties = IQModelImplUtilities.getMultiValueAttr(memberPropsElement, "memberProps");
            this.memberPropertiesModified = true;
        }
        if ((startingLevelElement = IQModelImplUtilities.getFirstSubelementNamed(dataItemRefElement, "StartingLevel")) != null) {
            this.modifiedStartingLevel = (com.sas.iquery.metadata.physical.Level)((Object)DataItemReferenceImpl.v1_readItemUnderSubelement(dataItemRefElement, readingContext, "StartingLevel", new Class[]{com.sas.iquery.metadata.physical.Level.class}));
            this.startingLevelModified = true;
        }
        this.resultSetID = IQModelImplUtilities.getAttr(dataItemRefElement, "resultSetID");
        this.modifiedStartingLevelName = IQModelImplUtilities.getAttr(dataItemRefElement, "startingLevelName");
        if (this.modifiedStartingLevelName != null) {
            this.startingLevelNameModified = true;
        }
        if (this.resultSetID == null) {
            this.resultSetID = this.getIntraModelID();
        }
    }

    @Override
    public String toDebugString() {
        String baseString = "null";
        if (this.baseDataItem != null) {
            baseString = this.baseDataItem.toString();
        }
        return super.toString() + " ** based on DataItem: ** " + baseString;
    }

    @Override
    public boolean containsUserTypedAggregation() throws MetadataException {
        return this.baseDataItem != null ? this.baseDataItem.containsUserTypedAggregation() : false;
    }

    @Override
    public List<DataItem> getLeafDataItems() {
        LinkedHashSet<DataItem> leafItems = new LinkedHashSet<DataItem>();
        if (this.baseDataItem != null) {
            List<DataItem> temp = this.baseDataItem.getLeafDataItems();
            if (temp.size() == 1 && temp.get(0) == this.baseDataItem) {
                leafItems.add(this);
            } else {
                leafItems.addAll(temp);
            }
        }
        return new ArrayList<DataItem>(leafItems);
    }

    @Override
    public int getExpressionTypeIgnoringFormattingForced() {
        return IQModelImplUtilities.getExpressionTypeFactoringInAggregation(this.getExpression(), this.getUsage(), this.getAggregationType());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataItemReferenceImpl clone = (DataItemReferenceImpl)super.clone();
        if (this.modifiedLookupType != null) {
            clone.modifiedLookupType = (Lookup)this.modifiedLookupType.clone();
        }
        if (this.modifiedSortCriteria != null) {
            clone.modifiedSortCriteria = (OlapDataItemSortCriteria)this.modifiedSortCriteria.clone();
        }
        clone._disabledActions = new ArrayList<DataItemActionType>(this._disabledActions);
        clone._disabledAggregationTypes = new ArrayList<Function>(this._disabledAggregationTypes);
        clone.steps = new ArrayList<StepInterface>();
        for (StepInterface step : this.steps) {
            if (step == null) continue;
            if (step instanceof AbstractModelItem) {
                step = (StepInterface)((AbstractModelItem)((Object)step)).clone();
                clone.steps.add(step);
                step.addListener(clone);
                continue;
            }
            throw new CloneNotSupportedException(IQMetadataResourceBundle.getMessageString("StepFactory.CannotCloneStep.fmt.txt", this.getIdentityString()));
        }
        return clone;
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this.baseDataItem);
        if (this.steps != null) {
            intoList.addAll(this.steps);
        }
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this.baseDataItem = (DataItem)DataItemReferenceImpl.replace(this.baseDataItem, oldObject, newObject);
        DataItemReferenceImpl.replaceInList(this.steps, oldObject, newObject);
    }

    protected final void setStepsTrusted(List steps) {
        this.steps = steps;
    }

    @Override
    protected final List<StepInterface> getStepsTrusted() {
        return this.steps;
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws MetadataException {
        return super.newLocalizableProperties(locale, this);
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws MetadataException {
        super.setLocalizableProperties(locale, this, map);
    }
}

