/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.business.impl.XMLV2ModelHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class DOMDispenser {
    private Element _elementToStartWith;
    private XMLV2ModelHandler _xmlHandler;
    private SAXAttributes _saxAttrs = new SAXAttributes();
    private static final String EMPTY_STRING = "";

    public DOMDispenser(Document doc, XMLV2ModelHandler xmlHandler) {
        this._elementToStartWith = doc.getDocumentElement();
        this._xmlHandler = xmlHandler;
    }

    public DOMDispenser(Element elementToStartWith, XMLV2ModelHandler xmlHandler) {
        this._elementToStartWith = elementToStartWith;
        this._xmlHandler = xmlHandler;
    }

    public void walkDOMAndDispenseToHandler() throws SAXException {
        this.driveElement(this._elementToStartWith);
    }

    private void driveElement(Element element) throws SAXException {
        String tagName = element.getTagName();
        NamedNodeMap domAttrs = element.getAttributes();
        this._saxAttrs.set(domAttrs);
        this._xmlHandler.startElement(EMPTY_STRING, EMPTY_STRING, tagName, this._saxAttrs);
        NodeList nl = element.getChildNodes();
        int size = nl.getLength();
        for (int i = 0; i < size; ++i) {
            Node childNode = nl.item(i);
            short nodeType = childNode.getNodeType();
            if (nodeType == 1) {
                this.driveElement((Element)childNode);
                continue;
            }
            if (nodeType == 3) {
                String str = ((Text)childNode).getData();
                char[] chArray = str.toCharArray();
                this._xmlHandler.characters(chArray, 0, chArray.length);
                continue;
            }
            String msg = IQMetadataResourceBundle.getMessageString("DOMDispenser.UnsupportedNode.fmt.txt", nodeType, childNode.getNodeName());
            throw new SAXException(msg);
        }
        this._xmlHandler.endElement(null, null, tagName);
    }

    static class SAXAttributes
    implements Attributes {
        NamedNodeMap _attrMap;

        SAXAttributes() {
        }

        public void set(NamedNodeMap attrMap) {
            this._attrMap = attrMap;
        }

        @Override
        public int getLength() {
            return this._attrMap.getLength();
        }

        @Override
        public String getURI(int index) {
            String out = null;
            Node node = this._attrMap.item(index);
            if (node != null) {
                out = node.getNamespaceURI();
            }
            return out;
        }

        @Override
        public String getLocalName(int index) {
            String out = null;
            Node node = this._attrMap.item(index);
            if (node != null) {
                out = node.getLocalName();
            }
            return out;
        }

        @Override
        public String getQName(int index) {
            return this._attrMap.item(index).getNodeName();
        }

        @Override
        public String getType(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue(int index) {
            return this._attrMap.item(index).getNodeValue();
        }

        @Override
        public int getIndex(String uri, String localName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex(String qName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType(String uri, String localName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType(String qName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue(String uri, String localName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue(String qName) {
            String value = null;
            Node node = this._attrMap.getNamedItem(qName);
            if (node != null) {
                value = node.getNodeValue();
            }
            return value;
        }
    }
}

