/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.business.CascadableFilter;
import com.sas.iquery.metadata.business.CascadeRule;
import com.sas.iquery.metadata.business.CascadeRuleItem;
import com.sas.iquery.metadata.business.impl.CascadeRuleItemImpl;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class CascadeRuleImpl
implements CascadeRule {
    private CascadeRuleItem _item;
    private final List<CascadeRuleItem> _dependentItems;
    private final List<CascadableFilter> _dependentFilters;

    protected CascadeRuleImpl(CascadeRuleItem item) {
        this._item = item;
        this._dependentItems = new ArrayList<CascadeRuleItem>();
        this._dependentFilters = new ArrayList<CascadableFilter>();
    }

    @Override
    public CascadeRuleItem getItem() {
        return this._item;
    }

    @Override
    public Collection<CascadableFilter> getDependentFilters() {
        return Collections.unmodifiableCollection(this._dependentFilters);
    }

    @Override
    public Collection<CascadeRuleItem> getDependentItems() {
        return Collections.unmodifiableCollection(this._dependentItems);
    }

    @Override
    public boolean hasDependentItemFor(PromptDefinitionInterface prompt, PromptValuesInterface promptValue) {
        return this._dependentItems.contains(new CascadeRuleItemImpl(prompt, promptValue));
    }

    @Override
    public boolean containsDependentFilter(CascadableFilter filter) {
        return this._dependentFilters.contains(filter);
    }

    protected void addDependentItem(CascadeRuleItem item) {
        if (item != null && !this._dependentItems.contains(item)) {
            this._dependentItems.add(item);
        }
    }

    protected void addDependentItem(int index, CascadeRuleItem item) {
        if (item != null && !this._dependentItems.contains(item)) {
            this._dependentItems.add(index, item);
        }
    }

    protected void addDependentFilter(CascadableFilter filter) {
        if (filter != null && !this._dependentFilters.contains(filter)) {
            this._dependentFilters.add(filter);
        }
    }

    protected void addDependentFilter(int index, CascadableFilter filter) {
        if (filter != null && !this._dependentFilters.contains(filter)) {
            this._dependentFilters.add(index, filter);
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("CascadeRuleItem: " + this._item.toString() + "\n");
        output.append("DependentItems: " + this._dependentItems + "\n");
        output.append("DependentFilters: " + this._dependentFilters + "\n");
        return output.toString();
    }
}

