/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.CommaSeparatedString;
import com.sas.iquery.metadata.business.impl.MonotonicIntegerToStringMapping;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.SimpleAttributesProvider;
import com.sas.iquery.metadata.business.impl.XMLV2;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public final class AttributesProvider
extends SimpleAttributesProvider {
    private ReadingContextV2 _readingContext;
    private AbstractModel _modelBeingRead;
    private final SimpleDateFormat _timestampParser = XMLV2.newXMLTimestampFormatterParser();
    private static final String EMPTY_STRING = "";
    private static final String BOOLEAN_FALSE = "0";
    private static final String BOOLEAN_TRUE = "1";

    public AttributesProvider(ReadingContextV2 readingContext, int initialCapacity) {
        super(initialCapacity);
        this.resetContext(readingContext);
        this._timestampParser.setLenient(false);
    }

    void resetContext(ReadingContextV2 readingContext) {
        this._readingContext = readingContext;
        this._modelBeingRead = this._readingContext.getModelBeingRead();
    }

    public String consumeAttr(String attrName) {
        return this.consumeAttr(attrName, null);
    }

    public String consumeAttrAndInternResult(String attrName) {
        String out = this.consumeAttr(attrName, null);
        if (out != null) {
            out = out.intern();
        }
        return out;
    }

    public String consumeAttrEmptyDefault(String attrName) {
        String out = this.consumeAttr(attrName, null);
        if (out == null) {
            out = EMPTY_STRING;
        } else if (out.length() == 0) {
            out = null;
        }
        return out;
    }

    public boolean consumeBooleanAttr(String attrName, boolean defaultValue) {
        boolean out;
        String value = this.consumeAttr(attrName);
        if (value == null) {
            out = defaultValue;
        } else if (value.equals(BOOLEAN_TRUE)) {
            out = true;
        } else if (value.equals(BOOLEAN_FALSE)) {
            out = false;
        } else {
            throw new NumberFormatException(IQMetadataResourceBundle.getMessageString("AttributesProvider.InvalidBooleanValue.fmt.txt", value, attrName));
        }
        return out;
    }

    public Character consumeCharAttr(String attrName, Character defaultValue) {
        Character out;
        String value = this.consumeAttr(attrName);
        if (value == null) {
            out = defaultValue;
        } else if (value.length() == 1) {
            out = Character.valueOf(value.charAt(0));
        } else {
            throw new NumberFormatException(IQMetadataResourceBundle.getMessageString("AttributesProvider.InvalidCharacterValue.fmt.txt", value, attrName));
        }
        return out;
    }

    public int consumeExpressionTypeAttr(String attrName) {
        int out = 0;
        String value = this.consumeAttr(attrName);
        if (value != null) {
            out = value.equals("numeric") ? 2 : (value.equals("char") ? 3 : (value.equals("boolean") ? 9 : (value.equals("date") ? 4 : (value.equals("time") ? 5 : (value.equals("timestamp") ? 6 : Integer.parseInt(value))))));
        }
        return out;
    }

    public int consumeIntAttr(String attrName, int defaultValue) {
        String value = this.consumeAttr(attrName);
        int out = value == null ? defaultValue : Integer.parseInt(value);
        return out;
    }

    public Double consumeDoubleAttr(String attrName, Double defaultValue) {
        String value = this.consumeAttr(attrName);
        Double out = value == null ? defaultValue : Double.valueOf(value);
        return out;
    }

    public Long consumeLongAttr(String attrName, Long defaultValue) {
        String value = this.consumeAttr(attrName);
        Long out = value == null ? defaultValue : Long.valueOf(value);
        return out;
    }

    public Date consumeTimestampAttr(String attrName, Date defaultValue) throws SAXException {
        Date out;
        String value = this.consumeAttr(attrName);
        if (value == null) {
            out = defaultValue;
        } else {
            try {
                out = this._timestampParser.parse(value);
            }
            catch (ParseException e) {
                SAXException se = new SAXException(e);
                se.initCause(e);
                throw se;
            }
        }
        return out;
    }

    public int consumeIntWrittenAsString(String attrName, MonotonicIntegerToStringMapping mapping, int defaultValue) {
        String attrWritten = this.consumeAttr(attrName);
        return mapping.intValueNoCheckedException(attrWritten, defaultValue);
    }

    public ModelVersion consumeVersion(String attrName) {
        ModelVersion out = null;
        String value = this.consumeAttr(attrName);
        if (value != null) {
            out = new ModelVersion(value);
        }
        return out;
    }

    public Function consumeFunction(String attrName) throws SAXException {
        Function out = null;
        String attrValue = this.consumeAttr(attrName);
        if (attrValue != null) {
            return this.functionIDToFunction(attrValue);
        }
        return out;
    }

    private Function functionIDToFunction(String functionID) throws SAXException {
        Function out = null;
        try {
            if (functionID.indexOf(46) != -1) {
                out = ServerProperties.getFunctionByFullID(functionID);
            } else {
                ServerProperties sp = this._modelBeingRead.getServerProperties();
                sp.getFunctionByID(functionID);
            }
        }
        catch (MetadataException e) {
            SAXException se = new SAXException(IQMetadataResourceBundle.getMessageString("AttributesProvider.CannotGetServerProperties.fmt.txt", functionID));
            se.initCause(e);
            throw se;
        }
        return out;
    }

    public ArrayList<Function> consumeListOfCommaSeparatedFunctions(String attrName) throws SAXException {
        ArrayList<Function> out = null;
        String attrValue = this.consumeAttr(attrName);
        if (attrValue != null) {
            out = new ArrayList<Function>();
            StringTokenizer st = new StringTokenizer(attrValue, ",");
            while (st.hasMoreTokens()) {
                String ftnString = st.nextToken();
                Function function = this.functionIDToFunction(ftnString);
                if (function == null) continue;
                out.add(function);
            }
        } else {
            out = new ArrayList(0);
        }
        return out;
    }

    public String[] consumeCommaSeparatedString(String attrName) throws SAXException {
        String[] out = null;
        String attrValue = this.consumeAttr(attrName);
        if (attrValue != null) {
            try {
                out = CommaSeparatedString.split(attrValue);
            }
            catch (IOException e) {
                SAXException se = new SAXException(e);
                se.initCause(e);
                throw se;
            }
        }
        return out;
    }

    public List<String> consumeCommaSeparatedStringAsList(String attrName) throws SAXException {
        List<String> out = null;
        String attrValue = this.consumeAttr(attrName);
        if (attrValue != null) {
            try {
                out = CommaSeparatedString.splitAsList(attrValue);
            }
            catch (IOException e) {
                SAXException se = new SAXException(e);
                se.initCause(e);
                throw se;
            }
        } else {
            out = new ArrayList<String>(0);
        }
        return out;
    }

    public DataItemActionType getDataItemUsageWhenMissing() {
        return this._readingContext.getDataItemUsageWhenMissing();
    }

    public void setDataItemUsageWhenMissing(DataItemActionType usage) {
        this._readingContext.setDataItemUsageWhenMissing(usage);
    }

    public ReadingContextV2 getReadingContext() {
        return this._readingContext;
    }

    public AbstractModel getModelBeingRead() {
        return this._modelBeingRead;
    }
}

