/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.PropertyChangeListenee;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.JoinTypeList;
import com.sas.iquery.metadata.business.ModelItemWithIdentity;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.util.LocalizableString;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractModelItemWithIdentity
extends AbstractModelItem
implements ModelItemWithIdentity {
    private String _label = "";
    private String _description = "";
    private AbstractModel _model = null;
    private String _intraModelIdentity = null;
    private String _interModelIdentityWhenUnresolved = null;
    private boolean _hidden = false;
    private static final boolean NOXML_HIDDEN = false;

    protected AbstractModelItemWithIdentity() {
    }

    protected AbstractModelItemWithIdentity(AbstractModel model) {
        if (model == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("AbstractBusinessModelObject.OwningBusinessModelIsNull.txt", new Object[0]));
        }
        this._model = model;
        this._intraModelIdentity = this.getDefaultID();
    }

    protected static String interModelIDToIntraModelID(String interModelID) {
        int index;
        String out = interModelID;
        if (out != null && (index = out.indexOf(46)) != -1) {
            out = out.substring(index + 1);
        }
        return out;
    }

    @Override
    public AbstractModel getModel() {
        return this._model;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public void setLabel(String label) throws MetadataException {
        if (!IQModelImplUtilities.same(this._label, label)) {
            this.changeableCheck();
            this._label = label;
            this.fireChangeEvent("label changed");
        }
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(String description) throws MetadataException {
        if (!IQModelImplUtilities.same(this._description, description)) {
            this.changeableCheck();
            this._description = description;
            this.fireChangeEvent("description changed");
        }
    }

    @Override
    public boolean isHidden() {
        this.unresolvedCheck();
        return this._hidden;
    }

    @Override
    public void setIsHidden(boolean hidden) {
        if (this._hidden != hidden) {
            this.changeableCheck();
            this._hidden = hidden;
            this.fireChangeEvent("hidden attribute changed");
        }
    }

    @Override
    public String getIntraModelIdentity() {
        return this._intraModelIdentity;
    }

    @Override
    boolean isLocatedExternalToGivenModel(AbstractModel model) {
        return this._model != model || !model.contains(this);
    }

    public void setIdentityOutsideModelWhenUnresolved(String str) {
        this._interModelIdentityWhenUnresolved = str;
    }

    @Override
    public String getInterModelIdentity() {
        String out = this.isUnresolved() && this._interModelIdentityWhenUnresolved != null ? this._interModelIdentityWhenUnresolved : (this._intraModelIdentity != null ? this._model.getIdentity() + "." + this._intraModelIdentity : null);
        return out;
    }

    public void setIdentityWithinContainer(String identityWithinContainer) throws InvalidIDException {
        Preconditions.ensureNonNull(identityWithinContainer, "ID");
        if (identityWithinContainer.equals(this._intraModelIdentity)) {
            return;
        }
        this.changeableCheck();
        if (this._model.contains(this) && this._model.containsObjectWithID(identityWithinContainer)) {
            MessageFormatter message = IQModelImplUtilities.getMessageFormatter("AbstractModelItemWithIdentity.IDConflict.fmt.txt", identityWithinContainer);
            throw new InvalidIDException(message);
        }
        this._intraModelIdentity = identityWithinContainer;
    }

    protected synchronized String getDefaultID() {
        String defaultID = null;
        String prefix = this.getDefaultIDPrefix();
        boolean inUse = true;
        AbstractModel model = this.getModel();
        while (inUse) {
            defaultID = prefix + model.newDefaultIDNumber();
            inUse = model.containsObjectWithID(defaultID);
        }
        return defaultID;
    }

    @Override
    protected abstract String getDefaultIDPrefix();

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setAttr(thisElement, "identity", this._intraModelIdentity);
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "label", this._label);
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "desc", this._description);
        IQModelImplUtilities.setBooleanAttr(thisElement, "hidden", this._hidden, false);
        if (this.isUnresolved()) {
            MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("AbstractModelItemWithIdentity.Unresolved.fmt.txt", this.getIdentityString());
            throw new IQueryServicesRuntimeException(messageFormatter);
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._intraModelIdentity = attrsProvider.consumeAttr("identity");
        this._label = attrsProvider.consumeAttrEmptyDefault("label");
        this._description = attrsProvider.consumeAttrEmptyDefault("desc");
        this._hidden = attrsProvider.consumeBooleanAttr("hidden", false);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
    }

    @Override
    void setModel(AbstractModel model) {
        this._model = model;
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._intraModelIdentity = IQModelImplUtilities.getAttr(thisElement, "imid");
        this._label = IQModelImplUtilities.getAttr(thisElement, "label");
        this._description = IQModelImplUtilities.getAttr(thisElement, "description");
        this._hidden = IQModelImplUtilities.getBooleanAttr(thisElement, "hidden", false);
    }

    @Override
    protected void readExternalReferenceV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._label = IQModelImplUtilities.getAttr(thisElement, "label");
        this._description = IQModelImplUtilities.getAttr(thisElement, "description");
        this._interModelIdentityWhenUnresolved = IQModelImplUtilities.getAttr(thisElement, "xmid");
    }

    @Override
    protected void writeExternalReference(Element thisElement, WritingContext writingContext) throws MetadataException {
        String identityAttrName = null;
        String identityAttrValue = null;
        AbstractModel modelBeingWritten = writingContext.getModel();
        AbstractModel baseModel = modelBeingWritten.getParent();
        if (this.isUnresolved()) {
            if (baseModel != null) {
                String basemodelIDPlusDot = baseModel.getIdentity() + '.';
                String xmid = this.getInterModelIdentity();
                if (xmid.startsWith(basemodelIDPlusDot)) {
                    identityAttrName = "identity";
                    identityAttrValue = this.getIntraModelIdentity();
                }
            }
            if (identityAttrName == null) {
                identityAttrName = "interModelID";
                identityAttrValue = this.getInterModelIdentity();
            }
        } else if (this.getModel() == baseModel) {
            identityAttrName = "identity";
            identityAttrValue = this.getIntraModelIdentity();
        } else {
            identityAttrName = "interModelID";
            identityAttrValue = this.getInterModelIdentity();
        }
        IQModelImplUtilities.setAttr(thisElement, identityAttrName, identityAttrValue);
    }

    @Override
    public void consumeExternalReferenceAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeExternalReferenceAttributes(attrsProvider);
        this._intraModelIdentity = attrsProvider.consumeAttr("identity");
        if (this._intraModelIdentity == null) {
            this._interModelIdentityWhenUnresolved = attrsProvider.consumeAttr("interModelID");
            if (this._interModelIdentityWhenUnresolved != null) {
                this._intraModelIdentity = IQModelImplUtilities.rightOfDot(this._interModelIdentityWhenUnresolved);
            } else {
                String msg = IQModelImplUtilities.getMessage("AbstractModelItem.InvalidExternalReference.fmt.txt", "identity", "interModelID");
                throw new SAXException(msg);
            }
        }
    }

    protected void accumulateReasonsNotPersistableWithinModel(List<Reason> reasons) {
        Reason reason;
        if (!this._model.contains(this)) {
            reason = new Reason((Object)this, 1, 6, "BusinessModelObjectImplObjectNotFoundInModel.fmt.txt", this.getIdentityString());
            reasons.add(reason);
        }
        if (this._intraModelIdentity == null) {
            reason = new Reason((Object)this, 1, 1, "BusinessModelObjectImplObjectNoId.fmt.txt", this.getIdentityString());
            reasons.add(reason);
        }
    }

    protected final void _copyFrom(Object obj) throws MetadataException {
        this.checksForCopyingFromObject(obj);
        AbstractModelItemWithIdentity from = (AbstractModelItemWithIdentity)obj;
        this.clearListeningToBaseObjects();
        try {
            this.copyWholeDefinition(from);
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(e);
        }
    }

    protected void checksForCopyingFromObject(Object fromObject) throws MetadataException {
        if (fromObject == null || fromObject.getClass() != this.getClass()) {
            Object[] args = new Object[]{fromObject.getClass().getName(), this.getClass().getName()};
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("AbstractModelItemWithIdentity.ObjectsAreNotSameType.fmt.txt", args));
        }
        AbstractModelItemWithIdentity from = (AbstractModelItemWithIdentity)fromObject;
        this.changeableCheck();
        String oldID = this.getIntraModelIdentity();
        String newID = from.getIntraModelIdentity();
        if (!IQModelImplUtilities.same(oldID, newID) && this.getModel().containsObjectWithID(newID)) {
            MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("AbstractModelItemWithIdentity.IDConflict.fmt.txt", newID);
            throw new MetadataException(messageFormatter);
        }
    }

    private void copyWholeDefinition(AbstractModelItemWithIdentity fromObject) throws CloneNotSupportedException {
        IdentityHashMap copiedObjects = new IdentityHashMap();
        for (Class<?> c = this.getClass(); c != null && c != IQModelImplUtilities.class; c = c.getSuperclass()) {
            Field[] fields = c.getDeclaredFields();
            if (fields == null) continue;
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                this.copyInstanceField(field, fromObject, copiedObjects);
            }
        }
    }

    private void copyInstanceField(Field field, AbstractModelItemWithIdentity fromObject, IdentityHashMap copiedObjects) throws CloneNotSupportedException {
        int modifiers = field.getModifiers();
        if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
            try {
                field.setAccessible(true);
                Object fromObjectFieldValue = field.get(fromObject);
                Object toObjectFieldValue = field.get(this);
                if (fromObjectFieldValue != toObjectFieldValue && fromObject.shouldCopyFieldValue(fromObjectFieldValue)) {
                    this.setFieldValue(field, fromObjectFieldValue, copiedObjects);
                }
                field.setAccessible(false);
            }
            catch (IllegalAccessException e) {
                CloneNotSupportedException e2 = new CloneNotSupportedException();
                e2.initCause(e);
                throw e2;
            }
            catch (InstantiationException e) {
                CloneNotSupportedException e2 = new CloneNotSupportedException();
                e2.initCause(e);
                throw e2;
            }
        }
    }

    protected boolean shouldCopyFieldValue(Object fromObjectFieldValue) {
        return true;
    }

    private void setFieldValue(Field field, Object fromFieldValue, IdentityHashMap copiedObjects) throws IllegalAccessException, CloneNotSupportedException, InstantiationException {
        if (fromFieldValue != null) {
            fromFieldValue = this.adjustFieldValue(fromFieldValue, copiedObjects);
        }
        field.set(this, fromFieldValue);
        if (fromFieldValue instanceof PropertyChangeListenee) {
            this.listenTo((PropertyChangeListenee)fromFieldValue);
        }
    }

    private Object adjustFieldValue(Object fieldValue, IdentityHashMap copiedObjects) throws CloneNotSupportedException, InstantiationException, IllegalAccessException {
        Object out = fieldValue;
        Object copiedObject = copiedObjects.get(fieldValue);
        if (copiedObject != null) {
            out = copiedObject;
        } else if (fieldValue instanceof AbstractModelItem) {
            if (!(fieldValue instanceof BusinessModelResource)) {
                AbstractModelItem item = (AbstractModelItem)fieldValue;
                out = item.clone();
                copiedObjects.put(fieldValue, out);
            }
        } else if (fieldValue instanceof List) {
            List<Object> newList;
            List oldList = (List)fieldValue;
            if (oldList instanceof JoinTypeList) {
                newList = new JoinTypeList();
                newList.addAll(oldList);
            } else {
                newList = !(oldList instanceof ArrayList) ? ListUtils.newCOWList(oldList) : ListUtils.newList(oldList);
            }
            out = newList;
            copiedObjects.put(fieldValue, out);
            ListIterator<Object> it = newList.listIterator();
            while (it.hasNext()) {
                Object obj = it.next();
                Object newObj = this.adjustFieldValue(obj, copiedObjects);
                if (newObj == obj) continue;
                it.set(newObj);
            }
        } else if (fieldValue instanceof EntityInterface) {
            try {
                out = Utils.copy((EntityInterface)fieldValue);
                copiedObjects.put(fieldValue, out);
            }
            catch (MetadataException e) {
                CloneNotSupportedException e2 = new CloneNotSupportedException();
                e2.initCause(e);
                throw e2;
            }
        } else if (fieldValue instanceof LocalizableString) {
            out = ((LocalizableString)fieldValue).clone();
            copiedObjects.put(fieldValue, out);
        }
        return out;
    }
}

