/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.QualifiedLevel;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.ColumnManagerImpl2;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.expr.ConstantExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.util.impl.MessageFormatter;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public abstract class AbstractModelItem
extends AbstractBase
implements ModelItem {
    protected static final Class<?>[] VALID_TYPES_ANY_EXPRESSION = new Class[]{ExpressionInterface.class};
    protected static final Class<?>[] VALID_TYPES_NONCALCULATED_VALUE = new Class[]{StringExpression.class, ConstantExpressionInterface.class, Prompt.class};
    private static final Logger _logger = LogManager.getLogger(AbstractModelItem.class);
    private static final Class<?>[] DATA_ITEM_AND_FILTER_BARRIER = new Class[]{DataItem.class, FilterItem.class};
    private static final Class<?>[] DATA_ITEM_BARRIER = new Class[]{DataItem.class};
    private static final Class<?>[] FILTER_BARRIER = new Class[]{FilterItem.class};
    private static final Class<?>[] PROMPT_BARRIER = new Class[]{Prompt.class};
    private static final Class<?>[] DATA_ITEM_FILTER_AND_PROMPT_BARRIER = new Class[]{DataItem.class, FilterItem.class, Prompt.class};
    private static final Class<?>[] DATA_ITEM_AND_PROMPT_BARRIER = new Class[]{DataItem.class, Prompt.class};
    private static final Class<?>[] FILTER_AND_PROMPT_BARRIER = new Class[]{FilterItem.class, Prompt.class};

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("AbstractModelItem.UnsupportedObjectType.fmt.txt", thisElement.getTagName());
        throw new MetadataException(messageFormatter);
    }

    protected void readExternalReferenceV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean isReachableViaPersistenceFromGivenModel(AbstractModel model) {
        AbstractModel itemModel;
        boolean result = false;
        if (this.isUnresolved()) {
            String interModelID = this.getInterModelIdentity();
            if (interModelID != null) {
                result = true;
            }
        } else if (this.getIntraModelIdentity() != null && (itemModel = this.getModel()) != null && itemModel.contains(this)) {
            result = itemModel.isReachableViaPersistenceFromGivenModel(model);
        }
        return result;
    }

    @Override
    boolean isLocatedExternalToGivenModel(AbstractModel model) {
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractModelItem clone = (AbstractModelItem)super.clone();
        List<ModelItem> referencedObjects = this.getDirectlyReferencedItemsInDownwardDefinition();
        for (ModelItem item : referencedObjects) {
            if (!(item instanceof AbstractBase)) continue;
            ((AbstractBase)((Object)item)).addListener(clone);
        }
        return clone;
    }

    String getIntraModelIdentity() {
        return null;
    }

    String getInterModelIdentity() {
        return null;
    }

    AbstractModel getModel() {
        return null;
    }

    @Override
    public String getIdentityString() {
        String identityString = IQModelImplUtilities.getMessage("AbstractModelItem.getIdentityString.fmt.txt", this.getClass().getName());
        return identityString;
    }

    public final <T> List<T> getResources(@Nonnull Class<T> c, int flags) {
        return this.getResources(c, flags, false);
    }

    public final <T> List<T> getResources(@Nonnull Class<T> c, int flags, boolean includePhysical) {
        Class<Object>[] barrierItemTypes = (flags & 2) == 0 && (flags & 1) == 0 ? ((flags & 4) == 0 ? DATA_ITEM_FILTER_AND_PROMPT_BARRIER : DATA_ITEM_AND_FILTER_BARRIER) : ((flags & 2) == 0 ? ((flags & 4) == 0 ? DATA_ITEM_AND_PROMPT_BARRIER : DATA_ITEM_BARRIER) : ((flags & 1) == 0 ? ((flags & 4) == 0 ? FILTER_AND_PROMPT_BARRIER : FILTER_BARRIER) : ((flags & 4) == 0 ? PROMPT_BARRIER : NO_BARRIER_TYPES)));
        List<T> out = this.getRecursivelyReferencedItemsInDownwardDefinition(barrierItemTypes, null, c);
        if (!includePhysical) {
            int outSize = out.size();
            for (int i = outSize - 1; i >= 0; --i) {
                T item = out.get(i);
                if (item instanceof Column && !(item instanceof QualifiedColumn)) {
                    out.remove(i);
                    continue;
                }
                if (!(item instanceof Level) || item instanceof QualifiedLevel) continue;
                out.remove(i);
            }
        }
        return out;
    }

    @Override
    public final List<Reason> getReasonsUnusable() {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        try {
            this.accumulateReasonsUnusable(reasons);
        }
        catch (MetadataUnresolvedException e) {
            BusinessModelResource bmr = e.getUnresolvedResource();
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("BusinessModelObjectImplObjectNotResolved.fmt.txt", bmr == null ? "null" : bmr.getIdentityString());
            Reason reason = new Reason((Object)bmr, 2, 22, formatter);
            reasons.add(reason);
        }
        return reasons;
    }

    protected void accumulateReasonsUnusable(List<Reason> reasons) {
        if (this.hasCycleInDownwardDefinition()) {
            reasons.add(new Reason((Object)this, 2, 200, "AbstractModelItem.ObjectHasCycleInItsDefinition.fmt.txt", this.getIdentityString()));
        } else {
            AbstractModelItem.accumulateReasonsUnusableNonrecursiveForOneItem(reasons, this);
            this.accumulateReasonsUnusableForSubitems(reasons);
        }
    }

    protected final void accumulateReasonsUnusableForSubitems(List<Reason> reasons) {
        List<AbstractModelItem> items = this.getRecursivelyReferencedItemsInDownwardDefinition(new Class[]{ColumnManagerImpl2.class}, null, AbstractModelItem.class);
        for (AbstractModelItem item : items) {
            AbstractModelItem.accumulateReasonsUnusableNonrecursiveForOneItem(reasons, item);
        }
    }

    protected static final void accumulateReasonsUnusableNonrecursiveForOneItem(List<Reason> reasons, AbstractModelItem item) {
        if (item.isUnresolved()) {
            reasons.add(new Reason((Object)item, 2, 22, "BusinessModelObjectImplObjectNotResolved.fmt.txt", item.getIdentityString()));
        } else {
            item.accumulateReasonsItemItselfIsUnusable(reasons);
        }
    }

    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
    }

    @Override
    public final boolean isUsableInQuery() {
        return this.getReasonsUnusable().size() == 0;
    }

    protected String getDefaultIDPrefix() {
        return null;
    }

    public final boolean isPersistable() {
        return true;
    }

    protected final void error(Throwable errorFound) throws MetadataException {
        _logger.error("", errorFound);
        throw new MetadataException(errorFound);
    }

    protected final void error(MessageFormatter msg, Throwable errorFound) throws MetadataException {
        if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
            _logger.error(msg == null ? "" : msg.toString(), errorFound);
        }
        throw new MetadataException(msg, errorFound);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    protected AbstractModelItem getConstantEquivalent() {
        return null;
    }

    protected static ExpressionInterface cloneReferencedExpression(ExpressionInterface expr) throws CloneNotSupportedException {
        ExpressionInterface out = expr;
        if (!(expr instanceof BusinessModelResource) && expr != null) {
            out = (ExpressionInterface)expr.clone();
        }
        return out;
    }

    protected static List cloneReferencedExpressionList(List exprs) throws CloneNotSupportedException {
        ArrayList<ExpressionInterface> out = null;
        if (exprs != null) {
            out = new ArrayList<ExpressionInterface>();
            for (int i = 0; i < exprs.size(); ++i) {
                ExpressionInterface expr = (ExpressionInterface)exprs.get(i);
                ExpressionInterface cloneExpr = AbstractModelItem.cloneReferencedExpression(expr);
                out.add(cloneExpr);
            }
        }
        return out;
    }
}

