/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.metadata.business.ChangeHistoryItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.Model;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.QueryWriteOption;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBase;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItemWithIdentity;
import com.sas.iquery.metadata.business.impl.AbstractModelReference;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.DOMDispenser;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.QualifiedLevelImpl;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.ResourceConstraint;
import com.sas.iquery.metadata.business.impl.SAXParserProperties;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.business.impl.XMLV2ModelHandler;
import com.sas.iquery.metadata.business.impl.XMLV2PeepholeOptimizer;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.ModelItemReadFactory;
import com.sas.iquery.metadata.impl.SessionContextDependentCache;
import com.sas.iquery.metadata.impl.SessionContextDependentCacheException;
import com.sas.iquery.metadata.physical.oma.OMAHierarchy;
import com.sas.iquery.metadata.physical.oma.OMAQualifiedLevel;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.editableproperties.PropertyList;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractModel
extends AbstractBase
implements Model {
    private String _identity = null;
    private String _label = "";
    private String _description = "";
    private String _absolutePathLocationWhenUnresolved;
    private AbstractModel _baseModel = null;
    private boolean _isOrphanedFromBaseModel = false;
    private boolean _disposed = false;
    private int _nextDefaultIDNumber = 0;
    private List<AbstractModel> _knownChildContainers = new ArrayList<AbstractModel>();
    private List<? extends BusinessModelResource> _unresolvedResources = new ArrayList<BusinessModelResource>();
    private ModelVersion _lastPersistedModelVersion = null;
    private SessionContextInterface _session;
    protected List<ChangeHistoryItem> _changeHistory = new ArrayList<ChangeHistoryItem>();
    private static final Logger _logger = LogManager.getLogger(AbstractModel.class);
    private static final Logger _persistLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist");
    private static final Logger _persistRFDLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist.readflow.details");
    private static final Logger _persistRFSLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist.readflow.summary");
    private static final Logger _persistWFDLogger = LogManager.getLogger((String)"com.sas.iquery.metadata.persist.writeflow.details");
    private static final Class<?>[] ONLY_CHANGE_HISTORY_ITEMS = new Class[]{ChangeHistoryItem.class};
    private static ModelItemReadFactory v1ItemReadFactory = null;
    private static final String POOL_KEY = SyncStringPool.class.getName();
    private static final SessionContextDependentCache _sessionCache = SessionContextDependentCache.getNewInstance();

    protected AbstractModel() {
        this._identity = this.getDefaultID();
    }

    protected AbstractModel(SessionContextInterface session) {
        this._session = session;
        this._identity = this.getDefaultID();
    }

    protected AbstractModel(AbstractModel parentContainer) {
        this._baseModel = parentContainer;
        if (this._baseModel != null) {
            this._baseModel.addParentToChildLink(this);
            this._session = parentContainer.getSession();
        }
        this._identity = this.getDefaultID();
    }

    String getLocationWhenUnresolved() {
        return this._absolutePathLocationWhenUnresolved;
    }

    @Override
    protected void accumulateDirectlyReferencedModelsInDownwardDefinition(List<? super Model> intoList) {
        super.accumulateDirectlyReferencedModelsInDownwardDefinition(intoList);
        intoList.add(this._baseModel);
    }

    @Override
    public final String getIdentityString() {
        String msg = IQModelImplUtilities.getMessage("IdentityStringThreeArgs.fmt.txt", this.getDefinitionElementName(), this._label, this._identity);
        return msg;
    }

    protected abstract boolean contains(Object var1);

    protected final boolean contains(boolean includeBaseModels, Object obj) {
        boolean found = this.contains(obj);
        if (!found && this._baseModel != null && includeBaseModels) {
            found = this._baseModel.contains(includeBaseModels, obj);
        }
        return found;
    }

    public final Iterator<BusinessModelObject> iterator() {
        return this.getAllContainedObjects().iterator();
    }

    protected abstract List<BusinessModelObject> getAllContainedObjects();

    AbstractModelItemWithIdentity getContainedItemWithID(String ID) {
        AbstractModelItemWithIdentity out = null;
        Iterator<BusinessModelObject> it = this.iterator();
        while (it.hasNext() && out == null) {
            AbstractModelItemWithIdentity item = (AbstractModelItemWithIdentity)((Object)it.next());
            if (!IQModelImplUtilities.same(ID, item.getIntraModelID())) continue;
            out = item;
        }
        return out;
    }

    @Override
    boolean isReachableViaPersistenceFromGivenModel(AbstractModel model) {
        return model == this || model.getLineage().contains(this);
    }

    @Override
    boolean isLocatedExternalToGivenModel(AbstractModel model) {
        return this != model && (model.getLineage().contains(this) || this.hasPersistedStorageLocation());
    }

    protected final String getIdentity() {
        return this._identity;
    }

    protected final void setIdentity(String identity) throws MetadataException {
        this.changeableCheck();
        if (this.getLineageIDs().contains(identity)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImplIDExist.txt", new Object[0]));
        }
        this._identity = identity;
        this.fireChangeEvent("ID changed");
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public void setLabel(String label) throws MetadataException {
        this.changeableCheck();
        this._label = label;
        this.fireChangeEvent("label changed");
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(String description) {
        this.changeableCheck();
        this._description = description;
        this.fireChangeEvent("description changed");
    }

    public AbstractModel getParent() {
        return this._baseModel;
    }

    public int newDefaultIDNumber() {
        return ++this._nextDefaultIDNumber;
    }

    public synchronized boolean containsObjectWithID(String intraContainerID) {
        boolean found = false;
        if (intraContainerID != null) {
            Iterator<BusinessModelObject> it = this.iterator();
            while (it.hasNext() && !found) {
                AbstractModelItemWithIdentity obj = (AbstractModelItemWithIdentity)((Object)it.next());
                if (!intraContainerID.equals(obj.getIntraModelIdentity())) continue;
                found = true;
            }
        }
        return found;
    }

    void markContainerAndContentsNeverChangeable() throws MetadataException {
        AbstractModelItem item;
        this.trustedMarkNeverChangeable();
        List<BusinessModelObject> listToProcess = this.getAllContainedObjects();
        List<BusinessModelObject> accumulator = ListUtils.newList(listToProcess);
        for (BusinessModelObject bmo : listToProcess) {
            if (!(bmo instanceof AbstractModelItem)) continue;
            item = (AbstractModelItem)((Object)bmo);
            accumulator.addAll(item.getRecursivelyReferencedItemsInDownwardDefinition(AbstractBase.NO_BARRIER_TYPES, this, ModelItem.class));
        }
        IQModelImplUtilities.removeDuplicates(accumulator);
        for (BusinessModelObject obj : accumulator) {
            if (!(obj instanceof AbstractModelItem)) continue;
            item = (AbstractModelItem)((Object)obj);
            item.trustedMarkNeverChangeable();
        }
    }

    public List getChildren() {
        return ListUtils.newList(this._knownChildContainers);
    }

    public List getDescendents() {
        List<AbstractModel> outList = ListUtils.newList(this._knownChildContainers);
        for (int i = 0; i < this._knownChildContainers.size(); ++i) {
            AbstractModel child = this._knownChildContainers.get(i);
            List grandChildren = child.getDescendents();
            outList.addAll(grandChildren);
        }
        return outList;
    }

    public void removeChild(AbstractModel child) {
        this.unlinkChild(child);
        if (child.getParent() == this) {
            child.orphan();
        }
    }

    protected void orphan() {
        this.setParent(null);
        this._isOrphanedFromBaseModel = true;
    }

    public boolean isOrphaned() {
        return this._isOrphanedFromBaseModel;
    }

    protected void unlinkChild(AbstractModel child) {
        this._knownChildContainers.remove(child);
        this.removeListener(child);
    }

    public void addParentToChildLink(AbstractModel child) {
        if (!this._knownChildContainers.contains(child)) {
            this._knownChildContainers.add(child);
            this.addListener(child);
        }
    }

    @Override
    public final synchronized void dispose() {
        if (!this._disposed) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Disposing of " + this + " [" + this.getID() + "] " + this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()));
            }
            if (this instanceof CancelQuerySupport.CancellableQuery && this instanceof DataSelection) {
                CancelQuerySupport.unRegisterQuery((DataSelection)((Object)this));
            }
            while (this._knownChildContainers.size() > 0) {
                AbstractModel child = this._knownChildContainers.get(0);
                if (!(child instanceof AbstractModel)) continue;
                AbstractModel childModel = child;
                childModel.dispose();
            }
            this.clearReferencesToModelItems();
            if (this._baseModel != null) {
                this._baseModel.removeChild(this);
            }
            this._lastPersistedModelVersion = null;
            this._disposed = true;
        }
    }

    @Override
    public final synchronized boolean hasBeenDispose() {
        return this._disposed;
    }

    protected void clearReferencesToModelItems() {
        this._changeHistory = (List)this.clearItemUsages(this._changeHistory);
        this._unresolvedResources = (List)this.clearItemUsages(this._unresolvedResources);
    }

    protected Object clearItemUsages(Object objectUsedByThisModel) {
        Object out = null;
        if (objectUsedByThisModel != null) {
            Object obj = objectUsedByThisModel;
            if (obj instanceof AbstractModelItem) {
                AbstractModelItem ami = (AbstractModelItem)obj;
                ami.removeListener(this);
                out = null;
            } else if (obj instanceof List) {
                List instanceVarList = (List)obj;
                if (instanceVarList.size() > 0) {
                    ArrayList l = new ArrayList(instanceVarList);
                    this.clearUsagesInList(l);
                    instanceVarList.clear();
                }
                out = instanceVarList;
            } else if (obj instanceof Map) {
                Map map = (Map)obj;
                if (map.size() > 0) {
                    ArrayList keys = new ArrayList(map.keySet());
                    ArrayList values = new ArrayList(map.values());
                    this.clearUsagesInList(keys);
                    this.clearUsagesInList(values);
                    map.clear();
                }
                out = map;
            } else {
                throw new IQueryServicesRuntimeException(IQModelImplUtilities.getMessageFormatter("AbstractModel.ErrorCannotClearUsageOfUnknownObject.fmt.txt", obj.getClass().getName()));
            }
        }
        return out;
    }

    private <T> void clearUsagesInList(List<T> list) {
        int listSize = list.size();
        if (listSize > 0) {
            for (int i = listSize - 1; i >= 0; --i) {
                T obj = list.get(i);
                if (!(obj instanceof AbstractModelItem)) continue;
                AbstractModelItem ami = (AbstractModelItem)obj;
                ami.removeListener(this);
            }
        }
    }

    public void reParentLinkage(AbstractModel newParent) throws MetadataException {
        if (this._baseModel != null) {
            this._baseModel.unlinkChild(this);
        }
        newParent.addParentToChildLink(this);
        this.setParent(newParent);
    }

    protected final void setParent(AbstractModel newParent) {
        this._baseModel = newParent;
    }

    protected List<AbstractModel> getFamily() {
        AbstractModel top;
        ArrayList<AbstractModel> outList = new ArrayList<AbstractModel>();
        for (AbstractModel parent = top = this; parent != null; parent = parent.getParent()) {
            top = parent;
        }
        outList.add(top);
        outList.addAll(top.getDescendents());
        return outList;
    }

    AbstractModel findContainerByID(String identity) {
        if (IQModelImplUtilities.same(identity, this._identity)) {
            return this;
        }
        if (this._baseModel != null) {
            return this._baseModel.findContainerByID(identity);
        }
        return null;
    }

    protected List<AbstractModel> getLineage() {
        ArrayList<AbstractModel> outList = new ArrayList<AbstractModel>();
        for (AbstractModel parent = this.getParent(); parent != null; parent = parent.getParent()) {
            outList.add(parent);
        }
        return outList;
    }

    protected abstract String getDefaultIDPrefix();

    private String getDefaultID() {
        String defaultPrefix;
        String tryThisID = defaultPrefix = this.getDefaultIDPrefix();
        List<String> familyContainerIDs = this.getFamilyIDs();
        int i = 1;
        while (familyContainerIDs.contains(tryThisID)) {
            tryThisID = defaultPrefix + "_" + i++;
        }
        return tryThisID;
    }

    private List<String> getFamilyIDs() {
        List<AbstractModel> family = this.getFamily();
        return AbstractModel.modelsToModelIDs(family);
    }

    private List<String> getLineageIDs() {
        List<AbstractModel> lineage = this.getLineage();
        return AbstractModel.modelsToModelIDs(lineage);
    }

    private static List<String> modelsToModelIDs(List<AbstractModel> models) {
        int modelCount = models.size();
        ArrayList<String> outList = new ArrayList<String>(modelCount);
        for (int i = 0; i < modelCount; ++i) {
            AbstractModel model = models.get(i);
            outList.add(model.getIdentity());
        }
        return outList;
    }

    protected void accumulateReasonsNotPersistable(List<Reason> reasons) {
        List<String> lineageIDs;
        HashSet<String> lineageIdSet;
        if (this._identity == null) {
            Reason reason = new Reason((Object)this, 1, 3, "BusinessModelImplIDOfModel.fmt.txt", this.getLabel());
            reasons.add(reason);
        }
        if ((lineageIdSet = new HashSet<String>(lineageIDs = this.getLineageIDs())).size() < lineageIDs.size()) {
            Reason reason = new Reason((Object)this, 1, 25, "BusinessModelImplParentChildDuplicates.fmt.txt", " " + lineageIDs);
            reasons.add(reason);
        }
    }

    public final List<Reason> getReasonsNotPersistable() {
        long time = 0L;
        if (_persistWFDLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogWriteFlowDetails("start getReasonsNotPersistable()");
            time = System.currentTimeMillis();
        }
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        if (this._isOrphanedFromBaseModel) {
            Reason reason = new Reason((Object)this, 1, 3, "DataSelectionImpl.RemovedFromModelNotPersistable.txt", new Object[0]);
            reasons.add(reason);
        } else {
            this.accumulateReasonsNotPersistable(reasons);
        }
        if (_persistWFDLogger.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - time;
            ExtraLoggingContexts.debugLogWriteFlowDetails("end   getReasonsNotPersistable(): " + elapsedTime + "ms");
        }
        return reasons;
    }

    protected ModelWritingResults writeAsInlineXMLUnder(Node parentNode, Map<QueryWriteOption, Object> writeOptions) throws MetadataException {
        ModelWritingInput input = new ModelWritingInput(parentNode, false, false);
        input.setWritingOptions(writeOptions);
        return this.writeModelUnderAndFinalizeXML(input);
    }

    protected ModelWritingResults writeModelUnderAndFinalizeXML(ModelWritingInput input) throws MetadataException {
        WritingContext writingContext = new WritingContext(this, input);
        Node parentNode = input.getNodeToWriteUnder();
        if (parentNode == null) {
            parentNode = IQModelImplUtilities.newDocument();
        }
        try {
            Element thisElement = this.writeElementWithModelDefinition(parentNode, writingContext, null, true);
            writingContext.finalizeWritingOfModels();
            XMLV2PeepholeOptimizer peepholer = new XMLV2PeepholeOptimizer(thisElement, writingContext.trustedGetInternalPersistenceIDsReferencedXMLWide());
            peepholer.optimize();
            ModelVersion version = writingContext.getModelVersion();
            IQModelImplUtilities.setModelVersionAttr(thisElement, "ver", version);
        }
        catch (MetadataException e) {
            Element topElementCreated = writingContext.getElement();
            if (topElementCreated != null) {
                String xmlWritten = IQModelImplUtilities.toString(topElementCreated);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("XML written at point of problem: " + xmlWritten);
                }
                parentNode.removeChild(topElementCreated);
            }
            throw e;
        }
        return writingContext;
    }

    Element writeElementWithModelDefinition(Node parentNode, WritingContext writingContext, String persistenceID, boolean writingOutermostModel) throws MetadataException {
        writingContext = writingContext.transitionToWritingInnerModel(this, writingOutermostModel);
        this.modelPersistabilityCheck();
        Element thisElement = this.writeElementWithDefinition(parentNode, writingContext, persistenceID);
        writingContext.transitionToWritingOuterModel(thisElement);
        return thisElement;
    }

    @Override
    protected Element createDefinitionElement(Node parentNode, WritingContext writingContext) {
        Element definitionElement = super.createDefinitionElement(parentNode, writingContext);
        if (writingContext.getElement() == null) {
            writingContext.setElement(definitionElement);
        }
        return definitionElement;
    }

    @Override
    public ModelVersion computeModelVersion() throws MetadataException {
        ModelWritingResults results = this.writeModelUnderAndFinalizeXML(new ModelWritingInput(false, true));
        return results.getModelVersion();
    }

    protected IdentityHashMap getResourceConstraints() throws MetadataException {
        return new IdentityHashMap();
    }

    protected void notePotentialRepositoryResourceConstraint(IdentityHashMap resourceConstraintsMapping, ModelItem constrainer, String relationshipName, ModelItem constrainee) throws MetadataException {
        if (constrainer instanceof MetadataRepositoryResource && constrainee instanceof MetadataRepositoryResource && relationshipName != null) {
            ResourceConstraint cr = (ResourceConstraint)resourceConstraintsMapping.get(constrainee);
            if (cr != null) {
                if (cr.getConstrainer() != constrainer || !relationshipName.equals(cr.getRelationshipName())) {
                    throw new MetadataException(IQModelImplUtilities.getMessageFormatter("AbstractModel.UnexpectedMultipleConstrainmentFound.txt", new Object[0]));
                }
            } else {
                cr = new ResourceConstraint(constrainer, relationshipName, constrainee);
                resourceConstraintsMapping.put(constrainee, cr);
            }
        }
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setAttr(thisElement, "identity", this._identity);
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "label", this._label);
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "desc", this._description);
        IQModelImplUtilities.setIntAttr(thisElement, "nextDefaultID", this._nextDefaultIDNumber);
        AbstractModel.writeRelatedObject(this._baseModel, thisElement, writingContext, "BaseModel");
        AbstractModel.writeRelatedObjects(this._changeHistory, thisElement, writingContext, "ChangeHistory");
    }

    @Override
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._identity = attrsProvider.consumeAttr("identity");
        this._label = attrsProvider.consumeAttrEmptyDefault("label");
        this._description = attrsProvider.consumeAttrEmptyDefault("desc");
        this._nextDefaultIDNumber = attrsProvider.consumeIntAttr("nextDefaultID", 5000);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._changeHistory = riHolder.consumeObjects("ChangeHistory", ChangeHistoryItem.class);
        this._baseModel = (AbstractModel)riHolder.consumeObject("BaseModel");
    }

    void consumeModelVersion(ModelVersion version) throws SAXException {
        this._lastPersistedModelVersion = version;
    }

    protected boolean checkModelVersion(ModelVersion modelVersion) throws MetadataException {
        if (modelVersion == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImpl.RequiredAttribute.fmt.txt", "ver"));
        }
        if (modelVersion.equals(ModelVersion.VERSION_pre92a)) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("AbstractModel.VersionNoLongerSupported.fmt.txt", IQModelImplUtilities.toString(modelVersion)));
        }
        if (modelVersion.laterThan(ModelVersion.THIS_SOFTWARE_VERSION)) {
            MessageFormatter formatter = this instanceof InformationMap ? IQModelImplUtilities.getMessageFormatter("BusinessModelImpl.CannotReadNewerMap.fmt.txt", ModelVersion.THIS_SOFTWARE_VERSION.toString(), modelVersion.toString()) : IQModelImplUtilities.getMessageFormatter("BusinessModelImpl.CannotReadNewerDataSelection.fmt.txt", ModelVersion.THIS_SOFTWARE_VERSION.toString(), modelVersion.toString());
            Reason reason = new Reason((Object)this, 9, 87, formatter);
            throw new MetadataException(formatter, Collections.singletonList(reason));
        }
        return modelVersion.laterThanOrSame(ModelVersion.VERSION_pre92b);
    }

    void modelPersistabilityCheck() throws MetadataException {
        List<Reason> reasons = this.getReasonsNotPersistable();
        if (reasons.size() > 0) {
            Reason reason = reasons.get(0);
            MessageFormatter baseMessage = IQModelImplUtilities.getMessageFormatter("BusinessModelImplNotPersisted.fmt.txt", reason, reason.getReason(), reason.getSubReason());
            throw new MetadataException(Reason.getMessageFormatter(baseMessage, reasons, true), reasons);
        }
    }

    protected final String[] getStartingOrderOfMainSubelements() {
        ArrayList<String> list = new ArrayList<String>();
        this.adjustTopSubelementsOrder(list);
        list.add(0, "ExternalResources");
        list.add(1, "ExternalAssociatedPrompts");
        return list.toArray(new String[list.size()]);
    }

    protected void adjustTopSubelementsOrder(ArrayList<String> priorityElementNames) {
    }

    protected String getLocationWhenNotUnresolved() throws MetadataException {
        return null;
    }

    protected boolean hasPersistedStorageLocation() {
        return this.isUnresolved() && this._absolutePathLocationWhenUnresolved != null;
    }

    @Override
    protected void writeExternalReference(Element thisElement, WritingContext writingContext) throws MetadataException {
        IQModelImplUtilities.setAttr(thisElement, "identity", this._identity);
        String location = null;
        if (this.isUnresolved()) {
            location = this._absolutePathLocationWhenUnresolved;
        } else if (writingContext.shouldWriteExternalLocation(this)) {
            location = this.getLocationWhenNotUnresolved();
            writingContext.addReferencedBriefInfoMap(this.getSmartObject());
        }
        IQModelImplUtilities.setAttr(thisElement, "absolutePathLocation", location);
    }

    protected MetadataInterface getSmartObject() {
        return null;
    }

    @Override
    public void consumeExternalReferenceAttributes(AttributesProvider attrsProvider) throws SAXException {
        String loc;
        super.consumeExternalReferenceAttributes(attrsProvider);
        this._identity = attrsProvider.consumeAttr("identity");
        this._absolutePathLocationWhenUnresolved = attrsProvider.consumeAttr("absolutePathLocation");
        if (this._absolutePathLocationWhenUnresolved == null && (loc = attrsProvider.consumeAttr("location")) != null) {
            this._absolutePathLocationWhenUnresolved = IQModelImplUtilities.fullPathToAbsolutePath(loc);
        }
    }

    public abstract AbstractModelReference getModelReference() throws MetadataException;

    protected final void readV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this.readDefinitionV1(thisElement, readingContext);
        this.resolveExternalDependenciesV1(readingContext);
        readingContext.replaceUnresolvedReferencesWithResolvedReferences();
        this._unresolvedResources = readingContext.getUnresolvedObjectDefinitions();
        this.postReadV1(readingContext);
        this.setUpListenersWithinModel(readingContext.trustedGetObjsCreatedDuringRead());
    }

    protected abstract void resolveExternalDependenciesV1(ReadingContext var1) throws MetadataException;

    protected void setUpListenersWithinModel(List objsCreatedDuringRead) {
        long startSetListeners = 0L;
        long startModelListeners = 0L;
        if (_persistRFDLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogReadFlowDetails("start setting up listeners within model");
            startSetListeners = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogReadFlowDetails("start setting model listeners");
            startModelListeners = startSetListeners;
        }
        List<ModelItem> items = this.getDirectlyReferencedItemsInDownwardDefinition();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            AbstractModelItem item = (AbstractModelItem)items.get(i);
            item.addListenerUnsynchronized(this);
        }
        long startReverseMapping = 0L;
        if (_persistRFDLogger.isDebugEnabled()) {
            long elapsedModelListeners = System.currentTimeMillis() - startModelListeners;
            ExtraLoggingContexts.debugLogReadFlowDetails("end   setting model listeners: " + elapsedModelListeners + "ms");
            ExtraLoggingContexts.debugLogReadFlowDetails("start computing reverse mapping");
            startReverseMapping = System.currentTimeMillis();
        }
        IdentityHashMap objToItsListeners = new IdentityHashMap(objsCreatedDuringRead.size() + 20);
        int objsCreatedSize = objsCreatedDuringRead.size();
        for (int i = 0; i < objsCreatedSize; ++i) {
            AbstractBase objCreated = (AbstractBase)objsCreatedDuringRead.get(i);
            this.addToReverseMapping(objCreated, objToItsListeners);
        }
        int count = objToItsListeners.size();
        long startInitializeListeners = 0L;
        if (_persistRFDLogger.isDebugEnabled()) {
            long elapsedReverseMapping = System.currentTimeMillis() - startReverseMapping;
            ExtraLoggingContexts.debugLogReadFlowDetails("end   computing reverse mapping: " + elapsedReverseMapping + "ms");
            ExtraLoggingContexts.debugLogReadFlowDetails("start initializing listeners (count=" + count + "):");
            startInitializeListeners = System.currentTimeMillis();
        }
        for (Map.Entry entry : objToItsListeners.entrySet()) {
            AbstractBase base = (AbstractBase)entry.getKey();
            IdentityList listeners = (IdentityList)entry.getValue();
            base.addListenersUnsynchronized(listeners);
        }
        if (_persistRFDLogger.isDebugEnabled()) {
            long elapsedInitializeListeners = System.currentTimeMillis() - startInitializeListeners;
            ExtraLoggingContexts.debugLogReadFlowDetails("end   initializing listeners: " + elapsedInitializeListeners + "ms");
            long elapsedSetListeners = System.currentTimeMillis() - startSetListeners;
            ExtraLoggingContexts.debugLogReadFlowDetails("end   setting up listeners within model: " + elapsedSetListeners + "ms");
        }
    }

    private void addToReverseMapping(AbstractBase base, IdentityHashMap objToItsListeners) {
        List<ModelItem> objs = base.getDirectlyReferencedItemsInDownwardDefinition();
        int size = objs.size();
        for (int i = 0; i < size; ++i) {
            AbstractModelItem obj = (AbstractModelItem)objs.get(i);
            IdentityList listeners = (IdentityList)objToItsListeners.get(obj);
            if (listeners == null) {
                listeners = new IdentityList(1);
                objToItsListeners.put(obj, listeners);
            }
            listeners.add(base);
        }
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._identity = IQModelImplUtilities.getAttr(thisElement, "bmid");
        this._label = IQModelImplUtilities.getAttr(thisElement, "label");
        this._description = IQModelImplUtilities.getAttr(thisElement, "desc");
        this._nextDefaultIDNumber = IQModelImplUtilities.getIntAttr(thisElement, "nextDefaultID", 0);
        this._lastPersistedModelVersion = IQModelImplUtilities.getModelVersionAttr(thisElement, "ver");
        if (this._lastPersistedModelVersion == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelImpl.RequiredAttribute.fmt.txt", "ver"));
        }
        ModelVersion lastPersistedModelVersion = this.getLastPersistedModelVersion();
        if (lastPersistedModelVersion.laterThan(ModelVersion.THIS_SOFTWARE_VERSION)) {
            MessageFormatter formatter = this instanceof InformationMap ? IQModelImplUtilities.getMessageFormatter("BusinessModelImpl.CannotReadNewerMap.fmt.txt", ModelVersion.THIS_SOFTWARE_VERSION, lastPersistedModelVersion) : IQModelImplUtilities.getMessageFormatter("BusinessModelImpl.CannotReadNewerDataSelection.fmt.txt", ModelVersion.THIS_SOFTWARE_VERSION, lastPersistedModelVersion);
            Reason reason = new Reason((Object)this, 9, 87, formatter);
            throw new MetadataException(formatter, Collections.singletonList(reason));
        }
        this._changeHistory = AbstractModel.v1_readItemListUnderSubelement(thisElement, readingContext, "ChangeHistoryList", ONLY_CHANGE_HISTORY_ITEMS);
    }

    @Override
    protected void replaceDirectReferences(Object replaceThis, Object withThis) {
        this._baseModel = (AbstractModel)AbstractModel.replace(this._baseModel, replaceThis, withThis);
    }

    public String toString() {
        return this._label;
    }

    public String getFamilyGraph() {
        return this.getFamilyStateDebugString();
    }

    public String getFamilyStateDebugString() {
        List<AbstractModel> family = this.getFamily();
        Element topElement = null;
        try {
            topElement = IQModelImplUtilities.newDocumentWithElementName("ModelFamilySnapshot");
        }
        catch (MetadataException e) {
            return null;
        }
        for (AbstractModel apc : family) {
            try {
                apc.writeAsInlineXMLUnder(topElement, null);
            }
            catch (MetadataException e) {
                this.gotExceptionWritingModel(e, topElement);
            }
            catch (RuntimeException e) {
                this.gotExceptionWritingModel(e, topElement);
            }
        }
        return IQModelImplUtilities.toPrettyString(topElement, -1);
    }

    private void gotExceptionWritingModel(Exception e, Element topElement) {
        Element exceptionElement = IQModelImplUtilities.newSubelement(topElement, "ExceptionWritingModel");
        IQModelImplUtilities.setAttr(exceptionElement, "exceptionMsg", e.toString());
    }

    public String toDebugString() throws MetadataException {
        String out = this.getDefinitionElementName() + " contents (debug use only, do not store) = ";
        try {
            ModelWritingResults results = this.writeModelUnderAndFinalizeXML(new ModelWritingInput(false, false));
            Element thisElement = results.getElement();
            out = out + IQModelImplUtilities.toString(thisElement);
        }
        catch (MetadataException e) {
            out = out + "Exception occurred getting string representation for business model: " + e.toString();
        }
        return out;
    }

    @Override
    public ModelVersion getLastPersistedModelVersion() {
        return this._lastPersistedModelVersion;
    }

    public List<BusinessModelResource> getUnresolvedResources() {
        ArrayList<BusinessModelResource> unresolved = this._unresolvedResources != null ? new ArrayList<BusinessModelResource>(this._unresolvedResources) : new ArrayList<BusinessModelResource>();
        return unresolved;
    }

    protected void setUnresolvedResources(List<? extends BusinessModelResource> unresolved) {
        this._unresolvedResources = unresolved != null ? new ArrayList<BusinessModelResource>(unresolved) : new ArrayList<BusinessModelResource>(0);
    }

    public SessionContextInterface getSession() {
        return this._session;
    }

    void setSession(SessionContextInterface session) {
        this._session = session;
    }

    @Nonnull
    public List<ChangeHistoryItem> getChangeHistory() throws MetadataException {
        return new ArrayList<ChangeHistoryItem>(this._changeHistory);
    }

    public void setChangeHistory(List<? extends ChangeHistoryItem> changeHistory) throws MetadataException {
        IQModelImplUtilities.ensureProperArgumentTypes(changeHistory, ONLY_CHANGE_HISTORY_ITEMS);
        this._changeHistory = new ArrayList<ChangeHistoryItem>(changeHistory);
    }

    protected void postReadV1(ReadingContext readingContext) throws MetadataException {
        this.v1ConvertQualifiedLevels(readingContext);
    }

    protected void v1ConvertQualifiedLevels(ReadingContext readingContext) throws MetadataException {
        List qualifiedLevels = IQModelImplUtilities.filterList(readingContext.trustedGetObjsCreatedDuringRead(), QualifiedLevelImpl.class);
        int size = qualifiedLevels.size();
        for (int i = 0; i < size; ++i) {
            OMAQualifiedLevel oql;
            QualifiedLevelImpl ql = (QualifiedLevelImpl)qualifiedLevels.get(i);
            OMAHierarchy insideHierarchy = (OMAHierarchy)ql.getOwningHierarchy();
            if (!insideHierarchy.isUnresolved()) {
                oql = insideHierarchy.getEquivalentLevel(ql);
                readingContext.replaceReferencesWith(ql, oql);
                continue;
            }
            oql = insideHierarchy.getEquivalentLevel(ql);
            readingContext.replaceReferencesWith(ql, oql);
        }
    }

    protected String v1GetXrefPersistenceIDAttrName(String elementName) throws MetadataException {
        String out = null;
        out = elementName.startsWith("Repos") || elementName.startsWith("MetadataResource") ? "prid" : "xmid";
        return out;
    }

    protected String v1GetModelPersistenceIDAttrName(String elementName) throws MetadataException {
        String out = null;
        out = elementName.equals("ReposObjUse") || elementName.equals("MetadataResourceUse") || elementName.equals("InMemoryTable") || elementName.equals("InMemoryColumn") || elementName.equals("QualifiedColumn") || elementName.equals("QualifiedColumnUse") || elementName.equals("QualifiedLevel") || elementName.equals("QualifiedLevelUse") ? "prid" : (elementName.endsWith("Use") ? "xmid" : "imid");
        return out;
    }

    public AbstractModelItem newModelItemForElementName(String elementName, ReadingContext readingContext) throws MetadataException {
        if (v1ItemReadFactory == null) {
            v1ItemReadFactory = ModelItemReadFactory.getInstance();
        }
        AbstractModelItem item = v1ItemReadFactory.newItem(elementName);
        readingContext.addItemCreatedDuringRead(item);
        return item;
    }

    protected static Root readCompositeObjectFromOmr(Root mainOMRObjectForCompositeObject, OMIRepositoryInterface repos, String template) throws MetadataException, MdException, ServiceException, RemoteException {
        _logger.debug("Getting IQ composite object from OMR...");
        Root outObject = IQModelImplUtilities.reGetObjectWithTemplate((RepositoryInterface)repos, mainOMRObjectForCompositeObject, template, 0);
        _logger.debug("Done getting IQ composite object from OMR.");
        if (outObject == null) {
            String omrObjectName = null;
            try {
                omrObjectName = mainOMRObjectForCompositeObject.getName();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("AbstractModel.MapDoesNotExistInMetadataServer.fmt.txt", omrObjectName == null ? "" : omrObjectName));
        }
        return outObject;
    }

    protected static void deletePromptsQuietly(List prompts, OMIRepositoryInterface repos) {
        if (prompts != null && prompts.size() > 0 && repos != null) {
            try {
                ArrayList<Root> rootObjs = new ArrayList<Root>();
                for (Object object : prompts) {
                    Root root;
                    MetadataInterface smartObject;
                    if (!(object instanceof MetadataInterface) || (smartObject = (MetadataInterface)object).isDeleted() || (root = IQModelImplUtilities.unwrapOMRSmartObject(smartObject)) == null) continue;
                    rootObjs.add(root);
                }
                repos.deleteEntities(rootObjs);
            }
            catch (RemoteException e) {
                _logger.debug("Exception while deleting previously used prompt objects", (Throwable)e);
            }
            catch (ServiceException e) {
                _logger.debug("Exception while deleting previously used prompt objects", (Throwable)e);
            }
        }
    }

    protected static void removeJomaObjectFromItsStores(Root jomaObject) {
        block3: {
            try {
                MdStore store1 = jomaObject.getObjectStore();
                if (store1 instanceof MdObjectStore) {
                    MdObjectStore objectStore = (MdObjectStore)store1;
                    objectStore.removeElementFromStore((CMetadata)jomaObject);
                }
            }
            catch (RemoteException e) {
                if (!_logger.isDebugEnabled()) break block3;
                _logger.debug(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected static Root newOmrObject(String objectType, OMIRepositoryInterface repos, String name) throws ServiceException, RemoteException {
        return repos.createMetadata(name, objectType);
    }

    protected static String getReposId(RepositoryInterface repos) throws RemoteException {
        String base = repos.getBase();
        return AbstractModel.getShortId(base);
    }

    protected static String getShortId(String reposId) {
        String out = reposId;
        int idot = reposId.indexOf(46);
        if (idot != -1) {
            out = reposId.substring(idot + 1);
        }
        return out;
    }

    protected static void staticPersistenceError(MessageFormatter message) throws MetadataException {
        if (_logger.isEnabled(Level.ERROR)) {
            _logger.error(message.toString());
        }
        throw new MetadataException(message);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.fireChangeEvent(EVENT_OBJECT_DEFINITION_CHANGED);
    }

    public ServerProperties getServerProperties() throws MetadataException {
        return null;
    }

    IntelligentQueryMetadataServiceInterface getService() {
        return null;
    }

    void setService(IntelligentQueryMetadataServiceInterface service) {
    }

    protected void pushXMLAndPostProcess(Element modelElement, XMLV2ModelHandler handler, ReadingContextV2 readingContext) throws MetadataException {
        XMLV2Pusher pusher = new XMLV2Pusher(modelElement, handler);
        pusher.push();
        AbstractModel.doPostProcessing(readingContext);
    }

    protected void pushXMLAndPostProcess(InputSource inputSource, XMLV2ModelHandler handler, ReadingContextV2 readingContext) throws MetadataException {
        XMLV2Pusher pusher = new XMLV2Pusher(inputSource, handler);
        pusher.push();
        AbstractModel.doPostProcessing(readingContext);
    }

    private static void doPostProcessing(ReadingContextV2 readingContext) throws MetadataException {
        AbstractModel model = readingContext.getModelBeingRead();
        model.postPopulationProcessing(readingContext);
        ArrayList<ReadingContextV2> readingContextsOneLevelEmbedded = readingContext.trustedGetImmediateInnerModelContexts();
        for (ReadingContextV2 innerContext : readingContextsOneLevelEmbedded) {
            AbstractModel.doPostProcessing(innerContext);
        }
    }

    protected abstract void postPopulationProcessing(ReadingContextV2 var1) throws MetadataException;

    protected void removeUnresolvedResource(BusinessModelResource oldResource) {
        if (this._unresolvedResources.contains(oldResource)) {
            this._unresolvedResources.remove(oldResource);
        }
    }

    protected MetadataServerInterface getAuthServer() throws MetadataException {
        MetadataServerInterface outServer = null;
        if (this._session != null) {
            try {
                outServer = IQModelImplUtilities.getMetadataServerAuthenticatedWith(this._session);
            }
            catch (ServiceException e) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("AbstractModel.CouldNotGetMetadataServer.txt", new Object[0]), (Throwable)e);
            }
            catch (RemoteException e) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("AbstractModel.CouldNotGetMetadataServer.txt", new Object[0]), (Throwable)e);
            }
        }
        return outServer;
    }

    static Object getSynchronizationObject(MetadataInterface smartObject, SessionContextInterface session) throws ServiceException, RemoteException, MetadataException {
        StringBuffer buf = new StringBuffer(150);
        String sessionKey = session.getEntityKey();
        String metadataKey = smartObject.getEntityKey();
        buf.append(sessionKey);
        buf.append(metadataKey);
        String str = buf.toString();
        SyncStringPool pool = AbstractModel.getPool(session);
        str = pool.getUniqueString(str);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Persistence synchronization object used: \"" + str + "\", hashCode=" + Integer.toString(str.hashCode()));
        }
        return str;
    }

    private static synchronized SyncStringPool getPool(SessionContextInterface session) throws MetadataException {
        SyncStringPool pool = (SyncStringPool)_sessionCache.get(session, POOL_KEY);
        if (pool == null) {
            String sessionKey = null;
            pool = new SyncStringPool();
            if (_persistLogger.isDebugEnabled()) {
                try {
                    sessionKey = session.getEntityKey();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                ExtraLoggingContexts.debugLogPersistence("Creating new SyncStringPool for session key: \"" + sessionKey + "\"");
            }
            try {
                _sessionCache.put(session, POOL_KEY, pool, pool);
                if (_persistLogger.isDebugEnabled()) {
                    ExtraLoggingContexts.debugLogPersistence("Added SyncStringPool to session listener for session key: \"" + sessionKey + "\"");
                }
            }
            catch (SessionContextDependentCacheException e) {
                throw new MetadataException(e);
            }
        }
        return pool;
    }

    private static class XMLV2Pusher {
        private XMLV2ModelHandler _xmlHandler;
        private Element _domElementToStartParsing;
        private InputSource _saxInputSource;

        public XMLV2Pusher(Element domElement, XMLV2ModelHandler xmlHandler) {
            this._xmlHandler = xmlHandler;
            this._domElementToStartParsing = domElement;
        }

        public XMLV2Pusher(InputSource inputSource, XMLV2ModelHandler xmlHandler) {
            this._xmlHandler = xmlHandler;
            this._saxInputSource = inputSource;
        }

        public void push() throws MetadataException {
            try {
                long startTime = System.currentTimeMillis();
                if (this._saxInputSource != null) {
                    ExtraLoggingContexts.debugLogReadFlowSummary("Start getting SAX parser & parsing our XML");
                    SAXParser saxParser = IQModelImplUtilities.getSAXParser();
                    SAXParserProperties saxParserProperties = new SAXParserProperties(saxParser);
                    this._xmlHandler.setParserIsInterningStrings(saxParserProperties.isParserInterningStrings());
                    saxParserProperties.logDebug();
                    saxParser.parse(this._saxInputSource, (DefaultHandler)this._xmlHandler);
                } else {
                    ExtraLoggingContexts.debugLogReadFlowSummary("Start reading our XML via DOM (DOM already at this point)");
                    DOMDispenser dispense = new DOMDispenser(this._domElementToStartParsing, this._xmlHandler);
                    dispense.walkDOMAndDispenseToHandler();
                }
                if (_persistRFSLogger.isDebugEnabled()) {
                    long endTime = System.currentTimeMillis();
                    ExtraLoggingContexts.debugLogReadFlowSummary("Done parsing our XML.  Parsing time = " + (endTime - startTime) + "ms");
                }
            }
            catch (ClassCastException e) {
                this.handleClassCastExceptionDuringRead(e, this._xmlHandler);
            }
            catch (NumberFormatException e) {
                this.handleNumberFormatExceptionDuringRead(e, this._xmlHandler);
            }
            catch (ParserConfigurationException e) {
                MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("AbstractModel.FailedToParseXMLAtElementPath.fmt.txt", this._xmlHandler.getElementLocation());
                throw new MetadataException(messageFormatter, (Throwable)e);
            }
            catch (IOException e) {
                MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("AbstractModel.FailedToParseXMLAtElementPath.fmt.txt", this._xmlHandler.getElementLocation());
                throw new MetadataException(messageFormatter, (Throwable)e);
            }
            catch (SAXException e) {
                MessageFormatter messageFormatter = IQModelImplUtilities.getMessageFormatter("AbstractModel.FailedToParseXMLNear.fmt.txt", this._xmlHandler.getElementLocation());
                Exception cause = e.getException();
                if (cause != null) {
                    if (cause instanceof ClassCastException) {
                        this.handleClassCastExceptionDuringRead((ClassCastException)cause, this._xmlHandler);
                    }
                    if (cause instanceof NumberFormatException) {
                        this.handleNumberFormatExceptionDuringRead((NumberFormatException)cause, this._xmlHandler);
                    }
                    if (cause instanceof MetadataException) {
                        throw (MetadataException)cause;
                    }
                    throw new MetadataException(messageFormatter, (Throwable)e);
                }
                throw new MetadataException(messageFormatter, (Throwable)e);
            }
        }

        private void handleClassCastExceptionDuringRead(ClassCastException classCastException, XMLV2ModelHandler xmlHandler) throws MetadataException {
            AbstractBase objectDoingConsumption = xmlHandler.getObjectDoingConsumption();
            if (objectDoingConsumption != null) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("AbstractModel.UnexpectedObjectFoundAtLocation.fmt.txt", objectDoingConsumption.getClass().getName(), xmlHandler.getElementLocation()), (Throwable)classCastException);
            }
            throw classCastException;
        }

        private void handleNumberFormatExceptionDuringRead(NumberFormatException numberFormatException, XMLV2ModelHandler xmlHandler) throws MetadataException {
            AbstractBase objectDoingConsumption = xmlHandler.getObjectDoingConsumption();
            if (objectDoingConsumption != null) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("AbstractModel.UnexpectedValueFoundAtLocation.fmt.txt", objectDoingConsumption.getClass().getName(), xmlHandler.getElementLocation()), (Throwable)numberFormatException);
            }
            throw numberFormatException;
        }
    }

    protected static interface ModelWritingResults {
        public Element getElement();

        public ModelVersion getModelVersion();

        public List getMetadataRepositoryResources();

        public List getPrivateExternalPromptsNeedingAssociations();

        public List getReferencedInfoMaps();

        public HashMap<Locale, PropertyList> getPropertyMap();
    }

    protected static class ModelWritingInput
    implements ModelWritingInputInterface {
        private Node _writeUnderThisNode;
        private boolean _isWriteOperationToOMR = false;
        private boolean _writeOperationIsToGetVersionOnly = false;
        private OMIRepositoryInterface _targetRepository;
        private FailedWriteCleanupInfo _cleanupInfo;
        private Map<QueryWriteOption, Object> _writeOptions;

        ModelWritingInput(boolean isWriteOperationToOMR, boolean writeIsToGetVersionOnly) {
            this._writeUnderThisNode = null;
            this._isWriteOperationToOMR = isWriteOperationToOMR;
            this._writeOperationIsToGetVersionOnly = writeIsToGetVersionOnly;
        }

        ModelWritingInput(Node nodeToWriteUnder, boolean isWriteOperationToOMR, boolean writeIsToGetVersionOnly) {
            this._writeUnderThisNode = nodeToWriteUnder;
            this._isWriteOperationToOMR = isWriteOperationToOMR;
            this._writeOperationIsToGetVersionOnly = writeIsToGetVersionOnly;
        }

        void setCleanupInfo(FailedWriteCleanupInfo cleanupInfo) {
            this._cleanupInfo = cleanupInfo;
        }

        FailedWriteCleanupInfo getCleanupInfo() {
            return this._cleanupInfo;
        }

        Node getNodeToWriteUnder() {
            return this._writeUnderThisNode;
        }

        @Override
        public boolean isWriteOperationToOMR() {
            return this._isWriteOperationToOMR;
        }

        @Override
        public boolean isWriteOperationToGetVersionOnly() {
            return this._writeOperationIsToGetVersionOnly;
        }

        void setRepository(OMIRepositoryInterface repos) {
            this._targetRepository = repos;
        }

        @Override
        public OMIRepositoryInterface getRepository() {
            return this._targetRepository;
        }

        public void setWritingOptions(Map<QueryWriteOption, Object> writeOptions) {
            this._writeOptions = writeOptions;
        }

        public Map<QueryWriteOption, Object> getWritingOptions() {
            return this._writeOptions;
        }
    }

    protected static interface ModelWritingInputInterface {
        public boolean isWriteOperationToOMR();

        public boolean isWriteOperationToGetVersionOnly();

        public OMIRepositoryInterface getRepository();
    }

    private static class SyncStringPool
    implements SessionContextDependentCache.SessionContextEndListener {
        private Map _pool = new HashMap();

        private SyncStringPool() {
        }

        public synchronized String getUniqueString(String value) {
            String out = value;
            String poolValue = (String)this._pool.get(value);
            if (poolValue != null) {
                out = poolValue;
                if (_persistLogger.isDebugEnabled()) {
                    ExtraLoggingContexts.debugLogPersistence("Reused SyncStringPool entry: \"" + out + "\"");
                }
            } else {
                this._pool.put(value, value);
                if (_persistLogger.isDebugEnabled()) {
                    ExtraLoggingContexts.debugLogPersistence("Added new SyncStringPool entry: \"" + out + "\"");
                }
            }
            return out;
        }

        @Override
        public synchronized void sessionEnd(SessionContextInterface session) {
            this._pool.clear();
            _sessionCache.removeCachedValue(session, POOL_KEY);
            _sessionCache.removeSessionContextEndListener(session, this);
            if (_persistLogger.isDebugEnabled()) {
                String sessionKey = null;
                try {
                    sessionKey = session.getEntityKey();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                ExtraLoggingContexts.debugLogPersistence("SyncStringPool cleared for logged off session key: \"" + sessionKey + "\"");
            }
        }
    }

    static class FailedWriteCleanupInfo {
        private List<ChangeHistoryItem> _updatedChangeHistory;
        private List<OMRPromptDefinitionInterface> _privatePromptsCreated = new ArrayList<OMRPromptDefinitionInterface>();
        private OMIRepositoryInterface _repos;

        FailedWriteCleanupInfo() {
        }

        void addNewPrivatePromptCreated(OMRPromptDefinitionInterface prompt) {
            this._privatePromptsCreated.add(prompt);
        }

        void setUpdatedChangeHistory(List<ChangeHistoryItem> updatedChangeHistory) {
            this._updatedChangeHistory = updatedChangeHistory;
        }

        void setRepository(OMIRepositoryInterface repos) {
            this._repos = repos;
        }

        void cleanupFromFailedWrite() {
            if (this._updatedChangeHistory != null && this._updatedChangeHistory.size() > 0) {
                this._updatedChangeHistory.remove(this._updatedChangeHistory.size() - 1);
            }
            try {
                ServerInterface server = this._repos.getServer();
                if (server != null) {
                    server.clearPendingChanges(true);
                }
            }
            catch (RemoteException e) {
                _logger.debug("Exception while clearing pending changes", (Throwable)e);
            }
            catch (ServiceException e) {
                _logger.debug("Exception while clearing pending changes", (Throwable)e);
            }
            AbstractModel.deletePromptsQuietly(this._privatePromptsCreated, this._repos);
        }
    }
}

