/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.LocalizableModelObject;
import com.sas.iquery.metadata.business.ModelItemWithIdentity;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModelObject;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.util.LocalizableString;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractLocalizableBusinessModelObject
extends AbstractBusinessModelObject
implements LocalizableModelObject {
    private static final Logger _logger = LogManager.getLogger(AbstractLocalizableBusinessModelObject.class);
    private LocalizableString _descriptions = null;
    private LocalizableString _labels = null;

    public AbstractLocalizableBusinessModelObject() {
    }

    public AbstractLocalizableBusinessModelObject(AbstractBusinessModel model) {
        super(model);
        this._descriptions = new LocalizablePersistableString();
        this._labels = new LocalizablePersistableString();
    }

    @Override
    public String getDescription(Locale locale) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale(this.getBusinessModel());
        }
        LocalizableString descriptions = this._getDescriptions();
        String result = null;
        if (descriptions != null) {
            result = descriptions.getText(locale);
        }
        if (result == null) {
            result = this.getDescription();
        }
        return result;
    }

    @Override
    public LocalizableString getDescriptions() {
        LocalizableString dup = null;
        LocalizableString descriptions = this._getDescriptions();
        if (descriptions != null) {
            try {
                dup = (LocalizableString)descriptions.clone();
            }
            catch (CloneNotSupportedException e) {
                dup = IQModelImplUtilities.copyToLocalizablePersistableString(descriptions);
            }
        }
        return dup;
    }

    @Override
    public String getLabel(Locale locale) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale(this.getBusinessModel());
        }
        LocalizableString labels = this._getLabels();
        String result = null;
        if (labels != null) {
            result = labels.getText(locale);
        }
        if (result == null) {
            result = this.getLabel();
        }
        return result;
    }

    @Override
    public LocalizableString getLabels() {
        LocalizableString dup = null;
        LocalizableString labels = this._getLabels();
        if (labels != null) {
            try {
                dup = (LocalizableString)labels.clone();
            }
            catch (CloneNotSupportedException e) {
                dup = IQModelImplUtilities.copyToLocalizablePersistableString(labels);
            }
        }
        return dup;
    }

    @Override
    public void setDescription(String description, Locale locale) throws MetadataException {
        LocalizableString descriptions = this._getDescriptions();
        this._updateLocalizableString(descriptions, locale, description, "localizable descriptions changed");
    }

    @Override
    public void setDescriptions(LocalizableString descriptions) throws MetadataException {
        LocalizableString oldDescs = this._getDescriptions();
        this._updateLocalizableString(oldDescs, descriptions, "localizable descriptions changed");
    }

    @Override
    public void setLabel(String label, Locale locale) throws MetadataException {
        LocalizableString labels = this._getLabels();
        this._updateLocalizableString(labels, locale, label, "localizable labels changed");
    }

    @Override
    public void setLabels(LocalizableString labels) throws MetadataException {
        LocalizableString oldLabels = this._getLabels();
        this._updateLocalizableString(oldLabels, labels, "localizable labels changed");
    }

    private void _updateLocalizableString(LocalizableString localizableString, Locale locale, String text, String propertyChangeEventId) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale(this.getBusinessModel());
        }
        if (localizableString != null) {
            List knownLocales = localizableString.getLocales();
            if (text == null) {
                if (knownLocales.contains(locale)) {
                    this.changeableCheck();
                    localizableString.clearText(locale);
                    this.fireChangeEvent(propertyChangeEventId, locale, null);
                }
            } else if (!knownLocales.contains(locale)) {
                this.changeableCheck();
                localizableString.setText(text, locale);
                this.fireChangeEvent(propertyChangeEventId, null, locale);
            } else {
                String oldText = localizableString.getText(locale);
                if (!IQModelImplUtilities.same(oldText, text)) {
                    this.changeableCheck();
                    localizableString.setText(text, locale);
                    this.fireChangeEvent(propertyChangeEventId, locale, locale);
                }
            }
        }
    }

    private void _updateLocalizableString(LocalizableString copyTo, LocalizableString copyFrom, String propertyChangeEventId) {
        if (copyTo != null && !IQModelImplUtilities.same(copyTo, copyFrom)) {
            boolean changed = false;
            if (copyFrom == null) {
                if (copyTo.getDefaultLocale() != null) {
                    this.changeableCheck();
                    copyTo.setDefaultLocale(null);
                    changed = true;
                }
                if (copyTo.getLocales().size() > 0) {
                    this.changeableCheck();
                    copyTo.clearAll();
                    changed = true;
                }
            } else {
                Locale fromDefaultLocale = copyFrom.getDefaultLocale();
                Locale toDefaultLocale = copyTo.getDefaultLocale();
                if (fromDefaultLocale == null && toDefaultLocale != null || fromDefaultLocale != null && (toDefaultLocale == null || !fromDefaultLocale.equals(toDefaultLocale))) {
                    this.changeableCheck();
                    copyTo.setDefaultLocale(fromDefaultLocale);
                    changed = true;
                }
                List fromLocales = copyFrom.getLocales();
                List toLocales = copyTo.getLocales();
                for (Locale toLocale : toLocales) {
                    if (fromLocales.contains(toLocale)) continue;
                    this.changeableCheck();
                    copyTo.clearText(toLocale);
                    changed = true;
                }
                for (Locale fromLocale : fromLocales) {
                    String fromText = copyFrom.getText(fromLocale);
                    if (toLocales.contains(fromLocale)) {
                        String toText = copyTo.getText(fromLocale);
                        if ((fromText != null || toText == null) && (fromText == null || toText != null && fromText.equals(toText))) continue;
                        this.changeableCheck();
                        copyTo.setText(fromText, fromLocale);
                        changed = true;
                        continue;
                    }
                    this.changeableCheck();
                    copyTo.setText(fromText, fromLocale);
                    changed = true;
                }
            }
            if (changed) {
                this.fireChangeEvent(propertyChangeEventId, null, copyTo);
            }
        }
    }

    protected LocalizableString _getDescriptions() {
        this.loadAllLocalizableProperties();
        return this._descriptions;
    }

    protected LocalizableString _getLabels() {
        this.loadAllLocalizableProperties();
        return this._labels;
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        String key;
        super.writeDefinition(thisElement, writingContext);
        String keyValue = this.getLocalizationPrependKey() + "." + this.getLocalizationID();
        if (this._labels != null && (this._labels.getLocales().size() > 0 || this._labels.getDefaultLocale() != null)) {
            if (writingContext.isWriteOperationToOMR()) {
                key = keyValue + "." + "Label";
                writingContext.addLocalizableString(key, this._labels);
            } else {
                AbstractLocalizableBusinessModelObject.writeForeignObjectUnderNewSubelement(this._labels, thisElement, writingContext, "Labels");
            }
        }
        if (this._descriptions != null && (this._descriptions.getLocales().size() > 0 || this._descriptions.getDefaultLocale() != null)) {
            if (writingContext.isWriteOperationToOMR()) {
                key = keyValue + "." + "Description";
                writingContext.addLocalizableString(key, this._descriptions);
            } else {
                AbstractLocalizableBusinessModelObject.writeForeignObjectUnderNewSubelement(this._descriptions, thisElement, writingContext, "Descs");
            }
        }
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._labels = (LocalizableString)riHolder.consumeForeignObject("Labels");
        if (this._labels == null) {
            this._labels = new LocalizablePersistableString();
        }
        this._descriptions = (LocalizableString)riHolder.consumeForeignObject("Descs");
        if (this._descriptions == null) {
            this._descriptions = new LocalizablePersistableString();
        }
    }

    @Override
    public String getLocalizationID() throws MetadataException {
        return this.getIntraModelID();
    }

    protected PropertyList newLocalizableProperties(Locale locale, LocalizableModelObject bi) throws MetadataException {
        PropertyList list = new PropertyList();
        if (locale == null) {
            list.addProperty("Label", bi.getLabel());
            list.addProperty("Description", bi.getDescription());
        } else {
            list.addProperty("Label", bi.getLabel(locale));
            list.addProperty("Description", bi.getDescription(locale));
        }
        return list;
    }

    protected void setLocalizableProperties(Locale locale, LocalizableModelObject bmObject, PropertyMap nestedMap) throws MetadataException {
        String localizeKey = null;
        if (bmObject instanceof ModelItemWithIdentity) {
            boolean saveIsChangeableAllowed = this.isSetIsChangeableAllowed();
            boolean saveIsChangable = this.isChangeable();
            localizeKey = bmObject.getLocalizationID();
            if (nestedMap.containsNestedProperty(localizeKey)) {
                PropertyMap objectMap = nestedMap.getNestedProperties(localizeKey);
                this.trustedSetIsChangeable(true);
                this.trustedSetChangeableAllowed(true);
                if (objectMap.containsProperty("Label")) {
                    bmObject.setLabel(objectMap.getProperty("Label"), locale);
                }
                if (objectMap.containsProperty("Description")) {
                    bmObject.setDescription(objectMap.getProperty("Description"), locale);
                }
                this.trustedSetIsChangeable(saveIsChangable);
                this.trustedSetChangeableAllowed(saveIsChangeableAllowed);
            }
        }
    }

    @Override
    public String getLocalizationPrependKey() {
        return "";
    }

    public String toString(Locale locale) {
        String result = null;
        if (locale == null) {
            result = this.toString();
        } else {
            result = this.getLabel(locale);
            if (result == null) {
                result = this.toString();
            }
        }
        return result;
    }

    protected void loadAllLocalizableProperties() {
        for (AbstractModel model = this.getModel(); model != null; model = model.getParent()) {
            if (!(model instanceof InformationMapImpl2)) continue;
            try {
                ((InformationMapImpl2)model).loadAllLocalizableProperties();
                continue;
            }
            catch (MetadataException e) {
                _logger.warn(this.getClass().getName(), (Throwable)e);
            }
        }
    }
}

