/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.CascadableFilter;
import com.sas.iquery.metadata.business.FilterCascadeInterface;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractFilterCascade
extends AbstractModelItem
implements FilterCascadeInterface {
    private Prompt _prompt;
    private CascadableFilter _dependentFilter;

    @Override
    public Collection<PromptDefinitionInterface> getDependentPrompts() {
        List<PromptDefinitionInterface> dependentPrompts;
        if (this._dependentFilter instanceof AbstractModelItem) {
            AbstractModelItem mdItem = (AbstractModelItem)((Object)this._dependentFilter);
            List<Prompt> iqPrompts = mdItem.getResources(Prompt.class, 65535);
            dependentPrompts = new ArrayList<PromptDefinitionInterface>(iqPrompts.size());
            for (Prompt prompt : iqPrompts) {
                PromptDefinitionInterface pdef = prompt.getPromptDefinition();
                if (pdef == null) continue;
                dependentPrompts.add(pdef);
            }
        } else {
            dependentPrompts = Collections.emptyList();
        }
        return dependentPrompts;
    }

    @Override
    public PromptDefinitionInterface getPrompt() {
        PromptDefinitionInterface pdi = null;
        if (this._prompt != null) {
            pdi = this._prompt.getPromptDefinition();
        }
        return pdi;
    }

    @Override
    public void setBusinessPrompt(Prompt prompt) {
        this.changeableCheck();
        this._prompt = prompt;
    }

    @Override
    public void setDependentFilter(CascadableFilter filter) {
        this.changeableCheck();
        this._dependentFilter = filter;
    }

    @Override
    public Prompt getBusinessPrompt() {
        return this._prompt;
    }

    @Override
    public CascadableFilter getDependentFilter() {
        return this._dependentFilter;
    }

    @Override
    public void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._prompt);
        intoList.add(this._dependentFilter);
    }

    @Override
    public void replaceDirectReferences(Object oldObject, Object newObject) {
        this._prompt = (Prompt)AbstractFilterCascade.replace(this._prompt, oldObject, newObject);
        this._dependentFilter = (CascadableFilter)AbstractFilterCascade.replace(this._dependentFilter, oldObject, newObject);
    }

    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
        this.changeableCheck();
        this._prompt = (Prompt)Utils.replaceResource(this._prompt, oldResource, newResource, model, recursive);
        this._dependentFilter = (CascadableFilter)Utils.replaceResource(this._dependentFilter, oldResource, newResource, model, recursive);
    }

    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._prompt = (Prompt)((Object)riHolder.consumeObject("DependentPrompt"));
        this._dependentFilter = (CascadableFilter)((Object)riHolder.consumeObject("DependentFilter"));
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        AbstractFilterCascade.writeRelatedObject(this._prompt, thisElement, writingContext, "DependentPrompt");
        AbstractFilterCascade.writeRelatedObject(this._dependentFilter, thisElement, writingContext, "DependentFilter");
    }
}

