/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.util.LocalizableToStringInterface;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractEnumerationObject
implements LocalizableToStringInterface {
    private String _visualKey;
    private String _persistentForm;
    private String _v2PersistentForm;
    private static final Logger _logger = LogManager.getLogger(AbstractEnumerationObject.class);

    protected AbstractEnumerationObject(String visualKey, String persistentForm, String v2PersistentForm) {
        this._visualKey = visualKey;
        if (v2PersistentForm.indexOf(32) != -1) {
            Object[] args = new Object[]{visualKey, v2PersistentForm};
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractEnumerationObject.InvalidSpacesInPersistentForm.fmt.txt", args);
            IQueryServicesRuntimeException e = new IQueryServicesRuntimeException(msg);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msg.toString(), (Throwable)e);
            }
            throw e;
        }
        this._persistentForm = persistentForm;
        this._v2PersistentForm = v2PersistentForm;
        this.addEnumerationInstance(v2PersistentForm);
    }

    public String getPersistentForm() {
        return this._persistentForm;
    }

    public String getV2PersistentForm() {
        return this._v2PersistentForm != null ? this._v2PersistentForm : this._persistentForm;
    }

    protected static <T extends AbstractEnumerationObject> T fromPersistentForm(String persistentForm, List<T> allDefinedObjects) {
        AbstractEnumerationObject out = null;
        if (persistentForm != null) {
            for (AbstractEnumerationObject aeo : allDefinedObjects) {
                if (!persistentForm.equals(aeo.getPersistentForm())) continue;
                out = aeo;
                break;
            }
            if (out == null) {
                MessageFormatter validValues = AbstractEnumerationObject.validValues(1, allDefinedObjects);
                Object[] args = new Object[]{persistentForm, validValues};
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractEnumerationObject.InvalidPersistentV1Value.fmt.txt", args);
                NumberFormatException e = new NumberFormatException(msg.toString());
                if (_logger.isEnabled(Level.WARN)) {
                    _logger.warn(e.toString(), (Throwable)e);
                }
            }
        }
        return (T)out;
    }

    protected static <T extends AbstractEnumerationObject> T fromPersistentFormV2(String attrName, String v2PersistentForm, List<T> allDefinedObjects) {
        AbstractEnumerationObject out;
        if (v2PersistentForm == null) {
            out = null;
        } else {
            AbstractEnumerationObject found = null;
            for (AbstractEnumerationObject aeo : allDefinedObjects) {
                if (!v2PersistentForm.equals(aeo.getV2PersistentForm())) continue;
                found = aeo;
                break;
            }
            if (found != null) {
                out = found;
            } else {
                MessageFormatter validValues = AbstractEnumerationObject.validValues(2, allDefinedObjects);
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractEnumerationObject.InvalidPersistentV2Value.fmt.txt", v2PersistentForm, attrName, validValues);
                NumberFormatException e = new NumberFormatException(msg.toString());
                if (_logger.isEnabled(Level.WARN)) {
                    _logger.warn(e.toString(), (Throwable)e);
                }
                throw e;
            }
        }
        return (T)out;
    }

    static <T extends AbstractEnumerationObject> MessageFormatter validValues(int version, List<T> allDefinedObjects) {
        ArrayList<Object> values = new ArrayList<Object>(allDefinedObjects.size());
        for (AbstractEnumerationObject aoe : allDefinedObjects) {
            Object value = null;
            value = version == 1 ? aoe.getPersistentForm() : (version == 2 ? aoe.getV2PersistentForm() : aoe);
            values.add(value);
        }
        ArrayMessageFormatter formatter = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, ArrayMessageFormatter.QUOTESTYLE_TEXT, values.toArray());
        return formatter;
    }

    protected static <T extends AbstractEnumerationObject> T consumeValue(AttributesProvider attrsProvider, String attrName, List<T> allDefinedObjects, T defaultValue) {
        T out = null;
        String persistentForm = attrsProvider.consumeAttr(attrName);
        if (persistentForm == null) {
            out = defaultValue;
        } else if (persistentForm.length() != 0) {
            out = AbstractEnumerationObject.fromPersistentFormV2(attrName, persistentForm, allDefinedObjects);
        }
        return out;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Locale locale) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        String value = null;
        try {
            value = IQMetadataResourceBundle.getStringResource(this._visualKey, locale);
        }
        catch (MissingResourceException e) {
            Object[] args = new Object[]{this.getClass().getName(), this._visualKey, locale};
            String msg = IQMetadataResourceBundle.getMessageString("AbstractEnumerationObject.MissingResource.fmt.txt", args);
            if (_logger.isEnabled(Level.WARN)) {
                _logger.warn(msg, (Throwable)e);
            }
            value = this._visualKey;
        }
        return value;
    }

    public abstract Enumeration<? extends AbstractEnumerationObject> enumerateSiblings();

    protected abstract void registerInstance();

    protected void addEnumerationInstance(String persistentForm) {
        Enumeration<? extends AbstractEnumerationObject> enumer = this.enumerateSiblings();
        while (enumer.hasMoreElements()) {
            AbstractEnumerationObject obj = enumer.nextElement();
            if (!persistentForm.equals(obj.getV2PersistentForm()) || this == obj) continue;
            Object[] args = new Object[]{persistentForm, this.getClass().getName()};
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractEnumerationObject.ErrorEnumAlreadyDefined.fmt.txt", args);
            IllegalStateException e = new IllegalStateException(msg.toString());
            if (_logger.isEnabled(Level.WARN)) {
                _logger.warn(msg.toString(), (Throwable)e);
            }
            throw e;
        }
        this.registerInstance();
    }

    protected static AbstractEnumerationObject fromPersistentForm(String attrName, String persistentForm, Class<? extends AbstractEnumerationObject> enumClass) {
        AbstractEnumerationObject out = null;
        try {
            Method method = enumClass.getMethod("fromPersistentFormV2", attrName.getClass(), persistentForm.getClass());
            out = (AbstractEnumerationObject)method.invoke(enumClass, attrName, persistentForm);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e1) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AbstractEnumerationObject.ErrorUnpersistingEnumAttribute.fmt.txt", attrName, enumClass.getName());
            IllegalStateException e = new IllegalStateException(msg.toString());
            e.initCause(e1);
            if (_logger.isEnabled(Level.WARN)) {
                _logger.warn(msg.toString(), (Throwable)e);
            }
            throw e;
        }
        return out;
    }

    public static <T extends AbstractEnumerationObject> List<T> consumeCommaList(AttributesProvider attrsProvider, String attrName, Class<T> type) {
        ArrayList<AbstractEnumerationObject> out = null;
        String attrValue = attrsProvider.consumeAttr(attrName);
        if (attrValue != null) {
            out = new ArrayList<AbstractEnumerationObject>();
            StringTokenizer st = new StringTokenizer(attrValue, ",");
            while (st.hasMoreTokens()) {
                String actionString = st.nextToken();
                AbstractEnumerationObject enumValue = AbstractEnumerationObject.fromPersistentForm(attrName, actionString, type);
                if (enumValue == null) continue;
                out.add((AbstractEnumerationObject)type.cast(enumValue));
            }
        }
        return out;
    }

    public static AbstractEnumerationObject[] sortByPersistedForm(List enums) {
        AbstractEnumerationObject[] enumsToSort = enums.toArray(new AbstractEnumerationObject[enums.size()]);
        Arrays.sort(enumsToSort, new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = 0;
                if (o1 == null) {
                    result = o2 == null ? 0 : -1;
                } else if (o2 == null) {
                    result = 1;
                } else {
                    String o1string = ((AbstractEnumerationObject)o1).getV2PersistentForm();
                    String o2string = ((AbstractEnumerationObject)o2).getV2PersistentForm();
                    result = o1string.compareTo(o2string);
                }
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                boolean result = this == obj;
                return result;
            }
        });
        return enumsToSort;
    }

    protected static class AEOEnumerator<E>
    implements Enumeration<E> {
        private final List<E> _all;
        private final Iterator<E> _iter;

        public AEOEnumerator(List<E> all) {
            this._all = all;
            this._iter = this._all.iterator();
        }

        @Override
        public E nextElement() {
            return this._iter.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this._iter.hasNext();
        }
    }
}

