/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business.impl;

import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.FolderItem;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractModelItemWithIdentity;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractBusinessModelObject
extends AbstractModelItemWithIdentity
implements BusinessModelObject {
    private EntityInterface _extendedAttributes = null;
    private static final Logger _logger = LogManager.getLogger(AbstractBusinessModelObject.class);

    public AbstractBusinessModelObject() {
    }

    protected AbstractBusinessModelObject(AbstractBusinessModel businessModel) {
        super(businessModel);
    }

    @Override
    public final List<Reason> getReasonsNotPersistable() {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        this.accumulateReasonsNotPersistableWithinModel(reasons);
        return reasons;
    }

    @Override
    public BusinessModel getBusinessModel() {
        return (BusinessModel)((Object)this.getModel());
    }

    protected AbstractBusinessModel getBusModel() {
        return (AbstractBusinessModel)this.getModel();
    }

    @Override
    public Date getCreated() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getUpdated() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final void accumulateReasonsUnusable(List<Reason> reasons) {
        if (this.hasCycleInDownwardDefinition()) {
            reasons.add(new Reason((Object)this, 2, 200, "AbstractModelItem.ObjectHasCycleInItsDefinition.fmt.txt", this.getIdentityString()));
        } else {
            AbstractBusinessModelObject.accumulateReasonsUnusableNonrecursiveForOneItem(reasons, this);
            int reasonListSize = reasons.size();
            this.accumulateReasonsUnusableForSubitems(reasons);
            if (reasons.size() > reasonListSize) {
                Reason reason = new Reason((Object)this, 2, 67, "BusinessModelObjectImpl.ReferencesObjectsThatAreNotUsable.fmt.txt", this.getIdentityString(), "" + (reasons.size() - reasonListSize));
                reasons.add(reasonListSize, reason);
            }
        }
    }

    @Override
    public boolean isContainedInBusinessModel() {
        boolean contained = true;
        AbstractBusinessModel model = this.getBusModel();
        if (model == null || !model.contains(this)) {
            contained = false;
        }
        return contained;
    }

    @Override
    public String getID() throws InvalidIDException {
        return this.getInterModelIdentity();
    }

    @Override
    public String getIntraModelID() {
        return this.getIntraModelIdentity();
    }

    @Override
    public void setIntraModelID(String ID) throws InvalidIDException {
        this.changeableCheck();
        if (!this.getBusModel().isLegalID(ID)) {
            throw new InvalidIDException(IQModelImplUtilities.getMessageFormatter("BusinessModelObjectImplBadID.fmt.txt", new String(BusinessModel.INVALID_ID_CHARS)));
        }
        this.setIdentityWithinContainer(ID);
        this.fireChangeEvent("item identity changed");
    }

    @Override
    public boolean isIDOK() {
        String thisID = this.getIntraModelIdentity();
        if (thisID == null) {
            return false;
        }
        List<String> allIDsInModel = this.getBusModel().getAllContainedIntraModelIDs();
        allIDsInModel.remove(thisID);
        return !allIDsInModel.contains(thisID);
    }

    @Override
    public void setExtendedAttributes(EntityInterface attrEntity) throws MetadataException {
        this.changeableCheck();
        this._extendedAttributes = attrEntity;
        this.fireChangeEvent("A property associated with the object has changed");
    }

    @Override
    public EntityInterface getExtendedAttributes() {
        return this._extendedAttributes;
    }

    @Override
    public boolean isReadOnly() {
        return !this.isChangeable();
    }

    @Override
    public boolean isOrphaned() {
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractBusinessModelObject clone = (AbstractBusinessModelObject)super.clone();
        if (this._extendedAttributes != null) {
            try {
                clone._extendedAttributes = Utils.copy(this._extendedAttributes);
            }
            catch (MetadataException e) {
                CloneNotSupportedException e2 = new CloneNotSupportedException(IQModelImplUtilities.getMessage("AbstractBusinessModelObject.CannotCloneAttributes.fmt.txt", this.getIdentityString()));
                e2.initCause(e);
                throw e2;
            }
        }
        return clone;
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        AbstractBusinessModelObject.writeForeignObjectUnderNewSubelement(this._extendedAttributes, thisElement, writingContext, "ExtendedAttributes");
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder riHolder) throws SAXException {
        super.consumeRelatedObjects(riHolder);
        this._extendedAttributes = (EntityInterface)riHolder.consumeForeignObject("ExtendedAttributes");
    }

    @Override
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(thisElement, readingContext);
        this.setModel(readingContext.getModelBeingRead());
        this._extendedAttributes = this.v1_readExtendedAttributes(thisElement);
    }

    @Override
    public String getIdentityString() {
        String tempid = null;
        try {
            tempid = this.getID();
        }
        catch (MetadataException e) {
            tempid = "." + this.getIntraModelID();
        }
        String msg = IQModelImplUtilities.getMessage("IdentityStringThreeArgs.fmt.txt", this.getDefinitionElementName(), this.getLabel(), tempid);
        return msg;
    }

    String getIdentityStringWithHashCode() {
        String tempid = null;
        try {
            tempid = this.getID();
        }
        catch (MetadataException e) {
            tempid = "." + this.getIntraModelID();
        }
        String msg = IQModelImplUtilities.getMessage("IdentityStringFourArgs.fmt.txt", this.getDefinitionElementName(), this.getLabel(), tempid, "" + this.hashCode());
        return msg;
    }

    public final String toString() {
        return this.getLabel();
    }

    public String toDebugString() {
        return this.getIdentityString();
    }

    @Override
    protected abstract String getDefaultIDPrefix();

    @Override
    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        super.accumulateReasonsItemItselfIsUnusable(reasons);
        if (!this.isContainedInBusinessModel()) {
            reasons.add(new Reason((Object)this, 2, 6, "BusinessModelObjectImplObjectNotContainedInModel.fmt.txt", this.getIdentityString()));
        }
        if (this.isOrphaned()) {
            reasons.add(new Reason((Object)this, 2, 21, "BusinessModelObjectImplObjectOrphanNoUsable.fmt.txt", this.getIdentityString()));
        }
    }

    public void moveTo(MapFolder newParent) throws MetadataException {
        if (!(this instanceof BusinessItem)) {
            throw new UnsupportedOperationException(IQModelImplUtilities.getMessage("AbstractBusinessModelObject.CannotMoveNonBusinessItem.fmt.txt", this.getIdentityString(), this.getClass().getName()));
        }
        if (newParent == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("MapFolderCantMoveNullParentFolder.txt", new Object[0]));
        }
        newParent.addBusinessItem((BusinessItem)((Object)this));
    }

    public Map<FolderItem, FolderItem> copyTo(MapFolder newParent, boolean recursive) throws MetadataException {
        if (!(this instanceof BusinessItem)) {
            throw new UnsupportedOperationException(IQModelImplUtilities.getMessage("AbstractBusinessModelObject.CannotMoveNonBusinessItem.fmt.txt", this.getIdentityString()));
        }
        BusinessModel model = this.getBusinessModel();
        if (model == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("BusinessModelObjectImplObjectNotFoundInModel.fmt.txt", this.getIdentityString()));
        }
        BusinessItem clone = null;
        try {
            clone = (BusinessItem)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(e);
        }
        String label = clone.getLabel();
        String id = model.generateIntraModelID(label);
        clone.setIntraModelID(id);
        model.addBusinessItem(clone);
        newParent.addBusinessItem(clone);
        HashMap<FolderItem, FolderItem> rules = new HashMap<FolderItem, FolderItem>();
        Utils.ruleBasedResourceReplacement(model, this, clone, rules, false);
        return rules;
    }

    public boolean canCopy() {
        BusinessModel model = this.getBusinessModel();
        if (!(this instanceof BusinessItem)) {
            return false;
        }
        return model != null;
    }

    public boolean canMove() {
        BusinessModel model = this.getBusinessModel();
        if (!(this instanceof BusinessItem)) {
            return false;
        }
        return model != null;
    }

    public AbstractBusinessModelObject resolve(ReadingContext resolutionContext) throws MetadataException {
        AbstractBusinessModelObject out = null;
        AbstractBusinessModel modelBeingRead = (AbstractBusinessModel)resolutionContext.getModelBeingRead();
        String idToResolve = this.getInterModelIdentity();
        String containerID = IQModelImplUtilities.leftOfDot(idToResolve);
        String objID = IQModelImplUtilities.rightOfDot(idToResolve);
        AbstractBusinessModel model = (AbstractBusinessModel)modelBeingRead.findContainerByID(containerID);
        if (model != null) {
            out = model.getItemByID(objID);
        }
        return out;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.fireChangeEvent("A property associated with the object has changed");
    }

    boolean isBasedOn(BusinessQuery query) {
        return false;
    }

    protected StructureOfDataItem getStructure(Object obj) {
        StructureOfDataItem out = StructureOfDataItem.STRUCTURE_COLUMN;
        if (obj instanceof Column) {
            out = StructureOfDataItem.STRUCTURE_COLUMN;
        } else if (obj instanceof ConstantExpression) {
            out = StructureOfDataItem.STRUCTURE_COLUMN;
        } else if (obj instanceof DataItem) {
            out = ((DataItem)obj).getStructure();
        } else if (obj instanceof Dimension) {
            out = StructureOfDataItem.STRUCTURE_DIMENSION;
        } else if (obj instanceof Hierarchy) {
            out = StructureOfDataItem.STRUCTURE_HIERARCHY;
        } else if (obj instanceof com.sas.iquery.metadata.physical.Level) {
            out = StructureOfDataItem.STRUCTURE_LEVEL;
        } else if (obj instanceof Measure) {
            out = StructureOfDataItem.STRUCTURE_MEASURE;
        } else if (obj instanceof NamedSet) {
            out = StructureOfDataItem.STRUCTURE_NAMED_SET;
        } else if (obj instanceof CalculatedMember) {
            out = StructureOfDataItem.STRUCTURE_CALCULATED_MEMBER;
        } else if (obj instanceof StringExpression || obj instanceof FractionOfTotalExpression || obj instanceof TimeExpressionMeasure) {
            BusinessModel businessModel = this.getBusinessModel();
            if (businessModel == null || businessModel.getStructure().isRelational()) {
                out = StructureOfDataItem.STRUCTURE_COLUMN;
            } else if (obj instanceof ResourceAwareStringExpression) {
                int dimType = -1;
                try {
                    dimType = BusinessQueryOLAPUtil.getDimensionType(businessModel, obj);
                }
                catch (MetadataException me) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(IQModelImplUtilities.getMessage("DataItemErrorExpression.txt", new Object[0]));
                    }
                    out = StructureOfDataItem.STRUCTURE_HIERARCHY;
                }
                out = dimType == 2 ? StructureOfDataItem.STRUCTURE_MEASURE : StructureOfDataItem.STRUCTURE_HIERARCHY;
            } else {
                out = StructureOfDataItem.STRUCTURE_MEASURE;
            }
        }
        return out;
    }

    protected boolean isValidResultSetID(String id, DataItem item) throws MetadataException {
        ExpressionInterface expression;
        int languageID = 0;
        if (item != null && !item.isUnresolved() && (expression = item.getExpression()) != null) {
            StructureOfDataItem structure = this.getStructure(expression);
            languageID = structure.isOLAP() ? 3 : (GenerationUtil.isSPDS(expression) ? 2 : 1);
        }
        boolean valid = GenerationUtil.isValidIdentifierName(id, languageID);
        return valid;
    }

    @Override
    protected void checksForCopyingFromObject(Object obj) throws MetadataException {
        super.checksForCopyingFromObject(obj);
        AbstractBusinessModelObject from = (AbstractBusinessModelObject)obj;
        BusinessModel fromModel = from.getBusinessModel();
        BusinessModel toModel = this.getBusinessModel();
        if (fromModel != toModel) {
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("AbstractBusinessModelObject.CannotCopyObjectsBetweenDifferentModels.txt", new Object[0]);
            throw new MetadataException(formatter);
        }
        if (fromModel.contains(from)) {
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("AbstractBusinessModelObject.CannotCopyFromAnObjectContainedWithinItsModel.txt", new Object[0]);
            throw new MetadataException(formatter);
        }
        if (!toModel.contains(this)) {
            MessageFormatter formatter = IQModelImplUtilities.getMessageFormatter("AbstractBusinessModelObject.CannotCopyToAnObjectNotContainedWithinItsModel.txt", new Object[0]);
            throw new MetadataException(formatter);
        }
    }
}

