/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.impl.AbstractEnumerationObject;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import java.util.Enumeration;
import java.util.concurrent.CopyOnWriteArrayList;

@SASScope(value="ALL")
public class Role
extends AbstractEnumerationObject {
    private static final CopyOnWriteArrayList<Role> allDefined = new CopyOnWriteArrayList();
    public static final Role ROW = new Role("ROW");
    public static final Role COLUMN = new Role("COLUMN");
    public static final Role BACKGROUND = new Role("BACKGROUND");
    @Deprecated
    public static final Role PAGE = new Role("PAGE");
    public static final Role HIDDEN = new Role("HIDDEN");

    @SASScope
    public static Role getInactiveRole(BusinessQuery query) {
        Role result = null;
        if (query != null) {
            StructureOfData sod = query.getInputStructure();
            if (sod.isOLAP()) {
                result = HIDDEN;
            } else if (sod.isRelational()) {
                result = BACKGROUND;
            }
        }
        return result;
    }

    public static boolean isInactiveRole(BusinessQuery query, Role role) {
        boolean result = false;
        if (query != null && role != null) {
            StructureOfData sod = query.getInputStructure();
            if (sod.isOLAP()) {
                result = HIDDEN.equals(role);
            } else if (sod.isRelational()) {
                result = BACKGROUND.equals(role);
            }
        }
        return result;
    }

    @SASScope
    public static Role[] getActiveRoles(BusinessQuery query) {
        Role[] results = new Role[]{};
        if (query != null) {
            StructureOfData sod = query.getInputStructure();
            if (sod.isOLAP()) {
                results = new Role[]{COLUMN, ROW, BACKGROUND};
            } else if (sod.isRelational()) {
                results = new Role[]{COLUMN, ROW, HIDDEN};
            }
        }
        return results;
    }

    public static boolean isOutputResultRole(BusinessQuery query, Role role) {
        return role != BACKGROUND && role != HIDDEN && !Role.isInactiveRole(query, role);
    }

    private Role(String value) {
        super("Role." + value + ".txt", value, value);
    }

    @SASScope
    public String getPersistedForm() {
        return this.getPersistentForm();
    }

    @SASScope
    public static Role fromPersistentForm(String value) {
        return Role.fromPersistentForm(value, allDefined);
    }

    @SASScope
    public static Role fromPersistentForm(String value, Role defaultValue) {
        Role out = defaultValue;
        if (value != null) {
            out = Role.fromPersistentForm(value, allDefined);
        }
        return out;
    }

    @SASScope
    public static Role fromPersistedForm(String value) {
        return Role.fromPersistentForm(value);
    }

    @SASScope
    public static Role consumeValue(AttributesProvider attrsHolder, String attrName, Role defaultValue) {
        return Role.consumeValue(attrsHolder, attrName, allDefined, defaultValue);
    }

    @SASScope
    public static Role fromPersistentFormV2(String attrName, String persistentForm) {
        return Role.fromPersistentFormV2(attrName, persistentForm, allDefined);
    }

    @Override
    @SASScope
    protected void registerInstance() {
        allDefined.add(this);
    }

    @SASScope
    public static Enumeration<Role> enumeration() {
        return new AbstractEnumerationObject.AEOEnumerator<Role>(allDefined);
    }

    @SASScope
    public Enumeration<Role> enumerateSiblings() {
        return Role.enumeration();
    }
}

