/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class LookupValue
extends AbstractModelItem
implements Cloneable {
    private int hashCode;
    private String formattedValue;
    private String unformattedValue;
    private boolean isQuoted;

    @SASScope(value="ALL")
    @SubjectToChange
    public LookupValue() {
        this(null, null, true);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public LookupValue(String formatted, String unformatted, boolean quoted) {
        this.formattedValue = formatted;
        this.unformattedValue = unformatted;
        this.isQuoted = quoted;
        this.hashCode = 0;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setFormattedValue(String value) {
        this.formattedValue = value;
        this.hashCode = 0;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setUnformattedValue(String value) {
        this.unformattedValue = value;
        this.hashCode = 0;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setIsQuoted(boolean quoted) {
        this.isQuoted = quoted;
        this.hashCode = 0;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getFormattedValue() {
        return this.formattedValue;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getUnformattedValue() {
        return this.unformattedValue;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isQuoted() {
        return this.isQuoted;
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        IQModelImplUtilities.setAttr(thisElement, "fmtd", this.formattedValue);
        IQModelImplUtilities.setAttr(thisElement, "ufmtd", this.unformattedValue);
        IQModelImplUtilities.setBooleanAttr(thisElement, "isQuoted", this.isQuoted, true);
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this.formattedValue = attrsProvider.consumeAttr("fmtd");
        this.unformattedValue = attrsProvider.consumeAttr("ufmtd");
        this.isQuoted = attrsProvider.consumeBooleanAttr("isQuoted", true);
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this.formattedValue = IQModelImplUtilities.getAttr(thisElement, "formattedValue");
        this.unformattedValue = IQModelImplUtilities.getAttr(thisElement, "unformattedValue");
        this.isQuoted = IQModelImplUtilities.getBooleanAttr(thisElement, "isQuoted", true);
    }

    @Override
    @SASScope
    public String getDefinitionElementName() {
        return "LookupValue";
    }

    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List intoList) {
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }

    @SASScope
    public boolean equals(Object value) {
        boolean isFormattedEqual = false;
        boolean isUnformattedEqual = false;
        boolean isQuotedEqual = false;
        if (value instanceof LookupValue) {
            LookupValue specifiedValue = (LookupValue)value;
            String spValueFormattedValue = specifiedValue.getFormattedValue();
            String spValueUnformattedValue = specifiedValue.getUnformattedValue();
            if (this.formattedValue != null && spValueFormattedValue != null) {
                isFormattedEqual = this.formattedValue.equals(spValueFormattedValue);
            } else if (this.formattedValue == null && spValueFormattedValue == null) {
                isFormattedEqual = true;
            }
            if (this.unformattedValue != null && spValueUnformattedValue != null) {
                isUnformattedEqual = this.unformattedValue.equals(spValueUnformattedValue);
            } else if (this.unformattedValue == null && spValueUnformattedValue == null) {
                isUnformattedEqual = true;
            }
            if (this.isQuoted == specifiedValue.isQuoted()) {
                isQuotedEqual = true;
            }
        }
        return isFormattedEqual && isUnformattedEqual && isQuotedEqual;
    }

    @SASScope
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 73;
            this.hashCode = 17 * this.hashCode + (this.formattedValue != null ? this.formattedValue.hashCode() : 0);
            this.hashCode = 17 * this.hashCode + (this.unformattedValue != null ? this.unformattedValue.hashCode() : 0);
            this.hashCode = 17 * this.hashCode + (this.isQuoted ? 1 : 0);
        }
        return this.hashCode;
    }

    @SASScope
    public String toString() {
        String fmtText = Utils.toString(this.formattedValue);
        StringBuffer sb = new StringBuffer();
        sb.append(fmtText);
        if (this.isQuoted || this.unformattedValue != null) {
            String unfmtText = Utils.toString(this.unformattedValue);
            if (this.isQuoted || fmtText.compareTo(unfmtText) != 0) {
                sb.append('[');
                if (this.isQuoted) {
                    sb.append('\"');
                }
                sb.append(unfmtText);
                if (this.isQuoted) {
                    sb.append('\"');
                }
                sb.append(']');
            }
        }
        return sb.toString();
    }
}

