/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.LasrType;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.physical.AccessPathToRelationalData;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.oma.OMASASLibrary;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.util.List;

public class Lasr
extends AbstractModelItem {
    BusinessModel _businessModel = null;
    private LasrType _usage = LasrType.SUBMIT_POST_PROCESS;
    private String _data = null;
    private String _create = null;
    private String _path = null;
    private String _host = null;
    private String _install = null;
    private int _nodes = 0;
    private int _nthreads = 0;
    private DataSourceTable _dataSourceTable = null;

    public Lasr(BusinessModel businessModel) {
        this._businessModel = businessModel;
    }

    public Lasr(BusinessModel businessModel, LasrType usage) {
        this._businessModel = businessModel;
        this._usage = usage;
    }

    public Lasr data(String data) throws GenerationException {
        if (this._usage == LasrType.SUBMIT_POST_PROCESS) {
            throw new GenerationException();
        }
        this._data = data;
        return this;
    }

    public Lasr data(Table table) throws GenerationException {
        if (this._usage == LasrType.SUBMIT_POST_PROCESS) {
            throw new GenerationException();
        }
        try {
            this.createDataSourceTable(table);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public Lasr create(String create) {
        this._create = create;
        return this;
    }

    public Lasr path(String path) {
        this._path = path;
        return this;
    }

    public Lasr host(String host) {
        this._host = host;
        return this;
    }

    public Lasr install(String install) {
        this._install = install;
        return this;
    }

    public Lasr nodes(int nodes) {
        this._nodes = nodes;
        return this;
    }

    public Lasr nthreads(int nthreads) {
        this._nthreads = nthreads;
        return this;
    }

    public StringBuffer generateLasrStatement() {
        if (this._host == null || this._install == null || this._create == null || this._path == null) {
            Throwable e = null;
            e.printStackTrace();
        }
        StringBuffer snapStatement = new StringBuffer();
        snapStatement.append("proc lasr data=" + this._data + " create='" + this._create + "' path='" + this._path + "'" + ';' + " performance host='" + this._host + "' install='" + this._install + "'");
        if (this._nodes > 0) {
            snapStatement.append(" nodes=" + this._nodes);
        }
        if (this._nthreads > 0) {
            snapStatement.append(" nthreads=" + this._nthreads);
        }
        snapStatement.append(";run;");
        return snapStatement;
    }

    public StringBuffer generateLasrStatement(String inputTable) {
        if (this._host == null || this._install == null || this._create == null || this._path == null) {
            Throwable e = null;
            e.printStackTrace();
        }
        StringBuffer snapStatement = new StringBuffer();
        snapStatement.append("proc lasr data=" + inputTable + " create='" + this._create + "' path='" + this._path + "'" + ';' + " performance host='" + this._host + "' install='" + this._install + "'");
        if (this._nodes > 0) {
            snapStatement.append(" nodes=" + this._nodes);
        }
        if (this._nthreads > 0) {
            snapStatement.append(" nthreads=" + this._nthreads);
        }
        snapStatement.append(";run;");
        return snapStatement;
    }

    public LasrType getUsage() {
        return this._usage;
    }

    public DataSourceTable getDataSourceTable() {
        return this._dataSourceTable;
    }

    private void createDataSourceTable(Table table) throws Exception {
        SessionContextInterface session = this._businessModel.getSession();
        Object iqService = null;
        SASWorkspaceServer server = null;
        DataSourceTable dataSourceTable = null;
        SASLibrary lib = null;
        String tablename = null;
        String libname = null;
        if (((ResourceRelationshipInterface)((Object)table)).getParentResource() instanceof SASLibrary) {
            lib = (SASLibrary)((ResourceRelationshipInterface)((Object)table)).getParentResource();
            if (!(lib instanceof OMASASLibrary)) {
                Object e = null;
                throw e;
            }
            List<SoftwareServer> servers = lib.getSoftwareServers();
            for (SoftwareServer sws : servers) {
                LogicalServerInterface logicalServer = sws.getLogicalServerInterface();
                if (logicalServer == null || !logicalServer.getClassIdentifier().equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") && !logicalServer.getClassIdentifier().equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) continue;
                server = (SASWorkspaceServer)sws;
                break;
            }
        }
        AccessPathToRelationalData ap = new AccessPathToRelationalData(server, lib);
        dataSourceTable = this._businessModel.newDataSourceTable(ap, table);
        this._businessModel.addDataSource(dataSourceTable);
        this._dataSourceTable = dataSourceTable;
        try {
            libname = lib.getLibref();
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
        try {
            tablename = table.getSasName();
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
        this._data = libname + "." + tablename;
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    protected String getDefinitionElementName() {
        return null;
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }
}

