/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.IMStatStatementType;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLFilterExaminerAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASFactory;
import com.sas.iquery.strategies.sas.oma.relational.join.JoinGeneration;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CodeStringDataSelectionProcessor;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalDataSelectionProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@SASScope
public class IMStat {
    private final CodeStringDataSelectionProcessor _codeDataSelectionProcessor;
    private final DataSelection _dataSelection;
    private final IMStatStatementType _statementType;
    private final String _outputTableNm;
    private final String _escapedOutputTableNm;
    private static final String STAGE1 = "STAGE1";
    private static final Map<FunctionNameID, String> VALID_FUNCTIONS;
    private int _calcItemCount = 0;
    private int _calcItemSuffix = 1;
    final LinkedHashMap<String, String> _calcItemNamesByExpression = new LinkedHashMap();

    public IMStat(CodeStringDataSelectionProcessor codeDataSelectionProcessor, DataSelection dataSelection, String outputTableNm) {
        this(codeDataSelectionProcessor, dataSelection, IMStatStatementType.SUMMARY, outputTableNm);
    }

    public IMStat(CodeStringDataSelectionProcessor codeDataSelectionProcessor, DataSelection dataSelection, IMStatStatementType statementType, String outputTableNm) {
        this._codeDataSelectionProcessor = codeDataSelectionProcessor;
        this._dataSelection = dataSelection;
        this._statementType = statementType;
        this._outputTableNm = outputTableNm;
        this._escapedOutputTableNm = GenerationUtil.generateEscapedIdentifier(this._outputTableNm, 1);
    }

    public static Set<FunctionNameID> getSupportedFunctions(DataSelection dataSelection) throws MetadataException {
        return VALID_FUNCTIONS.keySet();
    }

    public StringBuffer getQueryText() throws GenerationException, MetadataException {
        ArrayList<DataItem> measures = new ArrayList<DataItem>();
        ArrayList<DataItem> categories = new ArrayList<DataItem>();
        ArrayList<FilterItem> preAggregateFilters = new ArrayList();
        LinkedHashSet<String> functionNms = new LinkedHashSet<String>();
        ArrayList<String> measureColumnNms = new ArrayList<String>();
        LinkedHashMap<DataItem, String> dataItemsById = new LinkedHashMap<DataItem, String>();
        ArrayList<FilterItem> postAggregateFilters = new ArrayList();
        Set<FunctionNameID> supportedFunctions = IMStat.getSupportedFunctions(this._dataSelection);
        SQLSASFactory tempSQLFactory = new SQLSASFactory();
        SQLFilterExaminerAbstract tempFilterExaminer = (SQLFilterExaminerAbstract)tempSQLFactory.createSQLFilterExaminer();
        tempFilterExaminer.setDataSelection(this._dataSelection);
        tempFilterExaminer.examineFilters();
        preAggregateFilters = tempFilterExaminer.getWhereFilters();
        postAggregateFilters = tempFilterExaminer.getHavingFilters();
        for (SelectedItem si : this._dataSelection.getSelectedItems()) {
            Role role = si.getRole();
            DataItem di = si.getItem();
            boolean isInactiveRole = Role.isInactiveRole(this._dataSelection, role);
            if (isInactiveRole) continue;
            if (di.isCalculatedItem()) {
                ++this._calcItemCount;
            }
            if (di.getUsage() == DataItemActionType.USAGE_DETAIL) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("IMStat.DetailFail.txt", new Object[0]));
            }
            String columnNm = IMStat.generateColumnName(this._dataSelection, di.getExpression());
            if (columnNm == null) continue;
            if (di.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                FunctionNameID fnid = di.getAggregationType().getFunctionNameID();
                if (!supportedFunctions.contains(fnid)) {
                    throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("IMStat.UnsupportedFunctionFail.fmt.txt", fnid));
                }
                measures.add(di);
                measureColumnNms.add(columnNm);
                String functionNm = VALID_FUNCTIONS.get(fnid);
                functionNms.add(functionNm);
                String identifier = GenerationUtil.generateEscapedIdentifier(functionNm + (measureColumnNms.indexOf(columnNm) + 1));
                dataItemsById.put(di, identifier);
                continue;
            }
            if (di.getUsage() != DataItemActionType.USAGE_CATEGORY) continue;
            categories.add(di);
            String identifier = GenerationUtil.generateEscapedIdentifier(columnNm);
            dataItemsById.put(di, identifier);
        }
        StringBuffer query = new StringBuffer();
        switch (this._statementType) {
            case SUMMARY: {
                List<Governing> governors = this._dataSelection.getEffectiveRules(Governing.class);
                Governing governor = governors.isEmpty() ? null : governors.get(0);
                String summaryText = this.generateProcIMStat(dataItemsById, categories, measures, governor, preAggregateFilters);
                query.append(summaryText);
                break;
            }
            default: {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("IMStat.UnsupportedStatementType.fmt.txt", new Object[]{this._statementType}));
            }
        }
        query.append(this.generateDataStepStage2(dataItemsById, measureColumnNms, functionNms));
        query.append(this.generateDataStepStage3(postAggregateFilters));
        return query;
    }

    private String generateProcIMStat(LinkedHashMap<DataItem, String> dataItemsById, List<DataItem> categories, List<DataItem> measures, Governing governor, List<FilterItem> preAggregateFilters) throws GenerationException, MetadataException {
        String identifier;
        List<DataSourceTable> dataSourceTables = this._dataSelection.getObjects(true, DataSourceTable.class);
        DataSourceTable dst = dataSourceTables.get(0);
        String tableNm = dst.getLabel();
        AccessPath ap = dst.getAccessPath();
        Schema schema = ap.getSchema();
        if (!(schema instanceof SASLibrary)) {
            throw new GenerationException(IQMetadataResourceBundle.getMessageFormatter("IMStat.SchemaNotSasLibraryFail.fmt.txt", schema.getLabel()));
        }
        SASLibrary sasLibrary = (SASLibrary)schema;
        String libref = sasLibrary.getLibref();
        String engine = sasLibrary.getEngine();
        assert ("SASIOLA".equalsIgnoreCase(engine)) : "libref engine for PROC IMSTAT was " + engine;
        StringBuilder sb = new StringBuilder("PROC IMSTAT\n");
        sb.append("DATA=" + libref + "." + tableNm);
        if (this._calcItemCount > 0) {
            sb.append("(array=(temp," + this._calcItemCount + "))");
        }
        sb.append(";\n");
        StringBuilder whereClause = new StringBuilder();
        for (FilterItem filterItem : preAggregateFilters) {
            if (whereClause.length() == 0) {
                sb.append("   WHERE ");
            } else {
                whereClause.append("      AND ");
            }
            String where = this.generateWhereClause(filterItem, 4);
            whereClause.append(where);
            whereClause.append("\n");
        }
        if (whereClause.length() > 0) {
            sb.append((CharSequence)whereClause);
            sb.append(";\n");
        }
        sb.append("SUMMARY ");
        for (DataItem dataItem : measures) {
            String columnNm = IMStat.generateColumnName(this._dataSelection, dataItem.getExpression());
            if (columnNm == null) continue;
            identifier = GenerationUtil.generateEscapedIdentifier(columnNm);
            identifier = this.processIMStatIdentifier(identifier, dataItem, dataItemsById);
            sb.append(identifier);
            sb.append(" ");
        }
        StringBuilder groupByVars = new StringBuilder();
        for (DataItem di : categories) {
            identifier = dataItemsById.get(di);
            if (identifier == null) continue;
            identifier = this.processIMStatIdentifier(identifier, di, dataItemsById);
            groupByVars.append(identifier);
            groupByVars.append(" ");
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean hasOrderByAscending = false;
        boolean hasOrderByDescending = false;
        ArrayList<DataItem> all = new ArrayList<DataItem>(categories);
        all.addAll(measures);
        for (DataItem di : all) {
            String identifier2;
            DataItemActionType sortDirection = di.getSortDirection();
            if (sortDirection == DataItemActionType.SORT_ASCENDING) {
                hasOrderByAscending = true;
            }
            if (sortDirection == DataItemActionType.SORT_DESCENDING) {
                hasOrderByDescending = true;
            }
            if (sortDirection == DataItemActionType.SORT_NONE || (identifier2 = dataItemsById.get(di)) == null) continue;
            stringBuilder.append(identifier2);
            stringBuilder.append(" ");
        }
        if (hasOrderByAscending && hasOrderByDescending) {
            throw new GenerationException(IQMetadataResourceBundle.getMessageFormatter("IMStat.SortOrderAscDescFail.txt", new Object[0]));
        }
        int limit = governor != null ? governor.getOutputObservations() : -1;
        StringBuilder options = new StringBuilder();
        if (this._calcItemCount > 0) {
            StringBuilder tempVars = new StringBuilder();
            StringBuilder tempExpress = new StringBuilder();
            for (String tempName : this._calcItemNamesByExpression.keySet()) {
                tempVars.append(tempName + " ");
                tempExpress.append(tempName + "=" + this._calcItemNamesByExpression.get(tempName) + "; ");
            }
            options.append("TEMPNAMES=(" + tempVars + ")\n");
            options.append("TEMPEXPRESS=\"" + tempExpress + "\"\n");
        }
        if (groupByVars.length() > 0) {
            options.append("GROUPBY=(");
            options.append((CharSequence)groupByVars);
            options.append(") ");
        }
        if (stringBuilder.length() > 0) {
            options.append("ORDERBY=(");
            options.append((CharSequence)stringBuilder);
            options.append(") ");
        }
        if (hasOrderByDescending) {
            options.append("ORDERBYDESC ");
        }
        if (limit != -1) {
            options.append("LIMIT= ");
            options.append(limit);
            options.append(" ");
        }
        if (options.length() > 0) {
            sb.append(" / ").append((CharSequence)options);
        }
        sb.append(";\n");
        String tempLibname = this._codeDataSelectionProcessor.getTempLibname();
        String fullName = GenerationUtil.generateFullyQualifiedIdentifier(tempLibname, STAGE1);
        sb.append("ODS OUTPUT SUMMARY=" + fullName + ";\n");
        sb.append("RUN;\n");
        sb.append("QUIT;\n\n");
        return sb.toString();
    }

    private String processIMStatIdentifier(String identifier, DataItem di, LinkedHashMap<DataItem, String> dataItemsById) throws GenerationException {
        String imStatIdentifier = null;
        if (di.isCalculatedItem()) {
            imStatIdentifier = "TEMP" + this._calcItemSuffix;
            ++this._calcItemSuffix;
            this._calcItemNamesByExpression.put(imStatIdentifier, this.genCalcItemExpression(di));
            if (di.getUsage() == DataItemActionType.USAGE_CATEGORY) {
                dataItemsById.put(di, imStatIdentifier);
            }
        } else {
            imStatIdentifier = identifier;
        }
        return imStatIdentifier;
    }

    private String genCalcItemExpression(DataItem di) throws GenerationException {
        String calcItemText = null;
        SQLExpressionAbstract expression = this.generateExpression();
        calcItemText = expression.generateExpressionSQL(di, 4, null);
        return calcItemText;
    }

    private SQLExpressionAbstract generateExpression() throws GenerationException {
        JoinGeneration joinGenerator = new JoinGeneration();
        joinGenerator.setDataSelection(this._dataSelection);
        try {
            joinGenerator.setDataSelection(this._dataSelection);
            joinGenerator.generateJoinPath();
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        RelationalDataSelectionProcessor dsp = new RelationalDataSelectionProcessor(this._dataSelection);
        SQLSASFactory factory = new SQLSASFactory();
        SQLExpressionAbstract sqlExpression = factory.createSQLExpression();
        sqlExpression.setSQLFactory(factory);
        sqlExpression.setJoinGenerator(joinGenerator);
        sqlExpression.setDataSelection(this._dataSelection);
        sqlExpression.setDataSelectionProcessor(dsp);
        return sqlExpression;
    }

    public String generateDataStepStage2(LinkedHashMap<DataItem, String> dataItemsById, ArrayList<String> measureColumnNms, LinkedHashSet<String> functionNms) throws GenerationException, MetadataException {
        String dataStepId;
        DataItem di;
        StringBuilder sb = new StringBuilder();
        sb.append("/* Create an empty data set if PROC IMSTAT did not create a one. */\n");
        sb.append("/* Transform the PROC IMSTAT output result set if present. */\n");
        sb.append("%macro checkds(dsn);\n");
        sb.append("   %if not %sysfunc(exist(&dsn)) %then %do;\n");
        sb.append("DATA " + this._escapedOutputTableNm + ";\n");
        StringBuilder attrib = new StringBuilder("ATTRIB\n");
        StringBuilder init = new StringBuilder("/* suppress variable uninitialized warning */\n");
        for (Map.Entry<DataItem, String> entry : dataItemsById.entrySet()) {
            di = entry.getKey();
            dataStepId = entry.getValue();
            String length = this.generateLength(di.getExpression());
            String labelValue = GenerationUtil.generateQuotedLiteral(di.getLabel() == null ? "" : di.getLabel());
            attrib.append("   ");
            attrib.append(dataStepId);
            attrib.append(" ");
            attrib.append(length);
            attrib.append(" ");
            attrib.append("label= ");
            attrib.append(labelValue);
            attrib.append("\n");
            init.append(this.generateInitialization(dataStepId, di.getExpression(), di));
            init.append(";\n");
        }
        attrib.append(";\n");
        sb.append((CharSequence)attrib);
        sb.append((CharSequence)init);
        sb.append("STOP;\n");
        sb.append("RUN;\n");
        sb.append("   %end;\n");
        sb.append("   %else %do;\n");
        sb.append("DATA " + this._escapedOutputTableNm + "\n");
        StringBuilder keep = new StringBuilder("(KEEP= ");
        StringBuilder rename = new StringBuilder("RENAME= (");
        for (Map.Entry<DataItem, String> entry : dataItemsById.entrySet()) {
            di = entry.getKey();
            String identifier = entry.getValue();
            keep.append(identifier).append(" ");
            String rsIdentifier = GenerationUtil.generateEscapedIdentifier(di.getResultSetID(), 1);
            rename.append(identifier).append("=").append(rsIdentifier).append(" ");
        }
        sb.append((CharSequence)keep);
        sb.append((CharSequence)rename);
        sb.append("));\n");
        sb.append("ATTRIB\n");
        for (Map.Entry<DataItem, String> entry : dataItemsById.entrySet()) {
            di = entry.getKey();
            dataStepId = entry.getValue();
            String label = GenerationUtil.generateLabelEqStatement(di);
            sb.append("   ").append(dataStepId).append(label);
            String format = GenerationUtil.generateFormatEqStatement(di);
            if (!format.isEmpty()) {
                sb.append(format);
            }
            sb.append("\n");
        }
        sb.append(";\n");
        sb.append("/* " + measureColumnNms.size() + " is the number of measure columns */\n");
        for (String functionNm : functionNms) {
            sb.append("ARRAY " + functionNm + "S {" + measureColumnNms.size() + "} " + functionNm + "1-" + functionNm + measureColumnNms.size() + ";\n");
        }
        sb.append("DO I=1 TO " + measureColumnNms.size() + ";\n");
        String tempLibname = this._codeDataSelectionProcessor.getTempLibname();
        String fullName = GenerationUtil.generateFullyQualifiedIdentifier(tempLibname, STAGE1);
        sb.append("   SET " + fullName + ";\n");
        for (String functionNm : functionNms) {
            sb.append(functionNm + "S {I}= " + functionNm + ";\n");
        }
        sb.append("END;\n");
        sb.append("RUN;\n");
        sb.append("   %end;\n");
        sb.append("\n");
        sb.append("%mend checkds;\n");
        sb.append("/* invoke the macro - transform if present, create empty if not present */\n");
        sb.append("%checkds(" + fullName + ");\n");
        return sb.toString();
    }

    private String generateDataStepStage3(List<FilterItem> filterItems) throws GenerationException {
        StringBuilder sb = new StringBuilder();
        if (filterItems.size() > 0) {
            sb.append("\n");
            sb.append("/* apply post aggregate (HAVING) filters */\n");
            sb.append("DATA work.");
            sb.append(this._escapedOutputTableNm);
            sb.append(";\n");
            sb.append("SET work.");
            sb.append(this._escapedOutputTableNm);
            sb.append(";\n");
            StringBuilder whereClause = new StringBuilder();
            for (FilterItem fi : filterItems) {
                if (whereClause.length() == 0) {
                    whereClause.append("   WHERE ");
                } else {
                    whereClause.append("      AND ");
                }
                String where = this.generateWhereClause(fi, 2);
                whereClause.append(where);
                whereClause.append("\n");
            }
            sb.append((CharSequence)whereClause);
            sb.append(";\n");
            sb.append("run;\n");
            sb.append("quit;\n");
        }
        return sb.toString();
    }

    private String generateInitialization(String label, ExpressionInterface expr, DataItem di) throws GenerationException, MetadataException {
        String init = null;
        if (expr instanceof QualifiedColumn) {
            QualifiedColumn qc = (QualifiedColumn)expr;
            init = label + "= " + ("N".equals(qc.getSasType()) ? "0" : "\"\"");
        } else {
            init = di.isCalculatedItem() ? label + "= \"\"" : "";
        }
        return init;
    }

    private String generateLength(ExpressionInterface expr) throws GenerationException, MetadataException {
        String length;
        if (expr instanceof QualifiedColumn) {
            QualifiedColumn qc = (QualifiedColumn)expr;
            length = "LENGTH= " + ("N".equals(qc.getSasType()) ? "" : "$") + qc.getSasLength();
        } else {
            length = "";
        }
        return length;
    }

    public static String generateColumnName(DataSelection dataSelection, ExpressionInterface expr) throws GenerationException {
        try {
            String columnNm = null;
            if (expr instanceof QualifiedColumn) {
                QualifiedColumn qc = (QualifiedColumn)expr;
                columnNm = qc.getSasName();
            } else if (expr instanceof ResourceAwareStringExpression) {
                ResourceAwareStringExpression rase = (ResourceAwareStringExpression)expr;
                final RelationalDataSelectionProcessor dsp = new RelationalDataSelectionProcessor(dataSelection);
                final SQLSASFactory sqlFactory = new SQLSASFactory();
                final JoinGeneration joinGen = new JoinGeneration();
                joinGen.setDataSelection(dataSelection);
                joinGen.setDataSelectionProcessor(dsp);
                SQLExpressionAbstract sqlAb = new SQLExpressionAbstract(){
                    {
                        this.setJoinGenerator(joinGen);
                        this.setDataSelection(this._dataSelection);
                        this.setDataSelectionProcessor(dsp);
                        this.setSQLFactory(sqlFactory);
                    }

                    @Override
                    public void prepareSQL() throws GenerationException {
                    }

                    @Override
                    public String writeSQL() {
                        return null;
                    }
                };
                columnNm = sqlAb.generateExpressionSQL(rase, 4, Collections.emptyMap());
            }
            return columnNm;
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
    }

    private String generateWhereClause(FilterItem fi, int declareOrReference) throws GenerationException {
        ExpressionInterface expression = fi.getExpression();
        final RelationalDataSelectionProcessor dsp = new RelationalDataSelectionProcessor(this._dataSelection);
        final SQLSASFactory sqlFactory = new SQLSASFactory();
        final JoinGeneration joinGen = new JoinGeneration();
        joinGen.setDataSelection(this._dataSelection);
        joinGen.setDataSelectionProcessor(dsp);
        SQLExpressionAbstract sqlAb = new SQLExpressionAbstract(){
            {
                this.setJoinGenerator(joinGen);
                this.setDataSelection(IMStat.this._dataSelection);
                this.setDataSelectionProcessor(dsp);
                this.setSQLFactory(sqlFactory);
            }

            @Override
            public void prepareSQL() throws GenerationException {
            }

            @Override
            public String writeSQL() {
                return null;
            }
        };
        String whereString = sqlAb.generateExpressionSQL(expression, declareOrReference, Collections.emptyMap());
        return whereString;
    }

    public static boolean hasLasrEngine(@Nonnull DataSourceTable dataSourceTable) throws MetadataException {
        boolean hasLaserEngine;
        AccessPath accessPath = dataSourceTable.getAccessPath();
        if (accessPath != null) {
            Schema schema = accessPath.getSchema();
            if (schema instanceof SASLibrary) {
                SASLibrary sasLibrary = (SASLibrary)schema;
                String engine = sasLibrary.getEngine();
                hasLaserEngine = "SASIOLA".equalsIgnoreCase(engine);
            } else {
                hasLaserEngine = false;
            }
        } else {
            hasLaserEngine = false;
        }
        return hasLaserEngine;
    }

    public static boolean isImStatEnabled() {
        return IQSystemProperties.isBooleanPropertyEnabled("SASQueryServices.AllowIMSTAT");
    }

    static {
        LinkedHashMap<FunctionNameID, String> validFunctions = new LinkedHashMap<FunctionNameID, String>();
        validFunctions.put(FunctionNameID.N, "N");
        validFunctions.put(FunctionNameID.NMISS, "NMISS");
        validFunctions.put(FunctionNameID.SUM, "SUM");
        validFunctions.put(FunctionNameID.MEAN, "MEAN");
        validFunctions.put(FunctionNameID.STD, "STD");
        validFunctions.put(FunctionNameID.STDERR, "STDERR");
        validFunctions.put(FunctionNameID.VAR, "VAR");
        validFunctions.put(FunctionNameID.USS, "USS");
        validFunctions.put(FunctionNameID.CSS, "CSS");
        validFunctions.put(FunctionNameID.MIN, "MIN");
        validFunctions.put(FunctionNameID.MAX, "MAX");
        validFunctions.put(FunctionNameID.CV, "CV");
        validFunctions.put(FunctionNameID.INTERNAL_AGGREGATION, "INTERNAL_AGGREGATION");
        VALID_FUNCTIONS = Collections.unmodifiableMap(validFunctions);
    }
}

