/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.CreateTableDataSelection;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.LookThroughDataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SetOperationDataSelection;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.CreateTableDataSelectionImpl;
import com.sas.iquery.metadata.business.impl.DataSelectionImpl;
import com.sas.iquery.metadata.business.impl.LookThroughDataSelectionImpl;
import com.sas.iquery.metadata.business.impl.SetOperationDataSelectionImpl;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.services.session.SessionContextInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@SubjectToChange
public class DataSelectionFactory {
    @SASScope
    public static final int MAX_MEASURES = 2;
    @SASScope
    public static final int MAX_DIMENSIONS = 0;
    @SASScope
    public static final int MAX_HIERARCHIES = 2;
    @SASScope
    public static final int MAX_LEVELS = 0;
    @SASScope
    public static final int MAX_NAMEDSETS = 0;
    @SASScope
    public static final int MAX_CALCULATEDMEMBERS = 0;
    @SASScope
    public static final int MAX_COLUMNS = 20;
    private static DataSelectionFactory _instance = new DataSelectionFactory();

    @SASScope
    public static DataSelectionFactory getInstance() {
        return _instance;
    }

    @SASScope
    public static DataSelection newDataSelection(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service) {
        return DataSelectionFactory.getInstance().newDataSelectionNonStatic(session, service);
    }

    @SASScope
    public DataSelection newDataSelectionNonStatic(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service) {
        DataSelectionImpl dataSelection = new DataSelectionImpl(session, service);
        return dataSelection;
    }

    @SASScope
    public static DataSelection newDataSelection(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Locale dataLocale) {
        return DataSelectionFactory.getInstance().newDataSelectionNonStatic(session, service, dataLocale);
    }

    @SASScope
    public DataSelection newDataSelectionNonStatic(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Locale dataLocale) {
        DataSelectionImpl dataSelection = new DataSelectionImpl(session, service, dataLocale);
        return dataSelection;
    }

    public static DataSelection newDataSelection(@Nonnull BusinessModel businessModel) {
        return DataSelectionFactory.getInstance().newDataSelectionNonStatic(businessModel);
    }

    @SASScope
    public DataSelection newDataSelectionNonStatic(@Nonnull BusinessModel businessModel) {
        DataSelectionImpl ds = null;
        if (businessModel == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessage("DataSelectionFactoryNonNullBusinessModel.txt", new Object[0]));
        }
        if (!(businessModel instanceof AbstractBusinessModel)) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessage("DataSelectionFactoryInvalidBusinessModel.txt", new Object[0]));
        }
        ds = new DataSelectionImpl((AbstractBusinessModel)businessModel);
        return ds;
    }

    @SASScope
    public static LookThroughDataSelection newLookThroughDataSelection(DataSelection parentDataSelection) {
        return DataSelectionFactory.getInstance().newLookThroughDataSelectionNonStatic(parentDataSelection);
    }

    @SASScope
    public LookThroughDataSelection newLookThroughDataSelectionNonStatic(DataSelection parentDataSelection) {
        LookThroughDataSelectionImpl ds = null;
        if (parentDataSelection == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessage("DataSelectionFactoryNonNullDataSelection.txt", new Object[0]));
        }
        if (!(parentDataSelection instanceof DataSelectionImpl)) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessage("DataSelectionFactoryInvalidDataSelection.txt", new Object[0]));
        }
        ds = new LookThroughDataSelectionImpl((DataSelectionImpl)parentDataSelection);
        return ds;
    }

    @SASScope
    public static DataSelection readDataSelection(Element dataSelectionElement, Map<BusinessModelReferenceInfo, BusinessModel> reuseBusinessModels, IntelligentQueryMetadataServiceInterface metadataService, SessionContextInterface session) throws MetadataException {
        return DataSelectionFactory.getInstance().readDataSelectionNonStatic(dataSelectionElement, reuseBusinessModels, metadataService, session);
    }

    @SASScope
    public DataSelection readDataSelectionNonStatic(Element dataSelectionElement, Map<BusinessModelReferenceInfo, BusinessModel> reuseBusinessModels, IntelligentQueryMetadataServiceInterface metadataService, SessionContextInterface session) throws MetadataException {
        if (dataSelectionElement == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessage("BusinessQueryImplMapItemNull.txt", new Object[0]));
        }
        String elementName = dataSelectionElement.getTagName();
        DataSelection ds = null;
        if (elementName.equals("DataSelection")) {
            ds = DataSelectionImpl.readInNewDataSelection(session, metadataService, dataSelectionElement, reuseBusinessModels);
        } else if (elementName.equals("LookThroughDataSelection")) {
            ds = LookThroughDataSelectionImpl.readInNewLookThroughDataSelection(session, metadataService, dataSelectionElement, reuseBusinessModels);
        } else {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("DataSelectionFactoryReadError.fmt.txt", elementName));
        }
        return ds;
    }

    public static DataSelection newSampleDataSelection(BusinessModel rootBusinessModel, Map<StructureOfDataItem, Integer> maxElements) throws MetadataException {
        DataSelection dataSelection = DataSelectionFactory.newDataSelection(rootBusinessModel);
        int measureCount = 2;
        int dimensionCount = 0;
        int hierarchyCount = 2;
        int levelCount = 0;
        int namedSetCount = 0;
        int calculatedMemberCount = 0;
        int columnCount = 20;
        if (maxElements != null) {
            if (maxElements.containsKey(StructureOfDataItem.STRUCTURE_MEASURE)) {
                measureCount = maxElements.get(StructureOfDataItem.STRUCTURE_MEASURE);
            }
            if (maxElements.containsKey(StructureOfDataItem.STRUCTURE_DIMENSION)) {
                dimensionCount = maxElements.get(StructureOfDataItem.STRUCTURE_DIMENSION);
            }
            if (maxElements.containsKey(StructureOfDataItem.STRUCTURE_HIERARCHY)) {
                hierarchyCount = maxElements.get(StructureOfDataItem.STRUCTURE_HIERARCHY);
            }
            if (maxElements.containsKey(StructureOfDataItem.STRUCTURE_LEVEL)) {
                levelCount = maxElements.get(StructureOfDataItem.STRUCTURE_LEVEL);
            }
            if (maxElements.containsKey(StructureOfDataItem.STRUCTURE_COLUMN)) {
                columnCount = maxElements.get(StructureOfDataItem.STRUCTURE_COLUMN);
            }
            if (maxElements.containsKey(StructureOfDataItem.STRUCTURE_NAMED_SET)) {
                namedSetCount = maxElements.get(StructureOfDataItem.STRUCTURE_NAMED_SET);
            }
            if (maxElements.containsKey(StructureOfDataItem.STRUCTURE_CALCULATED_MEMBER)) {
                calculatedMemberCount = maxElements.get(StructureOfDataItem.STRUCTURE_CALCULATED_MEMBER);
            }
        }
        LinkedHashMap<String, DataItemReference> dimensions = new LinkedHashMap<String, DataItemReference>();
        ArrayList<DataItemReference> measures = new ArrayList<DataItemReference>();
        DataItem dataItem2 = null;
        DataItemReference dataItemRef = null;
        List<DataItem> dataItems = dataSelection.getObjects(1, DataItem.class);
        boolean isOLAP = dataSelection.getStructure().isOLAP();
        for (DataItem dataItem2 : dataItems) {
            boolean use = dataItem2.isUsableInQuery();
            if (!use) continue;
            StructureOfDataItem structure = dataItem2.getStructure();
            if (isOLAP) {
                String dimensionName;
                if (structure == StructureOfDataItem.STRUCTURE_MEASURE && measureCount != 0) {
                    --measureCount;
                    dataItemRef = dataSelection.newDataItemReference(dataItem2);
                    dataSelection.addBusinessItem(dataItemRef);
                    measures.add(dataItemRef);
                    continue;
                }
                if (structure == StructureOfDataItem.STRUCTURE_DIMENSION && dimensionCount != 0) {
                    dimensionName = BusinessQueryOLAPUtil.getDimensionName(dataSelection, dataItem2);
                    if (dimensions.containsKey(dimensionName)) continue;
                    --dimensionCount;
                    dataItemRef = dataSelection.newDataItemReference(dataItem2);
                    dataSelection.addBusinessItem(dataItemRef);
                    dimensions.put(dimensionName, dataItemRef);
                    continue;
                }
                if (structure == StructureOfDataItem.STRUCTURE_HIERARCHY && hierarchyCount != 0) {
                    dimensionName = BusinessQueryOLAPUtil.getDimensionName(dataSelection, dataItem2);
                    if (dimensions.containsKey(dimensionName)) continue;
                    --hierarchyCount;
                    dataItemRef = dataSelection.newDataItemReference(dataItem2);
                    dataSelection.addBusinessItem(dataItemRef);
                    dimensions.put(dimensionName, dataItemRef);
                    continue;
                }
                if (structure == StructureOfDataItem.STRUCTURE_LEVEL && levelCount != 0) {
                    dimensionName = BusinessQueryOLAPUtil.getDimensionName(dataSelection, dataItem2);
                    if (dimensions.containsKey(dimensionName)) continue;
                    --levelCount;
                    dataItemRef = dataSelection.newDataItemReference(dataItem2);
                    dataSelection.addBusinessItem(dataItemRef);
                    dimensions.put(dimensionName, dataItemRef);
                    continue;
                }
                if (structure == StructureOfDataItem.STRUCTURE_NAMED_SET && namedSetCount != 0) {
                    dimensionName = BusinessQueryOLAPUtil.getDimensionName(dataSelection, dataItem2);
                    if (dimensions.containsKey(dimensionName)) continue;
                    --namedSetCount;
                    dataItemRef = dataSelection.newDataItemReference(dataItem2);
                    dataSelection.addBusinessItem(dataItemRef);
                    dimensions.put(dimensionName, dataItemRef);
                    continue;
                }
                if (structure != StructureOfDataItem.STRUCTURE_CALCULATED_MEMBER || calculatedMemberCount == 0 || dimensions.containsKey(dimensionName = BusinessQueryOLAPUtil.getDimensionName(dataSelection, dataItem2))) continue;
                --calculatedMemberCount;
                dataItemRef = dataSelection.newDataItemReference(dataItem2);
                dataSelection.addBusinessItem(dataItemRef);
                dimensions.put(dimensionName, dataItemRef);
                continue;
            }
            if (columnCount == 0) continue;
            --columnCount;
            dataItemRef = dataSelection.newDataItemReference(dataItem2);
            dataSelection.addBusinessItem(dataItemRef);
            dataSelection.addResultItem(dataItemRef, Role.COLUMN);
        }
        if (isOLAP) {
            Iterator<DataItem> iterator = dimensions.values().iterator();
            Role role = null;
            int count = measures.size();
            int i = 0;
            while (iterator.hasNext()) {
                role = count > 1 ? (i % 2 == 0 ? Role.ROW : Role.COLUMN) : (i % 2 == 0 ? Role.COLUMN : Role.ROW);
                dataSelection.addResultItem(iterator.next(), role);
                ++i;
            }
            Role role2 = role = count > 1 ? Role.COLUMN : Role.BACKGROUND;
            if (dimensions.size() == 1 && count == 1) {
                role = Role.ROW;
            }
            for (i = 0; i < count; ++i) {
                dataSelection.addResultItem((DataItem)measures.get(i), role);
            }
        }
        return dataSelection;
    }

    @SASScope
    public CreateTableDataSelection newCreateTableDataSelection(DataSelection dataSelection) {
        CreateTableDataSelectionImpl createTable = new CreateTableDataSelectionImpl(dataSelection);
        return createTable;
    }

    @SASScope
    public SetOperationDataSelection newSetOperationDataSelection(BusinessModel businessModel) {
        SetOperationDataSelectionImpl ds = null;
        if (businessModel == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("DataSelectionFactoryNonNullBusinessModel.txt", new Object[0]));
        }
        if (!(businessModel instanceof AbstractBusinessModel)) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessageFormatter("DataSelectionFactoryInvalidBusinessModel.txt", new Object[0]));
        }
        ds = new SetOperationDataSelectionImpl((AbstractBusinessModel)businessModel);
        return ds;
    }
}

