/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.business;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
@SubjectToChange
public class ChangeHistoryItem
extends AbstractModelItem {
    private Date _timestamp;
    private String _userName = "";
    private String _description = "";

    @SASScope
    public ChangeHistoryItem() {
    }

    @SASScope
    public ChangeHistoryItem(Date timestamp) {
        this._timestamp = timestamp;
    }

    @SASScope
    public ChangeHistoryItem(Date timestamp, String timezoneID) {
        this._timestamp = timestamp;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public Date getTimestamp() {
        return this._timestamp;
    }

    @SASScope
    public TimeZone getTimeZone() {
        return null;
    }

    @SASScope
    public String getTimeZoneID() {
        return "";
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getUserName() {
        return this._userName;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setUserName(String userName) {
        this._userName = userName;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getDescription() {
        return this._description;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    @SASScope
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        if (this._timestamp != null) {
            String xmlTimestamp = writingContext.getXMLTimestampToMillisecond(this._timestamp);
            IQModelImplUtilities.setAttr(thisElement, "timestamp", xmlTimestamp);
        }
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "user", this._userName);
        IQModelImplUtilities.setAttrWithEmptyDefault(thisElement, "desc", this._description);
    }

    @Override
    @SASScope
    protected String getDefinitionElementName() {
        return "Change";
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeAttributes(attrsProvider);
        this._timestamp = attrsProvider.consumeTimestampAttr("timestamp", null);
        this._userName = attrsProvider.consumeAttrEmptyDefault("user");
        this._description = attrsProvider.consumeAttrEmptyDefault("desc");
    }

    @Override
    @SASScope
    protected void readDefinitionV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._timestamp = IQModelImplUtilities.getTimestampAttrV1(thisElement, "timestamp");
        this._userName = IQModelImplUtilities.getAttr(thisElement, "label");
        this._description = IQModelImplUtilities.getAttr(thisElement, "desc");
    }

    @Override
    @SASScope
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
    }

    @Override
    @SASScope
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
    }

    @Override
    @SASScope
    protected boolean isReferrableToWithinModel() {
        return false;
    }
}

